/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.controls;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import oracle.dmt.dataminer.controls.JSONAggregationFunctionProvider;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.workflow.dialog.jsonQuery.DialogsLrb;
import oracle.dmt.dataminer.workflow.xmlschema.AggregationElementsExType;

public class JSONAggregationFunctionCellEditor
extends DefaultCellEditor
implements TableCellEditor,
ActionListener,
FocusListener {
    protected static final String _EMPTY_ELEMENT = DialogsLrb.get("JSON_ADD_AGGREGATION_DLG_EMPTY_COLUMN");
    private static List<String> catAggregateFunctions = DatabaseMetadataUtils.AggregateFunctions.listCategoricFunctions();
    private static List<String> numAggregateFunctions = DatabaseMetadataUtils.AggregateFunctions.listNumericFunctions();
    private static List<String> mixedFunctions = DatabaseMetadataUtils.AggregateFunctions.listCommonCategoricAndNumericFunctions();
    private JSONAggregationFunctionProvider provider;
    private AggregationElementsExType.AggregationElement aggElement;
    private int thisrow = -1;
    private boolean busy = false;

    public JSONAggregationFunctionCellEditor(JComboBox<String> jComboBox, JSONAggregationFunctionProvider jSONAggregationFunctionProvider) {
        super(jComboBox);
        this.provider = jSONAggregationFunctionProvider;
        jComboBox.addActionListener(this);
        jComboBox.addFocusListener(this);
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.aggElement = this.provider.getAggregationElement(n);
        this.thisrow = n;
        if (this.aggElement != null) {
            String string = this.aggElement.getJSONAttribute().getDataType();
            String string2 = DatabaseMetadataUtils.convertJSONAttrType(string);
            String string3 = DatabaseMetadataUtils.getDefaultMiningType(string2);
            List<String> list = null;
            if (string3.equalsIgnoreCase("Categorical")) {
                list = catAggregateFunctions;
            }
            if (string3.equalsIgnoreCase("Numerical")) {
                list = numAggregateFunctions;
            }
            DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>(new Vector<String>(list));
            defaultComboBoxModel.addElement(_EMPTY_ELEMENT);
            ((JComboBox)this.editorComponent).setModel(defaultComboBoxModel);
            String string4 = this.aggElement.getAggregationFunction();
            this.busy = true;
            if (string4 == null) {
                ((JComboBox)this.editorComponent).setSelectedItem(_EMPTY_ELEMENT);
            } else {
                ((JComboBox)this.editorComponent).setSelectedItem(string4);
            }
            this.busy = false;
        } else assert (false) : "Should not happen";
        return this.editorComponent;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.busy) {
            return;
        }
        this.provider.setAggregationFunction((String)((JComboBox)this.editorComponent).getSelectedItem(), this.thisrow);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.cancelCellEditing();
    }

    static {
        Collections.sort(catAggregateFunctions);
        Collections.sort(numAggregateFunctions);
        Collections.sort(mixedFunctions);
    }
}

