/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.common.model;

import java.util.List;
import javax.swing.JComboBox;
import oracle.dmt.dataminer.common.model.AttrTableModel;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;

public class JSONAttrTableModel<T extends AttributeType>
extends AttrTableModel<T> {
    private List<String> constraintColumns;

    public JSONAttrTableModel(List<T> list, List<String> list2) {
        super(list);
        this.constraintColumns = list2;
    }

    private boolean isContstraint(String string) {
        return this.constraintColumns != null && this.constraintColumns.contains(string);
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return Object.class;
    }

    public boolean isCellEditable(int n, int n2) {
        String string;
        Object object = this.getValueAt(n, n2);
        AttributeType attributeType = (AttributeType)this.getValueAt(n, 0);
        if (!attributeType.getStatus().equals((Object)AttributeStatus.VALID)) {
            return false;
        }
        String string2 = string = attributeType.getAlias() != null ? attributeType.getAlias() : attributeType.getName();
        if (object instanceof JComboBox) {
            Object object2 = ((JComboBox)object).getSelectedItem();
            if (this.isContstraint(string)) {
                return false;
            }
            if (DatabaseMetadataUtils.isACharacterOracleDataType(object2.toString()) || DatabaseMetadataUtils.isJSONTypeSupported(object2.toString())) {
                return true;
            }
        }
        return false;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        AttributeType attributeType = (AttributeType)this.srcData.get(n);
        switch (n2) {
            case 0: {
                return attributeType;
            }
            case 1: {
                String string = attributeType.getDataType();
                String string2 = attributeType.getDataTypeQualifier();
                if (DatabaseMetadataUtils.isACharacterOracleDataType(string)) {
                    String string3 = DatabaseMetadataUtils.getJSONDataType(string, string2);
                    String[] stringArray = null;
                    stringArray = DatabaseMetadataUtils.isJSONDataType(attributeType) ? new String[]{string3, string} : new String[]{string, string3};
                    JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
                    return jComboBox;
                }
                return string;
            }
        }
        assert (false) : "Invalid column";
        return null;
    }

    public void setValueAt(Object object, int n, int n2) {
        List list = this.getSrcData();
        AttributeType attributeType = (AttributeType)list.get(n);
        String string = object.toString();
        if (DatabaseMetadataUtils.isJSONTypeSupported(string)) {
            string = DatabaseMetadataUtils.getDataTypeCorresponsingToJSONType(string);
            attributeType.setDataTypeQualifier("JSON");
        } else {
            attributeType.setDataTypeQualifier(null);
        }
        attributeType.setDataType(string);
    }
}

