/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.xml;

import oracle.bali.xml.grammar.QualifiedName;
import oracle.jdeveloper.audit.extension.Required;
import oracle.jdeveloper.audit.model.Location;
import oracle.jdeveloper.audit.model.ModelAdapter;
import oracle.jdeveloper.audit.transform.Transform;
import oracle.jdeveloper.audit.transform.TransformAdapter;
import oracle.jdeveloper.audit.xml.XmlTransformAdapter;
import oracle.jdeveloper.audit.xml.XmlTransformContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class AddAttributeTransform
extends Transform {
    private QualifiedName name;
    private String value;

    public AddAttributeTransform() {
        super((TransformAdapter)new XmlTransformAdapter());
    }

    public QualifiedName getName() {
        return this.name;
    }

    @Required
    public void setName(QualifiedName name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean isApplicable(XmlTransformContext context, Element construct) {
        String text;
        ModelAdapter model;
        Location location;
        Attr attribute;
        String localName;
        String namespace = this.name.getNamespace();
        if (!construct.hasAttributeNS(namespace, localName = this.name.getName())) {
            return true;
        }
        String existingValue = construct.getAttributeNS(namespace, localName);
        if (existingValue.isEmpty() && (attribute = construct.getAttributeNodeNS(namespace, localName)) != null && (location = (model = context.getModel()).getLocation((Object)attribute)) != null && ((text = model.getText(location.getOffset(), location.getLength()).trim()).endsWith(localName) || text.endsWith("="))) {
            existingValue = null;
        }
        return this.value != null ? !this.value.equals(existingValue) : existingValue == null;
    }

    public boolean isApplicable(XmlTransformContext context, Attr construct) {
        return this.isApplicable(context, construct.getOwnerElement());
    }

    public void apply(XmlTransformContext context, Element construct) {
        String newValue;
        String namespace = this.name.getNamespace();
        String localName = this.name.getName();
        String string = newValue = this.value != null ? this.value : "";
        if (newValue.isEmpty() && construct.getAttributeNS(namespace, localName).isEmpty()) {
            construct.removeAttributeNS(namespace, localName);
        }
        construct.setAttributeNS(namespace, localName, newValue);
        Attr attribute = construct.getAttributeNodeNS(namespace, localName);
        context.setSelection(attribute, Integer.MAX_VALUE, 1);
    }

    public void apply(XmlTransformContext context, Attr construct) {
        this.apply(context, construct.getOwnerElement());
    }
}

