/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.inspector;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.ide.util.MetaClass;
import oracle.bali.inspector.PropertyModel;
import oracle.bali.inspector.multi.SelectionModel;
import oracle.bali.xml.grammar.util.JavaTypeManager;
import oracle.bali.xml.gui.base.inspector.BaseInspectorGui;
import oracle.bali.xml.gui.base.inspector.PropertyModelUtils;
import oracle.bali.xml.gui.base.inspector.XmlPropertyModel;
import oracle.bali.xml.gui.jdev.inspector.XmlInspectorUtils;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.task.ReadOnlyTask;
import oracle.ide.inspector.layout.Element;
import oracle.ide.inspector.layout.FormLayoutFactory;
import oracle.ide.inspector.layout.PropertyFormLayout;
import oracle.ide.inspector.layout.PropertyFormLayoutAssembly;
import oracle.ide.inspector.layout.PropertyFormLayoutFactory;
import oracle.ide.util.Assert;
import org.w3c.dom.Node;
import org.xml.sax.XMLReader;

public class XmlFormLayoutFactory
implements FormLayoutFactory {
    private static final Logger _LOGGER = Logger.getLogger(XmlFormLayoutFactory.class.getName());
    private static final boolean _USE_CACHE = !"true".equals(System.getProperty("xmlef.pi.layout.cache.disabled"));
    private static Map<String, Element> _sFormLayouts = new ConcurrentHashMap<String, Element>(64);
    private static Element _NULL_PROPERTY_FORM_LAYOUT = new PropertyFormLayout(){

        public MetaClass getPropertyModelClass() {
            throw new UnsupportedOperationException("null object");
        }

        public List<Element> getChildren() {
            throw new UnsupportedOperationException("null object");
        }
    };

    public PropertyFormLayout createPropertyFormLayout(PropertyModel propertyModel) {
        if (!PropertyModelUtils.isSupportedRootModel((PropertyModel)propertyModel)) {
            return null;
        }
        ArrayList<Element> layouts = new ArrayList<Element>();
        SelectionModel sm = PropertyModelUtils.getSelectionModel((PropertyModel)propertyModel);
        if (sm != null) {
            int c = sm.getSelectedItemCount();
            for (int i = 0; i < c; ++i) {
                PropertyModel pm = (PropertyModel)sm.getSelectedItem(i);
                if (!this._isLayoutProvided(pm)) continue;
                BaseInspectorGui gui = null;
                XmlKey targetKey = null;
                Integer row = this._getRow(pm);
                if (row != null) {
                    gui = PropertyModelUtils.getInspectorGui((PropertyModel)pm, (int)row);
                    targetKey = PropertyModelUtils.getInspectableXmlKey((PropertyModel)pm, (int)row);
                }
                if (gui == null || targetKey == null) continue;
                layouts.addAll(this._getPropertyFormLayout(propertyModel, gui, targetKey));
            }
        }
        if (layouts.size() == 0) {
            return null;
        }
        if (layouts.size() == 1) {
            return (PropertyFormLayout)layouts.get(0);
        }
        return new PropertyFormLayoutAssembly(layouts);
    }

    private Integer _getRow(PropertyModel pm) {
        Integer i = null;
        Enumeration e = pm.getPropertyIDs();
        if (e.hasMoreElements()) {
            i = pm.getPropertyIndex(e.nextElement());
        }
        return i;
    }

    private List<Element> _getPropertyFormLayout(final PropertyModel propertyModel, BaseInspectorGui gui, final XmlKey xmlKey) {
        final Node node = PropertyModelUtils.getAncestorNode((PropertyModel)propertyModel, (int)0);
        List urls = (List)new ReadOnlyTask<List<URL>>(){

            protected List<URL> runImpl(AbstractModel model) {
                return model.getXmlMetadataResolver().getPropertyFormLayout(propertyModel, xmlKey, node);
            }
        }.run((AbstractModel)gui.getView());
        if (urls == null || urls.isEmpty()) {
            return Collections.emptyList();
        }
        boolean requiresParsing = false;
        ArrayList<Element> parsedPfls = new ArrayList<Element>(5);
        if (_USE_CACHE) {
            for (URL url : urls) {
                Element cached = _sFormLayouts.get(url.toExternalForm());
                if (cached == _NULL_PROPERTY_FORM_LAYOUT) continue;
                if (cached != null) {
                    parsedPfls.add(cached);
                    continue;
                }
                requiresParsing = true;
                break;
            }
            if (!requiresParsing) {
                return parsedPfls;
            }
        }
        ArrayList<Element> pfls = new ArrayList<Element>(5);
        for (URL url : urls) {
            PropertyFormLayout pfl = this._parsePropertyFormLayout(gui, node, xmlKey, url);
            Assert.println((String)"XMLEF PI: Parsed form layout to {0}; key={1} url={2}", (Object)pfl, (Object)xmlKey, (Object)url);
            if (pfl == null) {
                _sFormLayouts.put(url.toExternalForm(), _NULL_PROPERTY_FORM_LAYOUT);
                continue;
            }
            pfls.add((Element)pfl);
            _sFormLayouts.put(url.toExternalForm(), (Element)pfl);
        }
        return pfls;
    }

    private PropertyFormLayout _parsePropertyFormLayout(BaseInspectorGui gui, Node node, XmlKey key, URL url) {
        try {
            if (url == null) {
                return null;
            }
            String bundleClassName = gui.getView().getXmlMetadataResolver().getBundleNameForLayoutFile(node, key, url);
            List pfl = PropertyFormLayoutFactory.getExternalPropertyFormLayouts((XMLReader)XmlInspectorUtils.createFilteredXmlReader(), (String)url.toString(), (String)"oracle.ide.xmlef", (String)bundleClassName, (ClassLoader)JavaTypeManager.class.getClassLoader());
            if (pfl.size() == 1) {
                return (PropertyFormLayout)pfl.get(0);
            }
            throw new IOException("# of layouts returned from PropertyFormLayoutFactory.getExternalPropertyFormLayouts != 1; is" + pfl.size());
        }
        catch (Exception e) {
            LogRecord lr = new LogRecord(Level.WARNING, "Error parsing PI form layout for {0}; url={1}");
            lr.setParameters(new Object[]{key, url.toExternalForm()});
            lr.setThrown(e);
            _LOGGER.log(lr);
            return null;
        }
    }

    private boolean _isLayoutProvided(PropertyModel pm) {
        if (pm instanceof XmlPropertyModel) {
            return ((XmlPropertyModel)pm).isFormLayoutPromoted();
        }
        return false;
    }
}

