/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.dependency.url;

import java.net.URL;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.dom.position.DomRange;
import oracle.bali.xml.dom.traversal.DocumentTreeTraversal;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.grammar.GrammarProvider;
import oracle.bali.xml.grammar.instance.XmlInstanceGrammarProvider;
import oracle.bali.xml.gui.jdev.audit.XmlefAuditBundle;
import oracle.bali.xml.gui.jdev.dependency.ExternalIdDeclaration;
import oracle.bali.xml.gui.jdev.dependency.url.UrlReference;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.dependency.Declaration;
import oracle.bali.xml.model.dependency.DependencyContext;
import oracle.bali.xml.model.dependency.ValidationResult;
import oracle.ide.Context;
import oracle.ide.dependency.URLDeclarationProvider;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.status.Severity;
import org.w3c.dom.Node;

public class SystemIdReference
extends UrlReference {
    public SystemIdReference(XmlContext xmlContext, Node node, int start, int end, URL url) {
        super(xmlContext, node, start, end, url);
    }

    @Override
    public Declaration findDeclaration(DependencyContext context) {
        if (this._url == null || !this.isLocalURL(this.getURL(), this._url)) {
            return null;
        }
        GrammarProvider gp = this.getXmlContext(context).getGrammarProvider();
        if (gp instanceof XmlInstanceGrammarProvider) {
            if (!URLFileSystem.exists((URL)this._url)) {
                return null;
            }
            String declId = URLDeclarationProvider.getDeclarationId((URL)this._url);
            if (declId == null) {
                return null;
            }
            return ExternalIdDeclaration.getDeclaration(new Context(this.getWorkspace(), this.getProject()), declId);
        }
        return null;
    }

    @Override
    public ValidationResult validateDeclaration(DependencyContext context, Declaration declaration) {
        if (declaration == null) {
            GrammarProvider gp = this.getXmlContext(context).getGrammarProvider();
            if (gp instanceof XmlInstanceGrammarProvider) {
                if (this._url == null || this.isLocalURL(this.getURL(), this._url)) {
                    return this._notFound(context);
                }
            } else {
                return ValidationResult.OK;
            }
        }
        return ValidationResult.OK;
    }

    private ValidationResult _notFound(DependencyContext context) {
        StringBuffer message = new StringBuffer();
        message.append(XmlefAuditBundle.get("LOCAL_LOCATION_NOT_FOUND"));
        String value = this.getValue(context);
        if (value != null && value.length() > 0) {
            message.append(" (");
            message.append(value);
            message.append(")");
        }
        return new ValidationResult(Severity.WARNING, message.toString());
    }

    public DomRange getDomRange(DependencyContext context) {
        Node node = this.getNode(context);
        return DomRange.create((DomPosition)DomPositionFactory.before((Node)node), (DomPosition)DomPositionFactory.inside((Node)node), (TreeTraversal)DocumentTreeTraversal.INSTANCE);
    }

    @Override
    protected boolean supportsUpdateReference() {
        return false;
    }
}

