/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle.tool.undo;

import java.awt.Rectangle;
import oracle.bali.jle.LayoutItem;
import oracle.bali.jle.tool.BoundsPainter;
import oracle.bali.jle.tool.BoundsTool;
import oracle.bali.jle.tool.undo.LocalizedEdit;
import oracle.bali.jle.util.ItemUtils;

public class MoveUndo
extends LocalizedEdit {
    private LayoutItem _moved;
    private double _dx;
    private double _dy;
    private BoundsTool _tool;
    private String _name;

    public MoveUndo(LayoutItem moved, double dx, double dy, BoundsTool tool) {
        if (moved == null) {
            throw new IllegalArgumentException();
        }
        this._moved = moved;
        this._dx = dx;
        this._dy = dy;
        this._tool = tool;
    }

    public void undo() {
        super.undo();
        Rectangle oldRect = ItemUtils.parentToDevice(this._moved, this._moved.getItemBounds());
        BoundsTool.processMove(this._moved, -this._dx, -this._dy, this._tool);
        if (this._tool != null) {
            this._repaintOldLocation(oldRect);
        } else {
            this._moved.getCanvas().repaintInterior();
        }
    }

    public void redo() {
        super.redo();
        Rectangle oldRect = ItemUtils.parentToDevice(this._moved, this._moved.getItemBounds());
        BoundsTool.processMove(this._moved, this._dx, this._dy, this._tool);
        if (this._tool != null) {
            this._repaintOldLocation(oldRect);
        } else {
            this._moved.getCanvas().repaintInterior();
        }
    }

    public void die() {
        super.die();
        this._moved = null;
        this._tool = null;
    }

    public String getBaseKey() {
        return "MOVE";
    }

    public LayoutItem getMovedItem() {
        return this._moved;
    }

    private void _repaintOldLocation(Rectangle oldRect) {
        BoundsPainter painter = this._tool.getBoundsPainter();
        int xOff = painter.getControlPointWidth() / 2 + 1;
        int yOff = painter.getControlPointHeight() / 2 + 1;
        this._tool.getCanvas().repaintCanvas(oldRect.x - xOff, oldRect.y - yOff, oldRect.width + xOff * 2, oldRect.height + yOff * 2);
    }
}

