/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle.tool;

import oracle.bali.jle.LayoutItem;
import oracle.bali.jle.tool.ControlPoint;

public final class ControlPointTable {
    private ControlPoint[] _entries = new ControlPoint[73];
    private boolean _inEnumeration;
    private ControlPoint _currentEntry;
    private int _currentIndex;
    private int _controlPointRadius = 2;

    ControlPointTable() {
    }

    void insert(ControlPoint cp) {
        int key = Math.abs((int)Math.round(cp.getX() + cp.getY())) % this._entries.length;
        if (this._entries[key] == null) {
            this._entries[key] = cp;
        } else if (this.before(cp, this._entries[key])) {
            cp.next = this._entries[key];
            this._entries[key] = cp;
        } else {
            ControlPoint tmp = this._entries[key];
            while (tmp.next != null && this.before(cp, tmp)) {
                tmp = tmp.next;
            }
            cp.next = tmp.next;
            tmp.next = cp;
        }
    }

    void insert(ControlPoint[] cparray) {
        int n = cparray == null ? 0 : cparray.length;
        for (int i = 0; i < n; ++i) {
            this.insert(cparray[i]);
        }
    }

    void removeAll() {
        int i = this._entries.length;
        while (--i >= 0) {
            this._entries[i] = null;
        }
    }

    boolean remove(ControlPoint cp) {
        if (cp == null) {
            return false;
        }
        int key = Math.abs((int)Math.round(cp.getX() + cp.getY())) % this._entries.length;
        ControlPoint curr = this._entries[key];
        ControlPoint prev = null;
        while (curr != null) {
            if (curr.equals(cp)) {
                if (prev == null) {
                    this._entries[key] = curr.next;
                } else {
                    prev.next = curr.next;
                }
                curr.next = null;
                return true;
            }
            prev = curr;
            curr = curr.next;
        }
        return false;
    }

    public ControlPoint lookup(double x, double y, double nearX, double nearY) {
        ControlPoint best = null;
        int bestdepth = Integer.MAX_VALUE;
        int bestwhichcp = 0;
        int entriesLength = this._entries.length;
        int key = Math.abs((int)Math.round(x + y)) % entriesLength;
        int keyDelta = Math.abs((int)Math.round(nearX + nearY));
        for (int i = key - keyDelta; i <= key + keyDelta; ++i) {
            int index = i;
            if (i < 0) {
                index = entriesLength + i;
            } else if (i >= entriesLength) {
                index = i - entriesLength;
            }
            ControlPoint cp = this._entries[index];
            while (cp != null) {
                if (x >= cp.getX() - nearX && x <= cp.getX() + nearX && y >= cp.getY() - nearY && y <= cp.getY() + nearY) {
                    int cpdepth = 0;
                    for (LayoutItem parent = cp.getSource().getItemParent(); parent != null; parent = parent.getItemParent()) {
                        ++cpdepth;
                    }
                    int cpwhichcp = cp.getType();
                    if (cpdepth < bestdepth || cpdepth == bestdepth && cpwhichcp > bestwhichcp) {
                        best = cp;
                        bestdepth = cpdepth;
                        bestwhichcp = cpwhichcp;
                    }
                }
                cp = cp.next;
            }
        }
        return best;
    }

    ControlPoint firstElement() {
        this._inEnumeration = true;
        this._currentIndex = this._entries.length;
        this._currentEntry = null;
        return this.nextElement();
    }

    ControlPoint nextElement() {
        if (!this._inEnumeration) {
            return null;
        }
        if (this._currentEntry != null) {
            this._currentEntry = this._currentEntry.next;
        }
        if (this._currentEntry == null) {
            while (this._currentIndex-- > 0 && (this._currentEntry = this._entries[this._currentIndex]) == null) {
            }
            if (this._currentEntry == null) {
                this._inEnumeration = false;
            }
        }
        return this._currentEntry;
    }

    ControlPoint currentElement() {
        if (!this._inEnumeration) {
            return null;
        }
        return this._currentEntry;
    }

    boolean before(ControlPoint first, ControlPoint second) {
        double firstX = first.getX();
        double firstY = first.getY();
        double secondX = second.getX();
        double secondY = second.getY();
        return firstX < secondX || firstX == secondX && firstY < secondY;
    }
}

