/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle.item;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import oracle.bali.jle.geom.AffineTransform;
import oracle.bali.jle.geom.Point2D;
import oracle.bali.jle.geom.Rectangle2D;
import oracle.bali.jle.item.LinkItem;
import oracle.bali.jle.item.LinkPainter;
import oracle.bali.jle.item.LinkPort;
import oracle.bali.jle.tool.SelectionTool;
import oracle.bali.jle.util.GeometryUtils;
import oracle.bali.jle.util.ItemUtils;

public class DefaultLinkPainter
implements LinkPainter {
    private static DefaultLinkPainter _sPainter;
    private Color _selectionColor = Color.red;
    private Color _normalColor = Color.black;
    private static int _sMINIMUM_DIM;
    private static int _sBOUNDS_INC;
    private static int _sHitWidth;
    private static int _sArrowHeight;

    public static DefaultLinkPainter getLinkPainter() {
        if (_sPainter == null) {
            _sPainter = new DefaultLinkPainter();
        }
        return _sPainter;
    }

    private DefaultLinkPainter() {
    }

    public Rectangle2D getLinkBounds(LinkItem link) {
        if (link.getItemParent() == null) {
            return null;
        }
        LinkPort[] ports = link.getPorts();
        Point2D firstPoint = ItemUtils.itemToDevice(ports[0].getItem(), ports[0].getX(), ports[0].getY());
        Rectangle2D deviceBounds = new Rectangle2D.Double(firstPoint.getX(), firstPoint.getY(), _sMINIMUM_DIM, _sMINIMUM_DIM);
        int pCount = link.getPortCount();
        for (int i = 1; i < pCount; ++i) {
            LinkPort curr = ports[i];
            Point2D devicePoint = ItemUtils.itemToDevice(curr.getItem(), curr.getX(), curr.getY());
            deviceBounds.add(devicePoint);
        }
        deviceBounds = ItemUtils.deviceToItem(link.getItemParent(), deviceBounds);
        return new Rectangle2D.Double(deviceBounds.getX() - (double)_sBOUNDS_INC, deviceBounds.getY() - (double)_sBOUNDS_INC, deviceBounds.getWidth() + (double)(2 * _sBOUNDS_INC), deviceBounds.getHeight() + (double)(2 * _sBOUNDS_INC));
    }

    public void paintLink(LinkItem link, Graphics g, AffineTransform trans) {
        double horizDist;
        boolean vertical;
        LinkPort[] ports = link.getPorts();
        LinkPort source = ports[0];
        LinkPort dest = ports[ports.length - 1];
        Point2D sourceDev = LinkItem.getPortInDeviceDouble(source);
        Point2D destDev = LinkItem.getPortInDeviceDouble(dest);
        double sourceX = sourceDev.getX();
        double sourceY = sourceDev.getY();
        double destX = destDev.getX();
        double destY = destDev.getY();
        double vertDist = Math.abs(sourceY - destY);
        boolean bl = vertical = vertDist >= (horizDist = Math.abs(sourceX - destX));
        double midVal = vertical ? (sourceY <= destY ? sourceY + vertDist / 2.0 : destY + vertDist / 2.0) : (sourceX <= destX ? sourceX + horizDist / 2.0 : destX + horizDist / 2.0);
        Point mid1 = null;
        Point mid2 = null;
        Point srcPt = GeometryUtils.toPoint(sourceDev);
        Point dstPt = GeometryUtils.toPoint(destDev);
        Color oldColor = g.getColor();
        if (SelectionTool.isSelected(link)) {
            g.setColor(this._selectionColor);
        } else {
            g.setColor(this._normalColor);
        }
        if (vertical) {
            mid1 = new Point(srcPt.x, (int)Math.round(midVal));
            mid2 = new Point(dstPt.x, (int)Math.round(midVal));
            if (dest.isLower()) {
                this._paintVertArrow(g, dstPt, true);
            } else {
                this._paintVertArrow(g, dstPt, false);
            }
        } else {
            mid1 = new Point((int)Math.round(midVal), srcPt.y);
            mid2 = new Point((int)Math.round(midVal), dstPt.y);
            if (dest.isRight()) {
                this._paintHorizArrow(g, dstPt, true);
            } else {
                this._paintHorizArrow(g, dstPt, false);
            }
        }
        g.drawLine(srcPt.x, srcPt.y, mid1.x, mid1.y);
        g.drawLine(mid1.x, mid1.y, mid2.x, mid2.y);
        g.drawLine(mid2.x, mid2.y, dstPt.x, dstPt.y);
        g.setColor(oldColor);
    }

    public boolean hitTest(LinkItem link, double x, double y) {
        double horizDist;
        boolean vertical;
        Point2D hitDev = ItemUtils.itemToDevice(link, x, y);
        LinkPort[] ports = link.getPorts();
        LinkPort source = ports[0];
        LinkPort dest = ports[ports.length - 1];
        Point2D sourceDev = LinkItem.getPortInDeviceDouble(ports[0]);
        Point2D destDev = LinkItem.getPortInDeviceDouble(ports[ports.length - 1]);
        double sourceX = sourceDev.getX();
        double sourceY = sourceDev.getY();
        double destX = destDev.getX();
        double destY = destDev.getY();
        double hitX = hitDev.getX();
        double hitY = hitDev.getY();
        double vertDist = Math.abs(sourceY - destY);
        boolean bl = vertical = vertDist >= (horizDist = Math.abs(sourceX - destX));
        double midVal = vertical ? (sourceY <= destY ? sourceY + vertDist / 2.0 : destY + vertDist / 2.0) : (sourceX <= destX ? sourceX + horizDist / 2.0 : destX + horizDist / 2.0);
        Point mid1 = null;
        Point mid2 = null;
        Point srcPt = GeometryUtils.toPoint(sourceDev);
        Point dstPt = GeometryUtils.toPoint(destDev);
        if (vertical) {
            Point right;
            mid1 = new Point(srcPt.x, (int)Math.round(midVal));
            mid2 = new Point(dstPt.x, (int)Math.round(midVal));
            Point upper = srcPt.y <= dstPt.y ? srcPt : dstPt;
            Point lower = upper == srcPt ? dstPt : srcPt;
            Point left = mid1.x <= mid2.x ? mid1 : mid2;
            Point point = right = left == mid1 ? mid2 : mid1;
            if (hitY >= (double)upper.y && hitY <= (double)left.y && hitX >= (double)(upper.x - _sHitWidth) && hitX <= (double)(upper.x + _sHitWidth)) {
                return true;
            }
            if (hitX >= (double)left.x && hitX <= (double)right.x && hitY >= (double)(left.y - _sHitWidth) && hitY <= (double)(left.y + _sHitWidth)) {
                return true;
            }
            if (hitY <= (double)lower.y && hitY >= (double)left.y && hitX >= (double)(lower.x - _sHitWidth) && hitX <= (double)(lower.x + _sHitWidth)) {
                return true;
            }
        } else {
            Point right;
            mid1 = new Point((int)Math.round(midVal), srcPt.y);
            mid2 = new Point((int)Math.round(midVal), dstPt.y);
            Point upper = mid1.y <= mid2.y ? mid1 : mid1;
            Point lower = upper == mid1 ? mid2 : mid1;
            Point left = srcPt.x <= dstPt.x ? srcPt : dstPt;
            Point point = right = left == srcPt ? dstPt : srcPt;
            if (hitX >= (double)left.x && hitX <= (double)upper.x && hitY >= (double)(left.y - _sHitWidth) && hitY <= (double)(left.y + _sHitWidth)) {
                return true;
            }
            if (hitY >= (double)upper.y && hitY <= (double)lower.y && hitX >= (double)(upper.x - _sHitWidth) && hitX <= (double)(upper.x + _sHitWidth)) {
                return true;
            }
            if (hitX >= (double)upper.x && hitX <= (double)right.x && hitY >= (double)(right.y - _sHitWidth) && hitY <= (double)(right.y + _sHitWidth)) {
                return true;
            }
        }
        return false;
    }

    public Color getSelectionColor() {
        return this._selectionColor;
    }

    public Color getLinkColor() {
        return this._normalColor;
    }

    public void setSelectionColor(Color selection) {
        if (selection == null) {
            throw new IllegalArgumentException();
        }
        this._selectionColor = selection;
    }

    public void setLinkColor(Color link) {
        if (link == null) {
            throw new IllegalArgumentException();
        }
        this._normalColor = link;
    }

    private void _paintVertArrow(Graphics g, Point loc, boolean up) {
        int x = loc.x;
        int y = loc.y;
        int incr = up ? 1 : -1;
        for (int i = 0; i < _sArrowHeight; ++i) {
            g.drawLine(x - i, y, x + i, y);
            y += incr;
        }
    }

    private void _paintHorizArrow(Graphics g, Point loc, boolean left) {
        int x = loc.x;
        int y = loc.y;
        int incr = left ? 1 : -1;
        for (int i = 0; i < _sArrowHeight; ++i) {
            g.drawLine(x, y - i, x, y + i);
            x += incr;
        }
    }

    static {
        _sMINIMUM_DIM = 1;
        _sBOUNDS_INC = 1;
        _sHitWidth = 4;
        _sArrowHeight = 5;
    }
}

