/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle.item;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.util.WindowUtils;
import oracle.bali.jle.JLECanvas;
import oracle.bali.jle.LayoutItem;
import oracle.bali.jle.TransformException;
import oracle.bali.jle.event.JLEEvent;
import oracle.bali.jle.geom.AffineTransform;
import oracle.bali.jle.geom.ImmTransform;
import oracle.bali.jle.item.BaseItem;
import oracle.bali.jle.item.JComponentContainer;
import oracle.bali.jle.util.ItemUtils;

public class ComponentItem
extends BaseItem {
    private Component _comp;
    private Component _mouseTarget;
    private Component _mouseMotionTarget;
    private String _displayName;
    private Container _hidden;
    private Rectangle _deviceBounds;
    private double _scaleX = 1.0;
    private double _scaleY = 1.0;
    private Cursor _cursor;
    private long _eventMask;
    private Listener _listener;
    private boolean _mouseConsume;
    private static Container _defaultHidden;

    public ComponentItem(Component comp) {
        this(comp, 60L);
    }

    public ComponentItem(Component comp, long eventMask) {
        this._init(comp, eventMask);
    }

    public ComponentItem(Class compClass, long eventMask) {
        if (compClass == null) {
            throw new IllegalArgumentException("can't create null class");
        }
        if (!Component.class.isAssignableFrom(compClass)) {
            throw new IllegalArgumentException("class not a Component");
        }
        Component comp = null;
        try {
            comp = (Component)compClass.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("couldn't create wrapped Component");
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("couldn't create wrapped Component");
        }
        if (comp == null) {
            throw new IllegalArgumentException("couldn't create wrapped Component");
        }
        this._init(comp, eventMask);
    }

    public String getName() {
        if (this._displayName == null) {
            this._displayName = this.getDefaultName() + ": " + this._comp.getClass().getName();
        }
        return this._displayName;
    }

    public void setItemSize(double width, double height) {
        super.setItemSize(width, height);
        this._updateBounds();
    }

    public void updateDeviceTransform(ImmTransform parent) throws TransformException {
        super.updateDeviceTransform(parent);
        JLECanvas newCanvas = this.getCanvas();
        this._updateCanvas(newCanvas);
        AffineTransform newDevice = this.getDeviceTransform();
        double newScaleX = newDevice.getScaleX();
        double newScaleY = newDevice.getScaleY();
        if (this._scaleX != newScaleX || this._scaleY != newScaleY) {
            int newW = (int)Math.round((double)this._deviceBounds.width * (newScaleX / this._scaleX));
            int newH = (int)Math.round((double)this._deviceBounds.height * (newScaleY / this._scaleY));
            this._comp.setSize(newW, newH);
            this._scaleX = newScaleX;
            this._scaleY = newScaleY;
        }
        this._updateBounds();
    }

    public Object clone() throws CloneNotSupportedException {
        ComponentItem cloned = (ComponentItem)super.clone();
        Constructor<?> nullCons = null;
        try {
            nullCons = this._comp.getClass().getConstructor(null);
        }
        catch (NoSuchMethodException e) {
            throw new CloneNotSupportedException();
        }
        try {
            cloned._comp = (Component)nullCons.newInstance(null);
        }
        catch (InvocationTargetException e) {
            throw new CloneNotSupportedException();
        }
        catch (IllegalAccessException e2) {
            throw new CloneNotSupportedException();
        }
        catch (InstantiationException e3) {
            throw new CloneNotSupportedException();
        }
        cloned._comp.addFocusListener(cloned._listener);
        cloned._updateCanvas(null);
        cloned._deviceBounds = this._comp.getBounds();
        AffineTransform newDevice = this.getDeviceTransform();
        double newScaleX = newDevice.getScaleX();
        double newScaleY = newDevice.getScaleY();
        cloned.setItemSize((double)this._deviceBounds.width / newScaleX, (double)this._deviceBounds.height / newScaleY);
        cloned._eventMask = this._eventMask;
        cloned.enableJLEEvents(this._eventMask);
        return cloned;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintItemImpl(Graphics g, AffineTransform trans) {
        if (this._hidden == null) {
            this._updateCanvas(null);
        }
        Rectangle devRect = this.getDeviceRect(trans);
        Graphics newG = g.create();
        Rectangle clipRect = g.getClipBounds().intersection(devRect);
        newG.clipRect(clipRect.x, clipRect.y, clipRect.width, clipRect.height);
        newG.translate(devRect.x, devRect.y);
        try {
            this._comp.paint(newG);
        }
        finally {
            newG.dispose();
        }
    }

    public boolean isFocusTraversable() {
        return this._comp.isFocusTraversable();
    }

    public Component getComponent() {
        return this._comp;
    }

    public void pack() {
        Dimension prefSize = this._comp.getPreferredSize();
        double width = prefSize.width;
        double height = prefSize.height;
        JLECanvas canvas = this.getCanvas();
        if (canvas != null) {
            width *= canvas.getEngineUnitsPerPixelX();
            height *= canvas.getEngineUnitsPerPixelY();
        }
        this.setItemSize(width, height);
    }

    public void setForcedMouseConsumption(boolean consume) {
        this._mouseConsume = consume;
    }

    public boolean hasForcedMouseConsumption() {
        return this._mouseConsume;
    }

    public String toString() {
        return "ComponentItem: " + this._comp.getName();
    }

    public String getToolTipText(double x, double y) {
        int newY;
        int newX = (int)Math.round(x * this._scaleX);
        Component target = ComponentItem._getTargetComponent(this._comp, newX, newY = (int)Math.round(y * this._scaleY));
        if (target instanceof JComponent) {
            JComponent c = (JComponent)target;
            MouseEvent mouseEvent = new MouseEvent(this._comp, 503, System.currentTimeMillis(), 0, newX, newY, 1, false);
            String s = c.getToolTipText(mouseEvent = SwingUtilities.convertMouseEvent(this._comp, mouseEvent, c));
            if (s != null && !"".equals(s)) {
                return s;
            }
        }
        return null;
    }

    protected void processMouseMotionEvent(JLEEvent e) {
        this._redispatchMouseEvent(e);
    }

    protected void processMouseEvent(JLEEvent e) {
        this._redispatchMouseEvent(e);
    }

    protected void processKeyEvent(JLEEvent e) {
        if (e.getSource() == this) {
            return;
        }
        KeyEvent key = new KeyEvent(this._comp, e.getID(), e.getWhen(), e.getModifiers(), e.getKeyCode(), e.getKeyChar());
        this._comp.dispatchEvent(key);
        if (key.isConsumed()) {
            e.consume();
        }
    }

    protected void processFocusEvent(JLEEvent e) {
        if (e.getSource() == this) {
            boolean hasFocus = this.hasFocus();
            if (hasFocus && e.getID() == 1004) {
                this._comp.requestFocus();
                this._comp.addKeyListener(this._listener);
            } else if (!hasFocus && e.getID() == 1005) {
                Window win = WindowUtils.getWindow((Component)this._comp);
                if (win != null && win.getFocusOwner() == this._comp) {
                    this._comp.transferFocus();
                }
                this._comp.removeKeyListener(this._listener);
            }
        }
    }

    protected double getScaleX() {
        return this._scaleX;
    }

    protected double getScaleY() {
        return this._scaleY;
    }

    protected AccessibleContext createAccessibleContext() {
        if (this.getComponent() instanceof Accessible) {
            return ((Accessible)((Object)this.getComponent())).getAccessibleContext();
        }
        return super.createAccessibleContext();
    }

    private void _init(Component comp, long eventMask) {
        this._mouseConsume = true;
        this._listener = new Listener();
        if (comp == null) {
            throw new IllegalArgumentException("comp must be instantiated");
        }
        this._comp = comp;
        this._comp.addFocusListener(this._listener);
        this._updateCanvas(null);
        this._deviceBounds = this._comp.getBounds();
        if (this._deviceBounds.width <= 0 && this._deviceBounds.height <= 0) {
            this._comp.invalidate();
            this._comp.validate();
            Dimension preferred = this._comp.getPreferredSize();
            this._deviceBounds.width = preferred.width;
            this._deviceBounds.height = preferred.height;
        }
        this.setItemSize(this._deviceBounds.width, this._deviceBounds.height);
        this._eventMask = eventMask;
        this.enableJLEEvents(eventMask);
    }

    private void _keyToCanvas(KeyEvent e) {
        JLECanvas canvas = this.getCanvas();
        if (canvas == null) {
            return;
        }
        JLEEvent event = new JLEEvent(this, e.getID(), e.getWhen(), e.getModifiers(), e.getKeyCode(), e.getKeyChar());
        canvas.processJLEEvent(event);
    }

    private void _redispatchMouseEvent(JLEEvent e) {
        Cursor itemCursor;
        int id = e.getID();
        int newX = (int)Math.round(e.getX() * this._scaleX);
        int newY = (int)Math.round(e.getY() * this._scaleY);
        Component target = this._comp;
        if (id == 506 || id == 502) {
            target = this._mouseTarget;
        } else {
            target = ComponentItem._getTargetComponent(this._comp, newX, newY);
            if (id == 503) {
                if (this._mouseMotionTarget != null && this._mouseMotionTarget != target) {
                    Point tempPoint = this._targetToComp(this._mouseMotionTarget, newX, newY);
                    this._sendEvent(this._mouseMotionTarget, 505, e, tempPoint.x, tempPoint.y);
                    id = 504;
                }
                this._mouseMotionTarget = target;
            }
        }
        if (target != null && target != this._comp) {
            Point truePoint = this._targetToComp(target, newX, newY);
            newX = truePoint.x;
            newY = truePoint.y;
        }
        if (id == 501) {
            this._mouseTarget = target;
        }
        boolean consumed = this._sendEvent(target, id, e, newX, newY);
        if (id == 502) {
            this._mouseTarget = null;
        }
        if (consumed || this.hasForcedMouseConsumption()) {
            e.consume();
        }
        if ((itemCursor = target.getCursor()) != this._cursor) {
            this._cursor = itemCursor;
            this.putProperty(LayoutItem.CURSOR_KEY, itemCursor);
        }
    }

    private boolean _sendEvent(Component target, int id, JLEEvent e, int x, int y) {
        MouseEvent mouse = new MouseEvent(target, id, e.getWhen(), e.getModifiers(), x, y, e.getClickCount(), false);
        target.dispatchEvent(mouse);
        return mouse.isConsumed();
    }

    private Point _targetToComp(Component comp, int x, int y) {
        while (comp != this._comp) {
            Point pos = comp.getLocation();
            x -= pos.x;
            y -= pos.y;
            comp = comp.getParent();
        }
        return new Point(x, y);
    }

    private void _updateCanvas(JLECanvas canvas) {
        if (canvas == null) {
            this._hidden = this._getDefaultHiddenContainer();
        } else if (this._hidden == this._getDefaultHiddenContainer()) {
            this._hidden = canvas.getComponentContainer(this._comp);
        }
        Container oldParent = this._comp.getParent();
        if (oldParent != this._hidden) {
            int index = -1;
            LayoutItem parent = this.getItemParent();
            if (parent != null) {
                int count = parent.getItemCount();
                int j = -1;
                for (int i = 0; i < count; ++i) {
                    LayoutItem item = parent.getItem(i);
                    if (!(item instanceof ComponentItem)) continue;
                    ++j;
                    if (item != this) continue;
                    index = j;
                    break;
                }
            }
            this._hidden.add(this._comp, this, index);
        }
    }

    private void _updateBounds() {
        LayoutItem parent = this.getItemParent();
        this._deviceBounds = parent == null ? ItemUtils.itemToDevice((LayoutItem)this, this.getItemBounds()) : ItemUtils.parentToDevice((LayoutItem)this, this.getItemBounds());
        JLECanvas canvas = this.getCanvas();
        if (canvas != null && canvas.isZoomed()) {
            this._deviceBounds.x = (int)((double)this._deviceBounds.x / canvas.getZoomX());
            this._deviceBounds.y = (int)((double)this._deviceBounds.y / canvas.getZoomY());
            this._deviceBounds.width = (int)((double)this._deviceBounds.width / canvas.getZoomX());
            this._deviceBounds.height = (int)((double)this._deviceBounds.height / canvas.getZoomY());
        }
        this._comp.setBounds(this._deviceBounds.x, this._deviceBounds.y, this._deviceBounds.width, this._deviceBounds.height);
        this._comp.validate();
    }

    private Container _getDefaultHiddenContainer() {
        if (_defaultHidden == null) {
            _defaultHidden = new JComponentContainer(null);
        }
        return _defaultHidden;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Component _getTargetComponent(Component component, int x, int y) {
        if (component instanceof Container) {
            Container container = (Container)component;
            Object object = container.getTreeLock();
            synchronized (object) {
                int count = container.getComponentCount();
                for (int i = 0; i < count; ++i) {
                    Component child = container.getComponent(i);
                    Point location = child.getLocation();
                    int childX = x - location.x;
                    int childY = y - location.y;
                    if (!child.isVisible() || !child.contains(childX, childY)) continue;
                    x = childX;
                    y = childY;
                    return ComponentItem._getTargetComponent(child, x, y);
                }
            }
        }
        return component;
    }

    class Listener
    implements FocusListener,
    KeyListener {
        Listener() {
        }

        public void focusGained(FocusEvent e) {
            ComponentItem.this.getCanvas().setFocusedItem(ComponentItem.this);
        }

        public void focusLost(FocusEvent e) {
        }

        public void keyTyped(KeyEvent e) {
            if (e.getKeyCode() != 9) {
                ComponentItem.this._keyToCanvas(e);
            }
        }

        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() != 9) {
                ComponentItem.this._keyToCanvas(e);
            }
        }

        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() != 9) {
                ComponentItem.this._keyToCanvas(e);
            }
        }
    }
}

