/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle.item;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.util.Enumeration;
import java.util.EventListener;
import javax.accessibility.AccessibleContext;
import oracle.bali.ewt.graphics.TransparencyFilter;
import oracle.bali.jle.JLECanvas;
import oracle.bali.jle.LayoutItem;
import oracle.bali.jle.ListPropertyManager;
import oracle.bali.jle.PropertyManager;
import oracle.bali.jle.TransformException;
import oracle.bali.jle.event.JLEEvent;
import oracle.bali.jle.event.JLEEventListener;
import oracle.bali.jle.geom.AffineTransform;
import oracle.bali.jle.geom.Dimension2D;
import oracle.bali.jle.geom.ImmTransform;
import oracle.bali.jle.geom.Point2D;
import oracle.bali.jle.geom.Rectangle2D;
import oracle.bali.jle.item.AccessibleLayoutItem;
import oracle.bali.jle.util.GeometryUtils;
import oracle.bali.jle.util.ItemUtils;
import oracle.bali.share.event.ListenerManager;

public class BaseItem
implements LayoutItem {
    private String _name;
    private AffineTransform _itemTran;
    private AffineTransform _deviceTran;
    private double _x;
    private double _y;
    private double _width;
    private double _height;
    private LayoutItem _parent;
    private PropertyManager _pm;
    private long _enabledEvents;
    private ListenerManager _listeners;
    private String _defaultName = null;
    private AffineTransform _lastTrans = new AffineTransform();
    private Rectangle _lastRect;
    private boolean _boundsChange = true;
    private Image _cachedImage;
    private double _cachedZoomX;
    private double _cachedZoomY;
    private AccessibleContext _accessibleContext;
    private static int _sInstanceCounter = 0;
    private static final ImmTransform _sIdentity = ImmTransform.getIdentity();
    private static final Color _sTransparentColor = Color.magenta;
    private static boolean _sCacheAllowed = true;
    private static int _sScaleHint = 2;

    public static boolean isZoomCachingAllowed() {
        return _sCacheAllowed;
    }

    public static void setZoomCachingAllowed(boolean allowCaching) {
        _sCacheAllowed = allowCaching;
    }

    public BaseItem() {
        this._itemTran = new AffineTransform();
        this._deviceTran = new AffineTransform();
        this.getPropertyManager().put(ITEM_TRANSFORM_KEY, this._itemTran.clone());
        this.getPropertyManager().put(DEVICE_TRANSFORM_KEY, this._deviceTran.clone());
        this._enabledEvents = 0L;
        this._height = 0.0;
        this._width = 0.0;
        this._y = 0.0;
        this._x = 0.0;
    }

    public String getName() {
        if (this._name == null) {
            this._name = this.getDefaultName();
        }
        return this._name;
    }

    public JLECanvas getCanvas() {
        if (this._parent != null) {
            return this._parent.getCanvas();
        }
        return null;
    }

    public String toString() {
        return this.getName();
    }

    public Rectangle2D getItemBounds() {
        return new Rectangle2D.Double(this._x, this._y, this._width, this._height);
    }

    public Dimension2D getItemSize() {
        return new Dimension2D.Double(this._width, this._height);
    }

    public void setItemSize(double width, double height) {
        boolean fireBounds = this.updateBounds(this._x, this._y, width, height);
        if (fireBounds) {
            this.getPropertyManager().put(BOUNDS_KEY, this.getItemBounds());
        }
    }

    public void setItemLocation(double x, double y) {
        double oldX = this._x;
        double oldY = this._y;
        boolean fireBounds = this.updateBounds(x, y, this._width, this._height);
        AffineTransform temp = this.getItemTransform();
        temp.translate(x - oldX, y - oldY);
        this._itemTran = temp;
        this.getPropertyManager().put(ITEM_TRANSFORM_KEY, this._itemTran.clone());
        try {
            LayoutItem parent = this.getItemParent();
            this.updateDeviceTransform(parent != null ? new ImmTransform(parent.getDeviceTransform()) : _sIdentity);
        }
        catch (TransformException e) {
            throw new IllegalStateException("couldn't set location transform");
        }
        if (fireBounds) {
            this.getPropertyManager().put(BOUNDS_KEY, this.getItemBounds());
        }
    }

    public void setItemBounds(double x, double y, double width, double height) {
        double oldX = this._x;
        double oldY = this._y;
        boolean fireBounds = this.updateBounds(x, y, width, height);
        AffineTransform temp = this.getItemTransform();
        temp.translate(this._x - oldX, this._y - oldY);
        this._itemTran = temp;
        try {
            LayoutItem parent = this.getItemParent();
            this.updateDeviceTransform(parent != null ? new ImmTransform(parent.getDeviceTransform()) : _sIdentity);
        }
        catch (TransformException e) {
            throw new IllegalStateException("couldn't set location transform");
        }
        if (fireBounds) {
            this.getPropertyManager().put(BOUNDS_KEY, this.getItemBounds());
        }
    }

    public Point2D getItemLocation() {
        return new Point2D.Double(this._x, this._y);
    }

    public AffineTransform getItemTransform() {
        return (AffineTransform)this._itemTran.clone();
    }

    public void setItemTransform(AffineTransform tran) throws TransformException {
        if (tran == null) {
            throw new IllegalArgumentException("item can't have null transform");
        }
        int type = tran.getType();
        this._itemTran = (AffineTransform)tran.clone();
        boolean fireBounds = this.updateBounds(this._itemTran.getTranslateX(), this._itemTran.getTranslateY(), this._width, this._height);
        this.getPropertyManager().put(ITEM_TRANSFORM_KEY, tran.clone());
        LayoutItem parent = this.getItemParent();
        this.updateDeviceTransform(parent != null ? new ImmTransform(parent.getDeviceTransform()) : _sIdentity);
        if (fireBounds) {
            this.getPropertyManager().put(BOUNDS_KEY, this.getItemBounds());
        }
    }

    public AffineTransform getDeviceTransform() {
        return (AffineTransform)this._deviceTran.clone();
    }

    public final void paintItem(Graphics g, AffineTransform trans) {
        JLECanvas canvas = this.getCanvas();
        if (canvas == null) {
            return;
        }
        if (canvas.isZoomed()) {
            this.paintItemZoomed(g, trans, canvas.getZoomX(), canvas.getZoomY());
        } else {
            this.paintItemImpl(g, trans);
        }
    }

    public void paintItemImpl(Graphics g, AffineTransform trans) {
    }

    public void paintItemZoomed(Graphics g, AffineTransform trans, double zoomX, double zoomY) {
        Point itemPoint = ItemUtils.parentToDevice((LayoutItem)this, this.getItemLocation());
        boolean useCache = this._useCachedImage(zoomX, zoomY);
        if (useCache) {
            g.drawImage(this._cachedImage, itemPoint.x, itemPoint.y, null);
            return;
        }
        JLECanvas canvas = this.getCanvas();
        AffineTransform localTrans = new AffineTransform(trans);
        Graphics savedGraphics = null;
        Image itemImage = ItemUtils.getItemImage(this);
        Image scaled = null;
        if (itemImage != null) {
            Dimension2D size = this.getItemSize();
            double engineX = canvas.getEngineUnitsPerPixelX();
            double engineY = canvas.getEngineUnitsPerPixelY();
            double imageWidth = size.getWidth() / engineX;
            double imageHeight = size.getHeight() / engineY;
            Dimension2D zoom = canvas.getZoom();
            savedGraphics = g;
            Rectangle clipBounds = savedGraphics.getClipBounds();
            g = itemImage.getGraphics();
            g.setClip(0, 0, (int)Math.ceil(imageWidth), (int)Math.ceil(imageHeight));
            g.setColor(_sTransparentColor);
            g.fillRect(0, 0, (int)Math.ceil(imageWidth), (int)Math.ceil(imageHeight));
            g.translate(-itemPoint.x, -itemPoint.y);
            localTrans.scale(1.0 / zoom.getWidth(), 1.0 / zoom.getHeight());
            this.paintItemImpl(g, localTrans);
            Image transparentImage = canvas.createImage(new FilteredImageSource(itemImage.getSource(), (ImageFilter)new TransparencyFilter(_sTransparentColor)));
            int newWidth = (int)(zoomX * imageWidth);
            int newHeight = (int)(zoomY * imageHeight);
            scaled = transparentImage.getScaledInstance(newWidth, newHeight, BaseItem.getImageScaleHint());
            g.dispose();
            itemImage.flush();
            transparentImage.flush();
            this._cachedImage = scaled;
            this._cachedZoomX = zoomX;
            this._cachedZoomY = zoomY;
            savedGraphics.drawImage(scaled, itemPoint.x, itemPoint.y, null);
        }
    }

    public static void setImageScaleHint(int hint) {
        _sScaleHint = hint;
    }

    public static int getImageScaleHint() {
        return _sScaleHint;
    }

    public void repaintItem(double x, double y, double width, double height) {
        if (this.getCanvas() != null) {
            Rectangle devRect = ItemUtils.itemToDevice(this, x, y, width, height);
            this.getCanvas().repaintCanvas(devRect.x, devRect.y, devRect.width, devRect.height);
        }
    }

    public void printItem(Graphics g, AffineTransform trans) {
        this.paintItem(g, trans);
    }

    public boolean eventEnabled(JLEEvent e) {
        switch (e.getID()) {
            case 503: 
            case 506: {
                if ((this._enabledEvents & 0x20L) == 0L) break;
                return true;
            }
            case 500: 
            case 501: 
            case 502: 
            case 504: 
            case 505: {
                if ((this._enabledEvents & 0x10L) == 0L) break;
                return true;
            }
            case 400: 
            case 401: 
            case 402: {
                if ((this._enabledEvents & 8L) == 0L) break;
                return true;
            }
            case 1004: 
            case 1005: {
                if ((this._enabledEvents & 4L) == 0L) break;
                return true;
            }
        }
        return false;
    }

    public final void processEvent(JLEEvent e) {
        if (!this.eventEnabled(e)) {
            return;
        }
        int id = e.getID();
        if (this._listeners != null) {
            Enumeration enumer = this._listeners.getListeners();
            while (enumer.hasMoreElements()) {
                JLEEventListener curr = (JLEEventListener)enumer.nextElement();
                switch (id) {
                    case 503: {
                        curr.mouseMoved(e);
                        break;
                    }
                    case 506: {
                        curr.mouseDragged(e);
                        break;
                    }
                    case 501: {
                        curr.mousePressed(e);
                        break;
                    }
                    case 502: {
                        curr.mouseReleased(e);
                        break;
                    }
                    case 500: {
                        curr.mouseClicked(e);
                        break;
                    }
                    case 504: {
                        curr.mouseEntered(e);
                        break;
                    }
                    case 505: {
                        curr.mouseExited(e);
                        break;
                    }
                    case 401: {
                        curr.keyPressed(e);
                        break;
                    }
                    case 402: {
                        curr.keyReleased(e);
                        break;
                    }
                    case 400: {
                        curr.keyTyped(e);
                        break;
                    }
                    case 1004: {
                        curr.focusGained(e);
                        break;
                    }
                    case 1005: {
                        curr.focusLost(e);
                    }
                }
            }
        }
        if (!e.isConsumed()) {
            switch (id) {
                case 503: 
                case 506: {
                    this.processMouseMotionEvent(e);
                    break;
                }
                case 500: 
                case 501: 
                case 502: 
                case 504: 
                case 505: {
                    this.processMouseEvent(e);
                    break;
                }
                case 400: 
                case 401: 
                case 402: {
                    this.processKeyEvent(e);
                }
            }
            if (id == 1004 || id == 1005) {
                this.processFocusEvent(e);
            }
        }
    }

    public boolean allowsChildren() {
        return false;
    }

    public void addItem(LayoutItem item, int index) {
        throw new IllegalStateException("item does not allow children");
    }

    public void addItem(LayoutItem item) {
        throw new IllegalStateException("item does not allow children");
    }

    public void removeItem(LayoutItem item) {
    }

    public void removeItem(int itemIndex) {
    }

    public void removeAllItems() {
    }

    public int getItemCount() {
        return 0;
    }

    public LayoutItem getItem(int i) {
        return null;
    }

    public LayoutItem[] getItems() {
        return new LayoutItem[0];
    }

    public void setItemParent(LayoutItem parent) {
        this._parent = parent;
        try {
            this.updateDeviceTransform(parent != null ? new ImmTransform(parent.getDeviceTransform()) : _sIdentity);
        }
        catch (TransformException e) {
            this._parent = null;
            this.setDeviceTransform(this.getItemTransform());
            this.getPropertyManager().put(PARENT_KEY, null);
            throw new IllegalStateException("couldn't set parent transform");
        }
        this.getPropertyManager().put(PARENT_KEY, parent);
    }

    public LayoutItem getItemParent() {
        return this._parent;
    }

    public boolean contains(double x, double y) {
        return x >= 0.0 && x < this._width && y >= 0.0 && y < this._height;
    }

    public LayoutItem getItemAt(double x, double y) {
        return this.contains(x, y) ? this : null;
    }

    public boolean hitTest(double x, double y) {
        return x >= 0.0 && x < this._width && y >= 0.0 && y < this._height;
    }

    public LayoutItem getHitItem(double x, double y) {
        return this.hitTest(x, y) ? this : null;
    }

    public PropertyManager getPropertyManager() {
        if (this._pm == null) {
            this._pm = this.createPropertyManager();
        }
        return this._pm;
    }

    public Object getProperty(Object key) {
        return this.getPropertyManager().get(key);
    }

    public Object putProperty(Object key, Object value) {
        return this.getPropertyManager().put(key, value);
    }

    public Object removeProperty(Object key) {
        return this.getPropertyManager().remove(key);
    }

    public Object clone() throws CloneNotSupportedException {
        BaseItem cloned = (BaseItem)super.clone();
        cloned._name = null;
        cloned._itemTran = new AffineTransform();
        cloned._deviceTran = new AffineTransform();
        cloned._height = 0.0;
        cloned._width = 0.0;
        cloned._y = 0.0;
        cloned._x = 0.0;
        cloned.setItemBounds(this._x, this._y, this._width, this._height);
        cloned._parent = null;
        cloned._pm = null;
        cloned._enabledEvents = 0L;
        cloned._listeners = null;
        cloned._accessibleContext = null;
        return cloned;
    }

    public void enableJLEEvents(long eventsToEnable) {
        this._enabledEvents |= eventsToEnable;
    }

    public void addJLEEventListener(JLEEventListener l) {
        if (this._listeners == null) {
            this._listeners = new ListenerManager();
        }
        this._listeners.addListener((EventListener)l);
    }

    public void removeJLEEventListener(JLEEventListener l) {
        if (this._listeners != null) {
            this._listeners.removeListener((EventListener)l);
        }
    }

    public final void repaintItem() {
        this.repaintItem(0.0, 0.0, this._width, this._height);
    }

    public void paintImmediate(double x, double y, double width, double height) {
        if (this.getCanvas() != null) {
            Rectangle devRect = ItemUtils.itemToDevice(this, x, y, width, height);
            this.getCanvas().paintImmediateCanvas(devRect.x, devRect.y, devRect.width, devRect.height);
        }
    }

    public final void paintImmediate() {
        this.paintImmediate(0.0, 0.0, this._width, this._height);
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public boolean hasFocus() {
        JLECanvas canvas = this.getCanvas();
        return canvas == null ? false : canvas.getFocusedItem() == this;
    }

    public void requestFocus() {
        JLECanvas canvas = this.getCanvas();
        if (canvas != null) {
            canvas.setFocusedItem(this);
        }
    }

    public Rectangle getDeviceRect(AffineTransform trans) {
        if (this._boundsChange || !trans.equals(this._lastTrans)) {
            this._lastRect = GeometryUtils.toRectangle(ItemUtils.transformRect(trans, 0.0, 0.0, this._width, this._height, false));
            this._boundsChange = false;
            this._lastTrans.setTransform(trans);
        }
        return new Rectangle(this._lastRect);
    }

    public void transferFocus() {
        JLECanvas canvas = this.getCanvas();
        if (canvas != null) {
            canvas.setFocusNext();
        }
    }

    public void invalidateZoomImage() {
        this._cachedImage = null;
    }

    public boolean isZoomImageValid() {
        return this._cachedImage != null;
    }

    protected String getDefaultName() {
        if (this._defaultName == null) {
            this._defaultName = this.getBaseClassName() + _sInstanceCounter++;
        }
        return this._defaultName;
    }

    protected String getBaseClassName() {
        String className = this.getClass().getName();
        return className.substring(className.lastIndexOf(46) + 1);
    }

    public void updateDeviceTransform(ImmTransform parent) throws TransformException {
        int type = parent.getType();
        AffineTransform newDevice = this.getItemTransform();
        newDevice.preConcatenate(parent);
        this.setDeviceTransform(newDevice);
    }

    public final AccessibleContext getAccessibleContext() {
        if (this._accessibleContext == null) {
            this._accessibleContext = this.createAccessibleContext();
        }
        return this._accessibleContext;
    }

    protected void setDeviceTransform(AffineTransform device) {
        this._deviceTran = device;
        this.getPropertyManager().put(DEVICE_TRANSFORM_KEY, device.clone());
    }

    protected PropertyManager createPropertyManager() {
        return new ListPropertyManager(this);
    }

    protected void processMouseMotionEvent(JLEEvent e) {
    }

    protected void processMouseEvent(JLEEvent e) {
    }

    protected void processKeyEvent(JLEEvent e) {
    }

    protected void processFocusEvent(JLEEvent e) {
    }

    protected boolean updateBounds(double x, double y, double width, double height) {
        boolean fireProperty;
        boolean invalidateImage = width != this._width || height != this._height;
        boolean bl = fireProperty = invalidateImage || x != this._x || y != this._y;
        if (width < 0.0) {
            width = -width;
            x = x <= this._x ? this._x - width : this._x + this._width;
        }
        if (height < 0.0) {
            height = -height;
            y = y <= this._y ? this._y - height : this._y + this._height;
        }
        this._x = x;
        this._y = y;
        this._width = width;
        this._height = height;
        this._boundsChange = true;
        if (invalidateImage) {
            this.invalidateZoomImage();
        }
        return fireProperty;
    }

    protected AccessibleContext createAccessibleContext() {
        return new AccessibleLayoutItem(this);
    }

    protected AccessibleContext accessAccessibleContext() {
        return this._accessibleContext;
    }

    private boolean _useCachedImage(double zoomX, double zoomY) {
        return this._cachedImage != null && BaseItem.isZoomCachingAllowed() && zoomX == this._cachedZoomX && zoomY == this._cachedZoomY;
    }
}

