/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle.item;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Vector;
import javax.accessibility.AccessibleContext;
import oracle.bali.ewt.painter.FilledRectPainter;
import oracle.bali.ewt.painter.FixedColorPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.painter.PainterStacker;
import oracle.bali.jle.LayoutItem;
import oracle.bali.jle.TransformException;
import oracle.bali.jle.geom.AffineTransform;
import oracle.bali.jle.geom.ImmTransform;
import oracle.bali.jle.geom.Point2D;
import oracle.bali.jle.geom.Rectangle2D;
import oracle.bali.jle.item.BaseItem;
import oracle.bali.jle.item.JLEContainerEvent;
import oracle.bali.jle.item.JLEContainerListener;
import oracle.bali.jle.tool.SelectionTool;
import oracle.bali.jle.util.GeometryUtils;
import oracle.bali.jle.util.ItemUtils;
import oracle.bali.share.event.ListenerManager;

public class BaseContainer
extends BaseItem {
    private Vector _items;
    private boolean _allowHits;
    private ListenerManager _listeners;
    private AffineTransform _lastTrans = new AffineTransform();
    private Painter _painter;
    private PainterStacker _stacker;
    private FixedColorPainter _colorChanger;

    public BaseContainer() {
        this(false);
    }

    public BaseContainer(boolean allowHits) {
        this._items = new Vector(4);
        this.setAllowsHits(allowHits);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void paintItemImpl(Graphics g, AffineTransform trans) {
        PainterStacker toPaint;
        Rectangle clip = g.getClipBounds();
        Object object = this._stacker != null ? this._stacker : (this._colorChanger != null ? this._colorChanger : (toPaint = this._painter != null ? this._painter : null));
        if (toPaint != null) {
            PaintContext context = this.getCanvas().getPaintContext();
            Rectangle devRect = this.getDeviceRect(trans);
            g.translate(devRect.x, devRect.y);
            clip.translate(-devRect.x, -devRect.y);
            toPaint.paint(context, g, 0, 0, devRect.width, devRect.height);
            g.translate(-devRect.x, -devRect.y);
            clip.translate(devRect.x, devRect.y);
        }
        this.paintBackground(g, trans);
        boolean useCache = trans.equals(this._lastTrans);
        this._lastTrans.setTransform(trans);
        for (int i = this.getItemCount() - 1; i >= 0; --i) {
            Rectangle childDevice;
            AffineTransform deviceT;
            ChildCache curr = (ChildCache)this._items.elementAt(i);
            LayoutItem child = curr._child;
            Rectangle2D bounds = child.getItemBounds();
            boolean itemUseCache = false;
            if (useCache && curr._childTransform != null && curr._childBounds.equals(bounds)) {
                itemUseCache = true;
            }
            if (itemUseCache) {
                deviceT = curr._childTransform;
                childDevice = curr._childDevRect;
            } else {
                deviceT = child.getItemTransform();
                deviceT.preConcatenate(trans);
                childDevice = GeometryUtils.toRectangle(ItemUtils.transformRect(trans, bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight(), false));
                curr._childTransform = deviceT;
                curr._childDevRect = childDevice;
                curr._childBounds = bounds;
            }
            Rectangle childClip = clip.intersection(childDevice);
            if (childClip.isEmpty()) continue;
            Graphics childGraphics = g.create();
            childGraphics.clipRect(childDevice.x, childDevice.y, childDevice.width, childDevice.height);
            try {
                child.paintItem(childGraphics, deviceT);
                continue;
            }
            finally {
                childGraphics.dispose();
            }
        }
    }

    public final void paintItemZoomed(Graphics g, AffineTransform trans, double zoomX, double zoomY) {
        this.paintItemImpl(g, trans);
    }

    public final Painter getPainter() {
        return this._painter;
    }

    public final void setPainter(Painter painter) {
        this._painter = painter;
        if (painter == null) {
            this._stacker = null;
        } else if (this._colorChanger != null) {
            this._stacker = new PainterStacker((Painter)this._colorChanger, this._painter);
        }
        this.repaintItem();
    }

    public final Color getBackground() {
        return this._colorChanger == null ? null : this._colorChanger.getColor(null);
    }

    public final void setBackground(Color background) {
        if (background == null) {
            this._stacker = null;
            this._colorChanger = null;
        } else {
            this._colorChanger = new FixedColorPainter(FilledRectPainter.getPainter(), background);
            if (this._painter != null) {
                this._stacker = new PainterStacker((Painter)this._colorChanger, this._painter);
            }
        }
        this.repaintItem();
    }

    public boolean getAllowsHits() {
        return this._allowHits;
    }

    public void setAllowsHits(boolean allowsHits) {
        this._allowHits = allowsHits;
        SelectionTool.setSelectable(this, this._allowHits);
    }

    public boolean allowsChildren() {
        return true;
    }

    public void addItem(LayoutItem item, int index) {
        this.addItemImpl(item, index);
    }

    public final void addItem(LayoutItem item) {
        this.addItemImpl(item, -1);
    }

    public final void removeItem(LayoutItem item) {
        int index = -1;
        for (int i = 0; i < this._items.size(); ++i) {
            ChildCache curr = (ChildCache)this._items.elementAt(i);
            if (curr._child != item) continue;
            index = i;
            break;
        }
        if (index == -1) {
            throw new IllegalArgumentException("item is not a child");
        }
        this.removeItem(index);
    }

    public void removeItem(int itemIndex) {
        if (itemIndex > this._items.size()) {
            throw new IllegalArgumentException("child index is not valid");
        }
        ChildCache curr = (ChildCache)this._items.elementAt(itemIndex);
        this._items.removeElementAt(itemIndex);
        LayoutItem child = curr._child;
        child.setItemParent(null);
        this.fireJLEContainerEvent(2, child);
        this.getPropertyManager().put(CHILDREN_KEY, this.getItems());
        AccessibleContext ac = this.accessAccessibleContext();
        if (ac != null) {
            ac.firePropertyChange("AccessibleChild", child, null);
        }
    }

    public void removeAllItems() {
        Enumeration doomed = this._items.elements();
        while (doomed.hasMoreElements()) {
            ChildCache curr = (ChildCache)doomed.nextElement();
            this.removeItem(curr._child);
            this.fireJLEContainerEvent(2, curr._child);
        }
        this.getPropertyManager().put(CHILDREN_KEY, this.getItems());
        this.repaintItem();
    }

    public int getItemCount() {
        return this._items.size();
    }

    public LayoutItem getItem(int i) {
        if (i < 0 || i > this._items.size() - 1) {
            throw new IllegalArgumentException("not a valid item index");
        }
        ChildCache found = (ChildCache)this._items.elementAt(i);
        return found._child;
    }

    public LayoutItem[] getItems() {
        LayoutItem[] items = new LayoutItem[this._items.size()];
        for (int i = 0; i < this._items.size(); ++i) {
            ChildCache curr = (ChildCache)this._items.elementAt(i);
            items[i] = curr._child;
        }
        return items;
    }

    public LayoutItem getItemAt(double x, double y) {
        int itemCount = this.getItemCount();
        if (itemCount > 0) {
            for (int i = 0; i < itemCount; ++i) {
                Point2D childPoint;
                LayoutItem child = this.getItem(i);
                LayoutItem foundItem = child.getItemAt((childPoint = ItemUtils.parentToItem(child, x, y)).getX(), childPoint.getY());
                if (foundItem == null) continue;
                return foundItem;
            }
        }
        return super.getItemAt(x, y);
    }

    public boolean hitTest(double x, double y) {
        return this._allowHits ? super.hitTest(x, y) : false;
    }

    public LayoutItem getHitItem(double x, double y) {
        int itemCount = this.getItemCount();
        if (itemCount > 0) {
            for (int i = 0; i < itemCount; ++i) {
                Point2D childPoint;
                LayoutItem child = this.getItem(i);
                LayoutItem foundItem = child.getHitItem((childPoint = ItemUtils.parentToItem(child, x, y)).getX(), childPoint.getY());
                if (foundItem == null) continue;
                return foundItem;
            }
        }
        return super.getHitItem(x, y);
    }

    public Object clone() throws CloneNotSupportedException {
        BaseContainer cloned = (BaseContainer)super.clone();
        cloned._items = new Vector(4);
        LayoutItem[] items = this.getItems();
        int count = items == null ? 0 : items.length;
        for (int i = 0; i < count; ++i) {
            LayoutItem clonedItem = (LayoutItem)items[i].clone();
            cloned.addItem(clonedItem);
        }
        return cloned;
    }

    protected void paintBackground(Graphics g, AffineTransform trans) {
    }

    protected void addItemImpl(LayoutItem item, int index) {
        if (index > this._items.size()) {
            throw new IllegalArgumentException("not a valid item index");
        }
        if (!this.allowsChildren()) {
            throw new IllegalStateException("container does not allow children");
        }
        LayoutItem oldParent = item.getItemParent();
        if (oldParent != null) {
            oldParent.removeItem(item);
        }
        if (index < 0) {
            this._items.addElement(new ChildCache(item));
        } else {
            this._items.insertElementAt(new ChildCache(item), index);
        }
        item.setItemParent(this);
        this.fireJLEContainerEvent(1, item);
        this.getPropertyManager().put(CHILDREN_KEY, this.getItems());
        AccessibleContext ac = this.accessAccessibleContext();
        if (ac != null) {
            ac.firePropertyChange("AccessibleChild", null, item);
        }
    }

    public void updateDeviceTransform(ImmTransform parent) throws TransformException {
        super.updateDeviceTransform(parent);
        ImmTransform device = new ImmTransform(this.getDeviceTransform());
        for (int i = this.getItemCount() - 1; i >= 0; --i) {
            ChildCache curr = (ChildCache)this._items.elementAt(i);
            LayoutItem child = curr._child;
            child.updateDeviceTransform(device);
        }
    }

    public void addJLEContainerListener(JLEContainerListener l) {
        if (this._listeners == null) {
            this._listeners = new ListenerManager();
        }
        this._listeners.addListener((EventListener)l);
    }

    public void removeJLEContainerListener(JLEContainerListener l) {
        if (this._listeners != null) {
            this._listeners.removeListener((EventListener)l);
        }
    }

    protected void fireJLEContainerEvent(int id, LayoutItem child) {
        Enumeration listeners;
        Enumeration enumeration = listeners = this._listeners == null ? null : this._listeners.getListeners();
        if (listeners == null) {
            return;
        }
        JLEContainerEvent event = new JLEContainerEvent(this, id, child);
        while (listeners.hasMoreElements()) {
            JLEContainerListener listener = (JLEContainerListener)listeners.nextElement();
            switch (id) {
                case 1: {
                    listener.itemAdded(event);
                    break;
                }
                case 2: {
                    listener.itemRemoved(event);
                }
            }
        }
    }

    class ChildCache {
        LayoutItem _child;
        AffineTransform _childTransform;
        Rectangle _childDevRect;
        Rectangle2D _childBounds;

        ChildCache(LayoutItem child) {
            this._child = child;
        }
    }
}

