/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle.geom;

import java.awt.Rectangle;
import oracle.bali.jle.geom.Dimension2D;
import oracle.bali.jle.geom.Line2D;
import oracle.bali.jle.geom.Point2D;

public abstract class Rectangle2D {
    public static final int OUT_LEFT = 1;
    public static final int OUT_TOP = 2;
    public static final int OUT_RIGHT = 4;
    public static final int OUT_BOTTOM = 8;

    protected Rectangle2D() {
    }

    public abstract void setRect(double var1, double var3, double var5, double var7);

    public void setRect(Rectangle2D r) {
        this.setRect(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public boolean intersectsLine(double x1, double y1, double x2, double y2) {
        int out1 = this.outcode(x1, y1);
        int out2 = this.outcode(x2, y2);
        while ((out1 & out2) == 0) {
            if (out1 == 0) {
                if (out2 == 0) {
                    return true;
                }
                double f = x1;
                x1 = x2;
                x2 = f;
                f = y1;
                y1 = y2;
                y2 = f;
                int out = out1;
                out1 = out2;
                out2 = out;
            }
            if ((out1 & 5) != 0) {
                double x = this.getX();
                if ((out1 & 4) != 0) {
                    x += this.getWidth();
                }
                y1 += (x - x1) * (y2 - y1) / (x2 - x1);
                x1 = x;
            } else if ((out1 & 0xA) != 0) {
                double y = this.getY();
                if ((out1 & 8) != 0) {
                    y += this.getHeight();
                }
                x1 += (y - y1) * (x2 - x1) / (y2 - y1);
                y1 = y;
            }
            out1 = this.outcode(x1, y1);
        }
        return false;
    }

    public boolean intersectsLine(Line2D l) {
        return this.intersectsLine(l.getX1(), l.getY1(), l.getX2(), l.getY2());
    }

    public abstract int outcode(double var1, double var3);

    public int outcode(Point2D p) {
        return this.outcode(p.getX(), p.getY());
    }

    public void setBounds(double x, double y, double w, double h) {
        this.setRect(x, y, w, h);
    }

    public Rectangle2D getBounds2D() {
        return this;
    }

    public boolean contains(double x, double y) {
        double x0 = this.getX();
        double y0 = this.getY();
        return x >= x0 && y >= y0 && x < x0 + this.getWidth() && y < y0 + this.getHeight();
    }

    public boolean intersects(double x, double y, double w, double h) {
        if (this.isEmpty() || w <= 0.0 || h <= 0.0) {
            return false;
        }
        double x0 = this.getX();
        double y0 = this.getY();
        return x + w > x0 && y + h > y0 && x < x0 + this.getWidth() && y < y0 + this.getHeight();
    }

    public boolean contains(double x, double y, double w, double h) {
        if (this.isEmpty() || w <= 0.0 || h <= 0.0) {
            return false;
        }
        double x0 = this.getX();
        double y0 = this.getY();
        return x >= x0 && y >= y0 && x + w <= x0 + this.getWidth() && y + h <= y0 + this.getHeight();
    }

    public abstract Rectangle2D createIntersection(Rectangle2D var1);

    public static void intersect(Rectangle2D src1, Rectangle2D src2, Rectangle2D dest) {
        double x1 = Math.max(src1.getLeft(), src2.getLeft());
        double y1 = Math.max(src1.getTop(), src2.getTop());
        double x2 = Math.min(src1.getRight(), src2.getRight());
        double y2 = Math.min(src1.getBottom(), src2.getBottom());
        dest.setBoundsFromDiagonal(x1, y1, x2, y2);
    }

    public abstract Rectangle2D createUnion(Rectangle2D var1);

    public static void union(Rectangle2D src1, Rectangle2D src2, Rectangle2D dest) {
        double x1 = Math.min(src1.getLeft(), src2.getLeft());
        double y1 = Math.min(src1.getTop(), src2.getTop());
        double x2 = Math.max(src1.getRight(), src2.getRight());
        double y2 = Math.max(src1.getBottom(), src2.getBottom());
        dest.setBoundsFromDiagonal(x1, y1, x2, y2);
    }

    public void add(double newx, double newy) {
        double x1 = Math.min(this.getLeft(), newx);
        double x2 = Math.max(this.getRight(), newx);
        double y1 = Math.min(this.getTop(), newy);
        double y2 = Math.max(this.getBottom(), newy);
        this.setRect(x1, y1, x2 - x1, y2 - y1);
    }

    public void add(Point2D pt) {
        this.add(pt.getX(), pt.getY());
    }

    public void add(Rectangle2D r) {
        double x1 = Math.min(this.getLeft(), r.getLeft());
        double x2 = Math.max(this.getRight(), r.getRight());
        double y1 = Math.min(this.getTop(), r.getTop());
        double y2 = Math.max(this.getBottom(), r.getBottom());
        this.setRect(x1, y1, x2 - x1, y2 - y1);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj instanceof Rectangle2D) {
            Rectangle2D r2d = (Rectangle2D)obj;
            return this.getX() == r2d.getX() && this.getY() == r2d.getY() && this.getWidth() == r2d.getWidth() && this.getHeight() == r2d.getHeight();
        }
        return super.equals(obj);
    }

    public abstract double getX();

    public abstract double getY();

    public abstract double getWidth();

    public abstract double getHeight();

    public abstract boolean isEmpty();

    public double getLeft() {
        return this.getX();
    }

    public double getTop() {
        return this.getY();
    }

    public double getRight() {
        return this.getX() + this.getWidth();
    }

    public double getBottom() {
        return this.getY() + this.getHeight();
    }

    public double getCenterX() {
        return this.getX() + this.getWidth() / 2.0;
    }

    public double getCenterY() {
        return this.getY() + this.getHeight() / 2.0;
    }

    public void setBounds(Point2D loc, Dimension2D size) {
        this.setBounds(loc.getX(), loc.getY(), size.getWidth(), size.getHeight());
    }

    public void setBounds(Rectangle2D r) {
        this.setBounds(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public void setBoundsFromDiagonal(double x1, double y1, double x2, double y2) {
        double t;
        if (x2 < x1) {
            t = x1;
            x1 = x2;
            x2 = t;
        }
        if (y2 < y1) {
            t = y1;
            y1 = y2;
            y2 = t;
        }
        this.setBounds(x1, y1, x2 - x1, y2 - y1);
    }

    public void setBoundsFromDiagonal(Point2D p1, Point2D p2) {
        this.setBoundsFromDiagonal(p1.getX(), p1.getY(), p2.getX(), p2.getY());
    }

    public void setBoundsFromCenter(double centerX, double centerY, double cornerX, double cornerY) {
        double halfW = Math.abs(cornerX - centerX);
        double halfH = Math.abs(cornerY - centerY);
        this.setBounds(centerX - halfW, centerY - halfH, halfW * 2.0, halfH * 2.0);
    }

    public void setBoundsFromCenter(Point2D center, Point2D corner) {
        this.setBoundsFromCenter(center.getX(), center.getY(), corner.getX(), corner.getY());
    }

    public boolean contains(Point2D p) {
        return this.contains(p.getX(), p.getY());
    }

    public boolean intersects(Rectangle2D r) {
        return this.intersects(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public boolean contains(Rectangle2D r) {
        return this.contains(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public Rectangle getBounds() {
        double width = this.getWidth();
        double height = this.getHeight();
        if (width < 0.0 || height < 0.0) {
            return new Rectangle();
        }
        double x = this.getX();
        double y = this.getY();
        double x1 = Math.floor(x);
        double y1 = Math.floor(y);
        double x2 = Math.ceil(x + width);
        double y2 = Math.ceil(y + height);
        return new Rectangle((int)x1, (int)y1, (int)(x2 - x1), (int)(y2 - y1));
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public static class Double
    extends Rectangle2D {
        private double x;
        private double y;
        private double width;
        private double height;

        public Double() {
        }

        public Double(double x, double y, double w, double h) {
            this.setRect(x, y, w, h);
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public double getWidth() {
            return this.width;
        }

        public double getHeight() {
            return this.height;
        }

        public boolean isEmpty() {
            return this.width <= 0.0 || this.height <= 0.0;
        }

        public void setRect(double x, double y, double w, double h) {
            this.x = x;
            this.y = y;
            this.width = w;
            this.height = h;
        }

        public void setRect(Rectangle2D r) {
            this.x = r.getX();
            this.y = r.getY();
            this.width = r.getWidth();
            this.height = r.getHeight();
        }

        public int outcode(double x, double y) {
            int out = 0;
            if (this.width <= 0.0) {
                out |= 5;
            } else if (x < this.x) {
                out |= 1;
            } else if (x > this.x + this.width) {
                out |= 4;
            }
            if (this.height <= 0.0) {
                out |= 0xA;
            } else if (y < this.y) {
                out |= 2;
            } else if (y > this.y + this.height) {
                out |= 8;
            }
            return out;
        }

        public Rectangle2D createIntersection(Rectangle2D r) {
            Double dest = new Double();
            Rectangle2D.intersect(this, r, dest);
            return dest;
        }

        public Rectangle2D createUnion(Rectangle2D r) {
            Double dest = new Double();
            Rectangle2D.union(this, r, dest);
            return dest;
        }

        public String toString() {
            return "[x=" + this.x + ",y=" + this.y + ",w=" + this.width + ",h=" + this.height + "]";
        }
    }

    public static class Float
    extends Rectangle2D {
        private float x;
        private float y;
        private float width;
        private float height;

        public Float() {
        }

        public Float(float x, float y, float w, float h) {
            this.setRect(x, y, w, h);
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public double getWidth() {
            return this.width;
        }

        public double getHeight() {
            return this.height;
        }

        public boolean isEmpty() {
            return this.width <= 0.0f || this.height <= 0.0f;
        }

        public void setRect(float x, float y, float w, float h) {
            this.x = x;
            this.y = y;
            this.width = w;
            this.height = h;
        }

        public void setRect(double x, double y, double w, double h) {
            this.x = (float)x;
            this.y = (float)y;
            this.width = (float)w;
            this.height = (float)h;
        }

        public void setRect(Rectangle2D r) {
            this.x = (float)r.getX();
            this.y = (float)r.getY();
            this.width = (float)r.getWidth();
            this.height = (float)r.getHeight();
        }

        public int outcode(double x, double y) {
            int out = 0;
            if (this.width <= 0.0f) {
                out |= 5;
            } else if (x < (double)this.x) {
                out |= 1;
            } else if (x > (double)(this.x + this.width)) {
                out |= 4;
            }
            if (this.height <= 0.0f) {
                out |= 0xA;
            } else if (y < (double)this.y) {
                out |= 2;
            } else if (y > (double)(this.y + this.height)) {
                out |= 8;
            }
            return out;
        }

        public Rectangle2D createIntersection(Rectangle2D r) {
            Rectangle2D dest = r instanceof Float ? new Float() : new Double();
            Rectangle2D.intersect(this, r, dest);
            return dest;
        }

        public Rectangle2D createUnion(Rectangle2D r) {
            Rectangle2D dest = r instanceof Float ? new Float() : new Double();
            Rectangle2D.union(this, r, dest);
            return dest;
        }

        public String toString() {
            return "[x=" + this.x + ",y=" + this.y + ",w=" + this.width + ",h=" + this.height + "]";
        }
    }
}

