/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import oracle.bali.jle.LayoutItem;
import oracle.bali.jle.PropertyManager;
import oracle.bali.share.collection.StringKey;

public class LayoutItemTransfer
implements Transferable {
    public static final DataFlavor LAYOUT_ITEM_FLAVOR = new DataFlavor(LayoutItem.class, LayoutItem.class.getName());
    public static final DataFlavor MULTI_LAYOUT_ITEM_FLAVOR = new DataFlavor(LayoutItem[].class, LayoutItem[].class.getName());
    public static final Object DATA_FLAVOR_KEY = new StringKey("DATA_FLAVOR_KEY");
    private LayoutItem[] _items;
    private DataFlavor[] _flavors;

    public LayoutItemTransfer(LayoutItem item) {
        this(new LayoutItem[]{item});
    }

    public LayoutItemTransfer(LayoutItem[] items) {
        if (items == null) {
            throw new IllegalArgumentException();
        }
        this._items = new LayoutItem[items.length];
        System.arraycopy(items, 0, this._items, 0, items.length);
        this._flavors = this._findDataFlavors();
    }

    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] found = this._flavors;
        if (found == null) {
            return new DataFlavor[]{LAYOUT_ITEM_FLAVOR, MULTI_LAYOUT_ITEM_FLAVOR};
        }
        DataFlavor[] flavors = new DataFlavor[found.length + 2];
        System.arraycopy(found, 0, flavors, 0, found.length);
        flavors[found.length] = LAYOUT_ITEM_FLAVOR;
        flavors[found.length + 1] = MULTI_LAYOUT_ITEM_FLAVOR;
        return flavors;
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        DataFlavor[] found = this._flavors;
        if (found != null) {
            for (int i = 0; i < found.length; ++i) {
                if (!found[i].equals(flavor)) continue;
                return true;
            }
        }
        return flavor.equals(LAYOUT_ITEM_FLAVOR) || flavor.equals(MULTI_LAYOUT_ITEM_FLAVOR);
    }

    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor.equals(LAYOUT_ITEM_FLAVOR)) {
            return this._items[0];
        }
        if (flavor.equals(MULTI_LAYOUT_ITEM_FLAVOR)) {
            return this._items;
        }
        Object[] found = new Object[this._items.length];
        for (int i = 0; i < this._items.length; ++i) {
            Object temp = this._items[i].getProperty(flavor);
            if (temp == PropertyManager.NOT_FOUND_OBJECT) {
                throw new UnsupportedFlavorException(flavor);
            }
            found[i] = temp;
        }
        return found;
    }

    public LayoutItem[] getItems() {
        return this._items;
    }

    private DataFlavor[] _findDataFlavors() {
        Vector<DataFlavor> candidates = new Vector<DataFlavor>(2 * this._items.length);
        Hashtable<LayoutItem, DataFlavor[]> itemFlavors = new Hashtable<LayoutItem, DataFlavor[]>(this._items.length);
        for (int i = 0; i < this._items.length; ++i) {
            Object found = this._items[i].getProperty(DATA_FLAVOR_KEY);
            if (found == PropertyManager.NOT_FOUND_OBJECT || found == null) continue;
            DataFlavor[] vals = (DataFlavor[])found;
            itemFlavors.put(this._items[i], vals);
            for (int j = 0; j < vals.length; ++j) {
                if (candidates.contains(vals[j])) continue;
                candidates.addElement(vals[j]);
            }
        }
        Object[] flavors = new DataFlavor[candidates.size()];
        candidates.copyInto(flavors);
        for (int k = 0; k < flavors.length; ++k) {
            Object currFlavor = flavors[k];
            for (int l = 0; l < this._items.length; ++l) {
                DataFlavor[] currItemFlavors = (DataFlavor[])itemFlavors.get(this._items[l]);
                if (this._containsFlavor(currItemFlavors, (DataFlavor)currFlavor)) continue;
                currFlavor = null;
                break;
            }
            if (currFlavor != null) continue;
            candidates.removeElement(currFlavor);
        }
        flavors = new DataFlavor[candidates.size()];
        candidates.copyInto(flavors);
        return flavors;
    }

    private boolean _containsFlavor(DataFlavor[] flavors, DataFlavor find) {
        if (flavors == null) {
            return false;
        }
        for (int i = 0; i < flavors.length; ++i) {
            if (!flavors[i].equals(find)) continue;
            return true;
        }
        return false;
    }
}

