/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
import oracle.bali.jle.JLECanvas;
import oracle.bali.jle.event.JLEEvent;

public final class JLEAutoScroller
implements Runnable,
ActionListener {
    private static int _INITIAL_SCROLLING_DELAY = 100;
    private static int _REPEAT_SCROLLING_DELAY = 50;
    private static final int _MULTIPLE_DIVISOR = 10;
    private static final int _MULTIPLE_MAX = 3;
    private static int _SCROLL_INTERVAL = 10;
    private static int _SCROLL_MARGIN = 5;
    private static JLEAutoScroller _sAutoScroller;
    private JLECanvas _canvas;
    private Timer _timer = new Timer(_INITIAL_SCROLLING_DELAY, this);
    private int _scrollX;
    private int _scrollY;
    private boolean _cancelled;

    private JLEAutoScroller() {
    }

    public static JLEAutoScroller getJLEAutoScroller() {
        if (_sAutoScroller == null) {
            _sAutoScroller = new JLEAutoScroller();
        }
        return _sAutoScroller;
    }

    public static int getInitialScrollingDelay() {
        return _INITIAL_SCROLLING_DELAY;
    }

    public static void setInitialScrollingDelay(int delay) {
        _INITIAL_SCROLLING_DELAY = delay;
    }

    public static int getRepeatScrollingDelay() {
        return _REPEAT_SCROLLING_DELAY;
    }

    public static void setRepeatScrollingDelay(int delay) {
        _REPEAT_SCROLLING_DELAY = delay;
    }

    public static int getScrollInterval() {
        return _SCROLL_INTERVAL;
    }

    public static void setScrollInterval(int intervalPixels) {
        _SCROLL_INTERVAL = intervalPixels;
    }

    public static int getScrollMargin() {
        return _SCROLL_MARGIN;
    }

    public static void setScrollMargin(int marginPixels) {
        _SCROLL_MARGIN = marginPixels;
    }

    public void schedule(JLECanvas canvas, int scrollX, int scrollY) {
        this._canvas = canvas;
        this._cancelled = false;
        this._scrollX = scrollX;
        this._scrollY = scrollY;
        this._timer.setDelay(_INITIAL_SCROLLING_DELAY);
        this._timer.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this._cancelled) {
            return;
        }
        int scrollX = this._scrollX;
        int scrollY = this._scrollY;
        Rectangle canvasBounds = this._canvas.getCanvasBounds();
        Rectangle innerBounds = this._canvas.getInnerBounds();
        int adjustX = 0;
        int adjustY = 0;
        if (scrollX != 0) {
            adjustX = scrollX / 10;
            adjustX = scrollX < 0 ? --adjustX : ++adjustX;
            if (adjustX > 3) {
                adjustX = 3;
            } else if (adjustX < -3) {
                adjustX = -3;
            }
            adjustX *= _SCROLL_INTERVAL;
        }
        if (scrollY != 0) {
            adjustY = this._scrollY / 10;
            adjustY = scrollY < 0 ? --adjustY : ++adjustY;
            if (adjustY > 3) {
                adjustY = 3;
            } else if (adjustY < -3) {
                adjustY = -3;
            }
            adjustY *= _SCROLL_INTERVAL;
        }
        try {
            this._canvas.freezeRepaints();
            this._canvas.setCanvasOrigin(canvasBounds.x - adjustX, canvasBounds.y - adjustY);
        }
        finally {
            this._canvas.unfreezeRepaints();
        }
        this._timer.setDelay(_REPEAT_SCROLLING_DELAY);
        this._timer.restart();
    }

    public void actionPerformed(ActionEvent ae) {
        this.run();
    }

    public void cancel() {
        this._cancelled = true;
        this._timer.stop();
    }

    public void cancel(JLECanvas possibleTarget) {
        if (this._canvas == possibleTarget) {
            this.cancel();
        }
    }

    public boolean checkAutoScroll(JLECanvas canvas, JLEEvent event) {
        Rectangle cBounds = canvas.getCanvasBounds();
        Dimension iSize = canvas.getInnerSize();
        Point device = canvas.contentToDevice(event.getX(), event.getY());
        int scrollX = device.x + cBounds.x;
        scrollX = scrollX < _SCROLL_MARGIN && cBounds.x < 0 ? (scrollX - _SCROLL_MARGIN) / _SCROLL_MARGIN - 1 : (scrollX > iSize.width - _SCROLL_MARGIN ? (scrollX - (iSize.width - _SCROLL_MARGIN)) / _SCROLL_MARGIN + 1 : 0);
        int scrollY = device.y + cBounds.y;
        scrollY = scrollY < _SCROLL_MARGIN && cBounds.y < 0 ? (scrollY - _SCROLL_MARGIN) / _SCROLL_MARGIN - 1 : (scrollY > iSize.height - _SCROLL_MARGIN ? (scrollY - (iSize.height - _SCROLL_MARGIN)) / _SCROLL_MARGIN + 1 : 0);
        if (scrollX != 0 || scrollY != 0) {
            JLEAutoScroller.getJLEAutoScroller().schedule(canvas, scrollX, scrollY);
            return true;
        }
        JLEAutoScroller.getJLEAutoScroller().cancel();
        return false;
    }
}

