/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.commands;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptUtils;
import oracle.dbtools.raptor.newscriptrunner.commands.show.ShowSga;
import oracle.dbtools.raptor.scriptrunner.commands.Messages;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.driver.OracleConnection;

public class Startup
extends CommandListener {
    private static final String RESTRICT = "restrict";
    private static final String FORCE = "force";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        boolean nonPlugSuccess;
        boolean pluggableAltered;
        block62: {
            boolean switchConOnly;
            boolean doMount;
            OracleConnection ocon;
            block60: {
                String alreadyUp = Messages.getString("Startup.ALREADYUP");
                pluggableAltered = false;
                nonPlugSuccess = false;
                boolean pluggableTried = false;
                boolean connIsNull = conn == null;
                String thepdb = null;
                String prospective = cmd.getSql();
                if ((prospective = ScriptUtils.stripFirstN(prospective, 500, true, true)).matches("(?i:startup\\s+pluggable\\s+database\\s+).*$")) {
                    thepdb = prospective.replaceFirst("(?i:startup\\s+pluggable\\s+database\\s+)", "").trim();
                    if (thepdb != null) {
                        thepdb = thepdb.replaceFirst("(?i:\\s+open\\s*)$", "");
                    }
                    if (thepdb == null || thepdb.equals("") || thepdb.matches("^.*\\s+.*$") && (thepdb.indexOf("\"") == -1 || !thepdb.endsWith("\""))) {
                        ctx.write(MessageFormat.format(Messages.getString("Startup.INVALIDPDB"), thepdb));
                        return true;
                    }
                }
                if (!connIsNull && !(conn instanceof OracleConnection)) {
                    ctx.write(Messages.getString("Startup.NOTORACLE"));
                    return true;
                }
                if (connIsNull) {
                    ctx.write(Messages.getString("Startup.NOCONNECTION"));
                    return true;
                }
                ocon = (OracleConnection)conn;
                doMount = false;
                switchConOnly = false;
                try {
                    block64: {
                        block59: {
                            if (ocon != null && (ctx.getProperty("script.runner.PRELIM_AUTH") == null || Boolean.valueOf(ctx.getProperty("script.runner.PRELIM_AUTH").equals(Boolean.FALSE)).booleanValue())) {
                                if (DBUtil.isOracleConnectionAlive((Connection)ocon)) {
                                    boolean amILocked = DBUtil.getConnectionResolver().lock((Connection)ocon);
                                    try {
                                        if (!amILocked) break block59;
                                        DBUtil dbUtil = DBUtil.getInstance((Connection)ocon);
                                        String s = ocon.getProperties().getProperty("internal_logon");
                                        boolean sysdba = false;
                                        if (s != null && s.toLowerCase().equals("sysdba")) {
                                            sysdba = true;
                                        } else {
                                            ctx.write(Messages.getString("Shutdown.NOTSYSDBA"));
                                        }
                                        if (!sysdba || DBUtil.getDbVersion((Connection)ocon).compareTo(new Version("12.1")) < 0) break block59;
                                        if (dbUtil.executeOracleReturnOneCol("select NVL(SYS_CONTEXT('USERENV','CDB_NAME'),'1') from dual", null).equals("1")) {
                                            ctx.write(Messages.getString("Shutdown.NOTCONSOLIDATED"));
                                            break block59;
                                        }
                                        if (dbUtil.executeOracleReturnOneCol("select to_char(SYS_CONTEXT('USERENV','CON_ID')) from dual", null).equals("1") && thepdb == null) {
                                            ctx.write(Messages.getString("Shutdown.CONID1"));
                                            break block59;
                                        }
                                        String con_name = thepdb;
                                        if (con_name == null) {
                                            con_name = dbUtil.executeOracleReturnOneCol("select to_char(SYS_CONTEXT ('USERENV', 'CON_NAME')) CON_NAME from dual", null);
                                        }
                                        Statement st = null;
                                        try {
                                            pluggableTried = true;
                                            st = ocon.createStatement();
                                            st.execute("alter pluggable database \"" + con_name + "\" open");
                                            pluggableAltered = true;
                                            ctx.write(Messages.getString("Startup.PDBOPENED"));
                                            break block59;
                                        }
                                        finally {
                                            try {
                                                if (st != null) {
                                                    st.close();
                                                }
                                            }
                                            catch (Exception e) {
                                                Logger.getLogger(this.getClass().getName()).log(Level.FINE, this.getClass().getName(), e);
                                            }
                                        }
                                    }
                                    finally {
                                        if (amILocked) {
                                            DBUtil.getConnectionResolver().unlock((Connection)ocon);
                                        }
                                    }
                                }
                                ctx.write(Messages.getString("Startup.NOTALIVE"));
                            }
                        }
                        if (ocon == null || ctx.getProperty("script.runner.PRELIM_AUTH") == null || !Boolean.valueOf(ctx.getProperty("script.runner.PRELIM_AUTH").equals(Boolean.TRUE)).booleanValue()) break block64;
                        boolean isLocked = DBUtil.getConnectionResolver().lock((Connection)ocon);
                        try {
                            block65: {
                                block66: {
                                    String[] cmdpartsNoMount;
                                    block61: {
                                        block68: {
                                            String[] cmdparts;
                                            block67: {
                                                if (!isLocked) break block60;
                                                if (!(ocon instanceof OracleConnection)) break block65;
                                                String s = ocon.getProperties().getProperty("internal_logon");
                                                if (s == null || !s.toLowerCase().equals("sysdba")) break block66;
                                                cmdpartsNoMount = cmd.getSQLOrig().split("\\s+");
                                                cmdparts = cmd.getSQLOrig().replaceFirst("(?i)\\s+nomount$", " ").replaceFirst("(?i)\\s+nomount\\s+", " ").split("\\s+");
                                                if (cmdparts.length != 1) break block67;
                                                ocon.startup(OracleConnection.DatabaseStartupMode.NO_RESTRICTION);
                                                ctx.write(Messages.getString("Startup.STARTEDUP"));
                                                doMount = true;
                                                break block61;
                                            }
                                            if (cmdparts.length != 2) break block68;
                                            boolean goodMode = this.getGoodMode(cmdparts[1]);
                                            if (goodMode) {
                                                if (this.getMode(cmdparts).equals(RESTRICT)) {
                                                    ocon.startup(OracleConnection.DatabaseStartupMode.RESTRICT);
                                                    doMount = true;
                                                    break block61;
                                                } else if (this.getMode(cmdparts).equals(FORCE)) {
                                                    ocon.startup(OracleConnection.DatabaseStartupMode.FORCE);
                                                    doMount = true;
                                                    break block61;
                                                } else {
                                                    ctx.write(Messages.getString("Startup.INVALIDSTARTUP"));
                                                }
                                            }
                                            break block61;
                                        }
                                        ctx.write(Messages.getString("Startup.NOTINSQLCL"));
                                    }
                                    for (String command : cmdpartsNoMount) {
                                        if (!command.equalsIgnoreCase("nomount")) continue;
                                        doMount = false;
                                        switchConOnly = true;
                                    }
                                    break block60;
                                }
                                ctx.write(Messages.getString("Startup.MUSTBESYSOPERORSYSDBA"));
                                break block60;
                            }
                            ctx.write(Messages.getString("Shutdown.NOTSUPPORTEDONCON"));
                            break block60;
                        }
                        finally {
                            if (isLocked) {
                                DBUtil.getConnectionResolver().unlock((Connection)ocon);
                            }
                        }
                    }
                    if (!pluggableTried) {
                        ctx.write(alreadyUp);
                    }
                }
                catch (SQLException e) {
                    ctx.write(e.getLocalizedMessage() + "\n");
                }
            }
            try {
                if (!doMount && !switchConOnly) break block62;
                Statement st = null;
                Connection connAuth = null;
                boolean isLocked = DBUtil.getConnectionResolver().lock((Connection)ocon);
                try {
                    if (!isLocked) break block62;
                    boolean switchBase = false;
                    if (conn.equals(ctx.getBaseConnection())) {
                        switchBase = true;
                    }
                    conn.close();
                    connAuth = DriverManager.getConnection((String)ctx.getProperty("cli.conn.url"), (Properties)ctx.getProperty("cli.conn.props"));
                    Boolean getCommit = (Boolean)ctx.getProperty("script.runner.autocommit.checkbox");
                    try {
                        if (getCommit == null || getCommit.equals(Boolean.FALSE)) {
                            connAuth.setAutoCommit(false);
                        } else {
                            connAuth.setAutoCommit(true);
                        }
                    }
                    catch (SQLException e) {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                    }
                    if (doMount) {
                        st = connAuth.createStatement();
                        st.execute("alter database mount");
                        ctx.write(Messages.getString("Startup.DBMOUNTED"));
                        st.close();
                        st = connAuth.createStatement();
                        st.execute("alter database open");
                        ctx.write(Messages.getString("Startup.DBOPEN"));
                    }
                    ctx.putProperty("script.runner.PRELIM_AUTH", Boolean.FALSE);
                    if (switchBase) {
                        ctx.setBaseConnection(connAuth);
                    }
                    ctx.setCurrentConnection(connAuth);
                    if (doMount) {
                        new ShowSga().doShowSga(connAuth, ctx, cmd);
                    }
                    nonPlugSuccess = true;
                }
                finally {
                    try {
                        if (st != null) {
                            st.close();
                        }
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                    if (isLocked) {
                        DBUtil.getConnectionResolver().unlock((Connection)ocon);
                    }
                }
            }
            catch (SQLException e) {
                ctx.write(e.getLocalizedMessage() + "\n");
            }
        }
        if (!nonPlugSuccess && !pluggableAltered) {
            ctx.write(Messages.getString("Startup.FAILED"));
            return true;
        }
        ctx.write(Messages.getString("Startup.SUCCESS"));
        return true;
    }

    private String getMode(String[] cmdparts) {
        return cmdparts[1].toLowerCase();
    }

    private boolean getGoodMode(String string) {
        return string.toLowerCase().equals(FORCE) || string.toLowerCase().equals(RESTRICT);
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }
}

