/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.commands;

import java.sql.Connection;
import java.util.Calendar;
import java.util.List;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.console.MultiLineHistory;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptParser;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.scriptrunner.commands.Messages;
import oracle.dbtools.raptor.utils.AnsiColorListPrinter;
import org.fusesource.jansi.Ansi;

public class RepeatSQLBufferCmd
extends CommandListener
implements IHelp {
    private static Logger LOGGER = Logger.getLogger(RepeatSQLBufferCmd.class.getName());
    public static final String ANSI_CLS = "\u001b[2J";
    public static final String ANSI_HOME = "\u001b[H";
    public static final String ANSI_BOLD = "\u001b[1m";
    public static final String ANSI_AT55 = "\u001b[10;10H";
    public static final String ANSI_REVERSEON = "\u001b[7m";
    public static final String ANSI_NORMAL = "\u001b[0m";
    public static final String ANSI_WHITEONBLUE = "\u001b[37;44m";

    @Override
    public String getCommand() {
        return "REPEAT";
    }

    @Override
    public String getHelp() {
        return Messages.getString(this.getCommand());
    }

    @Override
    public boolean isSqlPlus() {
        return false;
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (RepeatSQLBufferCmd.matches("repeat", cmd.getSql())) {
            if (Ansi.isEnabled()) {
                this.printTop(conn, ctx, cmd);
            } else {
                ctx.write("ANSI Console Required");
            }
            return true;
        }
        return false;
    }

    private void printTop(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String[] parts = cmd.getSQLOrig().split(" ");
        double sleep = 1.0;
        int num = 1;
        try {
            num = Integer.parseInt(parts[1]);
            sleep = Double.parseDouble(parts[2]);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (num < 0 || sleep < 0.0 || sleep > 120.0) {
            ctx.write("Usage: " + this.getCommand() + "  <iterations> <seconds>\n\t SQL is the sql from the current buffer\n\t Maximum sleep is 120s\n");
            return;
        }
        String sql = (String)MultiLineHistory.getInstance().get(MultiLineHistory.getInstance().size());
        ScriptParser sp = new ScriptParser(sql);
        sp.parse();
        ISQLCommand[] stmts = sp.getSqlStatements();
        if (stmts.length == 1 && stmts[0].getStmtType() != SQLCommand.StmtType.G_C_SQL) {
            ctx.write("Only SQL statements supported\n");
            return;
        }
        for (int i = 1; i < num + 1 && !ctx.isInterrupted(); ++i) {
            ctx.write(ANSI_CLS);
            ctx.write(ANSI_HOME);
            Calendar calendar = Calendar.getInstance();
            String now = calendar.get(10) + ":" + calendar.get(12) + ":" + calendar.get(13);
            String header = "Running " + i + " of " + num + " @ " + now + " with a delay of " + sleep + "s";
            DBUtil dbUtil = DBUtil.getInstance(conn);
            List<List<?>> rows = dbUtil.executeReturnListofList(sql, null);
            AnsiColorListPrinter.printListofList(ctx, header, rows);
            if (i == num) continue;
            try {
                Thread.sleep(Math.round(sleep * 1000.0));
                continue;
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }
}

