/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.cmdline.handlers;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.console.clone.DbtoolsConsoleReader;
import oracle.dbtools.raptor.newscriptrunner.IGetPromptedPasswordFieldsProvider;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerDbArb;
import oracle.dbtools.raptor.newscriptrunner.WrapListenBufferOutputStream;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.util.Pair;

public class SQLCliPromptedPasswordFieldsProvider
implements IGetPromptedPasswordFieldsProvider {
    private final String ENCODING = "UTF-8";
    private ScriptRunnerContext ctx = null;

    public String getPromptedField(ScriptRunnerContext ctx, String prompt, boolean hide) {
        DbtoolsConsoleReader reader = (DbtoolsConsoleReader)ctx.getProperty("script.runner.jline");
        if (reader != null) {
            if (prompt == null) {
                prompt = "";
            }
            String haveASpace = prompt;
            if (prompt != null && prompt.length() > 0 && !prompt.endsWith(" ")) {
                haveASpace = haveASpace + " ";
            }
            String fromConsole = null;
            try {
                fromConsole = hide ? reader.readLineSimple(haveASpace, Character.valueOf('*')) : reader.readLineSimple(haveASpace);
            }
            catch (Exception e) {
                ExceptionHandler.handleException(e);
            }
            return fromConsole;
        }
        return null;
    }

    @Override
    public Pair<String, String> passwordGetPassword(ScriptRunnerContext inctx, String currentUserId, String alterUserId) {
        this.ctx = inctx;
        String[] result = this.threePasswords(currentUserId.equals(alterUserId) || alterUserId == null, currentUserId, alterUserId, this.ctx.getCurrentConnection());
        if (result == null) {
            return null;
        }
        if (result[3].equals("CONNECT EXCEPTION")) {
            this.report(ScriptRunnerDbArb.getString("FAILED_TO_VALIDATE_USER"));
            return null;
        }
        if (result[3].equals("NO CLICK")) {
            return null;
        }
        if (result[1] != null && !result[1].equals(result[2])) {
            this.report(ScriptRunnerDbArb.getString("PASSWORDS_DO_NOT_MATCH"));
            return null;
        }
        return new Pair<String, String>(result[2], result[0]);
    }

    protected void report(String s) {
        WrapListenBufferOutputStream out = this.ctx.getOutputStream();
        if (out != null) {
            try {
                ((OutputStream)out).write(s.getBytes("UTF-8"));
                ((OutputStream)out).write(10);
            }
            catch (IOException e) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String[] threePasswords(boolean showUsers, String user, String alterUser, Connection lconn) {
        String localPassword = null;
        String newPass1 = null;
        String newPass2 = null;
        String errorOut = null;
        if (showUsers && (localPassword = this.getPromptedField(this.ctx, ScriptRunnerDbArb.format("PASSWORD_FOR", user), true)) == null) {
            return null;
        }
        newPass1 = this.getPromptedField(this.ctx, ScriptRunnerDbArb.format("NEW_PASSWORD_FOR", alterUser), true);
        if (newPass1 == null) {
            return null;
        }
        newPass2 = this.getPromptedField(this.ctx, ScriptRunnerDbArb.getString("NEW_PASSWORD_AGAIN"), true);
        if (newPass2 == null) {
            return null;
        }
        errorOut = "NO CLICK";
        if (showUsers) {
            Properties props = new Properties();
            props.setProperty("user", user);
            props.setProperty("password", localPassword);
            if (user.equalsIgnoreCase("SYS")) {
                props.setProperty("internal_logon", "SYSDBA");
            }
            Connection myconn = null;
            try {
                String url = lconn.getMetaData().getURL();
                myconn = DriverManager.getConnection(url, props);
                errorOut = "OK";
            }
            catch (Exception ex) {
                myconn = null;
                errorOut = "CONNECT EXCEPTION";
            }
            finally {
                if (myconn != null) {
                    try {
                        myconn.close();
                    }
                    catch (SQLException ex) {}
                }
            }
        } else {
            errorOut = "OK";
        }
        return new String[]{localPassword, newPass1, newPass2, errorOut};
    }
}

