/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.cmdline;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import jline.console.UserInterruptException;
import jline.console.completer.ArgumentCompleter;
import jline.console.completer.Completer;
import oracle.dbtools.app.SqlCompleter;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.db.ResultSetFormatter;
import oracle.dbtools.raptor.console.ConsoleListener;
import oracle.dbtools.raptor.console.FileNameCompleter;
import oracle.dbtools.raptor.console.MultiLineHistory;
import oracle.dbtools.raptor.console.SQLPlusConsoleReader;
import oracle.dbtools.raptor.console.clone.DbtoolsNonBlockingInputStream;
import oracle.dbtools.raptor.format.FormatRegistry;
import oracle.dbtools.raptor.newscriptrunner.CommandRegistry;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLPLUS;
import oracle.dbtools.raptor.newscriptrunner.SQLPlusProviderForSQLPATH;
import oracle.dbtools.raptor.newscriptrunner.ScriptExecutor;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.SqlParserProvider;
import oracle.dbtools.raptor.newscriptrunner.commands.alias.Aliases;
import oracle.dbtools.raptor.newscriptrunner.commands.editor.AppendCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.editor.ChangeCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.editor.DelCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.editor.GetCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.editor.InputCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.editor.ListCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.editor.SaveCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.editor.SetSuffix;
import oracle.dbtools.raptor.newscriptrunner.commands.editor.StoreCommand;
import oracle.dbtools.raptor.scriptrunner.cmdline.Messages;
import oracle.dbtools.raptor.scriptrunner.cmdline.ProductState;
import oracle.dbtools.raptor.scriptrunner.cmdline.SQLCliHelper;
import oracle.dbtools.raptor.scriptrunner.cmdline.SQLCliOptions;
import oracle.dbtools.raptor.scriptrunner.cmdline.editor.Buffer;
import oracle.dbtools.raptor.scriptrunner.cmdline.editor.EditCommand;
import oracle.dbtools.raptor.scriptrunner.commands.HistoryCommand;
import oracle.dbtools.raptor.scriptrunner.commands.RepeatSQLBufferCmd;
import oracle.dbtools.raptor.scriptrunner.commands.SetSQLPrompt;
import oracle.dbtools.raptor.scriptrunner.commands.SetTime;
import oracle.dbtools.raptor.scriptrunner.commands.Shutdown;
import oracle.dbtools.raptor.scriptrunner.commands.SshTunnelCommand;
import oracle.dbtools.raptor.scriptrunner.commands.Startup;
import oracle.dbtools.raptor.utils.BasicExceptionHandler;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiConsole;

public class SqlCli
implements ConsoleListener {
    public static Version version = new Version("4.1.0");
    public static String productName = "SQLcl";
    private static String devState = ProductState.Release_Candidate.toString().replaceAll("_", " ");
    private Connection _conn;
    private ScriptExecutor _runner;
    private ScriptRunnerContext _ctx;
    private SQLPlusConsoleReader reader;
    private Buffer _buffer;
    private boolean processed = false;
    boolean RUNNING = false;
    private static boolean logging = false;
    private static boolean _isCmdLine = false;
    private static boolean isPromptBold = false;
    private ExitThread _exitThread = null;
    private String prompt = "SQL>";

    public static boolean isCmdLine() {
        return _isCmdLine;
    }

    public SQLPlusConsoleReader getReader() {
        return this.reader;
    }

    protected ScriptRunnerContext getScriptRunnerContext() {
        return this._ctx;
    }

    public SqlCli() throws Exception {
        ExceptionHandler.setHandler(new BasicExceptionHandler());
        FormatRegistry.setLineTerminator(System.getProperty("line.separator"));
        SQLCliHelper.setDefaultScriptRunnerProperies();
        ResultSetFormatter.setMaxLines(Integer.MAX_VALUE);
        CommandRegistry.addListener(HistoryCommand.class, SQLCommand.StmtSubType.G_S_HISTORY);
        CommandRegistry.addListener(GetCommand.class, SQLCommand.StmtSubType.G_S_GET);
        CommandRegistry.addListener(SaveCommand.class, SQLCommand.StmtSubType.G_S_SAVE);
        CommandRegistry.addListener(StoreCommand.class, SQLCommand.StmtSubType.G_S_STORE);
        CommandRegistry.addListener(ListCommand.class, SQLCommand.StmtSubType.G_S_LIST);
        CommandRegistry.addListener(AppendCommand.class, SQLCommand.StmtSubType.G_S_APPEND);
        CommandRegistry.addListener(ChangeCommand.class, SQLCommand.StmtSubType.G_S_CHANGE);
        CommandRegistry.addListener(DelCommand.class, SQLCommand.StmtSubType.G_S_DEL_PLUS);
        CommandRegistry.addListener(SetSuffix.class, SQLCommand.StmtSubType.G_S_SET_SUFFIX);
        CommandRegistry.addListener(SetTime.class, SQLCommand.StmtSubType.G_S_SET_TIME);
        CommandRegistry.addListener(EditCommand.class, SQLCommand.StmtSubType.G_S_EDIT);
        CommandRegistry.addListener(InputCommand.class, SQLCommand.StmtSubType.G_S_INPUT);
        CommandRegistry.addListener(SshTunnelCommand.class, SQLCommand.StmtSubType.G_S_SSHTUNNEL);
        CommandRegistry.addListener(Startup.class, SQLCommand.StmtSubType.G_S_STARTUP);
        CommandRegistry.addListener(Shutdown.class, SQLCommand.StmtSubType.G_S_SHUTDOWN);
        CommandRegistry.addForAllStmtsListener(SetSQLPrompt.class);
        CommandRegistry.addForAllStmtsListener(RepeatSQLBufferCmd.class);
        SQLPLUS.setProductName(productName);
        this.reader = new SQLPlusConsoleReader();
        this._buffer = new Buffer();
        this.reader.setMultilineBuffer(this._buffer);
        this.reader.setHistory(MultiLineHistory.getInstance());
        MultiLineHistory.getInstance().setTermWidth(this.reader.getTerminal().getWidth());
        ScriptExecutor.setHistory(MultiLineHistory.getInstance());
        this.reader.setExpandEvents(false);
    }

    public ScriptRunnerContext processArgs(String[] args) throws Exception {
        ScriptRunnerContext context = SQLCliHelper.getCliScriptRunnerContext(this.reader);
        SQLCliOptions.setArgs(args);
        SQLCliOptions.processOptions(args);
        context = SQLCliOptions.populateContextWithOptions(context);
        context.setSQLPlusBuffer(this._buffer);
        return context;
    }

    private static void banner() {
        String banner = Messages.getString("SqlCli.18");
        banner = MessageFormat.format(banner, productName, SqlCli.getVersion(), SqlCli.getDevState(), SQLCliHelper.getBannerTime());
        System.err.println("\n" + banner);
        banner = Messages.getString("SqlCli.19");
        banner = MessageFormat.format(banner, SQLCliHelper.getBannerYear());
        System.err.println("\n" + banner + "\n");
    }

    public static String getDevState() {
        return devState.toString();
    }

    private Boolean process(String line) {
        try {
            this.reader.println();
            this.reader.flush();
        }
        catch (IOException e) {
            // empty catch block
        }
        line = line.replaceAll("\\xA0+", "");
        if (this._ctx.getCurrentConnection() != null) {
            this._runner.setConn(this._ctx.getCurrentConnection());
        }
        this._buffer.stopEditing();
        this._runner.setInterrupted(false);
        this._runner.setStmt(line);
        Iterator<ISQLCommand> parser = SqlParserProvider.getScriptParserIterator(this.getScriptRunnerContext(), new StringReader(line));
        while (parser.hasNext()) {
            ISQLCommand cmd = parser.next();
            if (cmd.getStmtType() == SQLCommand.StmtType.G_C_SQLPLUS && cmd.getStmtSubType() == SQLCommand.StmtSubType.G_S_ACCEPT) {
                SqlCli sqlCli = this;
                sqlCli._exitThread.stopListening();
            } else {
                this._exitThread.listen();
            }
            if (cmd.getStmtType().equals((Object)SQLCommand.StmtType.G_C_PLSQL) || cmd.getStmtType().equals((Object)SQLCommand.StmtType.G_C_SQL)) {
                if (!(cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_RUN) || cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_SLASH) || cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_DEL_PLUS) || cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_CHANGE) || cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_SAVE) || cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_STORE) || cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_GET) || cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_LIST) || cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_APPEND) || cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_EDIT) || cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_FORMAT) || cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_INSERT))) {
                    this.reader.getMultilineBuffer().setBufferSafe(this.reader.getMultilineBuffer().getBufferList());
                }
            } else if (cmd.getStmtType().equals((Object)SQLCommand.StmtType.G_C_SQLPLUS)) {
                // empty if block
            }
            this.reader.getMultilineBuffer().clear();
            this.reader.maxBufferDrawn = 0;
        }
        this._runner.run();
        SqlCli sqlCli = this;
        sqlCli._exitThread.stopListening();
        return true;
    }

    private void processLine(String line) {
        this.reader.resetEditor();
        this.process(line);
        this.prompt = this.getPrompt(isPromptBold);
        this.reader.setBasePrompt(this.prompt);
        this.reader.resetRedraw(line);
    }

    public static void usage() {
        System.err.println(MessageFormat.format("Usage: sqlplus username/password@tns [-oci] [-nologinfile] [-{0}] @file.sql define1 define2 define3 ...", "-verbose"));
        System.err.println("");
    }

    public static void main(String[] args) throws Exception {
        try {
            SqlCli.addShutdownHooks();
            _isCmdLine = true;
            AnsiConsole.systemInstall();
            SqlCli cli = new SqlCli();
            cli.setScriptRunnerContext(cli.processArgs(args));
            if (SQLCliOptions.isBadOption()) {
                System.err.println(SQLCliOptions.getBadOption());
                cli.getScriptRunnerContext().setExited(true);
                cli.getScriptRunnerContext().putProperty("script.runner.exit_int", 1);
                cli.handleHelp();
                SqlCli.handleExit(cli);
            }
            cli.setLoggingState(cli.getScriptRunnerContext());
            if (!SQLCliOptions.isOptionUsed("-version") && !SQLCliOptions.isOptionUsed("-help")) {
                if (!SQLCliOptions.isOptionUsed("-silent")) {
                    cli.handleBanner();
                }
                cli.getScriptRunnerContext().setSQLPlusConsoleReader(cli.getReader());
                SqlCli.setTerminalConstraints(cli);
                SQLPLUS.setSqlpathProvider(new SQLPlusProviderForSQLPATH());
                cli.handleLoginSql(cli.getScriptRunnerContext());
                cli.handleAtFiles(cli.getScriptRunnerContext());
                cli.handleExitInAtFiles();
                cli.startSQLPlus();
            } else if (SQLCliOptions.isOptionUsed("-version")) {
                cli.handleVersion();
            } else if (SQLCliOptions.isOptionUsed("-help")) {
                cli.handleHelp();
            }
            SqlCli.handleCloseDown(cli);
            SqlCli.handleExit(cli);
        }
        catch (FileNotFoundException fnfe) {
            SqlCli.log(Level.SEVERE, fnfe.getMessage());
        }
        catch (Exception e) {
            SqlCli.log(Level.SEVERE, e.getMessage());
            e.printStackTrace();
            ExceptionHandler.handleException(e);
        }
    }

    private static void setTerminalConstraints(SqlCli cli) {
        if (!System.getProperty("os.name").toLowerCase().contains("win")) {
            String val;
            byte[] buf;
            Process p;
            try {
                p = Runtime.getRuntime().exec(new String[]{"/bin/bash", "-c", "tput cols 2> /dev/tty"});
                buf = new byte[200];
                p.getInputStream().read(buf);
                val = new String(buf).trim();
                int cols = Integer.parseInt(val);
                cli.getScriptRunnerContext();
                cli.getScriptRunnerContext().putProperty("script.runner.setlinesize", cols);
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                p = Runtime.getRuntime().exec(new String[]{"/bin/bash", "-c", "tput lines 2> /dev/tty"});
                buf = new byte[200];
                p.getInputStream().read(buf);
                val = new String(buf).trim();
                int lines = Integer.parseInt(val);
                cli.getScriptRunnerContext();
                cli.getScriptRunnerContext().putProperty("script.runner.setpagesize", lines);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void addShutdownHooks() {
        Runtime.getRuntime().addShutdownHook(new Thread("cleanup"){

            @Override
            public void run() {
                MultiLineHistory.getInstance().save();
                Aliases.getInstance().save();
            }
        });
    }

    private void handleHelp() {
        try {
            String line;
            InputStream is = this.getClass().getResourceAsStream("/oracle/dbtools/raptor/scriptrunner/cmdline/help/help1.txt");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(is));
            while ((line = bufferedReader.readLine()) != null) {
                System.err.println(line);
            }
            bufferedReader.close();
        }
        catch (IOException e) {
            SqlCli.log(Level.SEVERE, e.getMessage());
        }
    }

    private static void log(Level level, String message) {
        if (logging) {
            Logger l = Logger.getLogger("oracle.dbtools");
            l.setLevel(Level.parse("SEVERE"));
            l.log(level, message);
        }
    }

    private void handleVersion() {
        String banner = Messages.getString("SqlCli.Version");
        banner = MessageFormat.format(banner, productName, SqlCli.getVersion(), SqlCli.getDevState());
        System.err.println(banner);
    }

    private void handleBanner() {
        if (!SQLCliOptions.isOptionUsed("-silent")) {
            SqlCli.banner();
        }
    }

    private void setLoggingState(ScriptRunnerContext context) {
        Boolean optlCheck = (Boolean)context.getProperty("SqlCli.optlflag");
        if (optlCheck == null || optlCheck.equals(Boolean.FALSE)) {
            logging = true;
            Logger l = Logger.getLogger("oracle.dbtools");
            l.setLevel(Level.parse("SEVERE"));
        }
    }

    private void handleExitInAtFiles() {
        if (this.getScriptRunnerContext().getProperty("script.runner.exit_int") != null) {
            SqlCli.handleCloseDown(this);
            SqlCli.handleExit(this);
        }
    }

    private void handleAtFiles(ScriptRunnerContext context) throws Exception {
        if (SQLCliOptions.getFileName() != null && SQLCliOptions.getFileName().length() > 0) {
            ArrayList<String> parserArgs = SQLCliOptions.getFileArguments();
            if (parserArgs != null) {
                for (int argCount = 0; argCount < parserArgs.size(); ++argCount) {
                    Map<String, String> m = context.getMap();
                    String preArg = parserArgs.get(argCount);
                    if ((preArg.startsWith("'") && preArg.endsWith("'") || preArg.startsWith("\"") && preArg.endsWith("\"")) && preArg.length() > 1) {
                        preArg = preArg.substring(1, preArg.length() - 1);
                    }
                    m.put(Integer.toString(argCount + 1), preArg);
                }
            }
            String toRun = null;
            String pathGiven = null;
            if (SQLPLUS.getSqlpathProvider() != null) {
                pathGiven = SQLPLUS.getSqlpathProvider().getSQLPATHsetting();
            }
            String inputFile = SQLCliOptions.getFileName();
            boolean prependDirectory = false;
            if (System.getProperty("os.name").startsWith("Windows")) {
                if (inputFile.length() <= 3 || (inputFile.charAt(1) != ':' || inputFile.charAt(2) != '/' && inputFile.charAt(2) != '\\') && (inputFile.charAt(0) != '/' || inputFile.charAt(2) != ':' || inputFile.charAt(3) != '/')) {
                    prependDirectory = true;
                }
            } else if (!inputFile.startsWith("/") && !inputFile.startsWith("\\")) {
                prependDirectory = true;
            }
            if (pathGiven != null && prependDirectory) {
                for (String possible : pathGiven.split(File.pathSeparator)) {
                    if (possible == null) continue;
                    possible = possible.endsWith("/") || possible.endsWith("\\") ? possible + inputFile : possible + File.separator + inputFile;
                    possible = System.getProperty("os.name").startsWith("Windows") ? possible.replace("/", "\\") : possible.replace("\\", "/");
                    Logger.getLogger(this.getClass().getName()).log(Level.INFO, MessageFormat.format(Messages.getString("SqlCli.FILECHECK"), possible));
                    if (!new File(possible).exists() || !new File(possible).canRead()) continue;
                    toRun = possible;
                    break;
                }
            }
            if (toRun == null) {
                toRun = SQLCliOptions.getFileName();
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, MessageFormat.format(Messages.getString("SqlCli.FILECHECK"), toRun));
            }
            this._runner = new ScriptExecutor(new FileInputStream(toRun), this._conn);
            context.setTopLevel(false);
            ArrayList scrArrayList = (ArrayList)this.getScriptRunnerContext().getProperty("script.runner.appinfo.arraylist");
            scrArrayList.add(inputFile);
            this.getScriptRunnerContext().putProperty("script.runner.appinfo.arraylist", scrArrayList);
            this._runner.setScriptRunnerContext(context);
            this._runner.run();
            context.setTopLevel(true);
        } else {
            this._runner = new ScriptExecutor(this._conn);
            this._runner.setScriptRunnerContext(context);
        }
    }

    private void handleLoginSql(ScriptRunnerContext context) {
        Boolean loginFileBool = (Boolean)context.getProperty("DBConfig.GLOGIN");
        if (loginFileBool == null || loginFileBool.equals(Boolean.TRUE)) {
            String loginFile = null;
            if (new File("login.sql").canRead()) {
                loginFile = "login.sql";
            } else {
                String pathGiven = null;
                if (SQLPLUS.getSqlpathProvider() != null) {
                    pathGiven = SQLPLUS.getSqlpathProvider().getSQLPATHsetting();
                }
                if (pathGiven != null) {
                    for (String possible : pathGiven.split(File.pathSeparator)) {
                        if (possible == null || !new File(possible = possible.endsWith(File.separator) ? possible + "login.sql" : possible + File.separator + "login.sql").exists() || !new File(possible).canRead()) continue;
                        loginFile = possible;
                        break;
                    }
                }
            }
            if (loginFile != null) {
                context.putProperty("DBConfig.GLOGIN_FILE", loginFile);
            }
        }
        if (!SQLCliOptions.isOptionUsed("/nolog")) {
            context.setSQLPlusCmdLineLogin();
            String connectS = SQLCliOptions.getConnectString();
            if (connectS == null) {
                connectS = "";
            }
            SQLCommand connectSql = new SQLCommand(SQLCommand.StmtType.G_C_SQLPLUS, SQLCommand.StmtSubType.G_S_CONNECT, SQLCommand.StmtResultType.G_R_NONE, true);
            if (SQLCliOptions.getAsRole() != null && !SQLCliOptions.getAsRole().equals("")) {
                connectS = connectS + " as " + SQLCliOptions.getAsRole();
            } else if (SQLCliOptions.isAsSysBackup()) {
                connectS = connectS + " as sysbackup";
            }
            connectSql.setOrigSQL("connect " + connectS);
            connectSql.setSql("connect " + connectS);
            SQLPLUS sp = new SQLPLUS(connectSql, new BufferedOutputStream(System.out));
            sp.setScriptRunnerContext(context);
            sp.run();
            if (sp.getConn() != null) {
                this._conn = sp.getConn();
                context.setBaseConnection(this._conn);
                context.setCloseConnection(false);
            } else {
                SqlCli.handleCloseDown(this);
                System.exit(1);
            }
        }
    }

    private String getPrompt(boolean bold) {
        if (this.RUNNING || SQLCliOptions.isOptionUsed("-silent")) {
            return "";
        }
        if (bold) {
            return Ansi.ansi().bold().a(this._ctx.getPrompt()).reset().toString();
        }
        return Ansi.ansi().render(this._ctx.getPrompt()).reset().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startSQLPlus() throws Exception {
        this.prompt = this.getPrompt(isPromptBold);
        this.reader.setHandleUserInterrupt(true);
        this.reader.setCopyPasteDetection(true);
        this.reader.setBellEnabled(true);
        this.reader.setBasePrompt(this.prompt);
        String leftOver = "";
        boolean skipNextRead = false;
        String currentLine = "";
        Pattern pattern = Pattern.compile("^(\\d+.*)");
        this.reader.getMultilineBuffer().clear();
        this._exitThread = this.startExitListener(this.reader);
        try {
            while (skipNextRead || this.startEditing() && (currentLine = this.reader.readLine(this._ctx.getPrompt())) != null) {
                if (this.RUNNING) continue;
                if (this._buffer.getBuffer().trim().length() == 0 || this._buffer.getLine(this._buffer.size()).trim().equals(".")) {
                    this.stopEditor();
                } else if (this._buffer.getBuffer().trim().replaceFirst(";", "").length() == 0) {
                    this.processLine("l");
                } else if (this._buffer.size() == 1 && pattern.matcher(currentLine).matches()) {
                    this.gotoOrChangeLine(currentLine);
                } else if (this.reader.justDidHistory()) {
                    this.reader.resetHistoryFlag();
                    this.processLine(this._buffer.getBuffer());
                } else if (this.reader.isRunBufferNow()) {
                    this.reader.setRunBufferNow(false);
                    this.processLine(this._buffer.getBuffer());
                } else if (this.isSQL(this._buffer.getBuffer()) && this.reader.getMultilineBuffer().size() > 1 && this.reader.getMultilineBuffer().getCurrentLine() == this.reader.getMultilineBuffer().size() && this.reader.getMultilineBuffer().getLine(this.reader.getMultilineBuffer().getCurrentLine()).trim().equals("")) {
                    this.stopEditor();
                } else if (this.reader.getMultilineBuffer().getCurrentLine() >= this.reader.getMultilineBuffer().size() && (this.reader.getMultilineBuffer().getCurrentLine() != this.reader.getMultilineBuffer().size() || this.reader.getCursorBuffer().cursor >= this.reader.getCursorBuffer().length())) {
                    String line = this._buffer.getBuffer();
                    if (line != null) {
                        this._buffer.startEditing(false);
                    }
                    String dummyComment = "";
                    String s = this._buffer.getBuffer();
                    for (int i = 0; i < 1000 && s.indexOf(dummyComment = "/* SQLDevZ " + i + " dummy*/") != -1; ++i) {
                    }
                    String alt = s + dummyComment;
                    Iterator<ISQLCommand> m_parser = SqlParserProvider.getScriptParserIterator(this.getScriptRunnerContext(), new StringReader(alt));
                    int commandCount = 0;
                    while ((commandCount <= 0 || !leftOver.equals("")) && m_parser.hasNext()) {
                        ISQLCommand icmd = m_parser.next();
                        if (++commandCount > 1 && icmd.getSQLOrig().indexOf(dummyComment) == -1) {
                            skipNextRead = true;
                        }
                        if (icmd.getSQLOrig().indexOf(dummyComment) != -1) continue;
                        s = s.replaceAll("\\\\r\\\\n", "\n");
                        leftOver = s.trim().substring(icmd.getSQLOrig().replaceAll("\\\\r\\\\n", "\n").trim().length()).trim();
                        String runWith = icmd.getSQLOrig();
                        if (icmd.getStatementTerminator() != null && !icmd.getStatementTerminator().equals("")) {
                            String termTrim = icmd.getStatementTerminator().trim();
                            if (leftOver.startsWith(termTrim)) {
                                leftOver = leftOver.length() == 1 || leftOver.length() == 0 ? "" : leftOver.substring(1).trim();
                            }
                            if (!termTrim.equals("") && !runWith.trim().endsWith(termTrim)) {
                                if (termTrim.equals("/")) {
                                    runWith = runWith + "\n/\n";
                                } else if (termTrim.equals(";")) {
                                    runWith = runWith + ";\n";
                                }
                            }
                        }
                        this.processLine(runWith);
                        this.prompt = this.getPrompt(isPromptBold);
                        if (this.getScriptRunnerContext().getProperty("script.runner.exit_int") == null) continue;
                        break;
                    }
                }
                if (this.getScriptRunnerContext().getProperty("script.runner.exit_int") != null) {
                    break;
                }
                if (this._buffer.getCurrentLine() > -1 && (this._buffer.getCurrentLine() < this._buffer.size() || this._buffer.isEditing())) {
                    this.prompt = this._buffer.getPrompt();
                    continue;
                }
                if (this._buffer.getCurrentLine() == this._buffer.size() && this._buffer.getLine(this._buffer.getCurrentLine()).trim().equals("") || this.processed) {
                    this.prompt = this.getPrompt(isPromptBold);
                    this._buffer.stopEditing();
                    this._buffer.clear();
                    this.processed = false;
                    continue;
                }
                if (!this.RUNNING && this._buffer.isEditing()) {
                    this.prompt = this._buffer.getPrompt();
                    continue;
                }
                this.prompt = this.getPrompt(isPromptBold);
                skipNextRead = false;
                this._buffer.clear();
            }
        }
        catch (UserInterruptException e) {
            System.out.println("Interupt");
            this.reader.fireListeners("ctrlc");
        }
        finally {
            this.stopExitListener(this._exitThread);
        }
    }

    private boolean isSQL(String buffer) {
        Iterator<ISQLCommand> parser = SqlParserProvider.getScriptParserIterator(this.getScriptRunnerContext(), new StringReader(buffer));
        while (parser.hasNext()) {
            ISQLCommand cmd = parser.next();
            if (!cmd.getStmtType().equals((Object)SQLCommand.StmtType.G_C_SQL)) continue;
            return true;
        }
        return false;
    }

    private void stopEditor() throws IOException {
        this.prompt = this.stopEditing();
        this._buffer.deleteLast();
        if (this._buffer.getBuffer().trim().length() > 0) {
            int currentLine = this._buffer.getBufferSafe().getCurrentLine();
            this.getScriptRunnerContext().getSQLPlusBuffer().setBufferSafe(this._buffer.getBufferList());
            this.getScriptRunnerContext().getSQLPlusBuffer().getBufferSafe().setCurrentLine(currentLine);
            this.getScriptRunnerContext().getSQLPlusBuffer().getBufferSafe().setTermLine(this._buffer.getTermLine(), this.reader.getTerminal().getHeight());
        }
        this.reader.println();
        this.reader.flush();
    }

    private ExitThread startExitListener(SQLPlusConsoleReader reader) {
        ExitThread exitThread = new ExitThread("Exit Thread", reader, this._runner);
        exitThread.setPriority(1);
        exitThread.setDaemon(true);
        exitThread.start();
        return exitThread;
    }

    private void stopExitListener(ExitThread exitThread) {
        if (exitThread != null) {
            exitThread.interrupt();
        }
    }

    private boolean startEditing() {
        return true;
    }

    private String stopEditing() {
        this._buffer.stopEditing();
        String prompt = this.getPrompt(isPromptBold);
        return prompt;
    }

    private void gotoOrChangeLine(String lineNumber) {
        String command = "";
        int gotoLineNumber = 0;
        StringTokenizer st = new StringTokenizer(lineNumber);
        if (st.hasMoreTokens()) {
            String s = st.nextToken();
            try {
                gotoLineNumber = Integer.parseInt(s);
            }
            catch (Exception e) {
                gotoLineNumber = -1;
            }
        }
        if (st.hasMoreTokens()) {
            while (st.hasMoreTokens()) {
                command = command + st.nextToken() + " ";
            }
        }
        if (gotoLineNumber >= 0) {
            if (command.length() > 0) {
                if (gotoLineNumber == 0) {
                    this._buffer.getBufferSafe().addAtIndex(0, command);
                } else if (gotoLineNumber > this._buffer.getBufferSafe().linesInBuffer()) {
                    this._buffer.getBufferSafe().add(command);
                } else {
                    this._buffer.getBufferSafe().replace(gotoLineNumber, command);
                }
            } else {
                System.out.println(this._buffer.getBufferSafe().setCurrentLine(gotoLineNumber));
            }
        }
        this.processed = true;
        this.reader.resetEditor();
        this.reader.setBasePrompt(this.getPrompt(isPromptBold));
    }

    protected void setScriptRunnerContext(ScriptRunnerContext newContext) {
        this._ctx = newContext;
        this._ctx.setSQLPlusBuffer(this._buffer);
        LinkedList<Completer> completors = new LinkedList<Completer>();
        this.reader.addCompleter(new FileNameCompleter(this._ctx));
        this.reader.addCompleter(new SqlCompleter(this._ctx));
        this.reader.addCompleter(new ArgumentCompleter(completors));
    }

    private static void handleExit(SqlCli cli) {
        Integer exitInt = (Integer)cli.getScriptRunnerContext().getProperty("script.runner.exit_int");
        cli.getScriptRunnerContext().deferredReInitClear();
        if (exitInt != null && exitInt > 0) {
            System.exit(exitInt);
        }
        System.exit(0);
    }

    private static void handleCloseDown(SqlCli cli) {
        Connection current = cli.getScriptRunnerContext().getCurrentConnection();
        try {
            if (cli.getScriptRunnerContext().getProperty("Spool.out.buffer") != null) {
                cli.getScriptRunnerContext().stopSpool();
            }
            if (current != null && !current.isClosed()) {
                if (cli.getScriptRunnerContext().getProperty("script.runner.sqlplus.nolog") == null || cli.getScriptRunnerContext().getProperty("script.runner.sqlplus.nolog").equals(Boolean.FALSE)) {
                    SQLPLUS.disconnectMessage(current, cli.getScriptRunnerContext(), cli.getScriptRunnerContext().getOutputStream());
                }
                current.close();
            }
        }
        catch (SQLException e) {
            ExceptionHandler.handleException(e);
        }
    }

    public static Version getVersion() {
        return version;
    }

    @Override
    public void raiseEvent(String event) {
        if (event.equals("ctrlc")) {
            this.getScriptRunnerContext();
        }
    }

    public static class ExitThread
    extends Thread {
        SQLPlusConsoleReader _reader = null;
        ScriptExecutor _runner = null;
        boolean _running = true;
        static boolean _listen = false;
        static boolean _resume = false;

        public ExitThread(String name, SQLPlusConsoleReader reader, ScriptExecutor runner) {
            super(name);
            this._reader = reader;
            this._runner = runner;
        }

        public static void stopListening() {
            _resume = _listen = false;
        }

        public void listen() {
            _resume = _listen = true;
        }

        public static void resumeListening() {
            _listen = _resume;
        }

        @Override
        public void interrupt() {
            super.interrupt();
            this._running = false;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            sameSession = false;
            while (!ExitThread.interrupted()) {
                if (!this._running) {
                    return;
                }
                if (ExitThread._listen) {
                    try {
                        in = this._reader.getInput();
                        if (!(in instanceof DbtoolsNonBlockingInputStream)) ** GOTO lbl33
                        chrs = ((DbtoolsNonBlockingInputStream)in).fullPeek();
                        if (chrs.contains(3)) {
                            if (sameSession) {
                                System.exit(1);
                            }
                            ((DbtoolsNonBlockingInputStream)in).resetBuffer();
                            sameSession = true;
                            if (this._runner == null) ** GOTO lbl33
                            this._runner.interrupt();
                        }
                        if (!chrs.contains(20)) ** GOTO lbl33
                        ((DbtoolsNonBlockingInputStream)in).resetBuffer();
                        threads = Thread.getAllStackTraces();
                        for (Thread key : threads.keySet()) {
                            System.out.println(key.getName());
                            for (StackTraceElement s : stack = threads.get(key)) {
                                System.out.println("\t" + s);
                            }
                            System.out.println("\n");
                        }
                    }
                    catch (Exception e) {
                        return;
                    }
                } else {
                    sameSession = false;
                }
lbl33:
                // 7 sources

                try {
                    ExitThread.sleep(200L);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }
    }
}

