/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.cmdline;

import java.io.File;
import java.net.MalformedURLException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.AdvancedConnectionResolver;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetFormatter;
import oracle.dbtools.raptor.console.clone.DbtoolsConsoleReader;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.proformatter.CodingStyleSQLOptionsBean;
import oracle.dbtools.raptor.proformatter.SQLPlusFormatter;
import oracle.dbtools.raptor.scriptrunner.cmdline.SqlCli;
import oracle.dbtools.raptor.scriptrunner.cmdline.handlers.SQLCliHandlePauseProvider;
import oracle.dbtools.raptor.scriptrunner.cmdline.handlers.SQLCliHandleSetPauseProvider;
import oracle.dbtools.raptor.scriptrunner.cmdline.handlers.SQLCliPromptedAcceptProvider;
import oracle.dbtools.raptor.scriptrunner.cmdline.handlers.SQLCliPromptedConnectFieldsProvider;
import oracle.dbtools.raptor.scriptrunner.cmdline.handlers.SQLCliPromptedPasswordFieldsProvider;
import oracle.dbtools.raptor.scriptrunner.cmdline.handlers.SQLCliPromptedSubstitutionProvider;

public class SQLCliHelper {
    public static String getBannerTime() {
        SimpleDateFormat dateformatter = new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy");
        Calendar now = Calendar.getInstance();
        return dateformatter.format((Object)now.getTime());
    }

    public static String getBannerYear() {
        SimpleDateFormat yearFormatter = new SimpleDateFormat("yyyy");
        Calendar now = Calendar.getInstance();
        return yearFormatter.format((Object)now.getTime());
    }

    public static ScriptRunnerContext getCliScriptRunnerContext(DbtoolsConsoleReader reader) {
        ScriptRunnerContext context = new ScriptRunnerContext();
        context.setVersion(SqlCli.getVersion());
        context.setPromptedFieldProvider(new SQLCliPromptedAcceptProvider());
        context.setSubstitutionFieldProvider(new SQLCliPromptedSubstitutionProvider());
        context.setPasswordFieldsProvider(new SQLCliPromptedPasswordFieldsProvider());
        context.setConnectFieldsProvider(new SQLCliPromptedConnectFieldsProvider());
        context.setHandlePauseProvider(new SQLCliHandlePauseProvider());
        context.setHandleSetPauseProvider(new SQLCliHandleSetPauseProvider());
        context.setSQLPlusFormatter(new SQLPlusFormatter());
        context.setSQLPlusCodingStyleOptions(new CodingStyleSQLOptionsBean());
        context.putProperty("script.runner.jline", reader);
        context.setTopLevel(true);
        context.putProperty("script.runner.using.systemout", true);
        context.putProperty("script.runner.arraysize", "15");
        context.putProperty("script.runner.setpagesize", 14);
        context.putProperty("script.runner.setlinesize", 80);
        context.putProperty("script.runner.setlong", 80);
        context.putProperty("script.runner.setlongchunksize", new Integer(80));
        context.putProperty("script.runner.setheading", "ON");
        context.putProperty("script.runner.setnumwidth", new Integer(10));
        context.putProperty("script.runner.setnumformat", "");
        context.consumerRuning(true);
        try {
            context.putProperty("script.runner.node.url", new File(System.getProperty("user.dir") + File.separator + "filename_will_be_stripped").toURI().toURL());
        }
        catch (MalformedURLException e) {
            Logger.getLogger("oracle.dbtools").log(Level.SEVERE, e.toString());
            e.printStackTrace();
        }
        context.putProperty("DBConfig.GLOGIN", true);
        context.putProperty("DBConfig.USE_THICK_DRIVER", false);
        return context;
    }

    public static void setDefaultScriptRunnerProperies() {
        ResultSetFormatter.setMaxLines(Integer.MAX_VALUE);
        ResultSetFormatter.setMaxRows(Integer.MAX_VALUE);
        DBUtil.setConnectionResolver(AdvancedConnectionResolver.getInstance());
    }
}

