/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.console.clone;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import jline.console.CursorBuffer;
import oracle.dbtools.raptor.console.clone.CompletionHandler;
import oracle.dbtools.raptor.console.clone.DbtoolsConsoleReader;

public class CandidateListCompletionHandler
implements CompletionHandler {
    @Override
    public boolean complete(DbtoolsConsoleReader reader, List<CharSequence> candidates, int pos) throws IOException {
        CursorBuffer buf = reader.getCursorBuffer();
        if (candidates.size() == 1) {
            CharSequence value = candidates.get(0);
            if (value.equals(buf.toString())) {
                return false;
            }
            CandidateListCompletionHandler.setBuffer(reader, value, pos);
            reader.setRedraw(reader.getMultilineBuffer().getCurrentLine(), DbtoolsConsoleReader.MoveState.SAME, reader.getCursorBuffer().cursor, 0, DbtoolsConsoleReader.CursorState.NORMAL, false);
            return true;
        }
        if (candidates.size() > 1) {
            String value = this.getUnambiguousCompletions(candidates);
            CandidateListCompletionHandler.setBuffer(reader, value, pos);
        }
        CandidateListCompletionHandler.printCandidates(reader, candidates);
        return true;
    }

    public static void setBuffer(DbtoolsConsoleReader reader, CharSequence value, int offset) throws IOException {
        while (reader.getCursorBuffer().cursor > offset && reader.backspace()) {
        }
        reader.putString(value);
        reader.setCursorPosition(offset + value.length());
        reader.getMultilineBuffer().replace(reader.getMultilineBuffer().getCurrentLine(), reader.getCursorBuffer().toString());
    }

    public static void printCandidates(DbtoolsConsoleReader reader, Collection<CharSequence> candidates) throws IOException {
        HashSet<CharSequence> distinct = new HashSet<CharSequence>(candidates);
        if (distinct.size() != candidates.size()) {
            ArrayList<CharSequence> copy = new ArrayList<CharSequence>();
            for (CharSequence next : candidates) {
                if (copy.contains(next)) continue;
                copy.add(next);
            }
            candidates = copy;
        }
        reader.printColumns(candidates);
    }

    private String getUnambiguousCompletions(List<CharSequence> candidates) {
        if (candidates == null || candidates.isEmpty()) {
            return null;
        }
        String[] strings = candidates.toArray(new String[candidates.size()]);
        String first = strings[0];
        StringBuilder candidate = new StringBuilder();
        for (int i = 0; i < first.length() && this.startsWith(first.substring(0, i + 1), strings); ++i) {
            candidate.append(first.charAt(i));
        }
        return candidate.toString();
    }

    private boolean startsWith(String starts, String[] candidates) {
        for (String candidate : candidates) {
            if (candidate.startsWith(starts)) continue;
            return false;
        }
        return true;
    }

    private static enum Messages {
        DISPLAY_CANDIDATES,
        DISPLAY_CANDIDATES_YES,
        DISPLAY_CANDIDATES_NO;

        private static final ResourceBundle bundle;

        public String format(Object ... args) {
            if (bundle == null) {
                return "";
            }
            return String.format(bundle.getString(this.name()), args);
        }

        static {
            bundle = ResourceBundle.getBundle(CandidateListCompletionHandler.class.getName(), Locale.getDefault());
        }
    }
}

