/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.probe;

import java.util.Collections;
import java.util.Map;
import oracle.jdevimpl.debugger.probe.DebugProbe;
import oracle.jdevimpl.debugger.probe.DebugProbeClassLoaderInfo;
import oracle.jdevimpl.debugger.probe.DebugProbeThreadGroupInfo;
import oracle.jdevimpl.debugger.support.DebugClassLoaderInfo;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugLocation;
import oracle.jdevimpl.debugger.support.DebugMonitorInfo;
import oracle.jdevimpl.debugger.support.DebugRegisterInfo;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugThreadGroupInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.debugger.support.DebugVariableInfo;
import oracle.jdevimpl.debugger.support.MethodVisitationInfoRetrievalKey;
import oracle.jdevimpl.debugger.support.TargetMethod;

final class DebugProbeThreadInfo
implements DebugThreadInfo {
    DebugProbe dp;
    DebugProbeThreadGroupInfo group;
    String name;

    DebugProbeThreadInfo(DebugProbe dp, DebugProbeThreadGroupInfo group, String name) {
        this.dp = dp;
        this.group = group;
        this.name = name;
    }

    public boolean hasExited() {
        return this.dp.isTerminated();
    }

    public long getThreadId() {
        return 1L;
    }

    public String getName() {
        return this.name;
    }

    public String getGroupName() {
        return this.group.name;
    }

    public DebugThreadGroupInfo getThreadGroup() {
        return this.group;
    }

    public int getStatus() {
        if (this.dp.isTerminated()) {
            return 6;
        }
        return 5;
    }

    public boolean isThreadSuspended() {
        return false;
    }

    public void suspendThread() {
    }

    public void resumeThread() {
    }

    public void interruptThread() {
    }

    public void stopThread() {
    }

    public DebugDataObjectInfo getThreadObject() {
        return null;
    }

    public void stepInto() {
        this.dp.stepInto();
    }

    public void stepOver() {
        this.dp.stepOver();
    }

    public void stepIntoBC() {
        this.dp.stepInto();
    }

    public void stepOverBC() {
        this.dp.stepOver();
    }

    public void stepOut() {
        this.dp.stepOut();
    }

    public boolean isAtEndOfMethod() {
        return false;
    }

    public void stepToEndOfMethod() {
    }

    public void stepIntoMethod(String methodName, String callerPackage, String callerFileName, int callerLine) {
    }

    public void stepIntoMethod(String methodName, String callerPackage, String callerFileName, int callerLineMin, int callerLineMax) {
    }

    public int getStackFrameCount() {
        return this.dp.getStackFrameCount();
    }

    public DebugStackFrameInfo getStackFrame(int frame) {
        return this.dp.getStackFrame(frame);
    }

    public DebugStackFrameInfo[] listStack() {
        return this.dp.listStack();
    }

    public DebugMonitorInfo[] listOwnedMonitors() {
        return new DebugMonitorInfo[0];
    }

    public DebugMonitorInfo getMonitorThreadWaitingFor() {
        return null;
    }

    public DebugMonitorInfo getMonitorThreadBlockedFor() {
        return null;
    }

    public DebugRegisterInfo[] listRegisters() {
        return new DebugRegisterInfo[0];
    }

    public DebugRegisterInfo[] listFloatRegisters() {
        return new DebugRegisterInfo[0];
    }

    public DebugVariableInfo getReturnValue() {
        return null;
    }

    public DebugVariableInfo getReturnedValue() {
        return null;
    }

    public boolean setLocation(DebugLocation location) {
        return false;
    }

    public DebugDataObjectInfo getContextClassLoaderObject() {
        return null;
    }

    public DebugClassLoaderInfo getContextClassLoader() {
        return DebugProbeClassLoaderInfo.makeClassLoaderInfo(this.dp);
    }

    public boolean isThreadInterrupted() {
        return false;
    }

    public boolean isThreadDebuggerStopped() {
        return false;
    }

    public boolean canDebuggerStopThread() {
        return false;
    }

    public MethodVisitationInfoRetrievalKey stepIntoMethod(TargetMethod selectedMethod, Map<TargetMethod, TargetMethod.VisitationTrackingInfo> methodsToTrack) {
        return null;
    }

    public Map<TargetMethod, TargetMethod.VisitationTrackingInfo> getMethodVisitationInfo(MethodVisitationInfoRetrievalKey retrievalKey) {
        return Collections.emptyMap();
    }

    public void clearMethodVisitationInfo(MethodVisitationInfoRetrievalKey retrievalKey) {
    }
}

