/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.validators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.Column;
import oracle.javatools.db.ColumnSequenceProcessor;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Table;
import oracle.javatools.db.plsql.Trigger;
import oracle.javatools.db.refactoring.CascadeAction;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.PlSqlValidator;
import oracle.javatools.db.validators.SourceValidationException;
import oracle.javatools.db.validators.ValidationContext;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.db.validators.ValidationLevel;
import oracle.javatools.util.ModelUtil;

public class TriggerValidator
extends PlSqlValidator<Trigger> {
    public TriggerValidator(DBObjectProvider dbObjectProvider) {
        super(dbObjectProvider);
    }

    @DBObjectValidator.PropertyValidator(value={"baseType"})
    public void validateBaseType(Trigger original, Trigger updated) throws ValidationException {
        if (updated.getBaseType() == null) {
            throw new ValidationException((DBObject)updated, APIBundle.get((String)"TRIGGER_BASE_TYPE_INVALID"));
        }
    }

    @DBObjectValidator.PropertyValidator(value={"baseObjectID"}, level=ValidationLevel.FULL)
    public void validateBaseObjectID(Trigger original, Trigger updated) throws ValidationException {
        if (updated.getBaseType() != null) {
            String actualType;
            String expectedType = updated.getBaseType() == Trigger.BaseType.TABLE ? "TABLE" : (updated.getBaseType() == Trigger.BaseType.VIEW ? "VIEW" : (updated.getBaseType() == Trigger.BaseType.SCHEMA ? "SCHEMA" : null));
            if (updated.getBaseObjectID() == null) {
                actualType = null;
            } else if (updated.getBaseObjectID() instanceof BaseObjectID) {
                actualType = ((BaseObjectID)updated.getBaseObjectID()).getType();
            } else {
                DBObject obj = null;
                try {
                    obj = updated.getBaseObjectID().resolveID();
                }
                catch (DBException e) {
                    this.logException(e, Level.WARNING);
                }
                String string = actualType = obj == null ? null : obj.getType();
            }
            if (ModelUtil.areDifferent((Object)expectedType, actualType)) {
                throw new ValidationException((DBObject)updated, APIBundle.get((String)"TRIGGER_TABLE_OR_VIEW_INVALID"));
            }
        }
    }

    @DBObjectValidator.PropertyValidator(value={"timing"})
    public void validateTiming(Trigger original, Trigger updated) throws ValidationException {
        List list = Trigger.getEvents((Trigger.BaseType)updated.getBaseType(), (Trigger.Timing)updated.getTiming());
        if (list.size() == 0) {
            throw new ValidationException((DBObject)updated, APIBundle.get((String)"TRIGGER_TIMING_INVALID"));
        }
    }

    @DBObjectValidator.PropertyValidator(value={"events"})
    @DBObjectValidator.PropertyDependency(value={"baseType", "timing"})
    public void validateEvents(ValidationContext<Trigger> context) throws ValidationException {
        List list;
        Trigger updated = (Trigger)context.getUpdatedObject();
        String[] events = updated.getEvents();
        if (events == null || events.length == 0) {
            throw new ValidationException((DBObject)updated, APIBundle.get((String)"TRIGGER_NO_EVENTS_ERROR"));
        }
        if (context.getLevel() == ValidationLevel.FULL && (list = Trigger.getEvents((Trigger.BaseType)updated.getBaseType(), (Trigger.Timing)updated.getTiming())).size() > 0) {
            for (String event : events) {
                if (list.contains(event)) continue;
                throw new ValidationException((DBObject)updated, APIBundle.format((String)"TRIGGER_EVENT_INVALID", (Object[])new Object[]{event}));
            }
        }
    }

    @DBObjectValidator.PropertyValidator(value={"referencingNewAs", "referencingOldAs"}, path=false, level=ValidationLevel.FULL)
    public void validateReferencingAs(Trigger original, Trigger updated) throws ValidationException {
        if (updated != null) {
            String oldAs;
            String newAs = updated.getReferencingNewAs();
            if (newAs == null) {
                newAs = "NEW";
            }
            if ((oldAs = updated.getReferencingOldAs()) == null) {
                oldAs = "OLD";
            }
            if (oldAs.equals(newAs)) {
                throw new ValidationException((DBObject)updated, APIBundle.format((String)"TRIGGER_DUPLICATE_REFERENCING", (Object[])new Object[]{newAs}));
            }
        }
    }

    @Override
    @DBObjectValidator.PropertyValidator(value={"source"}, level=ValidationLevel.FULL)
    public void validateSource(Trigger original, Trigger updated) throws ValidationException {
        ValidationException ex = null;
        try {
            super.validateSource(original, updated);
        }
        catch (ValidationException ve) {
            ex = ve;
        }
        if (updated.getBaseType() == Trigger.BaseType.TABLE && updated.getBaseObjectID() != null) {
            Table table = null;
            try {
                table = (Table)updated.getBaseObjectID().resolveID();
            }
            catch (DBException e) {
                table = null;
                this.logException(e, Level.WARNING);
            }
            if (table != null) {
                ArrayList<Column> allColumns = new ArrayList<Column>();
                ArrayList<Column> matchingColumns = new ArrayList<Column>();
                DBObjectID triggerID = updated.getID();
                for (Column column : table.getColumns()) {
                    if (!triggerID.equals(column.getProperty("AUTO_GENERATED_SEQUENCE_TRIGGER"))) continue;
                    allColumns.add(column);
                }
                List<ColumnSequenceProcessor.ColumnInfo> infos = ColumnSequenceProcessor.getColumnInfos(updated.getSource(), this.getProvider());
                if (infos.size() > 0 || allColumns.size() > 0) {
                    if (updated.isStatementLevel()) {
                        ex = this.addColSeqException(ex, updated, 0, 0, APIBundle.get((String)"COLSEQ_TRIGGER_VALIDATION_ROW_LEVEL"));
                    }
                    boolean onInsert = false;
                    for (String event : updated.getEvents()) {
                        if (!"INSERT".equals(event)) continue;
                        onInsert = true;
                        break;
                    }
                    if (!onInsert) {
                        ex = this.addColSeqException(ex, updated, 0, 0, APIBundle.get((String)"COLSEQ_TRIGGER_VALIDATION_INSERT"));
                    }
                    for (Column column : allColumns) {
                        ColumnSequenceProcessor.ColumnInfo info = null;
                        for (ColumnSequenceProcessor.ColumnInfo ci : infos) {
                            if (!column.getName().equals(ci.getColumnName())) continue;
                            info = ci;
                            break;
                        }
                        if (info == null) {
                            ex = this.addColSeqException(ex, updated, 0, 0, APIBundle.format((String)"COLSEQ_TRIGGER_VALIDATION_COLUMN_NOT_SET", (Object[])new Object[]{column.getName()}));
                            continue;
                        }
                        matchingColumns.add(column);
                    }
                    for (ColumnSequenceProcessor.ColumnInfo info : infos) {
                        Column column = null;
                        for (Column col : allColumns) {
                            if (!col.getName().equals(info.getColumnName())) continue;
                            column = col;
                            break;
                        }
                        if (column != null) continue;
                        ex = this.addColSeqException(ex, updated, info.getColumnStart(), info.getColumnEnd(), APIBundle.format((String)"COLSEQ_TRIGGER_VALIDATION_COLUMN_SET", (Object[])new Object[]{info.getColumnName()}));
                    }
                    for (Column column : matchingColumns) {
                        DBObjectID seqID = (DBObjectID)column.getProperty("AUTO_GENERATED_SEQUENCE");
                        boolean nullCheck = Boolean.TRUE.equals(column.getProperty("ColumnSequenceExpander.TriggerNullCheck"));
                        ColumnSequenceProcessor.ColumnInfo info = null;
                        for (ColumnSequenceProcessor.ColumnInfo ci : infos) {
                            if (!column.getName().equals(ci.getColumnName())) continue;
                            info = ci;
                            break;
                        }
                        if (nullCheck != info.isCheckForNull()) {
                            ex = this.addColSeqException(ex, updated, info.getNullCheckStart(), info.getNullCheckEnd(), APIBundle.format((String)"COLSEQ_TRIGGER_VALIDATION_NULL_CHECK_MISMATCH", (Object[])new Object[]{column.getName()}));
                        }
                        if (info.getSequenceName().equals(DBUtil.getDBObjectName((DBObjectID)seqID))) continue;
                        ex = this.addColSeqException(ex, updated, info.getSequenceStart(), info.getSequenceEnd(), APIBundle.format((String)"COLSEQ_TRIGGER_VALIDATION_SEQUENCE_MISMATCH", (Object[])new Object[]{column.getName()}));
                    }
                }
            }
        }
        if (ex != null) {
            throw ex;
        }
    }

    private ValidationException addColSeqException(ValidationException ex, Trigger trigger, int start, int end, String message) {
        return this.addException(ex, trigger, SourceValidationException.ErrorType.COLSEQ, start, end, message);
    }

    @Override
    public CascadeAction cascadeDelete(DBObject removed, Trigger obj) throws DBException {
        CascadeAction retval;
        DBObjectID id = removed.getID();
        if (removed instanceof Column) {
            boolean inColList = false;
            for (DBObjectID colID : obj.getColumnIDs()) {
                if (!colID.equals(removed.getID(), true)) continue;
                inColList = true;
                break;
            }
            retval = inColList ? this.cascadeDelete(id, (DBObject)obj, (DBObject)obj) : super.cascadeDelete(removed, obj);
        } else {
            retval = ModelUtil.areEqual((Object)id, (Object)obj.getBaseObjectID()) ? CascadeAction.DELETE : super.cascadeDelete(removed, obj);
        }
        return retval;
    }

    @Override
    public DBObjectValidator.NamespaceType getNamespaceType() {
        return DBObjectValidator.NamespaceType.TYPE;
    }

    @Override
    public Collection<String> listAlwaysValidProperties() {
        HashSet<String> ret = new HashSet<String>(super.listAlwaysValidProperties());
        ret.add("enabled");
        ret.add("columnIDs");
        ret.add("statementLevel");
        ret.add("referencingOldAs");
        ret.add("referencingNewAs");
        ret.add("whenClause");
        return ret;
    }
}

