/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.validators;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.GlobalSettings;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Relation;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.datatypes.PredefinedDataType;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.sql.BuiltInFunction;
import oracle.javatools.db.sql.ParserUtils;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLFragmentExpressionBuilder;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.SQLQueryOwner;
import oracle.javatools.db.validators.AbstractChildDBObjectValidator;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.ValidationContext;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.db.validators.ValidationLevel;
import oracle.javatools.util.ModelUtil;

public class ColumnValidator
extends AbstractChildDBObjectValidator<Column> {
    private static final String ORACLE_DATE_FORMAT = "DD-MON-RR";
    private static final String ORACLE_TZ_FORMAT = "DD-MON-RR HH.MI.SSXFF AM TZR";
    private static final String DATE_FORMAT = "ddMMMyy";
    private static final String[] SIMPLE_TZ_FORMATS = new String[]{"ddMMMyy", "ddMMMyyhhmm", "ddMMMyyhhmmaa", "ddMMMyyhhmmaazzz", "ddMMMyyhhmmss", "ddMMMyyhhmmssaa", "ddMMMyyhhmmssaazzz", "ddMMMyyhhmmssSSSaa", "ddMMMyyhhmmssSSSaazzz"};
    private static final int ORACLE_FIRST_YEAR = -4712;
    private static final int ORACLE_LAST_YEAR = 9999;
    private static Collection<String> s_validDateTimeFunctions;
    private boolean m_validateDefaults;

    public ColumnValidator(DBObjectProvider prov) {
        this(prov, false);
    }

    public ColumnValidator(DBObjectProvider prov, boolean validateDefaults) {
        super(prov);
        this.m_validateDefaults = validateDefaults;
    }

    protected boolean isViewColumn(Column column) {
        return column.getRelation() instanceof SQLQueryOwner;
    }

    @DBObjectValidator.PropertyValidator(value={"dataTypeUsage"}, level=ValidationLevel.FULL)
    public void validateDataTypeUsage(Column original, Column updated) throws ValidationException {
        if (!this.isViewColumn(updated)) {
            DBObjectID dataTypeID;
            DataTypeUsage origDTU;
            DBObjectProvider pro = this.getProvider();
            DataTypeUsage dtu = updated.getDataTypeUsage();
            DataTypeUsage dataTypeUsage = origDTU = original == null ? null : original.getDataTypeUsage();
            if (origDTU != null && ModelUtil.areDifferent((Object)origDTU, (Object)dtu) && !this.canChangeColumnDatatype(pro, updated)) {
                throw new ValidationException((DBObject)original, APIBundle.format((String)"COLUMN_ERROR_CANNOT_CHANGE", (Object[])new Object[]{ColumnValidator.formatRelationColumn(original, null)}));
            }
            DataType dataType = null;
            DBObjectID dBObjectID = dataTypeID = dtu == null ? null : dtu.getDataTypeID();
            if (!(dataTypeID instanceof ReferenceID && "DATATYPE".equals(dataTypeID.getType()) && this.getProvider() instanceof Database)) {
                try {
                    dataType = DataTypeHelper.getDataType((DataTypeUsage)dtu, (boolean)false);
                }
                catch (DBException dbe) {
                    this.logException(dbe, Level.FINE);
                }
                if (dataType == null) {
                    throw new ValidationException((DBObject)updated, APIBundle.format((String)"COLUMN_ERROR_MISSING_TYPE", (Object[])new Object[]{ColumnValidator.formatRelationColumn(updated, null)}));
                }
            }
            pro.validateObject((DBObject)origDTU, (DBObject)dtu);
            this.validateDataTypeUsage(updated, dtu, dataTypeID, dataType);
        }
    }

    protected void validateDataTypeUsage(Column column, DataTypeUsage dtu, DBObjectID dataTypeID, DataType dataType) throws ValidationException {
    }

    @DBObjectValidator.PropertyValidator(value={"virtualExpression", "virtualExpressionSource"})
    public void validateVirtualExpression(ValidationContext<Column> context) throws ValidationException {
        Column updated = (Column)context.getUpdatedObject();
        String virtualExp = updated.getVirtualExpressionSource();
        if (virtualExp != null) {
            if (!ModelUtil.hasLength((String)virtualExp)) {
                throw new ValidationException((DBObject)updated, "virtualExpressionSource", APIBundle.get((String)"VIRTUAL_COLUMN_EXPRESSION_MISSING"));
            }
            if (context.getLevel() == ValidationLevel.FULL) {
                try {
                    this.getProvider().getObjectFactory().ensureDerivedPropertyBuilder((DBObject)updated);
                    DBUtil.ensureObjectBuilt((DBObject)updated, (String[])new String[]{"virtualExpression"});
                }
                catch (DBException dbe) {
                    throw new ValidationException((DBObject)updated, "virtualExpressionSource", APIBundle.format((String)"VIRTUAL_COLUMN_EXPRESSION_INVALID", (Object[])new Object[]{dbe.getMessage()}));
                }
                SQLFragment frag = updated.getVirtualExpression();
                if (frag != null) {
                    this.validateVirtualExpressionFragment(updated, frag);
                }
            }
        }
    }

    protected void validateVirtualExpressionFragment(Column updated, SQLFragment frag) throws ValidationException {
        if (DBUtil.findUsagesIn((DBObject)updated, (DBObject)frag).size() > 0) {
            throw new ValidationException((DBObject)updated, "virtualExpressionSource", APIBundle.format((String)"VIRTUAL_COLUMN_EXPRESSION_INVALID", (Object[])new Object[]{APIBundle.get((String)"VIRTUAL_COLUMN_EXPRESSION_SELF_REFERENCE")}));
        }
    }

    @DBObjectValidator.PropertyValidator(value={"notNull"}, level=ValidationLevel.FULL)
    public void validateNotNull(Column original, Column object) throws ValidationException {
        if (!object.isNotNull()) {
            PKConstraint pk;
            Relation r = object.getRelation();
            DBObjectID id = object.getID();
            if (r != null && (pk = PKConstraint.getPrimaryKey((Relation)r)) != null && pk.isEnabled()) {
                for (DBObjectID colID : pk.getColumnIDs()) {
                    if (!colID.equals(id)) continue;
                    throw new ValidationException((DBObject)object, APIBundle.format((String)"COLUMN_ERROR_NOT_NULL_PK", (Object[])new Object[]{object.getName()}));
                }
            }
        }
    }

    @DBObjectValidator.PropertyValidator(value={"default"}, level=ValidationLevel.FULL)
    public void validateDefaultValue(Column original, Column updated) throws ValidationException {
        if (!this.isViewColumn(updated) && updated.getDefault() != null) {
            DataTypeUsage dtu = updated.getDataTypeUsage();
            DataType dataType = null;
            try {
                dataType = DataTypeHelper.getDataType((DataTypeUsage)dtu, (boolean)false);
            }
            catch (DBException dbe) {
                this.logException(dbe, Level.FINE);
            }
            if (dataType != null) {
                this.validateDefaultValue(updated, dataType);
            }
        }
    }

    protected void validateDefaultValue(Column column, DataType dataType) throws ValidationException {
        String strDefaultValue;
        Object defaultValue = column.getDefault();
        if (this.useBaseDefaultValueValidation() && defaultValue != null && DataTypeHelper.isTypeOf((DataType)dataType, PredefinedDataType.class) && ModelUtil.hasLength((String)(strDefaultValue = defaultValue.toString().trim()))) {
            this.validateDefaultValue(strDefaultValue, column, column.getDataTypeUsage(), dataType);
        }
    }

    protected boolean useBaseDefaultValueValidation() {
        return this.m_validateDefaults;
    }

    protected void validateDefaultValue(String defaultValue, Column column, DataTypeUsage dataTypeUsage, DataType dataType) throws ValidationException {
        block16: {
            try {
                Relation parent = column.getRelation();
                Collection colrefs = ParserUtils.getColumnNames((String)defaultValue, (SQLFragmentExpressionBuilder.ExpressionType)SQLFragmentExpressionBuilder.ExpressionType.ITEM, (DBObjectProvider)this.getProvider(), (Relation)parent);
                if (colrefs.size() > 0) {
                    String colNames = null;
                    for (String[] nameComponents : colrefs) {
                        String name = null;
                        for (String component : nameComponents) {
                            name = name == null ? component : name + '.' + component;
                        }
                        if (colNames == null) {
                            colNames = name;
                            continue;
                        }
                        colNames = colNames + ", " + name;
                    }
                    throw new ValidationException((DBObject)column, APIBundle.format((String)"DEFAULT_VALUE_ERROR_COLUMN_REF", (Object[])new Object[]{colNames}));
                }
            }
            catch (SQLQueryException x) {
                Character first;
                String trimmed = defaultValue.trim();
                if (!ModelUtil.hasLength((String)trimmed) || !Character.isUnicodeIdentifierStart((first = Character.valueOf(trimmed.charAt(0))).charValue())) break block16;
                throw new ValidationException((DBObject)column, APIBundle.format((String)"DEFAULT_VALUE_ERROR_COLUMN_REF", (Object[])new Object[]{defaultValue}));
            }
        }
        PredefinedDataType.ValueType valueType = null;
        PredefinedDataType pdt = (PredefinedDataType)DataTypeHelper.unwrapDataType((DataType)dataType, PredefinedDataType.class);
        if (pdt != null) {
            valueType = pdt.getValueType();
        }
        if (valueType == PredefinedDataType.ValueType.CHAR) {
            this.validateCharacterDefaultValue(defaultValue, column, dataTypeUsage, dataType);
        } else if (PredefinedDataType.ValueType.isNumericType((PredefinedDataType.ValueType)valueType)) {
            this.validateNumericDefaultValue(defaultValue, column, dataTypeUsage, dataType);
        } else if (valueType == PredefinedDataType.ValueType.BINARY) {
            this.validateBinaryDefaultValue(defaultValue, column, dataTypeUsage, dataType);
        } else if (valueType == PredefinedDataType.ValueType.TIMESTAMP) {
            this.validateTimestampDefaultValue(defaultValue, column, dataTypeUsage, dataType);
        } else if (valueType == PredefinedDataType.ValueType.DATE) {
            this.validateDateDefaultValue(defaultValue, column, dataTypeUsage, dataType);
        }
    }

    protected void validateCharacterDefaultValue(String defaultValue, Column column, DataTypeUsage dataTypeUsage, DataType dataType) throws ValidationException {
        SQLFragment frag = this.parseDefaultValue(defaultValue, column);
        if (frag != null && ParserUtils.isConstant((SQLFragment)frag) && dataType.hasDataTypeAttribute("size")) {
            int defaultValueLength;
            DataTypeAttribute size = dataType.getDataTypeAttribute("size");
            Long dataTypeSize = size.isDeclarable() ? DataTypeHelper.getLongAttributeValue((DataTypeUsage)dataTypeUsage, (String)"size") : size.getMaxValue();
            if (dataTypeSize == null) {
                dataTypeSize = (Long)size.getDefaultValue();
            }
            if (dataTypeSize != null && (long)(defaultValueLength = (defaultValue = ParserUtils.getConstant((SQLFragment)frag)).length() - (defaultValue.charAt(0) == '\'' ? 2 : 0)) > dataTypeSize) {
                throw new ValidationException((DBObject)column, APIBundle.format((String)"DEFAULT_VALUE_ERROR_LENGTH_TOO_LARGE", (Object[])new Object[]{new Long(defaultValueLength), dataTypeSize}));
            }
        }
    }

    protected void validateBinaryDefaultValue(String defaultValue, Column column, DataTypeUsage dataTypeUsage, DataType dataType) throws ValidationException {
        if (this.isQuoted(defaultValue)) {
            this.validateCharacterDefaultValue(defaultValue, column, dataTypeUsage, dataType);
        }
    }

    protected void validateNumericDefaultValue(String strDefaultValue, Column column, DataTypeUsage dataTypeUsage, DataType dataType) throws ValidationException {
        SQLFragment frag = this.parseDefaultValue(strDefaultValue, column);
        if (ParserUtils.isConstant((SQLFragment)frag)) {
            Long scaleVal;
            BigDecimal value = null;
            try {
                String nodeValue = ParserUtils.getConstant((SQLFragment)frag);
                String quote = "'";
                if (nodeValue.length() > 0 && nodeValue.startsWith("'")) {
                    nodeValue = nodeValue.substring(1, nodeValue.length() - 1);
                }
                if (nodeValue.length() == 0) {
                    return;
                }
                if ((nodeValue = nodeValue.trim()).length() == 0) {
                    throw new ValidationException((DBObject)column, APIBundle.get((String)"DEFAULT_VALUE_ERROR_NOT_A_NUMERIC"));
                }
                value = new BigDecimal(nodeValue);
            }
            catch (NumberFormatException nfe) {
                throw new ValidationException((DBObject)column, APIBundle.get((String)"DEFAULT_VALUE_ERROR_NOT_A_NUMERIC"));
            }
            DataTypeAttribute precisionAttr = dataType.getDataTypeAttribute("precision");
            DataTypeAttribute scaleAttr = dataType.getDataTypeAttribute("scale");
            Long precisionVal = DataTypeHelper.getLongAttributeValue((DataTypeUsage)dataTypeUsage, (String)"precision");
            if (precisionVal == null && precisionAttr != null) {
                precisionVal = (Long)precisionAttr.getDefaultValue();
            }
            if ((scaleVal = DataTypeHelper.getLongAttributeValue((DataTypeUsage)dataTypeUsage, (String)"scale")) == null && scaleAttr != null) {
                scaleVal = (Long)scaleAttr.getDefaultValue();
            }
            if (precisionVal != null && scaleVal != null) {
                int defaultValueScale = value.scale();
                BigInteger unscaledValue = value.abs().unscaledValue();
                String strUnscaledValue = unscaledValue.toString();
                int defaultValuePrecision = strUnscaledValue.length();
                for (int s = 0; defaultValuePrecision > 0 && s < defaultValueScale && strUnscaledValue.charAt(defaultValuePrecision - 1) == '0'; --defaultValuePrecision, ++s) {
                }
                if (defaultValueScale == 0) {
                    defaultValueScale = defaultValuePrecision - strUnscaledValue.length();
                }
                if (scaleVal.intValue() >= 0) {
                    if (defaultValueScale > scaleVal.intValue()) {
                        throw new ValidationException((DBObject)column, APIBundle.format((String)"DEFAULT_VALUE_ERROR_SCALE_TOO_LARGE", (Object[])new Object[]{new Long(defaultValueScale), scaleVal}));
                    }
                } else if (defaultValueScale > 0) {
                    throw new ValidationException((DBObject)column, APIBundle.get((String)"DEFAULT_VALUE_ERROR_INVALID_FRACTION"));
                }
                if (defaultValuePrecision - defaultValueScale > precisionVal.intValue() - scaleVal.intValue()) {
                    throw new ValidationException((DBObject)column, APIBundle.format((String)"DEFAULT_VALUE_ERROR_VALUE_TOO_LARGE", (Object[])new Object[]{strDefaultValue, precisionVal, scaleVal}));
                }
            } else {
                boolean validValue = false;
                boolean isUnsigned = dataTypeUsage.getAttributeValue("unsigned") != null;
                PredefinedDataType numberType = (PredefinedDataType)DataTypeHelper.unwrapDataType((DataType)dataType, PredefinedDataType.class);
                PredefinedDataType.ValueType valueType = numberType.getValueType();
                if (valueType == PredefinedDataType.ValueType.FLOAT) {
                    BigDecimal minPositiveValue = numberType.getMinValue();
                    BigDecimal maxPositiveValue = numberType.getMaxValue();
                    BigDecimal minNegativeValue = minPositiveValue.negate();
                    BigDecimal maxNegativeValue = maxPositiveValue.negate();
                    if (value.compareTo(BigDecimal.ZERO) == 0 || (minPositiveValue == null || value.compareTo(minPositiveValue) >= 0) && (maxPositiveValue == null || value.compareTo(maxPositiveValue) <= 0)) {
                        validValue = true;
                    }
                    if (!(isUnsigned || minNegativeValue != null && value.compareTo(minNegativeValue) < 0 || maxNegativeValue != null && value.compareTo(maxNegativeValue) > 0)) {
                        validValue = true;
                    }
                } else {
                    BigDecimal maxUnsignedValue = null;
                    BigDecimal minIntValue = numberType.getMinValue();
                    BigDecimal maxIntValue = numberType.getMaxValue();
                    if (valueType == PredefinedDataType.ValueType.SIGNED_INT && maxIntValue != null) {
                        maxUnsignedValue = maxIntValue.multiply(BigDecimal.valueOf(2L)).add(BigDecimal.ONE);
                    }
                    if (valueType == PredefinedDataType.ValueType.SIGNED_INT) {
                        BigDecimal maxValue;
                        BigDecimal minValue = isUnsigned ? BigDecimal.ZERO : minIntValue;
                        BigDecimal bigDecimal = maxValue = isUnsigned ? maxUnsignedValue : maxIntValue;
                        if (!(minValue != null && value.compareTo(minValue) < 0 || maxValue != null && value.compareTo(maxValue) > 0)) {
                            validValue = true;
                        }
                    } else if (valueType == PredefinedDataType.ValueType.UNSIGNED_INT) {
                        if (!(minIntValue != null && value.compareTo(minIntValue) < 0 || maxIntValue != null && value.compareTo(maxIntValue) > 0)) {
                            validValue = true;
                        }
                    } else {
                        this.getLogger().fine("Min Max range not defined for " + dataType.getName());
                        validValue = true;
                    }
                }
                if (!validValue) {
                    throw new ValidationException((DBObject)column, APIBundle.format((String)"DEFAULT_VALUE_ERROR_RANGE", (Object[])new Object[]{strDefaultValue}));
                }
            }
        }
    }

    protected void validateDateDefaultValue(String defaultValue, Column column, DataTypeUsage dataTypeUsage, DataType dataType) throws ValidationException {
        String err = this.validateDateTime(column, defaultValue, new SimpleDateFormat(DATE_FORMAT), ORACLE_DATE_FORMAT);
        if (err != null) {
            throw new ValidationException((DBObject)column, err);
        }
    }

    protected void validateTimestampDefaultValue(String defaultValue, Column column, DataTypeUsage dataTypeUsage, DataType dataType) throws ValidationException {
        String format;
        String err = null;
        String[] stringArray = SIMPLE_TZ_FORMATS;
        int n = stringArray.length;
        for (int i = 0; i < n && (err = this.validateDateTime(column, defaultValue, new SimpleDateFormat(format = stringArray[i]), ORACLE_TZ_FORMAT)) != null; ++i) {
        }
        if (err != null) {
            throw new ValidationException((DBObject)column, err);
        }
    }

    protected String validateDateTime(Column column, String defaultValue, SimpleDateFormat format, String equivalentOracleFormat) throws ValidationException {
        String errorMessage = null;
        GlobalSettings settings = GlobalSettings.getInstance();
        if (settings != null && settings.isValidateDateTime() && !defaultValue.equalsIgnoreCase("null")) {
            errorMessage = this.isQuoted(defaultValue) ? this.validateUsingFormat(defaultValue, format, equivalentOracleFormat) : this.validateDateExpr(column, defaultValue);
        }
        return errorMessage;
    }

    private String validateDateExpr(Column column, String defaultValue) throws ValidationException {
        String error = null;
        String errorMessage = null;
        SQLFragment frag = null;
        try {
            frag = this.parseDefaultValue(defaultValue, column);
        }
        catch (ValidationException x) {
            error = APIBundle.format((String)"DEFAULT_VALUE_ERROR_INVALID_EXPRESSION", (Object[])new Object[]{x.getMessage()});
        }
        if (!ParserUtils.isAllowedExpression((SQLFragment)frag, this.getValidDateTimeFunctions())) {
            error = APIBundle.format((String)"DEFAULT_VALUE_ERROR_INVALID_EXPRESSION", (Object[])new Object[]{defaultValue});
        }
        if (error != null) {
            errorMessage = APIBundle.format((String)"DEFAULT_VALUE_ERROR_NOT_A_DATE_TIME_EXPR", (Object[])new Object[]{error});
        }
        return errorMessage;
    }

    private String validateUsingFormat(String defaultValue, SimpleDateFormat format, String equivalentOracleFormat) {
        String errorMessage = null;
        HashMap<Integer, Integer> pos = new HashMap<Integer, Integer>();
        String strippedDef = ColumnValidator.stripSpacesAndSeperators(defaultValue, pos);
        boolean ok = true;
        int offset = 0;
        String error = "";
        ParsePosition parsePosn = new ParsePosition(0);
        Date date = format.parse(strippedDef, parsePosn);
        if (null == date || parsePosn.getIndex() != strippedDef.length()) {
            ok = false;
            offset = parsePosn.getErrorIndex();
            if (-1 == offset) {
                offset = parsePosn.getIndex();
            }
        } else {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            int year = calendar.get(1);
            if (year < -4712 || year > 9999) {
                ok = false;
                error = APIBundle.format((String)"DEFAULT_VALUE_ERROR_INVALID_YEAR", (Object[])new Object[]{Integer.toString(year)});
            }
        }
        if (!ok) {
            String errLocation = "";
            Integer oldOffset = (Integer)pos.get(offset);
            if (oldOffset != null) {
                errLocation = APIBundle.format((String)"DEFAULT_VALUE_ERROR_FRAGMENT_NOT_RECOGNISED", (Object[])new Object[]{defaultValue.substring(oldOffset)});
            }
            errorMessage = APIBundle.format((String)"DEFAULT_VALUE_ERROR_NOT_A_DATE_TIME", (Object[])new Object[]{errLocation, error, equivalentOracleFormat});
        }
        return errorMessage;
    }

    protected boolean isQuoted(String str) {
        String quote = "'";
        String trimmed = str.trim();
        return trimmed.length() > 1 && trimmed.startsWith("'") && trimmed.endsWith("'");
    }

    protected SQLFragment parseDefaultValue(String strDefaultValue, Column column) throws ValidationException {
        SQLFragment retval = null;
        try {
            DBObjectProvider prov = this.getProvider();
            Relation rel = column.getRelation();
            SQLFragmentExpressionBuilder.ExpressionType type = SQLFragmentExpressionBuilder.ExpressionType.ITEM;
            retval = SQLFragmentExpressionBuilder.getExpressionOrFail((DBObjectProvider)prov, (Relation)rel, (SQLFragmentExpressionBuilder.ExpressionType)type, (String)strDefaultValue);
        }
        catch (SQLQueryException x) {
            throw new ValidationException((DBObject)column, APIBundle.format((String)"DEFAULT_VALUE_ERROR_INVALID_EXPRESSION", (Object[])new Object[]{x.getMessage()}));
        }
        return retval;
    }

    private static String stripSpacesAndSeperators(String defaultValue, Map<Integer, Integer> pos) {
        StringBuilder def = new StringBuilder();
        char[] chars = defaultValue.toCharArray();
        int i = 0;
        int j = 0;
        while (i < chars.length) {
            while (i < chars.length && Character.isWhitespace(chars[i])) {
                ++i;
            }
            if (chars.length == i) break;
            if (!Character.isLetterOrDigit(chars[i])) {
                ++i;
            }
            while (i < chars.length && Character.isWhitespace(chars[i])) {
                ++i;
            }
            if (chars.length == i) break;
            def.append(chars[i]);
            pos.put(new Integer(j++), new Integer(i++));
        }
        String strippedDef = def.toString();
        return strippedDef;
    }

    private boolean isDateTimeType(DBObjectID dtid) throws ValidationException {
        boolean retval = false;
        try {
            DBObject dt;
            if (dtid != null && (dt = dtid.resolveID()) instanceof PredefinedDataType) {
                PredefinedDataType.ValueType dtvt = ((PredefinedDataType)dt).getValueType();
                retval = dtvt == PredefinedDataType.ValueType.DATE || dtvt == PredefinedDataType.ValueType.TIMESTAMP;
            }
        }
        catch (DBException dbe) {
            this.logException(dbe, Level.FINE);
        }
        return retval;
    }

    private boolean isDateTimeFunction(BuiltInFunction bif) throws ValidationException {
        boolean retval = false;
        DBObjectID bifrtid = bif.getReturnTypeID();
        if (bifrtid != null) {
            retval = this.isDateTimeType(bifrtid);
        }
        return retval;
    }

    private Collection<String> getValidDateTimeFunctions() throws ValidationException {
        if (s_validDateTimeFunctions == null) {
            s_validDateTimeFunctions = new ArrayList<String>();
            DatabaseDescriptor dbd = this.getProvider().getDescriptor();
            List bifs = dbd.listBuiltInFunctions();
            for (BuiltInFunction bif : bifs) {
                if (!this.isDateTimeFunction(bif)) continue;
                s_validDateTimeFunctions.add(bif.getName());
            }
        }
        s_validDateTimeFunctions.add("ROUND");
        s_validDateTimeFunctions.add("LEAST");
        s_validDateTimeFunctions.add("GREATEST");
        s_validDateTimeFunctions.add("+");
        s_validDateTimeFunctions.add("-");
        return s_validDateTimeFunctions;
    }

    private boolean canChangeColumnDatatype(DBObjectProvider prov, Column col) throws ValidationException {
        try {
            Relation relation = col.getRelation();
            DBObjectID origRelID = null;
            if (relation.getID() instanceof TemporaryObjectID) {
                DBObject orig = ((TemporaryObjectID)relation.getID()).resolveOriginalID();
                origRelID = orig.getID();
            }
            for (Constraint con : relation.getConstraints()) {
                for (DBObject usage : DBUtil.findUsagesIn((DBObject)col, (DBObject)con)) {
                    FKConstraint[] fkrefs;
                    if (usage instanceof FKConstraint) {
                        return false;
                    }
                    if (!(usage instanceof PKConstraint) && !(usage instanceof UniqueConstraint)) continue;
                    for (Constraint c : relation.getConstraints()) {
                        DBObject refCon;
                        if (!(c instanceof FKConstraint) || (refCon = ((FKConstraint)c).getReferenceID().resolveID()) != usage) continue;
                        return false;
                    }
                    if (usage.getID() instanceof TemporaryObjectID) {
                        usage = ((TemporaryObjectID)usage.getID()).resolveOriginalID();
                    }
                    if (null == (fkrefs = DBUtil.getReferences((Constraint)((Constraint)usage), (DBObjectProvider)prov))) continue;
                    for (FKConstraint fk : fkrefs) {
                        if (fk.getParent().getID().equals(origRelID)) continue;
                        return false;
                    }
                }
            }
        }
        catch (DBException dbe) {
            this.logException(dbe, Level.WARNING);
        }
        return true;
    }

    public static String formatRelationColumn(Column column, Relation rel) {
        StringBuilder format = new StringBuilder();
        if (column != null) {
            String parName;
            Relation par = column.getRelation();
            Relation relation = par = par == null ? rel : par;
            if (par != null && ModelUtil.hasLength((String)(parName = par.getName()))) {
                format.append(parName);
                format.append(".");
            }
            format.append(column.getName());
        }
        return format.toString();
    }
}

