/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sqlite;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import oracle.javatools.db.BaseDatabaseCreator;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.sqlite.SQLiteDatabase;
import oracle.javatools.db.sqlite.SQLiteDatabaseDescriptor;
import oracle.javatools.db.sqlite.SQLiteDatabaseImpl;

public class SQLiteDatabaseFactory
extends BaseDatabaseCreator {
    protected Database createDatabaseImpl(String connStore, String connName, Connection conn) {
        int ver = this.getSQLiteConnectionVersion(conn);
        if (ver == 0) {
            return null;
        }
        return new SQLiteDatabaseImpl(connStore, connName, conn);
    }

    protected int getSQLiteConnectionVersion(Connection conn) {
        int majorVer = 0;
        if (conn != null) {
            try {
                DatabaseMetaData dmd = conn.getMetaData();
                String databaseName = dmd.getDatabaseProductName();
                if ("SQLite".equals(databaseName)) {
                    String ver = dmd.getDatabaseProductVersion();
                    if (ver != null) {
                        String[] chunks = ver.split("\\.");
                        int factor = 10000;
                        for (int i = 0; i < chunks.length && i < 3; ++i) {
                            try {
                                int v = Integer.valueOf(chunks[i]);
                                majorVer += v * factor;
                                factor /= 100;
                                continue;
                            }
                            catch (NumberFormatException nfe) {
                                majorVer = 0;
                                break;
                            }
                        }
                    }
                    if (majorVer == 0) {
                        majorVer = dmd.getDatabaseMajorVersion() * 10000;
                    }
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return majorVer;
    }

    protected DatabaseDescriptor getDatabaseDescriptorImpl(Class providerClass) {
        SQLiteDatabaseDescriptor retval = null;
        if (SQLiteDatabase.class.isAssignableFrom(providerClass)) {
            retval = new SQLiteDatabaseDescriptor(providerClass);
        }
        return retval;
    }
}

