/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.plsql.parser;

import java.lang.ref.WeakReference;
import java.util.logging.Level;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.plsql.PlSqlSchemaObject;
import oracle.javatools.db.plsql.PlSqlSchemaObjectBody;
import oracle.javatools.db.plsql.PlSqlSchemaObjectSpec;
import oracle.javatools.db.plsql.PlSqlUtil;
import oracle.javatools.db.plsql.parser.PlSqlSourceObjectBuilder;
import oracle.javatools.util.ModelUtil;

public class PlSqlSpecAndBodyBuilder<T extends PlSqlSchemaObject>
extends PlSqlSourceObjectBuilder<T> {
    private WeakReference<PlSqlSchemaObject> m_refToOther;

    public PlSqlSpecAndBodyBuilder(AbstractDBObjectProvider pro, String type) {
        super(pro, type);
    }

    @Override
    protected void addNameProperties(T pso, PlSqlUtil.TypeAndNameInfo info) throws CancelledException {
        super.addNameProperties(pso, info);
        String nameInSource = info.getName();
        String psoName = pso.getName();
        String otherType = PlSqlUtil.getCompanionObjectType(pso);
        if (otherType != null) {
            PlSqlSchemaObject other = null;
            if (!(this.m_refToOther == null || (other = (PlSqlSchemaObject)this.m_refToOther.get()) != null && otherType.equals(other.getType()) && nameInSource.equals(other.getName()))) {
                other = null;
                this.m_refToOther = null;
            }
            if (other == null) {
                try {
                    other = (PlSqlSchemaObject)this.getProvider().getObject(otherType, pso.getSchema(), nameInSource);
                    if (ModelUtil.areDifferent((Object)nameInSource, (Object)psoName) && other == null) {
                        other = (PlSqlSchemaObject)this.getProvider().getObject(otherType, pso.getSchema(), psoName);
                    }
                    if (other != null) {
                        this.m_refToOther = new WeakReference<PlSqlSchemaObject>(other);
                    }
                }
                catch (DBException e) {
                    DBLog.getLogger().log(Level.WARNING, "failed to find spec for " + psoName + " body");
                }
            }
            if (other instanceof PlSqlSchemaObjectSpec) {
                ((PlSqlSchemaObjectBody)pso).setSpecID(other.getID());
            } else if (other instanceof PlSqlSchemaObjectBody) {
                ((PlSqlSchemaObjectSpec)pso).setBodyID(other.getID());
            }
        }
    }
}

