/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.plsql.parser;

import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.plsql.PlSqlSourceObject;
import oracle.javatools.db.plsql.parser.LegacyPlSqlParserImpl;
import oracle.javatools.db.plsql.parser.PlSqlParser;
import oracle.javatools.db.plsql.parser.PlSqlParserFactory;
import oracle.javatools.db.plsql.parser.SQLDevPlSqlParserImpl;

public class PlSqlParserFactoryImpl
extends PlSqlParserFactory {
    static final String PARSER = "oracle.javatools.db.plsql.PlSqlParser";
    static final String LEGACY = "legacy";
    static final String SQLDEV = "sqldev";

    public PlSqlParserFactoryImpl(DBObjectProvider pro) {
        super(pro);
    }

    public PlSqlParser createParser(String source) {
        if (this.useLegacyParser()) {
            return new LegacyPlSqlParserImpl(this.getProvider(), null, source);
        }
        return new SQLDevPlSqlParserImpl(this.getProvider(), null, source);
    }

    public PlSqlParser createParser(PlSqlSourceObject pso) {
        if (this.useLegacyParser()) {
            return new LegacyPlSqlParserImpl(this.getProvider(), pso, null);
        }
        return new SQLDevPlSqlParserImpl(this.getProvider(), pso, null);
    }

    private boolean useLegacyParser() {
        boolean ret = false;
        String parser = System.getProperty(PARSER);
        if (LEGACY.equals(parser)) {
            ret = true;
        } else if (SQLDEV.equals(parser)) {
            ret = false;
        }
        return ret;
    }
}

