/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.plsql.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.SourceObject;
import oracle.javatools.db.plsql.DBObjectPlSqlFragment;
import oracle.javatools.db.plsql.PlSqlBlock;
import oracle.javatools.db.plsql.PlSqlDatatype;
import oracle.javatools.db.plsql.PlSqlFragment;
import oracle.javatools.db.plsql.PlSqlInterrogator;
import oracle.javatools.db.plsql.PlSqlInterrogatorFactory;
import oracle.javatools.db.plsql.PlSqlParameter;
import oracle.javatools.db.plsql.PlSqlSourceObject;
import oracle.javatools.db.plsql.PlSqlStatement;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.PlSqlVariable;
import oracle.javatools.db.plsql.Trigger;
import oracle.javatools.db.plsql.Type;
import oracle.javatools.db.plsql.parser.PlSqlParser;
import oracle.javatools.db.plsql.parser.PlSqlParserHelper;
import oracle.javatools.util.Tuple;

class LegacyPlSqlParserImpl
extends PlSqlParser {
    private PlSqlInterrogator m_pi;

    protected LegacyPlSqlParserImpl(DBObjectProvider pro, PlSqlSourceObject pso, String source) {
        super(pro, pso, source);
        this.m_pi = pso != null ? PlSqlInterrogatorFactory.getInterrogator((SourceObject)pso) : PlSqlInterrogator.findOrCreate((String)source);
    }

    public PlSqlToken getTokenAtOffset(int offset) {
        return this.m_pi.getTokenAtOffset(offset);
    }

    public boolean isWrapped() {
        return this.m_pi.isWrapped();
    }

    public Object getParseNode(DBObjectPlSqlFragment frag) {
        PlSqlFragment ret = null;
        if (frag instanceof PlSqlSourceObject) {
            ret = this.m_pi.getRoot();
        } else if (frag != null) {
            Integer end;
            Integer start = frag.getStartOffset();
            if (start == null) {
                start = 0;
            }
            if ((end = frag.getEndOffset()) == null) {
                end = this.getSource().length() - 1;
            }
            ret = this.findPlSqlFragment(this.m_pi.getRoot(), start, end);
        }
        return ret;
    }

    private PlSqlFragment findPlSqlFragment(PlSqlFragment pfrag, int start, int end) {
        if (pfrag == null) {
            return null;
        }
        int fragStart = pfrag.getStartOffset();
        int fragEnd = pfrag.getEndOffset();
        if (fragStart <= start && fragEnd >= end) {
            for (PlSqlFragment kid : pfrag.getChildren()) {
                PlSqlFragment ret = this.findPlSqlFragment(kid, start, end);
                if (ret == null) continue;
                return ret;
            }
            return pfrag;
        }
        return null;
    }

    public List getChildParseNodes(DBObjectPlSqlFragment frag, Object parseNode) {
        this.checkParseNode(parseNode);
        return Arrays.asList(((PlSqlFragment)parseNode).getChildren());
    }

    public DBObjectPlSqlFragment createFragment(DBObjectPlSqlFragment parentFragment, Object parentParseNode, Object parseNode) throws CancelledException {
        PlSqlFragment frag = this.checkParseNode(parseNode);
        DBObjectPlSqlFragment retval = null;
        PlSqlFragment parFrag = frag.getParent();
        PlSqlFragment.Type fragType = frag.getFragmentType();
        if (fragType == PlSqlFragment.Type.BEGIN && (frag.getParent().getFragmentType() == PlSqlFragment.Type.PROCEDURE || frag.getParent().getFragmentType() == PlSqlFragment.Type.FUNCTION)) {
            fragType = PlSqlFragment.Type.PLSQL_BLOCK;
        }
        switch (fragType) {
            case PROCEDURE: 
            case FUNCTION: 
            case PROCEDURE_FD: 
            case FUNCTION_FD: {
                if (parFrag.getFragmentType() == PlSqlFragment.Type.ROOT) break;
                retval = this.createPlSqlSubProgram(this.getRoot());
                break;
            }
            case PLSQL_BLOCK: 
            case FOR_LOOP: {
                retval = this.createFragment(PlSqlBlock.class);
                break;
            }
            case DECLARATION: {
                if (frag.getFirstToken().matches("TYPE") || frag.getFirstToken().matches("SUBTYPE")) {
                    retval = this.createFragment(PlSqlDatatype.class);
                    break;
                }
                retval = this.createFragment(PlSqlVariable.class);
                break;
            }
            case PARAMETER: {
                retval = this.createFragment(PlSqlParameter.class);
                break;
            }
            case CURSOR: {
                retval = this.createPlSqlSubProgram(this.getRoot());
                break;
            }
            case IF: 
            case ELSIF: 
            case ELSE: 
            case LOOP: 
            case WHILE_LOOP: 
            case STATEMENT: {
                retval = this.createFragment(PlSqlStatement.class);
                break;
            }
        }
        if (retval != null) {
            retval.setStartOffset(Integer.valueOf(frag.getStartOffset()));
            retval.setEndOffset(Integer.valueOf(frag.getEndOffset()));
            if (retval instanceof PlSqlStatement) {
                try {
                    ((PlSqlStatement)retval).setStatementType(PlSqlStatement.Type.valueOf((String)frag.getFragmentType().toString()));
                }
                catch (Throwable t) {
                    DBLog.getLogger((Object)((Object)this)).finest("failed to convert fragment type to statement type");
                }
            }
        }
        return retval;
    }

    protected Object[] getPropertyNodesImpl(DBObjectPlSqlFragment frag, String property) throws CancelledException {
        PlSqlFragment subProgramNode;
        PlSqlFragment parameterListNode;
        Object parseNode = this.getParseNode(frag);
        PlSqlFragment parentNode = this.checkParseNode(parseNode);
        if (frag instanceof Trigger) {
            Object[] objectArray;
            PlSqlFragment.Type type = null;
            PlSqlFragment retval = null;
            if ("baseObjectID".equals(property)) {
                type = PlSqlFragment.Type.TRIGGER_TABLE;
            } else if ("code".equals(property)) {
                type = PlSqlFragment.Type.PLSQL_BLOCK;
            } else if ("columnIDs".equals(property)) {
                type = PlSqlFragment.Type.TRIGGER_COLUMNS;
            } else if ("events".equals(property)) {
                type = PlSqlFragment.Type.TRIGGER_EVENTS;
            } else if ("referencingNewAs".equals(property) || "referencingOldAs".equals(property)) {
                type = PlSqlFragment.Type.TRIGGER_REFERENCING;
            } else if ("statementLevel".equals(property)) {
                type = PlSqlFragment.Type.TRIGGER_ROW_LEVEL;
            } else if ("timing".equals(property)) {
                type = PlSqlFragment.Type.TRIGGER_TIMING;
            } else if ("whenClause".equals(property)) {
                type = PlSqlFragment.Type.TRIGGER_WHEN;
            }
            if (type != null) {
                retval = parentNode.findChild(type, true);
            }
            if (retval == null) {
                objectArray = null;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = retval;
            }
            return objectArray;
        }
        if (frag instanceof Type) {
            PlSqlFragment rootFrag = parentNode.findChild(PlSqlFragment.Type.TYPE_SPEC, false);
            ArrayList<PlSqlFragment> frags = new ArrayList<PlSqlFragment>();
            for (PlSqlFragment kid : rootFrag.getChildren()) {
                PlSqlFragment.Type type = kid.getFragmentType();
                if ((type == PlSqlFragment.Type.PROCEDURE_FD || type == PlSqlFragment.Type.FUNCTION_FD) && "methods".equals(property)) {
                    frags.add(kid);
                    continue;
                }
                if (type != PlSqlFragment.Type.DECLARATION || kid.getFirstToken().matches("PRAGMA") || !"attributes".equals(property)) continue;
                frags.add(kid);
            }
            return frags.toArray(new PlSqlFragment[frags.size()]);
        }
        if ("parameters".equals(property) && (parameterListNode = (subProgramNode = this.checkParseNode(parseNode)).findChild(PlSqlFragment.Type.PARAMETER_LIST, false)) != null) {
            return parameterListNode.getChildren();
        }
        return new Object[0];
    }

    public PlSqlToken getTypeToken() {
        return this.m_pi.getRoot().getFirstToken();
    }

    public PlSqlToken getSchemaToken() {
        PlSqlToken tk = this.getNameToken();
        PlSqlToken ret = null;
        while (tk != null && tk.getPrevCodeToken() != null && ((PlSqlToken)tk.getPrevCodeToken()).matches(".")) {
            tk = (PlSqlToken)tk.getPrevCodeToken();
            ret = tk = (PlSqlToken)tk.getPrevCodeToken();
        }
        return ret;
    }

    public PlSqlToken getNameToken() {
        return this.m_pi.getTokenAtOffset(this.m_pi.getNameOffset());
    }

    public int getStartOffsetOfObject() {
        return this.m_pi.getRoot().getStartOffset();
    }

    public int getEndOffsetOfObject() {
        int retval = 0;
        PlSqlFragment root = this.m_pi.getRoot();
        if (root != null) {
            PlSqlFragment[] kids = root.getChildren();
            retval = kids.length > 1 ? kids[0].getEndOffset() : root.getEndOffset();
        }
        return retval;
    }

    public List<Tuple<PlSqlToken, PlSqlToken>> getAlterStatements() {
        ArrayList<Tuple<PlSqlToken, PlSqlToken>> ret = new ArrayList<Tuple<PlSqlToken, PlSqlToken>>();
        PlSqlFragment root = this.m_pi.getRoot();
        if (root != null) {
            PlSqlFragment[] frags = root.getChildren();
            for (int i = 1; i < frags.length; ++i) {
                ret.add((Tuple<PlSqlToken, PlSqlToken>)new Tuple((Object)frags[i].getFirstToken(), (Object)frags[i].getLastToken()));
            }
        }
        return ret;
    }

    public Object getParseNode(int offset) {
        return this.m_pi.getFragmentAtOffset(offset);
    }

    public int getStartOffset(Object parseNode) throws IllegalArgumentException {
        this.checkParseNode(parseNode);
        return parseNode != null ? ((PlSqlFragment)parseNode).getStartOffset() : 0;
    }

    public int getEndOffset(Object parseNode) throws IllegalArgumentException {
        this.checkParseNode(parseNode);
        return parseNode != null ? ((PlSqlFragment)parseNode).getEndOffset() : 0;
    }

    public List<PlSqlParser.Issue> getIssues() throws CancelledException {
        PlSqlSourceObject root = this.getRoot();
        if (root != null) {
            return PlSqlParserHelper.getIssues(root, this.getProvider());
        }
        return Collections.emptyList();
    }

    public List<PlSqlParser.Issue> getIssues(String source) {
        return PlSqlParserHelper.getIssues(this.getSource());
    }

    private PlSqlFragment checkParseNode(Object parseNode) throws IllegalArgumentException {
        if (!(parseNode instanceof PlSqlFragment)) {
            throw new IllegalArgumentException("parse node must be a PlSqlFragment");
        }
        return (PlSqlFragment)parseNode;
    }
}

