/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.plsql;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.GlobalSettings;
import oracle.javatools.db.Index;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SourceObject;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.ddl.DDLGenerator;
import oracle.javatools.db.ddl.DDLOptions;
import oracle.javatools.db.plsql.DBObjectPlSqlFragment;
import oracle.javatools.db.plsql.DefaultSourceOptions;
import oracle.javatools.db.plsql.Package;
import oracle.javatools.db.plsql.PackageBody;
import oracle.javatools.db.plsql.PlSqlBlock;
import oracle.javatools.db.plsql.PlSqlCodeFragment;
import oracle.javatools.db.plsql.PlSqlParameter;
import oracle.javatools.db.plsql.PlSqlReference;
import oracle.javatools.db.plsql.PlSqlSchemaObject;
import oracle.javatools.db.plsql.PlSqlSchemaObjectBody;
import oracle.javatools.db.plsql.PlSqlSchemaObjectSpec;
import oracle.javatools.db.plsql.PlSqlSearch;
import oracle.javatools.db.plsql.PlSqlSourceObject;
import oracle.javatools.db.plsql.PlSqlStatement;
import oracle.javatools.db.plsql.PlSqlSubProgram;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.PlSqlTokenizer;
import oracle.javatools.db.plsql.PlSqlUtilCore;
import oracle.javatools.db.plsql.Procedure;
import oracle.javatools.db.plsql.Trigger;
import oracle.javatools.db.plsql.Type;
import oracle.javatools.db.plsql.TypeBody;
import oracle.javatools.db.plsql.parser.AbstractPlSqlBuilder;
import oracle.javatools.db.plsql.parser.PlSqlParser;
import oracle.javatools.db.plsql.parser.PlSqlReferenceResolver;
import oracle.javatools.db.property.DerivedPropertyBuilder;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.token.Token;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.Tuple;

public final class PlSqlUtil
extends PlSqlUtilCore {
    public static final String TYPE_NAME_SEARCH = "[create [or replace]] <type {package [body]|type [body]|?}> <name ?.>";
    public static final String FUNCTION_SEARCH = "[create [or replace]] FUNCTION <signature {^{RETURN|AS|IS|;}}... [RETURN <datatype ?%>]>";
    public static final String TYPECODE_SEARCH = "[create [or replace]] TYPE ?. [OID ?] [AUTHID ?] <isAsUnder {IS|AS|UNDER}> <type [{OPAQUE|OBJECT|TABLE OF|VARRAY|VARYING ARRAY}]>";
    public static final String SUBPROGRAM_SEARCH = "{PROCEDURE <pname ?> <pparams [(...)]>|FUNCTION <fname ?> <fparams [(...)]> RETURN <datatype ?%>}";
    public static final String METHOD_SEARCH = "[ { NOT FINAL | <final FINAL> |     NOT OVERRIDING | <over OVERRIDING> |     <notInst  NOT INSTANTIABLE> | INSTANTIABLE }...] <methodType {MEMBER|STATIC|CONSTRUCTOR|MAP MEMBER|ORDER MEMBER}> { PROCEDURE <pname ?> <pparams [(...)]> |   FUNCTION <fname ?> <fparams [(...)]> RETURN <datatype {SELF AS RESULT|?%}> } [EXTERNAL {NAME <extname ?> | VARIABLE NAME <extvarname ?> } ][{DETERMINISTIC|PIPELINED|RESULT_CACHE}...][ {IS|AS} LANGUAGE     { JAVA NAME <javaname ?>     | C [NAME <cname ?>] LIBRARY <clibname ?.>       [AGENT IN ({^)}...) ]       [WITH <ccontext CONTEXT>]       [PARAMETERS ({^)}...) ]     } ]";
    public static final String PARAMETER_SEARCH = "<param ?> [<mode {IN OUT|OUT|IN}>] [<nocopy NOCOPY>] <datatype ?%> [{DEFAULT|:=} <default ?.[(...)]>]";
    public static final String DATATYPE_SEARCH = "<type {TYPE|SUBTYPE}> <name ?> IS <structure ?>";
    public static final String VARIABLE_SEARCH = "<var ?> [CONSTANT] <datatype ?%>";
    public static final String INTO_SEARCH = "select {^{into|from}}... into <intoClause {^from}...>";
    public static final String ALTER_TYPE_SEARCH = "alter type ?. <action {ADD|DROP|MODIFY}> <what ?>";
    private static final String SP = " ";
    private static final String SP2 = "  ";
    private static final String SP4 = "    ";
    private static final String NEWLINE = "\n";
    private static final String SEMICOLON = ";";
    private static final String AS = "AS";
    private static final String IS = "IS";
    private static final String BEGIN = "BEGIN";
    private static final String CREATE_OR_REPLACE = "CREATE OR REPLACE";
    private static final String BODY = "BODY";
    private static final String END = "END";
    private static final String NULL = "NULL";
    private static final String RETURN = "RETURN";
    private static final String SELECT = "SELECT * FROM DUAL;";

    private PlSqlUtil() {
    }

    protected PlSqlSubProgram findPlSqlSubProgramImpl(String callSignature, PlSqlBlock block) {
        String[] bits;
        ArrayList<String> names = new ArrayList<String>();
        for (String bit : bits = callSignature.replace("(", ".(").split("\\.")) {
            names.add(bit);
        }
        return PlSqlUtil.findPlSqlSubProgram(names, block);
    }

    protected List<DBObject> getPlSqlFragmentReferersImpl(PlSqlSourceObject so, DBObjectID to, DBObjectProvider pro) throws CancelledException {
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        if (to != null) {
            PlSqlParser parser;
            String name = DBUtil.getDBObjectName((DBObjectID)to);
            String type = to.getType();
            Class clz = Metadata.getInstance().getObjectClass(type);
            boolean ok = SchemaObject.class.isAssignableFrom(clz) && Index.class != clz || DBObjectPlSqlFragment.class.isAssignableFrom(clz) || Column.class == clz;
            if (name != null && ok && so.getSource() != null && (parser = PlSqlUtil.findOrCreateParser((PlSqlSourceObject)so, (DBObjectProvider)pro)) != null) {
                String search = name.contains("(") ? name.substring(0, name.indexOf("(")) : name;
                List offsets = parser.getLocationOffsets(search);
                for (Integer pos : offsets) {
                    DBObjectPlSqlFragment f = so.getReferenceAtOffset(pos.intValue());
                    if (f == null) continue;
                    PlSqlUtil.addRefs((DBObject)f, to, list);
                }
            }
        }
        return list;
    }

    protected String getTypeFromSourceImpl(String source) {
        return PlSqlUtil.getTypeAndNameFromSource(source, null).getType();
    }

    protected String getNameFromSourceImpl(String source) {
        return PlSqlUtil.getTypeAndNameFromSource(source, null).getName();
    }

    public static void registerPlSqlUtil() {
        PlSqlUtil utils = new PlSqlUtil();
        PlSqlUtil.setInstance((PlSqlUtilCore)utils);
    }

    public static PlSqlSubProgram findPlSqlSubProgram(List<String> names, PlSqlBlock block) {
        String name;
        if (names.size() > 2 || names.size() == 2 && !names.get(1).startsWith("(")) {
            return null;
        }
        ArrayList<PlSqlSubProgram> candidates = new ArrayList<PlSqlSubProgram>();
        ArrayList<String> args = new ArrayList<String>();
        if (names.get(names.size() - 1).startsWith("(")) {
            name = names.get(names.size() - 2);
            StringTokenizer tok = new StringTokenizer(names.get(names.size() - 1), "(),", false);
            while (tok.hasMoreTokens()) {
                args.add(tok.nextToken());
            }
        } else {
            name = names.get(names.size() - 1);
        }
        PlSqlSubProgram firstMatchByName = null;
        for (PlSqlSubProgram prog : block.getSubPrograms()) {
            String progName;
            String pname = prog.getName();
            String string = progName = pname == null ? null : prog.getName().split("[\\( ]")[0];
            if (!name.equals(progName)) continue;
            if (firstMatchByName == null) {
                firstMatchByName = prog;
            }
            if (args.size() > prog.getParameters().length) continue;
            boolean unmatchedArg = false;
            for (String arg : args) {
                PlSqlParameter p;
                if ("?".equals(arg) || (p = prog.getParameter(arg)) != null) continue;
                unmatchedArg = true;
                break;
            }
            if (unmatchedArg) continue;
            candidates.add(prog);
        }
        if (candidates.size() == 0) {
            return firstMatchByName;
        }
        for (int i = candidates.size() - 1; i >= 0; --i) {
            ArrayList<PlSqlParameter> params = new ArrayList<PlSqlParameter>();
            boolean delete = false;
            for (PlSqlParameter param : ((PlSqlSubProgram)candidates.get(i)).getParameters()) {
                params.add(param);
            }
            boolean nameRequired = false;
            for (int j = 0; j < args.size(); ++j) {
                if (nameRequired && "?".equals(args.get(j))) {
                    delete = true;
                    break;
                }
                if ("?".equals(args.get(j))) {
                    params.set(j, null);
                    continue;
                }
                for (int k = 0; k < params.size(); ++k) {
                    if (params.get(k) == null || !((String)args.get(j)).equals(((PlSqlParameter)params.get(k)).getName())) continue;
                    params.set(k, null);
                    break;
                }
                nameRequired = true;
            }
            for (int k = 0; k < params.size(); ++k) {
                if (params.get(k) == null || ((PlSqlParameter)params.get(k)).getMode() != PlSqlParameter.Mode.OUT && ((PlSqlParameter)params.get(k)).getMode() != PlSqlParameter.Mode.INOUT && ((PlSqlParameter)params.get(k)).getDefaultValue() != null) continue;
                delete = true;
                break;
            }
            if (!delete) continue;
            candidates.remove(i);
        }
        if (candidates.size() < 2) {
            return candidates.size() == 0 ? firstMatchByName : (PlSqlSubProgram)candidates.get(0);
        }
        return (PlSqlSubProgram)candidates.get(0);
    }

    private static void addRefs(DBObject obj, DBObjectID to, List<DBObject> list) {
        DBObjectID[] ids = obj instanceof PlSqlReference ? ((PlSqlReference)obj).getReferences() : obj.getReferenceIDs();
        for (DBObjectID dBObjectID : ids) {
            if (!DBUtil.isSameOrChildOf((DBObjectID)dBObjectID, (DBObjectID)to, (boolean)false)) continue;
            list.add(obj);
            break;
        }
        for (DBObjectID dBObjectID : obj.getOwnedObjects()) {
            PlSqlUtil.addRefs((DBObject)dBObjectID, to, list);
        }
    }

    @Deprecated
    public static boolean updateSoureForPropertyChange(PlSqlSourceObject so, DBObjectProvider pro, DBObject referencedObject, String propName, Object newValue) {
        try {
            return PlSqlUtil.updateSourceForRefactor(so, pro, referencedObject, propName, referencedObject.getProperty(propName), newValue);
        }
        catch (CancelledException e) {
            DBLog.getLogger(PlSqlUtil.class).info(e.getMessage());
            return false;
        }
    }

    private static String getName(String propName, Object value) {
        String name;
        if ("schema".equals(propName)) {
            name = ((Schema)value).getName();
        } else if (((String)value).contains("(")) {
            String justname = (String)value;
            name = justname = justname.substring(0, justname.indexOf("("));
        } else {
            name = (String)value;
        }
        return name;
    }

    public static boolean updateSourceForRefactor(PlSqlSourceObject pso, DBObjectProvider pro, DBObject dbo, String propName, Object oldValue, Object newValue) throws CancelledException {
        boolean retval = false;
        if (pso != null && ModelUtil.hasLength((String)pso.getSource())) {
            String nameInSource;
            if ("name".equals(propName) && dbo == pso && ModelUtil.areDifferent((Object)oldValue, (Object)(nameInSource = PlSqlUtil.getNameFromSource((String)pso.getSource())))) {
                return false;
            }
            if ("name".equals(propName) || "schema".equals(propName)) {
                DBObjectID origID = dbo.getID();
                String newName = PlSqlUtil.getName(propName, newValue);
                PlSqlParser parser = PlSqlUtil.findOrCreateParser((PlSqlSourceObject)pso, (DBObjectProvider)pro);
                if (parser != null) {
                    String oldName = PlSqlUtil.getName(propName, oldValue);
                    List list = parser.getLocationOffsets(oldName);
                    PlSqlToken nameTk = parser.getNameToken();
                    if (pso == dbo && nameTk != null && !nameTk.matches(oldName)) {
                        list.add(nameTk.getStart());
                    }
                    Object[] sorted = list.toArray(new Integer[list.size()]);
                    Arrays.sort(sorted);
                    ArrayList<PlSqlReference> refs = new ArrayList<PlSqlReference>();
                    for (Object i : sorted) {
                        DBObjectPlSqlFragment f = pso.getReferenceAtOffset(((Integer)i).intValue());
                        if (f instanceof PlSqlReference) {
                            refs.add((PlSqlReference)f);
                            continue;
                        }
                        if (f == null || !origID.equals(f.getID(), false)) continue;
                        PlSqlReference selfRef = new PlSqlReference();
                        DBObjectID[] references = new DBObjectID[]{f.getID()};
                        selfRef.setReferences(references);
                        if (dbo instanceof PlSqlSubProgram) {
                            PlSqlToken tk = parser.getTokenAtOffset(f.getStartOffset().intValue());
                            tk = (PlSqlToken)tk.getNextCodeToken();
                            selfRef.setStartOffset(Integer.valueOf(tk.getStart()));
                            selfRef.setEndOffset(Integer.valueOf(tk.getEnd()));
                        } else {
                            selfRef.setStartOffset(f.getStartOffset());
                            selfRef.setEndOffset(f.getEndOffset());
                        }
                        refs.add(selfRef);
                    }
                    StringBuilder sb = new StringBuilder();
                    String source = pso.getSource();
                    int lastOffset = source.length();
                    block3: for (int i = refs.size() - 1; i >= 0; --i) {
                        PlSqlReference ref = (PlSqlReference)refs.get(i);
                        DBObjectID[] dBObjectIDArray = ref.getReferences();
                        int n = dBObjectIDArray.length;
                        for (int j = 0; j < n; ++j) {
                            DBObjectID id;
                            DBObjectID refID = id = dBObjectIDArray[j];
                            PlSqlToken startTk = parser.getTokenAtOffset(ref.getStartOffset().intValue());
                            PlSqlToken endTk = parser.getTokenAtOffset(ref.getEndOffset().intValue());
                            PlSqlToken tk = startTk;
                            if (ref.getReferenceType() == PlSqlReference.ReferenceType.PCT_TYPE || ref.getReferenceType() == PlSqlReference.ReferenceType.PCT_ROWTYPE) {
                                endTk = (PlSqlToken)((PlSqlToken)endTk.getPrevToken()).getPrevToken();
                            } else if (origID.equals(refID, false) && dbo instanceof PlSqlParameter) {
                                endTk = startTk;
                            }
                            while (refID != null) {
                                String refName;
                                boolean selfRef = false;
                                if (refID instanceof TemporaryObjectID) {
                                    DBObject x = null;
                                    try {
                                        x = refID.resolveID();
                                        if (x == dbo) {
                                            selfRef = true;
                                        }
                                    }
                                    catch (DBException dBException) {}
                                } else if (dbo == pso && "UNSPECIFIED_TYPE".equals(refID.getType()) && ModelUtil.areEqual((Object)pso.getName(), (Object)newName) && refID instanceof ReferenceID && (refName = ((ReferenceID)refID).getName()) != null) {
                                    int pos = refName.indexOf("(");
                                    if (pos > 0) {
                                        refName = refName.substring(0, pos);
                                    }
                                    boolean bl = selfRef = refName.equals(newName) || refName.equals(oldName);
                                }
                                if (selfRef || origID.equals(refID, false)) {
                                    tk = endTk;
                                    break;
                                }
                                if ((refID = refID.getParent()) == null) continue;
                                if (endTk.getEnd() != startTk.getEnd() && ((PlSqlToken)endTk.getPrevToken()).matches(".")) {
                                    endTk = (PlSqlToken)((PlSqlToken)endTk.getPrevToken()).getPrevToken();
                                    continue;
                                }
                                refID = null;
                            }
                            if (refID == null) continue;
                            retval = true;
                            sb.insert(0, source.substring(tk.getEnd() + 1, lastOffset));
                            lastOffset = tk.getStart();
                            if ("schema".equals(propName)) {
                                sb.insert(0, tk.getSource());
                                if (!((PlSqlToken)tk.getPrevCodeToken()).matches(".")) {
                                    sb.insert(0, ".");
                                } else {
                                    tk = (PlSqlToken)((PlSqlToken)tk.getPrevCodeToken()).getPrevCodeToken();
                                    lastOffset = tk.getStart();
                                    if (pso.getSchema().getName().equals(newName)) continue;
                                    sb.insert(0, ".");
                                }
                            }
                            String newExtName = pro.getExternalName(newName);
                            String oldText = tk.getSource();
                            String newText = !newName.equals(newExtName) ? newExtName : (tk.getType() == Token.Type.DOUBLE_QUOTED_STRING && !pro.getExternalName(pro.getInternalName(oldText)).equals(oldText) ? "\"" + newName + "\"" : (oldText.toLowerCase().equals(oldText) ? newName.toLowerCase() : newName));
                            sb.insert(0, newText);
                            continue block3;
                        }
                    }
                    if (retval) {
                        sb.insert(0, source.substring(0, lastOffset));
                        pso.setSource(sb.toString());
                    }
                }
            }
        }
        return retval;
    }

    public static boolean isBodyOf(DBObject spec, DBObject body) {
        DBObjectID bodySpecID;
        boolean retval = false;
        if (spec instanceof PlSqlSchemaObjectSpec && body instanceof PlSqlSchemaObjectBody && (bodySpecID = ((PlSqlSchemaObjectBody)body).getSpecID()) != null) {
            retval = bodySpecID.equals(spec.getID(), false);
        }
        return retval;
    }

    public static void rebuildSource(DBObjectProvider pro, PlSqlSourceObject pso) throws CancelledException {
        PlSqlParser parserOrig;
        if ((pso instanceof Procedure || pso instanceof Trigger) && (parserOrig = PlSqlUtil.findOrCreateParser((PlSqlSourceObject)pso, (DBObjectProvider)pro)) != null) {
            PlSqlToken tk = parserOrig.getTypeToken();
            while (tk.getType() != Token.Type.ALPHANUMERIC && tk.getType() != Token.Type.END_MARKER) {
                tk = (PlSqlToken)tk.getNextToken();
            }
            boolean lower = false;
            if (tk.getType() == Token.Type.ALPHANUMERIC) {
                String tkStr = tk.getSource();
                lower = tkStr.equals(tkStr.toLowerCase());
            }
            PlSqlSourceObject copy = null;
            try {
                copy = (PlSqlSourceObject)pso.getClass().newInstance();
                copy = (PlSqlSourceObject)pso.copyTo((Object)copy);
                copy.setSource(null);
            }
            catch (IllegalAccessException e) {
                DBLog.getLogger(PlSqlUtil.class).warning("Failed to create copy: " + e.getMessage());
            }
            catch (InstantiationException e) {
                DBLog.getLogger(PlSqlUtil.class).warning("Failed to create copy: " + e.getMessage());
            }
            StringBuilder sb = new StringBuilder(PlSqlUtil.getDefaultSource(pro, copy, lower));
            PlSqlToken tk2 = (PlSqlToken)tk.getTokenAt(0);
            if (!tk2.isCode()) {
                PlSqlToken tk3 = (PlSqlToken)((PlSqlToken)tk2.getNextCodeToken()).getPrevToken();
                sb.insert(0, tk2.getSource(false, (Token)tk3));
            }
            if (pso instanceof Procedure) {
                copy.setSource(sb.toString());
                PlSqlParser parserUpd = PlSqlUtil.findOrCreateParser((PlSqlSourceObject)copy, (DBObjectProvider)pro);
                if (parserUpd != null) {
                    Tuple<PlSqlToken, PlSqlToken> origLimits = PlSqlUtil.getParameterLimits(parserOrig.getTypeToken());
                    Tuple<PlSqlToken, PlSqlToken> updLimits = PlSqlUtil.getParameterLimits(parserUpd.getTypeToken());
                    PlSqlToken origFirst = (PlSqlToken)origLimits.getFirst();
                    PlSqlToken origLast = (PlSqlToken)origLimits.getSecond();
                    PlSqlToken updFirst = (PlSqlToken)updLimits.getFirst();
                    PlSqlToken updLast = (PlSqlToken)updLimits.getSecond();
                    if (origFirst != null && origLast != null && updFirst != null && updLast != null) {
                        sb = new StringBuilder();
                        sb.append(pso.getSource().substring(0, origFirst.getStart()));
                        sb.append(copy.getSource().substring(updFirst.getStart(), updLast.getStart()));
                        sb.append(pso.getSource().substring(origLast.getStart()));
                    }
                }
            }
            pso.setSource(sb.toString());
        }
    }

    public static String getDefaultSource(DBObjectProvider pro, PlSqlSourceObject obj) {
        boolean lower = false;
        GlobalSettings settings = GlobalSettings.getInstance();
        if (settings != null) {
            lower = settings.isNewPlSqlLowerCase();
        }
        return PlSqlUtil.getDefaultSource(pro, obj, lower);
    }

    @Deprecated
    public static String getDefaultSource(DBObjectProvider pro, PlSqlSourceObject obj, DDLGenerator gen) {
        return PlSqlUtil.getDefaultSource(pro, obj);
    }

    private static String getDefaultSource(DBObjectProvider pro, PlSqlSourceObject obj, boolean lower) {
        DatabaseDescriptor desc = pro.getDescriptor();
        DefaultSourceOptions srcOpts = desc.getDefaultSourceOptions();
        boolean disableTrigger = false;
        if (obj instanceof Trigger) {
            Trigger trig = (Trigger)obj;
            if ("".equals(trig.getWhenClause())) {
                trig.setWhenClause(null);
            }
            if (!trig.isEnabled() && srcOpts.isEnableTriggers()) {
                disableTrigger = true;
                trig.setEnabled(true);
            }
        }
        DDLOptions options = new DDLOptions(srcOpts.isUseCreateOrReplace(), false);
        DDLGenerator gen = pro.getDDLGenerator();
        String source = gen.getCreateDDL(options, new DBObject[]{obj}).toString(srcOpts.isIncludeTerminators());
        if (lower) {
            StringBuilder sb = new StringBuilder();
            PlSqlToken tk = PlSqlTokenizer.tokenize((String)source, (String[])new String[0]);
            while (tk.getType() != Token.Type.END_MARKER) {
                tk = (PlSqlToken)tk.getPrevToken();
            }
            tk = (PlSqlToken)tk.getNextToken();
            while (tk.getType() != Token.Type.END_MARKER) {
                if (tk.isCode() && !tk.getSource().startsWith("\"")) {
                    sb.append(tk.getSource().toLowerCase());
                } else {
                    sb.append(tk.getSource());
                }
                tk = (PlSqlToken)tk.getNextToken();
            }
            source = sb.toString();
        }
        if (disableTrigger) {
            ((Trigger)obj).setEnabled(false);
        }
        return source;
    }

    @Deprecated
    public static void setSource(PlSqlSourceObject sourceObject, String source, boolean clearDerived) {
    }

    @Deprecated
    public static void clearDerivedProperties(SourceObject sourceObject) {
    }

    @Deprecated
    public static boolean isDerivedPropsBuilt(DBObjectPlSqlFragment frag) {
        return false;
    }

    private static Tuple<PlSqlToken, PlSqlToken> getParameterLimits(PlSqlToken startTk) {
        PlSqlToken first = null;
        PlSqlToken last = null;
        PlSqlSearch head = new PlSqlSearch("{procedure|function} ?.");
        PlSqlSearch tail = new PlSqlSearch("[return ?%] {is|as}");
        PlSqlToken tk = startTk;
        if (head.isWithin(tk)) {
            tk = head.getEndToken();
            first = tk = (PlSqlToken)tk.getNextToken();
            if ((tk = (PlSqlToken)tk.getNextCodeToken()).matches("(")) {
                int parens = 1;
                tk = (PlSqlToken)tk.getNextCodeToken();
                while (parens > 0 && tk.getType() != Token.Type.END_MARKER) {
                    if (tk.matches("(")) {
                        ++parens;
                    } else if (tk.matches(")")) {
                        --parens;
                    }
                    tk = (PlSqlToken)tk.getNextToken();
                }
            }
            if (tail.isWithin(tk)) {
                tk = tail.getEndToken();
                last = tk = (PlSqlToken)tk.getPrevToken();
            }
        }
        return new Tuple(first, last);
    }

    public static TypeAndNameInfo getTypeAndNameFromSource(PlSqlSourceObject so, DatabaseDescriptor dd) {
        return PlSqlUtil.getTypeAndNameFromSource(so == null ? null : so.getSource(), dd);
    }

    public static TypeAndNameInfo getTypeAndNameFromSource(String source, DatabaseDescriptor dd) {
        PlSqlToken tk;
        TypeAndNameInfo res = new TypeAndNameInfo();
        PlSqlSearch search = new PlSqlSearch(TYPE_NAME_SEARCH);
        if (source != null && search.matches(tk = PlSqlTokenizer.tokenize((Reader)new StringReader(source), (Integer)10))) {
            res.m_type = search.getNamedMatch("type", true);
            res.m_typeStart = search.getNamedMatchStartToken("type").getStart();
            res.m_typeEnd = search.getNamedMatchEndToken("type").getEnd();
            if (dd == null) {
                res.m_name = search.getNamedMatchEndToken("name").getSource(true);
            } else {
                res.m_name = dd.getInternalName(search.getNamedMatchEndToken("name").getSource(), res.m_type);
            }
            res.m_nameStart = search.getNamedMatchStartToken("name").getStart();
            res.m_nameEnd = search.getNamedMatchEndToken("name").getEnd();
        }
        return res;
    }

    @Deprecated
    public static boolean containsUnResolvedReferences(PlSqlSourceObject obj, DBObjectProvider pro) {
        return false;
    }

    public static String getDefaultBodyForSpec(PlSqlSourceObject obj, String externalName, DBObjectProvider pro) throws CancelledException {
        PlSqlParser parser;
        StringBuilder body = new StringBuilder();
        if (obj != null && (parser = PlSqlUtil.findOrCreateParser((PlSqlSourceObject)obj, (DBObjectProvider)pro)) != null) {
            body.append(PlSqlUtil.getDefaultBodyHeaderForSpec(obj, externalName));
            PlSqlSearch nonInstantiable = new PlSqlSearch("not instantiable");
            IdentityHashMap map = new IdentityHashMap();
            for (PlSqlSubProgram subFrag : obj.getSubPrograms()) {
                if (!parser.getTokenAtOffset(subFrag.getStartOffset().intValue()).matches("cursor")) continue;
                body.append(PlSqlUtil.getDefaultImplementation(obj, subFrag, pro));
                map.put(subFrag, null);
            }
            for (PlSqlSubProgram subFrag : obj.getSubPrograms()) {
                if (map.containsKey(subFrag) || nonInstantiable.isWithin(parser.getTokenAtOffset(subFrag.getStartOffset().intValue()), parser.getTokenAtOffset(subFrag.getEndOffset().intValue()))) continue;
                body.append(PlSqlUtil.getDefaultImplementation(obj, subFrag, pro));
            }
            body.append(PlSqlUtil.getDefaultBodyFooterForSpec(obj, externalName));
        }
        return body.toString();
    }

    private static String getDefaultBodyHeaderForSpec(PlSqlSourceObject obj, String externalName) {
        StringBuilder body = new StringBuilder();
        if (obj != null) {
            body.append(CREATE_OR_REPLACE).append(NEWLINE);
            body.append(obj.getType()).append(SP).append(BODY).append(SP).append(externalName).append(SP).append(AS).append(NEWLINE).append(NEWLINE);
        }
        return PlSqlUtil.toLowerIfNeeded(body.toString());
    }

    private static String getDefaultBodyFooterForSpec(PlSqlSourceObject obj, String externalName) {
        StringBuilder body = new StringBuilder();
        if (obj != null) {
            body.append(END);
            if (!(obj instanceof Type)) {
                body.append(SP).append(externalName);
            }
            body.append(SEMICOLON);
        }
        return PlSqlUtil.toLowerIfNeeded(body.toString());
    }

    public static String getDefaultImplementation(PlSqlSourceObject obj, PlSqlSubProgram frag, DBObjectProvider pro) throws CancelledException {
        StringBuilder sb = new StringBuilder();
        PlSqlParser parser = PlSqlUtil.findOrCreateParser((PlSqlSourceObject)obj, (DBObjectProvider)pro);
        if (parser != null) {
            PlSqlToken fragStartTk;
            PlSqlToken tok = fragStartTk = parser.getTokenAtOffset(frag.getStartOffset().intValue());
            while (!(tok.matches("FUNCTION") || tok.matches("PROCEDURE") || tok.matches("CURSOR"))) {
                tok = (PlSqlToken)tok.getNextCodeToken();
            }
            String type = tok.getSource();
            tok = (PlSqlToken)tok.getNextCodeToken();
            String name = tok.getSource();
            if ("CURSOR".equalsIgnoreCase(type)) {
                sb.append(SP2);
                PlSqlToken end = parser.getTokenAtOffset(frag.getEndOffset().intValue());
                if (end.matches(SEMICOLON)) {
                    end = (PlSqlToken)end.getPrevCodeToken();
                    sb.append(fragStartTk.getSource(false, (Token)end)).append(SP).append(IS);
                    sb.append(NEWLINE).append(SP4).append(APIBundle.format((String)"NEW_SOURCE_TODO_IMPLEMENTATION_REQD", (Object[])new Object[]{type, obj.getName(), name}));
                    sb.append(NEWLINE).append(SP4).append(SELECT);
                }
                sb.append(NEWLINE).append(NEWLINE);
            } else {
                String fd = obj.getSource().substring(frag.getStartOffset(), frag.getEndOffset() + 1);
                int pos = fd.length();
                if (pos > 0) {
                    int pos2;
                    if (obj.getType().equals("PACKAGE") && (pos2 = fd.lastIndexOf(SEMICOLON)) > 0) {
                        pos = pos2;
                    }
                    sb.append(SP2);
                    sb.append(fd.substring(0, pos)).append(SP).append(AS);
                    sb.append(NEWLINE).append(SP2).append(BEGIN);
                    sb.append(NEWLINE).append(SP4).append(APIBundle.format((String)"NEW_SOURCE_TODO_IMPLEMENTATION_REQD", (Object[])new Object[]{type, obj.getName(), name}));
                    sb.append(NEWLINE).append(SP4);
                    if (frag.getReturnTypeReference() != null) {
                        sb.append(RETURN).append(SP);
                    }
                    sb.append(NULL).append(SEMICOLON);
                    sb.append(NEWLINE).append(SP2).append(END).append(SP).append(name).append(SEMICOLON);
                    sb.append(NEWLINE).append(NEWLINE);
                }
            }
        }
        return PlSqlUtil.toLowerIfNeeded(sb.toString());
    }

    public static String toLowerIfNeeded(String source) {
        boolean lowercasePlSql;
        GlobalSettings settings = GlobalSettings.getInstance();
        boolean bl = lowercasePlSql = settings != null && settings.isNewPlSqlLowerCase();
        if (source != null && lowercasePlSql) {
            StringBuilder sb = new StringBuilder();
            PlSqlToken tk = PlSqlTokenizer.tokenize((String)source, (String[])new String[0]);
            while (!tk.isEndMarker()) {
                tk = (PlSqlToken)tk.getPrevToken();
            }
            tk = (PlSqlToken)tk.getNextToken();
            while (tk.getType() != Token.Type.END_MARKER) {
                if (tk.isCode(true) && !tk.getSource().startsWith("\"")) {
                    sb.append(tk.getSource().toLowerCase());
                } else {
                    sb.append(tk.getSource());
                }
                tk = (PlSqlToken)tk.getNextToken();
            }
            source = sb.toString();
        }
        return source;
    }

    public static PlSqlSchemaObject getCompanionObject(PlSqlSchemaObject obj, DBObjectProvider pro) {
        PlSqlSchemaObject otherObject = null;
        try {
            if (obj != null) {
                DBObjectID otherID = null;
                if (obj instanceof PlSqlSchemaObjectSpec && !DBUtil.needsBuilding((DBObject)obj, (String)"bodyID")) {
                    otherID = ((PlSqlSchemaObjectSpec)obj).getBodyID();
                } else if (obj instanceof PlSqlSchemaObjectBody && !DBUtil.needsBuilding((DBObject)obj, (String)"specID")) {
                    otherID = ((PlSqlSchemaObjectBody)obj).getSpecID();
                }
                otherObject = otherID != null ? (PlSqlSchemaObject)otherID.resolveID() : (PlSqlSchemaObject)pro.getObject(PlSqlUtil.getCompanionObjectType(obj), obj.getSchema(), obj.getName());
            }
        }
        catch (DBException dBException) {
            // empty catch block
        }
        return otherObject;
    }

    public static String getCompanionObjectType(PlSqlSchemaObject obj) {
        String otherType = obj instanceof Package ? "PACKAGE BODY" : (obj instanceof Type ? "TYPE BODY" : (obj instanceof PackageBody ? "PACKAGE" : (obj instanceof TypeBody ? "TYPE" : null)));
        return otherType;
    }

    public static List<Tuple<PlSqlSubProgram, PlSqlSubProgram>> getTopLevelPlSqlFragments(DBObjectProvider pro, PlSqlSchemaObject obj, PlSqlSchemaObject otherObject) throws CancelledException {
        if (obj == null) {
            throw new IllegalArgumentException("obj is null");
        }
        ArrayList<Tuple<PlSqlSubProgram, PlSqlSubProgram>> ret = new ArrayList<Tuple<PlSqlSubProgram, PlSqlSubProgram>>();
        HashMap<String, PlSqlSubProgram> otherTopLevelObjects = new HashMap<String, PlSqlSubProgram>();
        PlSqlParser objParser = PlSqlUtil.findOrCreateParser((PlSqlSourceObject)obj, (DBObjectProvider)pro);
        if (objParser == null || objParser.isWrapped()) {
            return ret;
        }
        if (otherObject != null) {
            PlSqlParser otherParser = PlSqlUtil.findOrCreateParser((PlSqlSourceObject)otherObject, (DBObjectProvider)pro);
            if (otherParser == null || otherParser.isWrapped()) {
                return ret;
            }
            PlSqlSubProgram[] plSqlSubProgramArray = otherObject.getSubPrograms();
            int n = plSqlSubProgramArray.length;
            for (int i = 0; i < n; ++i) {
                String sig;
                PlSqlSubProgram sub = plSqlSubProgramArray[i];
                CancelledException.checkInterrupt();
                PlSqlStatement.Type type = sub.getStatementType();
                if (otherObject instanceof PlSqlSchemaObjectBody && (type == PlSqlStatement.Type.FUNCTION_FD || type == PlSqlStatement.Type.PROCEDURE_FD) || (sig = sub.getSignature(false)) == null) continue;
                otherTopLevelObjects.put(sig, sub);
            }
        }
        for (PlSqlSubProgram sub : obj.getSubPrograms()) {
            String sig;
            PlSqlStatement.Type type = sub.getStatementType();
            if (obj instanceof PlSqlSchemaObjectBody && (type == PlSqlStatement.Type.FUNCTION_FD || type == PlSqlStatement.Type.PROCEDURE_FD) || (sig = sub.getSignature(false)) == null) continue;
            ret.add((Tuple<PlSqlSubProgram, PlSqlSubProgram>)new Tuple((Object)sub, otherTopLevelObjects.get(sig)));
        }
        return ret;
    }

    public static List<DBObjectID> findReferences(List<String> nameList, DBObjectProvider pro, DBObject context) {
        return PlSqlReferenceResolver.findReferences(nameList, pro, context);
    }

    protected PlSqlParser findOrCreateParserImpl(PlSqlSourceObject pso, DBObjectProvider pro) throws CancelledException {
        PlSqlParser ret = null;
        if (pso instanceof DBObjectPlSqlFragment && pro != null) {
            DBObjectPlSqlFragment dbof = (DBObjectPlSqlFragment)pso;
            DerivedPropertyBuilder dpb = pro.getObjectFactory().ensureDerivedPropertyBuilder((DBObject)dbof, false);
            if (dpb instanceof AbstractPlSqlBuilder) {
                ret = ((AbstractPlSqlBuilder)dpb).getParser((PlSqlCodeFragment)pso);
            } else {
                DBLog.getLogger((Object)((Object)this)).log(Level.SEVERE, "Unexpected derived property builder");
            }
        }
        return ret;
    }

    public static class TypeAndNameInfo {
        private String m_type;
        private int m_typeStart;
        private int m_typeEnd;
        private String m_name;
        private int m_nameStart;
        private int m_nameEnd;

        public String getType() {
            return this.m_type;
        }

        public int getTypeStart() {
            return this.m_typeStart;
        }

        public int getTypeEnd() {
            return this.m_typeEnd;
        }

        public String getName() {
            return this.m_name;
        }

        public int getNameStart() {
            return this.m_nameStart;
        }

        public int getNameEnd() {
            return this.m_nameEnd;
        }
    }
}

