/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.validators;

import java.util.Arrays;
import java.util.Collection;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.validators.ConstraintValidator;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.ValidationException;

public class OracleConstraintValidator
extends ConstraintValidator {
    private static final Collection<String> INVALID_CONSTRAINT_DATATYPES = Arrays.asList("BFILE", "BLOB", "CLOB", "LONG", "LONG RAW", "NCLOB", "LOB", "VARRAY", "NESTED TABLE", "OBJECT", "REF");

    public OracleConstraintValidator(DBObjectProvider prov) {
        super(prov);
    }

    @Override
    protected boolean isValidConstraintDatatype(String dataTypeName, DataTypeUsage dataTypeUsage) {
        String timeZoneValue;
        boolean isValidType;
        boolean bl = isValidType = !INVALID_CONSTRAINT_DATATYPES.contains(dataTypeName) && !"TYPE".equals(dataTypeUsage.getDataTypeID().getType());
        if (dataTypeUsage != null && dataTypeName.equals("TIMESTAMP") && (timeZoneValue = (String)dataTypeUsage.getAttributeValue("time_zone")) != null && timeZoneValue.equals("TIME ZONE")) {
            isValidType = false;
        }
        return isValidType;
    }

    @Override
    protected void handleMissingConstraintIndex(Constraint con, DBObjectID indexID) throws ValidationException {
        if (!con.getName().startsWith("SYS_")) {
            super.handleMissingConstraintIndex(con, indexID);
        }
    }

    @Override
    public DBObjectValidator.NamespaceType getNamespaceType() {
        return DBObjectValidator.NamespaceType.TYPE;
    }
}

