/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.validators;

import java.util.Collection;
import java.util.logging.Level;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Table;
import oracle.javatools.db.ora.OracleIndexOrganizedTableProperties;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.validators.AbstractChildDBObjectValidator;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.db.validators.ValidationLevel;
import oracle.javatools.util.ModelUtil;

public class IOTPropertiesValidator
extends AbstractChildDBObjectValidator<OracleIndexOrganizedTableProperties> {
    public IOTPropertiesValidator(DBObjectProvider pro) {
        super(pro);
    }

    protected boolean canHaveEmptyName() {
        return true;
    }

    protected Collection<String> listAlwaysValidProperties() {
        Collection retval = super.listAlwaysValidProperties();
        retval.add("overflowable");
        retval.add("mapped");
        return retval;
    }

    @DBObjectValidator.PropertyValidator(value={"pctThreshold"}, level=ValidationLevel.FULL)
    public void validatePctThreshold(OracleIndexOrganizedTableProperties original, OracleIndexOrganizedTableProperties props) throws ValidationException {
        Integer pct = props.getPctThreshold();
        if (pct != null && (pct < 1 || pct > 50)) {
            throw new ValidationException((DBObject)props, APIBundle.get((String)"IOT_PROPERTY_ERROR_PCT_THRESHOLD"));
        }
    }

    @DBObjectValidator.PropertyValidator(value={"keyCompression"}, level=ValidationLevel.FULL)
    public void validateKeyCompression(OracleIndexOrganizedTableProperties original, OracleIndexOrganizedTableProperties props) throws ValidationException {
        Integer keyComp = props.getKeyCompression();
        if (keyComp != null) {
            Integer pkColumnCount;
            PKConstraint pk = PKConstraint.getPrimaryKey((Relation)((Table)props.getParent()));
            Integer n = pkColumnCount = pk != null ? new Integer(pk.getColumns().length) : null;
            if (pkColumnCount != null && pkColumnCount == 1) {
                throw new ValidationException((DBObject)props, APIBundle.get((String)"IOT_PROPERTY_ERROR_KEY_COMPRESSION_INVALID_VALUE1"));
            }
            if (keyComp < 0 || pkColumnCount == null || keyComp.compareTo(pkColumnCount) >= 0) {
                throw new ValidationException((DBObject)props, APIBundle.get((String)"IOT_PROPERTY_ERROR_KEY_COMPRESSION_INVALID_VALUE2"));
            }
        }
    }

    @DBObjectValidator.PropertyValidator(value={"includeColumn"}, level=ValidationLevel.FULL)
    public void validateIncludeColumn(OracleIndexOrganizedTableProperties original, OracleIndexOrganizedTableProperties props) throws ValidationException {
        DBObjectID incCol = props.getIncludeColumn();
        if (incCol != null) {
            Column includeColumn = null;
            try {
                includeColumn = incCol != null ? (Column)incCol.resolveID() : null;
            }
            catch (DBException e) {
                this.logException(e, Level.FINE);
            }
            if (includeColumn != null) {
                Constraint[] constraints;
                Table table;
                String includeColumnName = includeColumn.getName();
                includeColumn = null;
                if (ModelUtil.hasLength((String)includeColumnName) && (table = (Table)props.getParent()) != null) {
                    for (Column col : table.getColumns()) {
                        if (!includeColumnName.equals(col.getName())) continue;
                        includeColumn = col;
                        break;
                    }
                }
                if (includeColumn == null) {
                    throw new ValidationException((DBObject)props, APIBundle.get((String)"IOT_PROPERTY_ERROR_INVALID_INCLUDING_COLUMN2"));
                }
                table = (Table)props.getParent();
                Constraint[] constraintArray = constraints = table == null ? null : table.getConstraints();
                if (constraints != null && constraints.length > 0) {
                    for (int con = 0; con < constraints.length; ++con) {
                        if (!constraints[con].getConstraintType().equals("PKConstraint")) continue;
                        PKConstraint pk = (PKConstraint)constraints[con];
                        Column[] pkColumns = pk.getColumns();
                        if (pkColumns.length <= 0 || includeColumn.getName().equals(pkColumns[pkColumns.length - 1].getName())) break;
                        for (int col = 0; col < pkColumns.length - 1; ++col) {
                            if (!includeColumn.getName().equals(pkColumns[col].getName())) continue;
                            throw new ValidationException((DBObject)props, APIBundle.get((String)"IOT_PROPERTY_ERROR_INVALID_INCLUDING_COLUMN2"));
                        }
                        break;
                    }
                }
            }
        }
    }
}

