/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sql;

import java.util.List;
import oracle.dbtools.parser.ParseNode;
import oracle.javatools.db.ora.sql.ExpressionContext;
import oracle.javatools.db.ora.sql.ExpressionFactory;
import oracle.javatools.db.ora.sql.OracleSQLQueryBuilderHelper;
import oracle.javatools.db.sql.ExpressionList;
import oracle.javatools.db.sql.OrderByObject;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.util.ModelUtil;

public class OrderByBuilder
extends ExpressionFactory {
    @Override
    public SQLFragment createFragment(ExpressionContext context, ParseNode node) throws SQLQueryException {
        ExpressionList retval = null;
        OracleSQLQueryBuilderHelper helper = context.getHelper();
        if (helper.isRule(node, "order_by_clause")) {
            ExpressionList orderBy = new ExpressionList();
            boolean siblings = false;
            String siblingsText = null;
            List<ParseNode> kids = helper.getOrderedChildren(node);
            String orderText = helper.getContent(kids.get(0));
            int i = 1;
            if (helper.isKeyword(kids.get(1), "SIBLINGS")) {
                siblings = true;
                siblingsText = helper.getContent(kids.get(1));
                ++i;
            }
            String by = helper.getContent(kids.get(i));
            List<List<ParseNode>> components = helper.getCommaSeparatedList(kids.subList(++i, kids.size()));
            for (List<ParseNode> component : components) {
                OrderByObject orderByObject = new OrderByObject();
                SQLFragment exp = context.createFragment(component.get(0), (SQLFragment)orderByObject, context.getQueryContext());
                orderByObject.setExpression(exp);
                String ascDescText = null;
                String nullsText = null;
                String firstLastText = null;
                for (int ic = 1; ic < component.size(); ++ic) {
                    if (helper.isKeyword(component.get(ic), "ASC")) {
                        ascDescText = helper.getContent(component.get(ic));
                        continue;
                    }
                    if (helper.isKeyword(component.get(ic), "DESC")) {
                        ascDescText = helper.getContent(component.get(ic));
                        continue;
                    }
                    if (helper.isKeyword(component.get(ic), "NULLS")) {
                        nullsText = helper.getContent(component.get(ic));
                        continue;
                    }
                    if (helper.isKeyword(component.get(ic), "FIRST")) {
                        firstLastText = helper.getContent(component.get(ic));
                        continue;
                    }
                    if (!helper.isKeyword(component.get(ic), "LAST")) continue;
                    firstLastText = helper.getContent(component.get(ic));
                }
                if (ModelUtil.hasLength(ascDescText)) {
                    orderByObject.setOrder(ascDescText);
                }
                if (ModelUtil.hasLength(firstLastText)) {
                    orderByObject.setNullOrdering(nullsText + " " + firstLastText);
                }
                orderBy.addArgument((SQLFragment)orderByObject);
            }
            retval = orderBy;
        }
        return retval;
    }
}

