/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sql;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Synonym;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.ViewColumn;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeID;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.ora.sql.ArithmeticOperationBuilder;
import oracle.javatools.db.ora.sql.BuiltInFunctionBuilder;
import oracle.javatools.db.ora.sql.CaseBuilder;
import oracle.javatools.db.ora.sql.ColumnBuilder;
import oracle.javatools.db.ora.sql.CompoundExpressionBuilder;
import oracle.javatools.db.ora.sql.ConditionBuilder;
import oracle.javatools.db.ora.sql.DataMiningFunctionBuilder;
import oracle.javatools.db.ora.sql.ExpressionContext;
import oracle.javatools.db.ora.sql.ExpressionFactory;
import oracle.javatools.db.ora.sql.GroupByExpressionBuilder;
import oracle.javatools.db.ora.sql.Keywords;
import oracle.javatools.db.ora.sql.LiteralBuilder;
import oracle.javatools.db.ora.sql.ModelBuilder;
import oracle.javatools.db.ora.sql.ModelExpressionBuilder;
import oracle.javatools.db.ora.sql.MultiColumnForLoopBuilder;
import oracle.javatools.db.ora.sql.OracleSQLQueryBuilderHelper;
import oracle.javatools.db.ora.sql.OrderByBuilder;
import oracle.javatools.db.ora.sql.ParenthesisBuilder;
import oracle.javatools.db.ora.sql.ParserRules;
import oracle.javatools.db.ora.sql.PartitionByBuilder;
import oracle.javatools.db.ora.sql.QueryBlockBuilder;
import oracle.javatools.db.ora.sql.RelationalPropertiesBuilder;
import oracle.javatools.db.ora.sql.SetOperationBuilder;
import oracle.javatools.db.ora.sql.SingleColumnForLoopBuilder;
import oracle.javatools.db.ora.sql.UnrecognizedFragmentException;
import oracle.javatools.db.ora.sql.UserFunctionBuilder;
import oracle.javatools.db.ora.sql.WhereObjectBuilder;
import oracle.javatools.db.ora.sql.WindowFunctionBuilder;
import oracle.javatools.db.property.DerivedPropertyBuilder;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.sql.AbstractSQLFragment;
import oracle.javatools.db.sql.AbstractSQLQueryBuilder;
import oracle.javatools.db.sql.AbstractSchemaObjectUsage;
import oracle.javatools.db.sql.AliasFragment;
import oracle.javatools.db.sql.BuiltInFunction;
import oracle.javatools.db.sql.ColumnKeywordUsage;
import oracle.javatools.db.sql.ColumnUsage;
import oracle.javatools.db.sql.DBObjectUsage;
import oracle.javatools.db.sql.ExpressionList;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.FromObjectUsage;
import oracle.javatools.db.sql.Function;
import oracle.javatools.db.sql.FunctionUsage;
import oracle.javatools.db.sql.GroupByObject;
import oracle.javatools.db.sql.HierarchicalQueryObject;
import oracle.javatools.db.sql.InvalidAliasException;
import oracle.javatools.db.sql.JoinCondition;
import oracle.javatools.db.sql.JoinObject;
import oracle.javatools.db.sql.ModelObject;
import oracle.javatools.db.sql.OnJoinCondition;
import oracle.javatools.db.sql.OrderByObject;
import oracle.javatools.db.sql.RelationUsage;
import oracle.javatools.db.sql.SQLCallable;
import oracle.javatools.db.sql.SQLDerivedPropertySupport;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLFragmentWithDatatype;
import oracle.javatools.db.sql.SQLParseException;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryCancelledException;
import oracle.javatools.db.sql.SQLQueryClauseException;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.SQLQueryOwner;
import oracle.javatools.db.sql.SelectObject;
import oracle.javatools.db.sql.SetOperator;
import oracle.javatools.db.sql.SimpleSQLFragment;
import oracle.javatools.db.sql.SynonymUsage;
import oracle.javatools.db.sql.UsingJoinCondition;
import oracle.javatools.db.sql.WhereObject;
import oracle.javatools.db.sql.XMLFunctionUsage;
import oracle.javatools.util.Holder;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.Tuple;

public class OracleSQLQueryBuilder
extends AbstractSQLQueryBuilder
implements Keywords,
ParserRules {
    private static final String DUAL = "DUAL";
    private static final String SELECT_ = "SELECT ";
    private static final String ORDER_BY_ = "ORDER BY ";
    private static final Collection<String> s_joinKeywords = Arrays.asList("FULL", "LEFT", "RIGHT", "INNER", "CROSS", "NATURAL", "JOIN", "OUTER");
    private final OracleSQLQueryBuilder m_parentBuilder;
    private final Holder<OracleSQLQueryBuilderHelper> m_helper = new Holder();
    private final List<ExpressionFactory> m_expressionFactories = new ArrayList<ExpressionFactory>();

    public OracleSQLQueryBuilder(DBObjectProvider pro, Schema defaultSchema) {
        this(pro, defaultSchema, null, null);
    }

    private OracleSQLQueryBuilder(DBObjectProvider pro, Schema defaultSchema, OracleSQLQueryBuilderHelper helper, OracleSQLQueryBuilder parent) {
        super(pro, defaultSchema);
        this.m_helper.set((Object)helper);
        this.m_parentBuilder = parent;
        this.m_expressionFactories.add(new LiteralBuilder());
        this.m_expressionFactories.add(new ColumnBuilder());
        this.m_expressionFactories.add(new ConditionBuilder());
        this.m_expressionFactories.add(new ArithmeticOperationBuilder());
        this.m_expressionFactories.add(new DataMiningFunctionBuilder());
        this.m_expressionFactories.add(new WindowFunctionBuilder());
        this.m_expressionFactories.add(new BuiltInFunctionBuilder());
        this.m_expressionFactories.add(new UserFunctionBuilder());
        this.m_expressionFactories.add(new GroupByExpressionBuilder());
        this.m_expressionFactories.add(new CaseBuilder());
        this.m_expressionFactories.add(new QueryBlockBuilder());
        this.m_expressionFactories.add(new RelationalPropertiesBuilder());
        this.m_expressionFactories.add(new WhereObjectBuilder());
        this.m_expressionFactories.add(new PartitionByBuilder());
        this.m_expressionFactories.add(new OrderByBuilder());
        this.m_expressionFactories.add(new SetOperationBuilder());
        this.m_expressionFactories.add(new ModelBuilder());
        this.m_expressionFactories.add(new SingleColumnForLoopBuilder());
        this.m_expressionFactories.add(new MultiColumnForLoopBuilder());
        this.m_expressionFactories.add(new ModelExpressionBuilder());
        this.m_expressionFactories.add(new CompoundExpressionBuilder());
        this.m_expressionFactories.add(new ParenthesisBuilder());
    }

    public boolean matchesProvider() {
        String proType = this.getProvider().getDescriptor().getDatabaseType();
        return ModelUtil.areEqual((Object)proType, (Object)"Oracle Database");
    }

    private OracleSQLQueryBuilderHelper getHelper() {
        OracleSQLQueryBuilderHelper retval = (OracleSQLQueryBuilderHelper)this.m_helper.get();
        if (retval == null) {
            throw new IllegalStateException("Cannot get helper outside of a call to the parseSQL method");
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T, E extends Exception> T parseSQL(String sql, HelperCallable<T, E> hc) throws E {
        Holder<OracleSQLQueryBuilderHelper> holder = this.m_helper;
        synchronized (holder) {
            if (this.m_helper.get() != null) {
                throw new IllegalStateException("Already have a helper");
            }
            OracleSQLQueryBuilderHelper helper = OracleSQLQueryBuilderHelper.getHelper(sql);
            this.m_helper.set((Object)helper);
            T t = hc.process(helper);
            return t;
            finally {
                this.m_helper.set(null);
            }
        }
    }

    protected void buildQueryImpl(String sql, final SQLQuery query, final SQLQueryOwner parent) throws SQLQueryException {
        if (ModelUtil.hasLength((String)sql)) {
            final String sql2 = OracleSQLQueryBuilder.fixEmptySelectClause(sql);
            final boolean removeStar = sql2.length() > sql.length();
            this.parseSQL(sql2, new HelperCallable<Object, SQLQueryException>(){

                @Override
                public Object process(OracleSQLQueryBuilderHelper helper) throws SQLQueryException {
                    List<LexerToken> tokens = helper.getLexerTokens();
                    if (tokens.size() > 0) {
                        ParseNode parseNode = helper.getRaptorRoot();
                        helper.checkErrors(parseNode, sql2);
                        OracleSQLQueryBuilder.this.buildQuery(parseNode, query, (DBObject)parent);
                        if (removeStar && query.getSelectObjects().length == 1) {
                            SelectObject select = query.getSelectObjects()[0];
                            if ("*".equals(select.getUsableAlias())) {
                                query.removeSelectObject(query.getSelectObjects()[0]);
                            } else {
                                OracleSQLQueryBuilder.this.getLogger().warning("Expected a single select object \"*\".");
                            }
                            OracleSQLQueryBuilder.this.throwException((SQLQueryException)new SQLQueryClauseException((SQLFragment)query, APIBundle.get((String)"SQL_EMPTY_SELECT")));
                        }
                    }
                    return null;
                }
            });
        }
    }

    private void buildQuery(ParseNode queryParseNode, SQLQuery query, DBObject parent) throws SQLQueryException {
        if (parent != null && !(parent instanceof SQLQueryOwner) && !(parent instanceof SQLQuery)) {
            throw new IllegalArgumentException("The parent of a SQLQuery must be a SQLQuery or SQLQueryOwner");
        }
        if (this.getSQLQuery() == null) {
            this.setSQLQuery(query);
        }
        query.setParent((DBObject)(parent == null ? this.getDefaultSchema() : parent));
        this.checkCancelled();
        OracleSQLQueryBuilderHelper helper = this.getHelper();
        if (helper.isRule(queryParseNode, "query_block")) {
            this.buildQueryBlock(queryParseNode, query, parent);
        } else if (helper.isRule(queryParseNode, "subquery")) {
            try {
                this.buildSubQuery(queryParseNode, query, parent);
            }
            catch (UnrecognizedFragmentException ufe) {
                this.throwException(new SQLQueryException(APIBundle.get((String)"SQL_CANT_BUILD_SUBQUERY")));
            }
        } else {
            this.throwException(new UnrecognizedFragmentException(helper.getSourceFragment(queryParseNode)));
        }
        query.setDeclarative(true);
    }

    public void buildSubQuery(ParseNode queryParseNode, SQLQuery query, DBObject parent) throws SQLQueryException {
        List<ParseNode> kids;
        boolean built = false;
        AbstractDBObjectProvider pro = this.getProvider();
        Schema defaultSchema = this.getDefaultSchema();
        ParseNode orderByNode = null;
        OracleSQLQueryBuilderHelper helper = this.getHelper();
        if (helper.isRule((kids = helper.getOrderedChildren(queryParseNode)).get(0), "subquery_factoring_clause")) {
            List<ParseNode> kidskids = helper.getOrderedChildren(kids.get(0));
            String alias = helper.getContent(kidskids.get(1));
            List<ParseNode> kidskidskids = helper.getOrderedChildren(kidskids.get(3));
            OracleSQLQueryBuilder builder = new OracleSQLQueryBuilder((DBObjectProvider)pro, defaultSchema, helper, this);
            SQLQuery subQueryFactoringClause = new SQLQuery();
            builder.buildQuery(kidskidskids.get(1), subQueryFactoringClause, parent);
            FromObject with = new FromObject((SQLFragment)subQueryFactoringClause, alias);
            with.setWith(true);
            this.addFromObject(with);
            builder.buildSubQuery(kids.get(1), query, parent);
            built = true;
        } else {
            if (helper.isRule(queryParseNode, "query_block")) {
                kids = new ArrayList<ParseNode>();
                kids.add(queryParseNode);
            }
            int i = 0;
            while (i < kids.size()) {
                if (helper.isKeyword(kids.get(i), "(")) {
                    ++i;
                }
                OracleSQLQueryBuilder builder = new OracleSQLQueryBuilder((DBObjectProvider)pro, defaultSchema, helper, this);
                ParseNode subQueryParseNode = kids.get(i);
                if (++i == kids.size()) {
                    builder.buildQuery(subQueryParseNode, query, parent);
                    built = true;
                    break;
                }
                if (helper.isRule(kids.get(i), "SET_OPER") || helper.isLeaf(kids.get(i))) {
                    if (helper.isKeyword(kids.get(i), ")")) {
                        builder.buildQuery(subQueryParseNode, query, parent);
                        built = true;
                        ++i;
                        continue;
                    }
                    if (!helper.isKeyword(kids.get(i), "UNION", "ALL", "INTERSECT", "MINUS") && !helper.isRule(kids.get(i), "SET_OPER")) continue;
                    SetOperator.Operator op = null;
                    if (helper.isRule(kids.get(i), "SET_OPER")) {
                        List<ParseNode> kidskids = helper.getOrderedChildren(kids.get(i));
                        op = this.isUnionAll(kidskids, 0) ? SetOperator.Operator.UNION_ALL : SetOperator.getSetOperator((String)helper.getContent(kidskids.get(0)));
                    } else if (this.isUnionAll(kids, i)) {
                        ++i;
                        op = SetOperator.Operator.UNION_ALL;
                    } else {
                        op = SetOperator.getSetOperator((String)helper.getContent(kids.get(i)));
                    }
                    if (op == null) {
                        throw new SQLQueryException(APIBundle.get((String)"SQL_UNION_SUPPORT"));
                    }
                    SQLQuery lhs = new SQLQuery();
                    builder.buildQuery(subQueryParseNode, lhs, parent);
                    OracleSQLQueryBuilder rhsBuilder = new OracleSQLQueryBuilder((DBObjectProvider)pro, defaultSchema, helper, this);
                    SQLQuery rhs = new SQLQuery();
                    rhsBuilder.buildQuery(kids.get(i + 1), rhs, parent);
                    OrderByObject[] obo = rhs.getOrderByObjects();
                    boolean obs = rhs.isOrderSiblings();
                    rhs.setOrderByObjects(null);
                    rhs.setOrderSiblings(false);
                    i += 2;
                    SetOperator setOperator = new SetOperator(op, new SQLFragment[]{lhs, rhs});
                    built = true;
                    query.setSetOperator(setOperator);
                    if (obo == null) continue;
                    query.setOrderByObjects(obo);
                    query.setOrderSiblings(obs);
                    continue;
                }
                if (!helper.isRule(kids.get(i), "order_by_clause")) break;
                builder.buildQuery(subQueryParseNode, query, parent);
                orderByNode = kids.get(i);
                boolean orderSiblings = helper.isKeyword(helper.getOrderedChildren(orderByNode).get(1), "SIBLINGS");
                ExpressionList orderBy = (ExpressionList)builder.createFragment(orderByNode, (SQLFragment)query, null);
                SQLFragment[] obargs = orderBy.getArguments();
                OrderByObject[] obos = new OrderByObject[obargs.length];
                for (int j = 0; j < obargs.length; ++j) {
                    obos[j] = (OrderByObject)obargs[j];
                }
                built = true;
                query.setOrderByObjects(obos);
                query.setOrderSiblings(orderSiblings);
                break;
            }
        }
        if (!built) {
            throw new UnrecognizedFragmentException(helper.getSourceFragment(queryParseNode));
        }
    }

    private boolean isUnionAll(List<ParseNode> nodes, int i) {
        OracleSQLQueryBuilderHelper helper = this.getHelper();
        return nodes.size() > i + 1 && helper.isKeyword(nodes.get(i), "UNION") && helper.isKeyword(nodes.get(i + 1), "ALL");
    }

    private void buildQueryBlock(ParseNode queryParseNode, SQLQuery query, DBObject parent) throws SQLQueryException {
        OracleSQLQueryBuilderHelper helper = this.getHelper();
        List<ParseNode> kids = helper.getOrderedChildren(queryParseNode);
        if (kids.size() == 3 && helper.isKeyword(kids.get(0), "(")) {
            queryParseNode = kids.get(1);
            kids = helper.getOrderedChildren(queryParseNode);
        }
        if (!helper.isRule(queryParseNode, "select", "query_block")) {
            throw new SQLQueryException(APIBundle.get((String)"SQL_SELECT_EXPECTED"));
        }
        ParseNode fromClause = helper.getRuleNode(kids, "from_clause");
        if (fromClause == null) {
            throw new SQLQueryException(this.buildErrorMessage(kids.get(kids.size() - 1), APIBundle.get((String)"SQL_RQB_INVALID_FROM_CLAUSE")));
        }
        SQLQueryException oops = null;
        List<ParseNode> fromKids = helper.getOrderedChildren(fromClause);
        int fromIndex = 0;
        try {
            ParseNode cartesianProduct = fromKids.get(fromIndex + 1);
            if (helper.isRule(cartesianProduct, "cartesian_product", "join_clause")) {
                this.buildFrom(cartesianProduct, query, parent);
            } else {
                List<ParseNode> tabrefNodes = fromKids.subList(fromIndex + 1, kids.size());
                if (!helper.isRule(tabrefNodes.get(0), "table_reference")) {
                    FromObject from = this.createFromx(tabrefNodes);
                    this.addFromObject(from);
                } else {
                    for (ParseNode tabrefNode : tabrefNodes) {
                        if (helper.isKeyword(tabrefNode, ",")) continue;
                        FromObject from = this.createFromx(tabrefNode);
                        this.addFromObject(from);
                    }
                }
            }
        }
        catch (SQLQueryCancelledException sqce) {
            throw sqce;
        }
        catch (SQLQueryException sqe) {
            oops = sqe;
        }
        ParseNode selectClauseNode = helper.getRuleNode(kids, "select_clause");
        if (selectClauseNode == null) {
            SQLQueryException sqe = new SQLQueryException(this.buildErrorMessage(selectClauseNode, APIBundle.get((String)"SQL_RQB_SELECT_LIST_OR_STAR_EXPECTED")));
            if (oops == null) {
                oops = sqe;
            } else {
                oops.setNextException((DBException)((Object)sqe));
            }
            throw oops;
        }
        try {
            List<ParseNode> selectClauseKids = helper.getOrderedChildren(selectClauseNode);
            int distinctIndex = helper.getKeywordIndex(selectClauseKids, "DISTINCT", "UNIQUE", "ALL");
            if (distinctIndex > 0) {
                String distinctQualifierSource = helper.getContent(selectClauseKids.get(distinctIndex));
                query.setDistinctSource(distinctQualifierSource);
                if (!helper.isKeyword(selectClauseKids.get(distinctIndex), "ALL")) {
                    query.setDistinct(true);
                }
            }
            ParseNode selectListNode = helper.getRuleNode(selectClauseKids, "select_list");
            this.buildSelectList(selectListNode, parent);
        }
        catch (SQLQueryCancelledException sqce) {
            throw sqce;
        }
        catch (SQLQueryException sqe) {
            if (oops == null) {
                oops = sqe;
            }
            oops.setNextException((DBException)((Object)sqe));
        }
        ParseNode whereNode = null;
        ParseNode hierarchicalQueryNode = null;
        ParseNode groupByNode = null;
        ParseNode havingNode = null;
        ParseNode modelNode = null;
        ParseNode restrictionsNode = helper.getRuleNode(kids, "restrictions");
        if (restrictionsNode == null) {
            whereNode = helper.getRuleNode(kids, "where_clause");
            hierarchicalQueryNode = helper.getRuleNode(kids, "hierarchical_query_clause");
            groupByNode = helper.getRuleNode(kids, "group_by_clause");
            havingNode = helper.getRuleNode(kids, "having_clause");
            modelNode = helper.getRuleNode(kids, "model_clause");
        } else if (helper.isRule(restrictionsNode, "where_clause")) {
            whereNode = restrictionsNode;
        } else if (helper.isRule(restrictionsNode, "hierarchical_query_clause")) {
            hierarchicalQueryNode = restrictionsNode;
        } else if (helper.isRule(restrictionsNode, "group_by_clause")) {
            groupByNode = restrictionsNode;
        } else if (helper.isRule(restrictionsNode, "having_clause")) {
            havingNode = restrictionsNode;
        } else if (helper.isRule(restrictionsNode, "model_clause")) {
            modelNode = restrictionsNode;
        } else {
            List<ParseNode> restrictions = helper.getOrderedChildren(restrictionsNode);
            whereNode = helper.getRuleNode(restrictions, "where_clause");
            groupByNode = helper.getRuleNode(restrictions, "group_by_clause");
            havingNode = helper.getRuleNode(restrictions, "having_clause");
            modelNode = helper.getRuleNode(restrictions, "model_clause");
            hierarchicalQueryNode = helper.getRuleNode(restrictions, "hierarchical_query_clause");
        }
        if (whereNode != null) {
            WhereObject whereObj = this.createWhere(whereNode);
            this.ensureID((DBObject)whereObj);
            this.setWhereObject(whereObj);
        }
        if (hierarchicalQueryNode != null) {
            HierarchicalQueryObject connectBy = this.createHierarchicalQuery(hierarchicalQueryNode);
            this.setHierarchicalQueryObject(connectBy);
        }
        if (groupByNode != null) {
            GroupByObject gbc = this.createGroupBy(groupByNode);
            this.setGroupByObject(gbc);
            if (havingNode != null) {
                List<ParseNode> havingConditions = helper.getOrderedChildren(havingNode);
                ParseNode havingCondition = helper.getRuleNode(havingConditions, "condition");
                WhereObject hv = this.createWhere(havingCondition);
                gbc.setHaving(hv);
            }
        }
        if (modelNode != null) {
            ModelObject model = this.createModel(modelNode);
            query.setModelObject(model);
        }
        if (oops != null) {
            throw oops;
        }
    }

    private void buildFrom(ParseNode fromNodes, SQLQuery query, DBObject parent) throws SQLQueryException {
        SQLQueryException oops = null;
        ArrayList from = new ArrayList();
        OracleSQLQueryBuilderHelper helper = this.getHelper();
        List<ParseNode> kids = helper.getOrderedChildren(fromNodes);
        if (helper.isRule(fromNodes, "xmltable")) {
            ArrayList<ParseNode> xmlTableNodes = new ArrayList<ParseNode>();
            xmlTableNodes.add(fromNodes);
            FromObject fromObject = this.createXMLTable(xmlTableNodes);
            this.addFromObject(fromObject);
        } else if (helper.isRule(fromNodes, "table_reference")) {
            FromObject fo = this.createFromx(fromNodes);
            this.addFromObject(fo);
        } else if (helper.isRule(fromNodes, "cartesian_product") && kids.size() == 3 && helper.isKeyword(kids.get(1), ",")) {
            this.buildFrom(kids.get(0), query, parent);
            this.buildFrom(kids.get(2), query, parent);
        } else {
            ArrayList<ParseNode> fromsublist = new ArrayList<ParseNode>();
            fromsublist.add(fromNodes);
            from.add(fromsublist);
        }
        if (from != null && from.size() > 0) {
            for (List list : from) {
                try {
                    FromObject newFrom = this.createFrom(fromNodes, list);
                    this.checkForCircularView(parent, newFrom);
                    this.addFromObject(newFrom);
                }
                catch (SQLQueryCancelledException sqce) {
                    throw sqce;
                }
                catch (SQLQueryException sqe) {
                    if (oops == null) {
                        oops = sqe;
                        continue;
                    }
                    oops.setNextException((DBException)((Object)sqe));
                }
            }
        }
        if (oops != null) {
            this.removeTemporaryObjectIDs((SQLFragment)query);
            throw oops;
        }
    }

    private void checkForCircularView(DBObject parent, FromObject newFrom) throws SQLQueryException {
        if (parent instanceof Relation) {
            for (RelationUsage relationUsage : DBUtil.findChildren((DBObject)newFrom, RelationUsage.class)) {
                this.checkCancelled();
                DBObjectID id = relationUsage.getObjectID();
                if (id == null) continue;
                DBObject rel = null;
                try {
                    rel = id.resolveID();
                }
                catch (DBException dbe) {
                    this.getLogger().fine(dbe.getMessage());
                }
                if (rel == null || !DBUtil.areNamesAndTypesEqual((DBObject)parent, (DBObject)rel)) continue;
                this.throwException((SQLQueryException)new SQLQueryClauseException((SQLFragment)relationUsage, APIBundle.get((String)"SQL_CIRCULAR_VIEW")));
            }
        }
    }

    private void buildSelectList(ParseNode selectListNode, DBObject parent) throws SQLQueryException {
        SQLQueryException oops = null;
        List<Object> selectList = null;
        OracleSQLQueryBuilderHelper helper = this.getHelper();
        if (helper.isKeyword(selectListNode, "*")) {
            ColumnKeywordUsage exp = new ColumnKeywordUsage("*", null);
            SelectObject obj = new SelectObject();
            obj.setExpression((SQLFragment)exp);
            this.addSelectObject(obj);
            selectList = Collections.emptyList();
        } else if (helper.isRule(selectListNode, "select_term")) {
            selectList = new ArrayList<ParseNode>();
            selectList.add(selectListNode);
        } else {
            selectList = helper.flattenListTree("select_list", selectListNode);
        }
        for (int i = 0; i < selectList.size(); ++i) {
            ParseNode e = (ParseNode)selectList.get(i);
            try {
                if (!helper.isRule(e, "select_term")) continue;
                this.buildSelectListItem(i, e, parent);
                continue;
            }
            catch (SQLQueryCancelledException sqce) {
                throw sqce;
            }
            catch (SQLQueryException sqe) {
                if (oops == null) {
                    oops = sqe;
                    continue;
                }
                oops.setNextException((DBException)((Object)sqe));
            }
        }
        if (oops != null) {
            throw oops;
        }
    }

    private void buildSelectListItem(int i, ParseNode selectListItem, DBObject parent) throws SQLQueryException {
        SQLFragment exp;
        SelectObject obj;
        SQLQueryException savedException;
        String alias;
        List<ParseNode> sliKids;
        OracleSQLQueryBuilderHelper helper;
        block10: {
            helper = this.getHelper();
            sliKids = helper.getOrderedChildren(selectListItem);
            ParseNode thing = null;
            boolean hasAs = false;
            alias = null;
            savedException = null;
            if (sliKids.size() == 2 && helper.isRule(sliKids.get(1), "as_alias")) {
                ParseNode asAliasNode = sliKids.get(1);
                List<ParseNode> aliasKids = helper.getOrderedChildren(asAliasNode);
                hasAs = aliasKids.size() == 2;
                alias = helper.getContent(aliasKids.get(hasAs ? 1 : 0));
                selectListItem = sliKids.get(0);
                sliKids = helper.getOrderedChildren(selectListItem);
            }
            int cbrShift = helper.isRule(sliKids.get(0), "'CONNECT_BY_ROOT'") ? 1 : 0;
            thing = sliKids.size() == cbrShift + 2 && helper.isLeaf(sliKids.get(cbrShift + 1)) ? (helper.isRule(selectListItem, "expr") ? selectListItem : sliKids.get(cbrShift)) : (cbrShift == 1 ? sliKids.get(1) : selectListItem);
            obj = new SelectObject();
            obj.setAlias(alias);
            obj.setUseAs(hasAs);
            exp = null;
            try {
                exp = this.createFragment(thing, (SQLFragment)obj, null);
            }
            catch (SQLQueryCancelledException sqce) {
                throw sqce;
            }
            catch (SQLQueryException sqe) {
                savedException = sqe;
                if (!(parent instanceof Relation)) break block10;
                if (!ModelUtil.hasLength((String)obj.getAlias())) {
                    String name = null;
                    String[] chunks = helper.getContent(thing).split("\\.");
                    if (chunks.length > 0) {
                        name = chunks[chunks.length - 1];
                    }
                    if (!ModelUtil.hasLength(name)) {
                        int j = i + 1;
                        name = "\"<column " + j + ">\"";
                    }
                    if (!name.startsWith("\"")) {
                        name = name.toUpperCase();
                    }
                    obj.setAlias(name);
                }
                exp = new SimpleSQLFragment("null");
                obj.setExpression(exp);
                this.addSelectObject(obj);
                this.throwException(sqe);
            }
        }
        if (exp == null) {
            if (savedException != null) {
                throw savedException;
            }
            String selectItem = helper.getContent(sliKids.get(0));
            throw new SQLQueryException(APIBundle.format((String)"SQL_CANT_CREATE_SELECT_ITEM", (Object[])new Object[]{selectItem}));
        }
        obj.setExpression(exp);
        this.addSelectObject(obj);
        this.checkAlias((AliasFragment)obj, alias);
    }

    protected SQLFragment parseFromExpression(String expression, FromObject creating) throws SQLQueryException {
        this.checkLength(expression);
        int dot = expression.indexOf(".");
        String schema = null;
        String relation = null;
        if (dot > 0) {
            schema = expression.substring(0, dot);
            relation = expression.substring(dot + 1);
        } else {
            relation = expression;
        }
        DBObjectUsage ru = this.createRelationUsage(schema, relation, null);
        if (ru == null) {
            this.throwException(new SQLQueryException(APIBundle.format((String)"SQL_CANT_FIND_REL", (Object[])new Object[]{expression})));
        }
        return ru;
    }

    protected boolean containsAsterisk() throws SQLQueryException {
        boolean ret = false;
        String query = this.getQuery().getSQLText();
        if (query != null) {
            ret = this.parseSQL(query, new HelperCallable<Boolean, SQLQueryException>(){

                @Override
                public Boolean process(OracleSQLQueryBuilderHelper helper) throws SQLQueryException {
                    boolean retval = false;
                    List<ParseNode> queryRootKids = helper.getQueryRootKids();
                    List<ParseNode> selectItemNodes = helper.getSelectItemNodes(queryRootKids);
                    for (ParseNode node : selectItemNodes) {
                        if (helper.isKeyword(node, "*")) {
                            retval = true;
                            break;
                        }
                        if (!helper.isDotSeperatedList(node)) continue;
                        List<ParseNode> l = helper.getLeftAndRight(node);
                        if (!helper.isKeyword(l.get(l.size() - 1), "*")) continue;
                        retval = true;
                        break;
                    }
                    return retval;
                }
            });
        }
        return ret;
    }

    protected DerivedPropertyBuilder getDTUBuilder(int columnIndex) {
        return new SQLDerivedPropertySupport.SQLQueryViewColumnDTUBuilder(this.getProvider(), this.getQuery(), columnIndex);
    }

    protected SQLFragment parseSelectExpression(String expression, final SelectObject creating) throws SQLQueryException {
        this.checkLength(expression);
        return this.checkExpression(SELECT_, expression, " FROM DUMMY", new HelperCallable<SQLFragment, SQLQueryException>(){

            @Override
            public SQLFragment process(OracleSQLQueryBuilderHelper helper) throws SQLQueryException {
                ParseNode selectRoot = helper.getRaptorRoot();
                List<ParseNode> kids = helper.getOrderedChildren(selectRoot);
                ParseNode selectClauseNode = helper.getRuleNode(kids, "select_clause");
                List<ParseNode> selectClauseKids = helper.getOrderedChildren(selectClauseNode);
                ParseNode expressionRoot = selectClauseKids.get(1);
                return OracleSQLQueryBuilder.this.createFragment(expressionRoot, (SQLFragment)creating, null, helper);
            }
        });
    }

    private void adjustErrorOffset(SQLParseException spe, String beginning) {
        if (ModelUtil.hasLength((String)beginning)) {
            int offset = spe.getOffset();
            if (beginning.length() < offset) {
                spe.adjustOffset(beginning.length());
            }
        }
    }

    private <T> T checkExpression(String begin, String middle, String expression, final HelperCallable<T, SQLQueryException> run) throws SQLQueryException {
        begin = begin.replace('\n', ' ');
        final String strippedExpression = expression.replace('\n', ' ');
        String select = begin + middle + strippedExpression;
        HelperCallable proxy = new HelperCallable<T, SQLQueryException>(){

            @Override
            public T process(OracleSQLQueryBuilderHelper helper) throws SQLQueryException {
                ParseNode selectRoot = helper.getRaptorRoot();
                helper.checkErrors(selectRoot, strippedExpression);
                return run.process(helper);
            }
        };
        try {
            return this.parseSQL(select, proxy);
        }
        catch (SQLParseException spe) {
            this.adjustErrorOffset(spe, begin);
            throw spe;
        }
    }

    public SQLFragment parseOrderByExpression(String expression, final OrderByObject creating) throws SQLQueryException {
        this.checkLength(expression);
        String begin = "SELECT  1 FROM DUMMY";
        return this.checkExpression(begin, " ORDER BY ", expression, new HelperCallable<SQLFragment, SQLQueryException>(){

            @Override
            public SQLFragment process(OracleSQLQueryBuilderHelper helper) throws SQLQueryException {
                ParseNode selectRoot = helper.getRaptorRoot();
                List<ParseNode> kids = helper.getOrderedChildren(selectRoot);
                ParseNode expressionRoot = kids.get(1);
                return OracleSQLQueryBuilder.this.createFragment(expressionRoot, (SQLFragment)creating, null, helper);
            }
        });
    }

    public SQLFragment parseWhereExpression(String expression, final WhereObject creating) throws SQLQueryException {
        this.checkLength(expression);
        String begin = "SELECT  '1' FROM DUAL WHERE";
        return this.checkExpression(begin, " ", expression, new HelperCallable<SQLFragment, SQLQueryException>(){

            @Override
            public SQLFragment process(OracleSQLQueryBuilderHelper helper) throws SQLQueryException {
                ParseNode selectRoot = helper.getRaptorRoot();
                List<ParseNode> kids = helper.getOrderedChildren(selectRoot);
                ParseNode whereClauseNode = helper.getRuleNode(kids, "where_clause");
                List<ParseNode> whereKids = helper.getOrderedChildren(whereClauseNode);
                ParseNode condition = whereKids.get(1);
                return OracleSQLQueryBuilder.this.createFragment(condition, (SQLFragment)creating, null, helper);
            }
        });
    }

    public OnJoinCondition parseOnExpression(String expression, final JoinObject join) throws SQLQueryException {
        this.checkLength(expression);
        String begin = "SELECT  '1' FROM " + join.getSQLText();
        return this.checkExpression(begin, " ON ", expression, new HelperCallable<OnJoinCondition, SQLQueryException>(){

            @Override
            public OnJoinCondition process(OracleSQLQueryBuilderHelper helper) throws SQLQueryException {
                ParseNode selectRoot = helper.getRaptorRoot();
                List<ParseNode> kids = helper.getOrderedChildren(selectRoot);
                ParseNode fromClauseNode = helper.getRuleNode(kids, "from_clause");
                List<ParseNode> fromClauseKids = helper.getOrderedChildren(fromClauseNode);
                ParseNode joinClauseNode = helper.getRuleNode(fromClauseKids, "join_clause");
                List<ParseNode> joinClauseKids = helper.getOrderedChildren(joinClauseNode);
                List<ParseNode> joinClauseKidsKids = helper.getOrderedChildren(joinClauseKids.get(1));
                ParseNode onUsingConditionNode = helper.getRuleNode(joinClauseKidsKids, "on_using_condition");
                List<ParseNode> onUsingConditionKids = helper.getOrderedChildren(onUsingConditionNode);
                if (onUsingConditionKids.size() > 0) {
                    ParseNode condition = onUsingConditionKids.get(1);
                    SQLFragment frag = OracleSQLQueryBuilder.this.createFragment(condition, (SQLFragment)join, null, helper);
                    if (frag instanceof WhereObject) {
                        return (OnJoinCondition)frag.copyTo((Object)new OnJoinCondition());
                    }
                    return new OnJoinCondition(frag);
                }
                throw new SQLQueryException(APIBundle.get((String)"SQL_QUERY_PARSE_NONE"));
            }
        });
    }

    public boolean supportsConnectBy() {
        return true;
    }

    public boolean supportsGroupBy() {
        return true;
    }

    public boolean supportsOrderBy() {
        return true;
    }

    protected Column[] getColumnsFromResultSet() throws DBException {
        List<Tuple<String, DataTypeUsage>> infos = SQLDerivedPropertySupport.SQLQueryViewColumnDTUBuilder.getColumnInfo((Database)this.getProvider(), this.getSQLQuery().getQueryString());
        int size = infos == null ? 0 : infos.size();
        Column[] ret = new Column[size];
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                ret[i] = new Column();
                ret[i].setName((String)infos.get(i).getFirst());
                ret[i].setDataTypeUsage((DataTypeUsage)infos.get(i).getSecond());
            }
        }
        return ret;
    }

    private FromObject createFrom(ParseNode parent, List<ParseNode> from) throws SQLQueryException {
        FromObject retval = null;
        OracleSQLQueryBuilderHelper helper = this.getHelper();
        if (helper.isRule(parent, "pivot_clause", "unpivot_clause")) {
            retval = this.createPivot84(parent, null);
        } else if (from.size() == 1 && helper.isRule(from.get(0), "join_clause")) {
            List<ParseNode> jkids = helper.getOrderedChildren(from.get(0));
            retval = this.createAnsiJoin(jkids);
        } else {
            retval = from.size() > 1 && (helper.isRule(parent, "join_clause") || helper.isRule(from.get(1), "outer_join_clause") || helper.isRule(from.get(1), "\"inner_cross_join_clause\"") || helper.isRule(from.get(1), "inner_cross_join_clause")) ? this.createAnsiJoin(from) : (from.size() == 2 && (helper.isRule(from.get(1), "pivot_clause") || helper.isRule(from.get(1), "unpivot_clause")) ? this.createPivot88(from, null) : (helper.isRule(parent, "pivot_clause") || helper.isRule(parent, "unpivot_clause") ? this.createPivot84(parent, null) : this.createFromx(from)));
        }
        retval.setStartOffset(Integer.valueOf(helper.getNodeStartOffset(from.get(0))));
        return retval;
    }

    private FromObject createAnsiJoin(List<ParseNode> from) throws SQLQueryException {
        List<ParseNode> fromLeftNodes;
        FromObject retval = null;
        int nextidx = 1;
        OracleSQLQueryBuilderHelper helper = this.getHelper();
        if (from.size() == 3 && helper.isKeyword(from.get(0), "(")) {
            fromLeftNodes = helper.getOrderedChildren(from.get(1));
            retval = this.createAnsiJoin(fromLeftNodes);
            nextidx = 3;
        } else if (helper.isRule(from.get(0), "join_clause")) {
            fromLeftNodes = helper.getOrderedChildren(from.get(0));
            retval = this.createAnsiJoin(fromLeftNodes);
        } else {
            retval = this.createFromx(from.get(0));
        }
        boolean isOuter = false;
        for (ParseNode joinNode : from.subList(nextidx, from.size())) {
            isOuter = helper.isRule(joinNode, "outer_join_clause");
            if (!helper.isRule(joinNode, "\"inner_cross_join_clause\"") && !helper.isRule(joinNode, "inner_cross_join_clause") && !helper.isRule(joinNode, "outer_join_clause")) continue;
            retval = this.processJoin(joinNode, retval, isOuter);
        }
        return retval;
    }

    private FromObject processJoin(ParseNode joinNode, FromObject left, boolean isOuter) throws SQLQueryException {
        ArrayList<String> keywords = new ArrayList<String>();
        FromObject retval = new FromObject();
        JoinObject jo = new JoinObject();
        jo.setLeftExpression(left);
        OracleSQLQueryBuilderHelper helper = this.getHelper();
        List<ParseNode> kids = helper.getOrderedChildren(joinNode);
        int i = 0;
        ExpressionList leftPartitionBy = null;
        if (helper.isRule(kids.get(i), "query_partition_clause")) {
            leftPartitionBy = (ExpressionList)this.createFragment(kids.get(i), (SQLFragment)jo, left);
            ++i;
            jo.setLeftPartitionBy(leftPartitionBy);
        }
        ArrayList<String> includeRules = new ArrayList<String>();
        includeRules.add("outer_join_type");
        i = this.addKeywords(kids, i, keywords, includeRules);
        FromObject right = null;
        if (helper.isRule(kids.get(i), "join_clause")) {
            List<ParseNode> kidskids = helper.getOrderedChildren(kids.get(i));
            right = this.createFrom(kids.get(i), kidskids);
        } else {
            right = this.createFromx(kids.get(i));
        }
        jo.setRightExpression(right);
        ExpressionList rightPartitionBy = null;
        if (++i < kids.size() && helper.isRule(kids.get(i), "query_partition_clause")) {
            rightPartitionBy = (ExpressionList)this.createFragment(kids.get(i), (SQLFragment)jo, right);
            ++i;
            jo.setRightPartitionBy(rightPartitionBy);
        }
        String joinType = null;
        if (isOuter) {
            if (this.hasToken(keywords, "FULL", null)) {
                joinType = "FULL";
            } else if (this.hasToken(keywords, "LEFT", null)) {
                joinType = "LEFT";
            } else if (this.hasToken(keywords, "RIGHT", null)) {
                joinType = "RIGHT";
            }
        } else {
            joinType = this.hasToken(keywords, "CROSS", null) ? "CROSS" : "INNER";
        }
        jo.setJoinType(joinType);
        jo.setNatural(this.hasToken(keywords, "NATURAL", null));
        if (joinType.equals("INNER")) {
            jo.setIncludeJoinKeyword(this.hasToken(keywords, joinType, "JOIN"));
        } else if (jo.isOuterJoin()) {
            jo.setIncludeJoinKeyword(this.hasToken(keywords, "OUTER", "JOIN"));
        }
        retval.setExpression((SQLFragment)jo);
        if (i < kids.size() && helper.isRule(kids.get(i), "on_using_condition")) {
            this.processOnUsingCondition(kids.get(i), retval);
        }
        return retval;
    }

    private void processOnUsingCondition(ParseNode onUsingConditionNode, FromObject fo) throws SQLQueryException {
        OracleSQLQueryBuilderHelper helper = this.getHelper();
        JoinObject jo = (JoinObject)fo.getExpression();
        List<ParseNode> kids = helper.getOrderedChildren(onUsingConditionNode);
        if (helper.isKeyword(kids.get(0), "ON")) {
            WhereObject w = this.createWhere(kids.get(1), (SQLFragment)fo);
            if (w != null) {
                OnJoinCondition on = (OnJoinCondition)w.copyTo((Object)new OnJoinCondition());
                jo.setCondition((JoinCondition)on);
            }
        } else {
            int i = 1;
            FromObject left = jo.getLeftExpression();
            FromObject right = jo.getRightExpression();
            this.processJoinUsingClause(kids, i, jo, left, right, fo);
        }
    }

    private void processJoinUsingClause(List<ParseNode> pnodes, int i, JoinObject jo, FromObject left, FromObject right, FromObject retval) throws SQLQueryException {
        int listEnd = pnodes.size();
        OracleSQLQueryBuilderHelper helper = this.getHelper();
        if (helper.isKeyword(pnodes.get(++i), "(")) {
            ++i;
            listEnd = helper.getKeywordIndex(pnodes, ")");
        }
        List<List<ParseNode>> joinCols = helper.getCommaSeparatedList(pnodes.subList(i, listEnd));
        UsingJoinCondition using = new UsingJoinCondition();
        jo.setCondition((JoinCondition)using);
        for (List<ParseNode> joinCol : joinCols) {
            String col = helper.getContent(joinCol.get(0));
            FromObjectUsage cu = this.findColumnInFromObjects(col, true, new FromObject[]{left, right}, true, true, (SQLFragment)retval);
            if (cu == null) continue;
            using.addColumn(cu);
        }
    }

    private int addKeywords(List<ParseNode> kids, int i, List<String> keywords, List<String> includeRules) {
        OracleSQLQueryBuilderHelper helper = this.getHelper();
        while (i < kids.size() && (helper.isLeaf(kids.get(i)) || helper.isRule(kids.get(i), includeRules))) {
            if (helper.isLeaf(kids.get(i))) {
                String keyword = helper.getContent(kids.get(i));
                if (!s_joinKeywords.contains(keyword.toUpperCase())) break;
                keywords.add(keyword);
            } else {
                if (!helper.isRule(kids.get(i), includeRules)) break;
                this.addKeywords(helper.getOrderedChildren(kids.get(i)), 0, keywords, includeRules);
            }
            ++i;
        }
        return i;
    }

    private boolean hasToken(List<String> keywords, String token, String before) {
        boolean retval = false;
        for (String keyword : keywords) {
            if (before != null && keyword.equalsIgnoreCase(before)) break;
            if (!keyword.equalsIgnoreCase(token)) continue;
            retval = true;
            break;
        }
        return retval;
    }

    private FromObject createFromx(ParseNode from) throws SQLQueryException {
        FromObject retval = null;
        OracleSQLQueryBuilderHelper helper = this.getHelper();
        List<ParseNode> kids = helper.getOrderedChildren(from);
        if (helper.isRule(from, "query_table_expression", "table_collection_expression")) {
            ParseNode expr = from;
            if (kids.size() == 3 && helper.isKeyword(kids.get(0), "(")) {
                expr = kids.get(1);
            }
            kids = new ArrayList<ParseNode>();
            kids.add(expr);
        }
        retval = this.createFromx(kids);
        retval.setStartOffset(Integer.valueOf(helper.getNodeStartOffset(from)));
        return retval;
    }

    private FromObject createXMLTable(List<ParseNode> kids) throws SQLQueryException {
        String alias = this.getTableAlias(kids);
        SQLFragment xmlTable = this.createFragment(kids.get(0), null, null);
        FromObject retval = new FromObject(xmlTable, alias);
        this.checkAlias((AliasFragment)retval, alias);
        return retval;
    }

    public List<AbstractSQLQueryBuilder.QueryColumnInfo> getQueryColumnInfos() throws SQLQueryException {
        String sql;
        List<AbstractSQLQueryBuilder.QueryColumnInfo> retval = null;
        SQLQuery query = this.getQuery();
        if (query != null && (sql = query.getSQLText()) != null) {
            retval = this.parseSQL(sql, new HelperCallable<List<AbstractSQLQueryBuilder.QueryColumnInfo>, SQLQueryException>(){

                @Override
                public List<AbstractSQLQueryBuilder.QueryColumnInfo> process(OracleSQLQueryBuilderHelper helper) throws SQLQueryException {
                    return OracleSQLQueryBuilder.this.getQueryColumnInfosImpl(helper);
                }
            });
        }
        return retval == null ? Collections.emptyList() : retval;
    }

    private List<AbstractSQLQueryBuilder.QueryColumnInfo> getQueryColumnInfosImpl(OracleSQLQueryBuilderHelper helper) throws SQLQueryException {
        ArrayList<AbstractSQLQueryBuilder.QueryColumnInfo> ret = new ArrayList<AbstractSQLQueryBuilder.QueryColumnInfo>();
        List<ParseNode> queryRootKids = helper.getQueryRootKids();
        List<ParseNode> sl = helper.getSelectItemNodes(queryRootKids);
        for (int i = 0; i < sl.size(); ++i) {
            ParseNode sli = sl.get(i);
            boolean isSelectTerm = helper.isRule(sli, "select_term");
            boolean isExpr = helper.isRule(sli, "expr");
            String usableName = null;
            int selectTermKidCount = 0;
            if (isSelectTerm) {
                List<ParseNode> selectTermKids = helper.getOrderedChildren(sli);
                selectTermKidCount = selectTermKids.size();
                boolean justUseLastName = false;
                if (!isExpr && selectTermKidCount > 1) {
                    justUseLastName = true;
                } else if (selectTermKidCount % 2 == 1) {
                    justUseLastName = true;
                    for (int j = 1; j < selectTermKidCount; j += 2) {
                        if (helper.isKeyword(selectTermKids.get(j), ".")) continue;
                        justUseLastName = false;
                        break;
                    }
                }
                if (justUseLastName && (usableName = helper.getContent(selectTermKids.get(selectTermKidCount - 1))) != null) {
                    usableName = this.getInternalName(usableName);
                }
            }
            String name = helper.isRule(sli) ? usableName : helper.getContent(sli);
            AbstractSQLQueryBuilder.QueryColumnInfo qci = new AbstractSQLQueryBuilder.QueryColumnInfo(name, helper.getContent(sli));
            ret.add(qci);
        }
        return ret;
    }

    private String getDblink(ParseNode node) {
        String dblink = this.getHelper().getContent(node);
        return dblink;
    }

    private LinkSchemaTableAndAlias getTableAndAlias(List<ParseNode> kids) {
        String link = null;
        String schema = null;
        String table = null;
        String alias = null;
        int aliasIndex = -1;
        OracleSQLQueryBuilderHelper helper = this.getHelper();
        int dotIndex = helper.getKeywordIndex(kids, ".");
        if (dotIndex == 1) {
            schema = helper.getContent(kids.get(0));
            table = helper.getContent(kids.get(2));
            aliasIndex = 3;
        } else {
            table = helper.getContent(kids.get(0));
            aliasIndex = 1;
        }
        int atIndex = helper.getKeywordIndex(kids, "@");
        if (atIndex > 0) {
            link = this.getDblink(kids.get(atIndex + 1));
            aliasIndex = atIndex + 2;
        }
        if (kids.size() == aliasIndex + 1) {
            alias = helper.getContent(kids.get(aliasIndex));
        }
        return new LinkSchemaTableAndAlias(link, schema, table, alias);
    }

    private String getTableAlias(List<ParseNode> kids) {
        String alias = null;
        OracleSQLQueryBuilderHelper helper = this.getHelper();
        if (kids.size() > 1 && helper.isLeaf(kids.get(1))) {
            alias = helper.getContent(kids.get(1));
        }
        return alias;
    }

    private LinkSchemaTableAndAlias getSchemaAndTable(ParseNode queryTableExpression) {
        return this.getTableAndAlias(this.getHelper().getOrderedChildren(queryTableExpression));
    }

    private FromObject createPivot88(List<ParseNode> from, String alias) throws SQLQueryException {
        ParseNode queryTableExpr = from.get(0);
        FromObject retval = this.createFromx(queryTableExpr);
        retval.setAlias(alias);
        List<ParseNode> kids = this.getHelper().getOrderedChildren(from.get(1));
        this.createPivot(kids, 0, retval);
        return retval;
    }

    private FromObject createPivot84(ParseNode pivotClause, String alias) throws SQLQueryException {
        List<ParseNode> kids = this.getHelper().getOrderedChildren(pivotClause);
        ParseNode queryTableExpr = kids.get(0);
        FromObject retval = this.createFromx(queryTableExpr);
        retval.setAlias(alias);
        this.createPivot(kids, 1, retval);
        return retval;
    }

    private void createPivot(List<ParseNode> kids, int i, FromObject retval) throws SQLQueryException {
        ParseNode pivotNode = kids.get(i);
        OracleSQLQueryBuilderHelper helper = this.getHelper();
        if (!helper.isKeyword(pivotNode, "PIVOT", "UNPIVOT")) {
            throw new SQLQueryException(APIBundle.get((String)"SQL_UNRECOGNISED_PIVOT_CLAUSE"));
        }
        ParseNode endNode = kids.get(kids.size() - 1);
        if (!helper.isKeyword(endNode, ")")) {
            throw new SQLQueryException(APIBundle.get((String)"SQL_PIVOT_CLAUSE_NOT_CLOSED"));
        }
        int start = helper.getNodeStartOffset(pivotNode);
        int end = helper.getNodeEndOffset(endNode);
        String pivotString = helper.getSourceFragment(start, end);
        SimpleSQLFragment pivotFrag = new SimpleSQLFragment(pivotString);
        retval.setPivotExpression((SQLFragment)pivotFrag);
    }

    private FromObject createFromx(List<ParseNode> from) throws SQLQueryException {
        List<Object> kidskids;
        List<ParseNode> kids;
        LinkSchemaTableAndAlias sta;
        ParseNode subquery = null;
        FromObject retval = null;
        String link = null;
        String schema = null;
        String table = null;
        String alias = null;
        OracleSQLQueryBuilderHelper helper = this.getHelper();
        if (from.size() == 2 && helper.isLeaf(from.get(1))) {
            alias = helper.getContent(from.get(1));
        }
        ParseNode fromNode = from.get(0);
        if (from.size() == 1) {
            if (helper.isLeaf(fromNode)) {
                table = helper.getContent(fromNode);
                FromObject with = this.getFromObject(table);
                if (with != null && with.isWith()) {
                    retval = new FromObject(null, table);
                }
            } else if (helper.isRule(fromNode, "pivot_clause", "unpivot_clause")) {
                retval = this.createPivot84(fromNode, alias);
            } else if (helper.isRule(fromNode, "xmltable")) {
                retval = this.createXMLTable(from);
            } else if (helper.isRule(fromNode, "table_reference")) {
                sta = new LinkSchemaTableAndAlias();
                kids = helper.getOrderedChildren(fromNode);
                if (helper.isRule(fromNode, "table_collection_expression")) {
                    subquery = fromNode;
                } else if (helper.isRule(fromNode, "query_table_expression")) {
                    if (kids.size() > 2 && helper.isKeyword(kids.get(0), "(")) {
                        subquery = kids.get(1);
                    } else {
                        sta = this.getSchemaAndTable(fromNode);
                    }
                } else if (helper.isRule(kids.get(0), "table_collection_expression")) {
                    subquery = kids.get(0);
                    sta.setAlias(this.getTableAlias(kids));
                } else if (helper.isRule(kids.get(0), "xmltable")) {
                    retval = this.createXMLTable(kids);
                } else if (helper.isRule(kids.get(0), "query_table_expression") && !helper.isLeaf(kids.get(0))) {
                    kidskids = helper.getOrderedChildren(kids.get(0));
                    if (helper.isKeyword((ParseNode)kidskids.get(0), "(")) {
                        subquery = (ParseNode)kidskids.get(1);
                    } else if (kidskids.size() == 3 && helper.isKeyword((ParseNode)kidskids.get(1), "@")) {
                        sta.setTable(helper.getContent((ParseNode)kidskids.get(0)));
                        link = helper.getContent((ParseNode)kidskids.get(2));
                    } else if (kidskids.size() == 5 && helper.isKeyword((ParseNode)kidskids.get(1), ".") && helper.isKeyword((ParseNode)kidskids.get(3), "@")) {
                        sta.setSchema(helper.getContent((ParseNode)kidskids.get(0)));
                        sta.setTable(helper.getContent((ParseNode)kidskids.get(2)));
                        link = helper.getContent((ParseNode)kidskids.get(4));
                    } else {
                        sta = this.getSchemaAndTable(kids.get(0));
                    }
                    sta.setAlias(this.getTableAlias(kids));
                } else {
                    sta = this.getTableAndAlias(kids);
                }
                link = sta.getLink();
                schema = sta.getSchema();
                table = sta.getTable();
                alias = sta.getAlias();
            } else if (helper.isRule(fromNode, "subquery", "table_collection_expression")) {
                subquery = fromNode;
            }
        } else if (from.size() == 2) {
            ParseNode queryTableExpression = fromNode;
            if (helper.isRule(from.get(1), "pivot_clause", "unpivot_clause")) {
                retval = this.createPivot88(from, null);
            } else if (helper.isRule(fromNode, "pivot_clause", "unpivot_clause")) {
                alias = helper.getContent(from.get(1));
                retval = this.createPivot84(fromNode, alias);
            }
            if (helper.isRule(fromNode, "table_collection_expression")) {
                subquery = fromNode;
            } else if (helper.isRule(fromNode, "xmltable")) {
                retval = this.createXMLTable(from);
            } else {
                kids = helper.getDotSeparatedList(queryTableExpression);
                kidskids = new ArrayList();
                if (kids.size() == 1) {
                    kidskids = helper.getOrderedChildren(kids.get(0));
                }
                if (kids.size() == 1 && helper.isLeaf(kids.get(0))) {
                    table = helper.getContent(kids.get(0));
                }
                if (kids.size() == 1 && kidskids.size() == 3 && helper.isKeyword((ParseNode)kidskids.get(1), "@")) {
                    table = helper.getContent((ParseNode)kidskids.get(0));
                    link = helper.getContent((ParseNode)kidskids.get(2));
                } else if (kids.size() == 4 && helper.isKeyword(kids.get(2), "@")) {
                    schema = helper.getContent(kids.get(0));
                    table = helper.getContent(kids.get(1));
                    link = helper.getContent(kids.get(3));
                } else if (kids.size() == 1 && kidskids.size() == 3 && helper.isKeyword((ParseNode)kidskids.get(0), "(")) {
                    subquery = (ParseNode)kidskids.get(1);
                } else if (kids.size() == 2 && helper.isLeaf(kids.get(0)) && helper.isLeaf(kids.get(1))) {
                    schema = helper.getContent(kids.get(0));
                    table = helper.getContent(kids.get(1));
                } else if (from.size() == 3 && helper.isKeyword(fromNode, "(") && helper.isRule(from.get(1), "subquery")) {
                    subquery = from.get(1);
                }
            }
        } else if (from.size() == 3 && helper.isKeyword(fromNode, "(")) {
            subquery = from.get(1);
        } else {
            sta = this.getTableAndAlias(from);
            link = sta.getLink();
            schema = sta.getSchema();
            table = sta.getTable();
            alias = sta.getAlias();
        }
        if (subquery == null && retval == null) {
            retval = new FromObject();
            retval.setAlias(alias);
            this.checkAlias((AliasFragment)retval, alias);
            if (ModelUtil.hasLength((String)table) && table.equalsIgnoreCase(DUAL)) {
                retval.setExpression((SQLFragment)new SimpleSQLFragment(table));
            } else {
                DBObjectUsage exp = this.createRelationUsage(schema, table, link);
                if (exp == null) {
                    this.throwException(new SQLQueryException(APIBundle.format((String)"SQL_CANT_FIND_REL", (Object[])new Object[]{table})));
                }
                int offset = helper.getNodeStartOffset(fromNode);
                ((AbstractSQLFragment)exp).setStartOffset(Integer.valueOf(offset));
                retval.setExpression((SQLFragment)exp);
            }
            this.ensureID((DBObject)retval);
        } else if (retval == null) {
            List<ParseNode> kids2 = helper.getOrderedChildren(subquery);
            if (helper.isRule(subquery, "query_table_expression") && kids2.size() == 3 && helper.isKeyword(kids2.get(0), "(")) {
                subquery = kids2.get(1);
            }
            if (helper.isRule(subquery, "subquery")) {
                retval = this.createSubquery(subquery, alias);
            } else if (helper.isRule(subquery, "join_clause")) {
                kids2 = helper.getOrderedChildren(subquery);
                retval = this.createAnsiJoin(kids2);
            } else if (helper.isRule(subquery, "table_collection_expression")) {
                kids2 = helper.getOrderedChildren(subquery);
                SQLFragment[] arg = new SQLFragment[]{this.createFragment(kids2.get(2), (SQLFragment)retval, null)};
                Function tc = this.createFunction("TABLE", arg, "TABLE");
                retval = new FromObject((SQLFragment)tc, alias);
            } else {
                this.throwException(new SQLQueryException(APIBundle.get((String)"SQL_CANT_BUILD_SUBQUERY")));
            }
        }
        if (retval == null) {
            throw new SQLQueryException(APIBundle.get((String)"SQL_CANT_FIND_FROM"));
        }
        retval.setStartOffset(Integer.valueOf(helper.getNodeStartOffset(fromNode)));
        return retval;
    }

    private void checkAlias(AliasFragment sqlFrag, String alias) throws InvalidAliasException {
        if (ModelUtil.hasLength((String)alias)) {
            this.validateAlias(sqlFrag, "COLUMN", alias);
        }
    }

    private FromObject createSubquery(ParseNode subqueryParseNode, String alias) throws InvalidAliasException, SQLQueryException {
        OracleSQLQueryBuilder builder = new OracleSQLQueryBuilder((DBObjectProvider)this.getProvider(), this.getDefaultSchema(), this.getHelper(), this);
        SQLQuery sub = new SQLQuery();
        builder.buildQuery(subqueryParseNode, sub, (DBObject)this.getSQLQuery());
        FromObject retval = new FromObject((SQLFragment)sub, alias);
        this.checkAlias((AliasFragment)retval, alias);
        return retval;
    }

    private DBObjectUsage createRelationUsage(String schema, String relation, String link) throws SQLQueryException {
        RelationUsage retval = null;
        if (ModelUtil.hasLength((String)relation)) {
            AbstractDBObjectProvider pro = this.getProvider();
            schema = schema == null ? null : this.getInternalName(schema);
            link = link == null ? null : this.getInternalName(link);
            relation = this.getInternalName(relation);
            try {
                SchemaObject so = this.getObjectForFrom(schema, relation, link);
                if (so instanceof Relation) {
                    retval = new RelationUsage(so.getID());
                } else if (so instanceof Synonym) {
                    retval = new SynonymUsage(so.getID());
                }
                if (retval != null && ModelUtil.hasLength((String)schema)) {
                    ((AbstractSchemaObjectUsage)retval).setQualified(true);
                }
            }
            catch (SQLQueryCancelledException ce) {
                throw ce;
            }
            catch (DBException e) {
                this.checkCancelled();
                this.getLogger().log(Level.WARNING, "couldn't create usage", e);
            }
            if (retval == null) {
                throw new SQLQueryException(APIBundle.format((String)"SQL_CANT_FIND_REL", (Object[])new Object[]{relation}));
            }
            retval.setProvider((DBObjectProvider)pro);
        }
        return retval;
    }

    public AbstractSQLQueryBuilder getParentBuilder() {
        return this.m_parentBuilder;
    }

    protected void replaceWithAliases(FromObject[] froms) {
        SQLQuery parentQuery = null;
        AbstractSQLQueryBuilder parentBuilder = this.getParentBuilder();
        if (parentBuilder != null) {
            parentQuery = this.getParentBuilder().getSQLQuery();
        }
        if (parentQuery != null) {
            block0: for (int i = 0; i < froms.length; ++i) {
                FromObject[] parentFroms;
                if (froms[i] == null || !ModelUtil.hasLength((String)froms[i].getAlias()) || froms[i].getExpression() != null) continue;
                String alias = froms[i].getAlias();
                for (FromObject parentFrom : parentFroms = parentQuery.getFromObjects()) {
                    if (!alias.equalsIgnoreCase(parentFrom.getAlias())) continue;
                    froms[i] = parentFrom;
                    continue block0;
                }
            }
        }
    }

    public SQLFragment createFragment(ParseNode node, SQLFragment creating, Object context) throws SQLQueryException {
        return this.createFragment(node, creating, context, this.getHelper());
    }

    SQLFragment createFragment(ParseNode node, SQLFragment creating, Object context, OracleSQLQueryBuilderHelper helper) throws SQLQueryException {
        OracleSQLQueryBuilderHelper existingHelper = (OracleSQLQueryBuilderHelper)this.m_helper.get();
        if (existingHelper == null) {
            throw new IllegalStateException("Cannot call createFragment outside of a parseSQL operation");
        }
        if (helper != existingHelper) {
            throw new IllegalStateException("Must use the current helper");
        }
        ExpressionContext expContext = new ExpressionContext(this, this.getSQLQuery(), (DBObjectProvider)this.getProvider(), this.getDefaultSchema(), helper, context, creating);
        SQLFragment retval = null;
        SQLQueryException caughtExceptions = null;
        for (ExpressionFactory f : this.m_expressionFactories) {
            this.checkCancelled();
            try {
                retval = f.createFragment(expContext, node);
                if (retval == null) continue;
                break;
            }
            catch (SQLQueryCancelledException sqce) {
                throw sqce;
            }
            catch (SQLQueryException sqe) {
                if (caughtExceptions == null) {
                    caughtExceptions = sqe;
                    continue;
                }
                caughtExceptions.setNextException((DBException)((Object)sqe));
            }
        }
        if (retval == null && helper.isLeaf(node)) {
            this.checkCancelled();
            retval = this.createFromFactory(creating, helper.getContent(node), helper.getNodeStartOffset(node));
        }
        if (retval == null) {
            Level level;
            String sourceFragment = helper.getSourceFragment(node);
            Logger logger = this.getLogger();
            if (logger.isLoggable(level = Level.FINEST)) {
                String rules = node.toString();
                logger.log(level, "OracleSQLQueryBuilder: Node cannot be built - Unrecognized SQL fragment\n Rules: " + rules + "\n" + " Source fragment: " + sourceFragment);
            }
            if (caughtExceptions == null) {
                caughtExceptions = new UnrecognizedFragmentException(sourceFragment);
            }
            this.throwException(caughtExceptions);
        } else {
            ((AbstractSQLFragment)retval).setStartOffset(Integer.valueOf(helper.getNodeStartOffset(node)));
        }
        return retval;
    }

    protected void checkCancelled() throws SQLQueryCancelledException {
        super.checkCancelled();
        if (this.m_parentBuilder != null) {
            this.m_parentBuilder.checkCancelled();
        }
    }

    public FromObjectUsage findColumnInFromExpression(String colName, boolean external, SQLFragment exp, boolean allowDuplicates, FromObject from, SQLFragment creating) throws SQLQueryException {
        FromObjectUsage found = super.findColumnInFromExpression(colName, external, exp, allowDuplicates, from, creating);
        if (found == null && exp instanceof XMLFunctionUsage && "XMLTABLE".equals(((XMLFunctionUsage)exp).getFunction())) {
            OracleSQLQueryBuilderHelper helper = this.getHelper();
            ArrayList<String> colNames = new ArrayList<String>();
            ParseNode xmltableNode = helper.getNodeAtOffset(exp.getStartOffset());
            if (xmltableNode != null) {
                for (ParseNode dec : xmltableNode.descendants()) {
                    List<ParseNode> oc;
                    if (!helper.isRule(dec, "XML_table_column") || (oc = helper.getOrderedChildren(dec)) == null || oc.size() <= 0) continue;
                    colNames.add(helper.getContent(oc.get(0)));
                }
            }
            DatabaseDescriptor desc = this.getProvider().getDescriptor();
            String externalColName = external ? colName : desc.getExternalName(colName, "COLUMN");
            for (String extName : colNames) {
                if (!desc.areNamesEqual(externalColName, extName, "COLUMN", true)) continue;
                found = new ColumnKeywordUsage(colName, from);
                break;
            }
        }
        return found;
    }

    public FromObjectUsage findColumnInFromObjects(String colName, boolean external, SQLFragment creating, FromObject ... extraFroms) throws SQLQueryException {
        FromObjectUsage retval = super.findColumnInFromObjects(colName, external, creating, extraFroms);
        if (retval == null && this.m_parentBuilder != null) {
            retval = this.m_parentBuilder.findColumnInFromObjects(colName, external, creating, new FromObject[0]);
        }
        return retval;
    }

    private WhereObject createWhere(ParseNode sql) throws SQLQueryException {
        return this.createWhere(sql, null);
    }

    private WhereObject createWhere(ParseNode sql, SQLFragment creating) throws SQLQueryException {
        WhereObject retval = null;
        OracleSQLQueryBuilderHelper helper = this.getHelper();
        if (helper.isRule(sql, "where_clause")) {
            ParseNode condition = helper.getOrderedChildren(sql).get(1);
            retval = new WhereObject(this.createFragment(condition, creating, null));
        } else {
            retval = new WhereObject(this.createFragment(sql, creating, null));
        }
        return retval;
    }

    private HierarchicalQueryObject createHierarchicalQuery(ParseNode hqNode) throws SQLQueryException {
        HierarchicalQueryObject retval = null;
        OracleSQLQueryBuilderHelper helper = this.getHelper();
        List<ParseNode> kids = helper.getOrderedChildren(hqNode);
        boolean startWithFirst = helper.getKeywordIndex(kids, "START") == 0;
        boolean noCycle = helper.getKeywordIndex(kids, "NOCYCLE") != -1;
        retval = new HierarchicalQueryObject(null, null, startWithFirst, noCycle);
        SQLFragment startWith = null;
        SQLFragment connectBy = null;
        boolean doingConnect = false;
        ArrayList<SQLFragment> connectByConditions = new ArrayList<SQLFragment>();
        for (ParseNode condition : kids) {
            if (helper.isKeyword(condition, "CONNECT")) {
                doingConnect = true;
            }
            if (helper.isKeyword(condition, "START")) {
                doingConnect = false;
                continue;
            }
            if (!helper.isRule(condition, "condition")) continue;
            if (doingConnect) {
                connectByConditions.add(this.createFragment(condition, (SQLFragment)retval, null));
                continue;
            }
            startWith = this.createFragment(condition, (SQLFragment)retval, null);
        }
        if (connectByConditions.size() > 1) {
            connectBy = new WhereObject(connectByConditions.toArray(new SQLFragment[connectByConditions.size()]), WhereObject.WhereOperator.AND);
        } else if (connectByConditions.size() == 1) {
            connectBy = (SQLFragment)connectByConditions.get(0);
        }
        retval.setConnectBy(connectBy);
        retval.setStartWith(startWith);
        return retval;
    }

    private List<List<ParseNode>> getGroupByCommaSeparatedList(List<ParseNode> gbexprs) {
        OracleSQLQueryBuilderHelper helper = this.getHelper();
        if (gbexprs.size() == 1 && helper.isRule(gbexprs.get(0), "parenthesized_group_by_list") && !helper.isRule(gbexprs.get(0), "group_by_col") && (gbexprs = helper.getOrderedChildren(gbexprs.get(0))).size() == 3 && helper.isRule(gbexprs.get(1), "group_by_list")) {
            gbexprs = helper.getOrderedChildren(gbexprs.get(1));
        }
        List<List<ParseNode>> retval = helper.getCommaSeparatedList(gbexprs);
        return retval;
    }

    private GroupByObject createGroupBy(ParseNode groupByNode) throws SQLQueryException {
        ParseNode havingCondition = null;
        OracleSQLQueryBuilderHelper helper = this.getHelper();
        List<ParseNode> kids = helper.getOrderedChildren(groupByNode);
        int havingIndex = helper.getKeywordIndex(kids, "HAVING");
        if (havingIndex == -1) {
            havingIndex = kids.size();
        } else {
            havingCondition = kids.get(havingIndex + 1);
        }
        List<List<ParseNode>> groupByExprs = this.getGroupByCommaSeparatedList(kids.subList(2, havingIndex));
        GroupByObject retval = new GroupByObject();
        SQLFragment[] frags = new SQLFragment[groupByExprs.size()];
        for (int i = 0; i < groupByExprs.size(); ++i) {
            SQLFragment f = this.createFragment(groupByExprs.get(i).get(0), (SQLFragment)retval, null);
            if (f != null) {
                frags[i] = f;
                continue;
            }
            this.throwException(new SQLQueryException(APIBundle.get((String)"SQL_GROUPBY_EXPRESSION_UNKNOWN")));
        }
        retval.setExpressions(frags);
        if (havingCondition != null) {
            WhereObject hv = this.createWhere(havingCondition);
            retval.setHaving(hv);
        }
        return retval;
    }

    private ModelObject createModel(ParseNode modelNode) throws SQLQueryException {
        ModelObject retval = null;
        retval = (ModelObject)this.createFragment(modelNode, null, null);
        return retval;
    }

    private void checkLength(String expression) throws SQLQueryException {
        if (!ModelUtil.hasLength((String)expression)) {
            this.throwException(new SQLQueryException(APIBundle.get((String)"SQL_EMPTY_EXP")));
        }
    }

    public FromObjectUsage findColumnInRelation(String colName, boolean external, Relation rel) throws SQLQueryException {
        if (this.getProvider().getDescriptor().areNamesEqual(colName, "ROWID", "COLUMN", external)) {
            ColumnKeywordUsage c = new ColumnKeywordUsage();
            c.setColumnName(colName);
            return c;
        }
        return super.findColumnInRelation(colName, external, rel);
    }

    public void ensureQueryNonDeclarative(final SQLQueryOwner owner) {
        final SQLQuery query = owner.getSQLQuery();
        if (query != null) {
            final String origtext = query.getSQLText();
            this.parseSQL(origtext, new HelperCallable<Object, RuntimeException>(){

                @Override
                public Object process(OracleSQLQueryBuilderHelper helper) {
                    String newtext = origtext;
                    try {
                        if (owner instanceof Relation) {
                            List<ParseNode> queryRootKids = helper.getQueryRootKids();
                            List<ParseNode> selectItemNodes = helper.getSelectItemNodes(queryRootKids);
                            List qcis = OracleSQLQueryBuilder.this.getQueryColumnInfosImpl(helper);
                            Column[] cols = ((Relation)owner).getColumns();
                            if (cols.length == 0) {
                                cols = new Column[selectItemNodes.size()];
                                for (int i = 0; i < selectItemNodes.size(); ++i) {
                                    cols[i] = new Column("COL" + (i + 1));
                                }
                            }
                            StringBuilder newtextBuilder = new StringBuilder(origtext);
                            int moved = 0;
                            if (selectItemNodes != null && selectItemNodes.size() == cols.length) {
                                for (int i = 0; i < selectItemNodes.size(); ++i) {
                                    boolean hasAlias;
                                    ParseNode selectItemNode = selectItemNodes.get(i);
                                    boolean bl = hasAlias = ((AbstractSQLQueryBuilder.QueryColumnInfo)qcis.get(i)).getName() != null;
                                    if (hasAlias) continue;
                                    int startOfNext = -1;
                                    if (i < selectItemNodes.size() - 1) {
                                        startOfNext = helper.getNodeStartOffset(selectItemNodes.get(i + 1));
                                        startOfNext = origtext.lastIndexOf(",", startOfNext);
                                    } else {
                                        ParseNode fromClauseNode = helper.getRuleNode(queryRootKids, "from_clause");
                                        List<ParseNode> fromClauseKids = helper.getOrderedChildren(fromClauseNode);
                                        ParseNode fromNode = fromClauseKids.get(0);
                                        startOfNext = helper.getNodeStartOffset(fromNode);
                                    }
                                    int selectItemNodeStart = helper.getNodeStartOffset(selectItemNode);
                                    String exp = origtext.substring(selectItemNodeStart, startOfNext).trim();
                                    String colName = cols[i].getName();
                                    if (startOfNext <= 0 || exp.contains("*") || exp.toUpperCase().endsWith("." + colName.toUpperCase()) || OracleSQLQueryBuilder.this.getProvider().isValidName("COLUMN", exp)) continue;
                                    String toInsert = " " + colName + " ";
                                    newtextBuilder.insert(moved + startOfNext, toInsert);
                                    OracleSQLQueryBuilder.this.getLogger().log(Level.INFO, APIBundle.format((String)"VIEW_COLUMN_HACK", (Object[])new Object[]{toInsert, exp, owner.getType(), owner.getName()}));
                                    moved += toInsert.length();
                                }
                            }
                            newtext = newtextBuilder.toString();
                        }
                    }
                    catch (DBException dbe) {
                        OracleSQLQueryBuilder.this.getLogger().log(Level.WARNING, APIBundle.format((String)"WARNING_ERROR_PROCESSING_VIEW", (Object[])new Object[]{owner.getType(), owner.getName(), origtext, dbe.getMessage()}));
                    }
                    catch (Exception e) {
                        OracleSQLQueryBuilder.this.getLogger().log(Level.SEVERE, "Error processing view", e);
                    }
                    query.setQueryString(newtext);
                    query.setDeclarative(false);
                    if (owner instanceof Relation) {
                        OracleSQLQueryBuilder.this.removeViewColumns((Relation)owner);
                    }
                    return null;
                }
            });
        }
    }

    private void removeViewColumns(Relation owner) {
        Object val = DBUtil.getFrozenProperties((DBObject)owner).get("columns");
        if (val instanceof Column[]) {
            for (Column c : (Column[])val) {
                if (!(c instanceof ViewColumn)) continue;
                owner.setColumns(null);
                break;
            }
        }
    }

    public String buildErrorMessage(ParseNode n, String mess) {
        String nodeSource = this.getHelper().getSourceFragment(n);
        return APIBundle.format((String)"SQL_RQB_ERROR", (Object[])new Object[]{mess, nodeSource});
    }

    private void removeTemporaryObjectIDs(SQLFragment frag) {
        if (frag != null) {
            DBObject[] children;
            if (frag.getID() instanceof TemporaryObjectID) {
                frag.setID(null);
            }
            if ((children = frag.getOwnedObjects()) != null) {
                for (DBObject child : children) {
                    if (!(child instanceof SQLFragment)) continue;
                    this.removeTemporaryObjectIDs((SQLFragment)child);
                }
            }
        }
    }

    public void addSetOperatorObject(SetOperator select) throws SQLQueryException {
    }

    protected Function createFunction(String func, SQLFragment[] args, String source) throws SQLQueryException {
        if (ModelUtil.hasLength((String)func)) {
            if (func.equals("CAST")) {
                if (args.length != 2) {
                    this.throwException((SQLQueryException)new SQLQueryClauseException(args[0], "usage: CAST( expr, type )"));
                }
                if (args[0] instanceof SQLQuery) {
                    args[0] = new Function("MULTISET", new SQLFragment[]{args[0]});
                    this.setFunctionReturnTypeID((Function)args[0]);
                }
                Function f = new Function(func, args, " AS ");
                this.setFunctionReturnTypeID(f);
                return f;
            }
            if (func.equals("CONCAT")) {
                if (source != null && source.equals("||")) {
                    Function f = new Function(source, args);
                    this.setFunctionReturnTypeID(f);
                    return f;
                }
            } else {
                if (func.equals("TRANSLATE") && args.length == 2) {
                    Function f = new Function(func, args, " USING ");
                    this.setFunctionReturnTypeID(f);
                    return f;
                }
                if (func.equals("LTRIM") && "LEADING".equals(source) || func.equals("RTRIM") && "TRAILING".equals(source) || func.equals("TRIM") && "BOTH".equals(source)) {
                    String leader = source;
                    if (args.length == 2) {
                        this.swapFirstTwoArgs(args);
                    } else {
                        leader = source + " FROM";
                    }
                    Function f = new Function("TRIM", args, " FROM ");
                    this.setFunctionReturnTypeID(f);
                    f.setTrimLeader(leader);
                    return f;
                }
                if (func.equals("TRIM") && args.length == 2) {
                    this.swapFirstTwoArgs(args);
                    Function f = new Function(func, args, " FROM ");
                    this.setFunctionReturnTypeID(f);
                    return f;
                }
            }
            boolean grouping = false;
            for (BuiltInFunction bif : this.getProvider().getDescriptor().listBuiltInFunctions(func)) {
                if (!bif.isAggregate()) continue;
                grouping = true;
                break;
            }
            Function f = new Function(func, args, grouping);
            this.setFunctionReturnTypeID(f);
            return f;
        }
        return null;
    }

    private void swapFirstTwoArgs(SQLFragment[] args) {
        SQLFragment one = args[1];
        args[1] = args[0];
        args[0] = one;
    }

    public static String fixEmptySelectClause(String sql) {
        String retval = sql;
        try {
            String select = "SELECT";
            String from = "FROM";
            String upper = retval.toUpperCase();
            int isel = upper.indexOf("SELECT");
            int ifrom = upper.indexOf("FROM");
            int ifromLen = "FROM".length();
            while (ifrom > 0) {
                char after;
                char before = upper.charAt(ifrom - 1);
                char c = after = ifrom < upper.length() - ifromLen ? upper.charAt(ifrom + ifromLen) : (char)'\u0000';
                if (Character.isWhitespace(before) && Character.isWhitespace(after)) {
                    int selLen = "SELECT".length();
                    String between = upper.substring(isel + selLen, ifrom);
                    if (between.trim().length() == 0) {
                        retval = retval.substring(0, isel + selLen) + " *" + retval.substring(isel + selLen);
                    }
                    break;
                }
                ifrom = upper.indexOf("FROM", ifrom + 1);
            }
        }
        catch (Exception e) {
            DBLog.getLogger(OracleSQLQueryBuilder.class).log(Level.SEVERE, "Couldn't fix query", e);
        }
        return retval;
    }

    void setFunctionReturnTypeID(Function function) throws SQLQueryException {
        SQLFragment[] tableArgs;
        AbstractDBObjectProvider pro = this.getProvider();
        DBObjectID dataTypeID = null;
        BuiltInFunction func = null;
        if (pro != null) {
            for (BuiltInFunction bif : pro.getDescriptor().listBuiltInFunctions(function.getFunction())) {
                if (func == null) {
                    func = bif;
                    continue;
                }
                if (func.isAggregate() != function.isGrouping() && bif.isAggregate() == function.isGrouping()) {
                    func = bif;
                    continue;
                }
                int numArgs = function.getArgumentCount();
                if (bif.getMinArgs() > numArgs || bif.getMaxArgs() < numArgs || func.getMinArgs() <= numArgs && func.getMaxArgs() >= numArgs) continue;
                func = bif;
            }
        }
        if (func != null) {
            Integer argNo = func.getArgumentDefiningReturnType();
            if (argNo != null && argNo <= function.getArgumentCount() && function.getArguments()[argNo - 1] instanceof SQLFragmentWithDatatype) {
                SQLFragmentWithDatatype dtFrag = (SQLFragmentWithDatatype)function.getArguments()[argNo - 1];
                if (dtFrag instanceof ColumnUsage) {
                    DataTypeUsage dtu;
                    DBObjectID colID = ((ColumnUsage)dtFrag).getObjectID();
                    DBObject obj = this.resolveID(colID);
                    if (obj instanceof Column && (dtu = ((Column)obj).getDataTypeUsage()) != null) {
                        dataTypeID = dtu.getDataTypeID();
                    }
                } else {
                    dataTypeID = dtFrag.getDataTypeID();
                }
            } else {
                dataTypeID = func.getReturnTypeID();
            }
            if (dataTypeID instanceof DataTypeID) {
                ((DataTypeID)dataTypeID).ensureProvider((DBObjectProvider)pro);
            } else if (dataTypeID instanceof BaseObjectID) {
                ((BaseObjectID)dataTypeID).setProvider((DBObjectProvider)pro);
            }
        } else if ("TABLE".equals(function.getFunction()) && (tableArgs = function.getArguments()).length > 0) {
            SQLFragment[] castArgs;
            SQLFragment lastArg = tableArgs[tableArgs.length - 1];
            if (lastArg instanceof FunctionUsage) {
                DBObjectID id = ((FunctionUsage)lastArg).getObjectID();
                DBObject obj = this.resolveID(id);
                if (obj instanceof SQLCallable) {
                    dataTypeID = ((SQLCallable)obj).getReturnTypeID();
                }
            } else if (lastArg instanceof ColumnUsage) {
                DBObjectID id = ((ColumnUsage)lastArg).getObjectID();
                DBObject obj = this.resolveID(id);
                if (obj instanceof Column) {
                    dataTypeID = ((Column)obj).getDataTypeUsage().getDataTypeID();
                }
            } else if (lastArg instanceof Function && "CAST".equals(((Function)lastArg).getFunction()) && (castArgs = ((Function)lastArg).getArguments()).length > 0) {
                SQLFragment dataTypeFrag = castArgs[castArgs.length - 1];
                dataTypeID = DataTypeHelper.findIDForTypeString((DBObjectProvider)this.getProvider(), (Schema)this.getDefaultSchema(), (String)dataTypeFrag.getSQLText());
            }
        }
        function.setDataTypeID(dataTypeID);
    }

    private static abstract class HelperCallable<T, E extends Exception> {
        private HelperCallable() {
        }

        public abstract T process(OracleSQLQueryBuilderHelper var1) throws E;
    }

    private class LinkSchemaTableAndAlias {
        private String m_link = null;
        private String m_schema = null;
        private String m_table = null;
        private String m_alias = null;

        LinkSchemaTableAndAlias() {
        }

        LinkSchemaTableAndAlias(String link, String schema, String table, String alias) {
            this.m_link = link;
            this.m_schema = schema;
            this.m_table = table;
            this.m_alias = alias;
        }

        private String getLink() {
            return this.m_link;
        }

        private void setSchema(String schema) {
            this.m_schema = schema;
        }

        private String getSchema() {
            return this.m_schema;
        }

        private void setTable(String table) {
            this.m_table = table;
        }

        private String getTable() {
            return this.m_table;
        }

        private void setAlias(String alias) {
            this.m_alias = alias;
        }

        private String getAlias() {
            return this.m_alias;
        }
    }
}

