/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sql;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import oracle.dbtools.parser.ParseNode;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Relation;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Sequence;
import oracle.javatools.db.ora.sql.ExpressionContext;
import oracle.javatools.db.ora.sql.ExpressionFactory;
import oracle.javatools.db.ora.sql.OracleSQLQueryBuilder;
import oracle.javatools.db.ora.sql.OracleSQLQueryBuilderHelper;
import oracle.javatools.db.ora.sql.UnrecognizedFragmentException;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.sql.ColumnKeywordUsage;
import oracle.javatools.db.sql.ColumnUsage;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.FunctionUsage;
import oracle.javatools.db.sql.OrderByObject;
import oracle.javatools.db.sql.RelationUsage;
import oracle.javatools.db.sql.SQLCallable;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryCancelledException;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.SelectObject;
import oracle.javatools.db.sql.SelectObjectUsage;
import oracle.javatools.db.sql.SequenceUsage;
import oracle.javatools.db.sql.SynonymUsage;
import oracle.javatools.util.ModelUtil;

public class ColumnBuilder
extends ExpressionFactory {
    @Override
    public SQLFragment createFragment(ExpressionContext context, ParseNode node) throws SQLQueryException {
        SQLFragment retval;
        SQLQueryException saveException;
        block9: {
            saveException = null;
            retval = null;
            OracleSQLQueryBuilderHelper helper = context.getHelper();
            if (helper.isLeaf(node) || helper.isDotSeperatedList(node) || helper.isRule(node, "column", "col_oj")) {
                Object queryContext = context.getQueryContext();
                if (queryContext instanceof String && "MAKE_REF".equalsIgnoreCase((String)queryContext)) {
                    retval = this.createColumnUsage(node, context);
                } else {
                    try {
                        retval = this.createColumnUsage(node, context);
                    }
                    catch (SQLQueryCancelledException sqce) {
                        throw sqce;
                    }
                    catch (SQLQueryException e) {
                        saveException = e;
                        retval = this.createFunctionUsageFromSqlColdef(node, context);
                        if (retval != null) break block9;
                        List<ParseNode> l = helper.getDotSeparatedList(node);
                        StringBuilder sb = new StringBuilder();
                        for (ParseNode n : l) {
                            if (sb.length() != 0) {
                                sb.append(".");
                            }
                            sb.append(helper.getContent(n));
                        }
                        retval = context.getQueryBuilder().createFromFactory(context.getCreating(), sb.toString(), helper.getNodeStartOffset(node));
                    }
                }
            }
        }
        if (saveException != null && retval == null) {
            throw saveException;
        }
        return retval;
    }

    private FunctionUsage createFunctionUsageFromSqlColdef(ParseNode node, ExpressionContext context) {
        FunctionUsage retval = null;
        OracleSQLQueryBuilderHelper helper = context.getHelper();
        List<ParseNode> l = helper.getDotSeparatedList(node);
        String userName = null;
        String tableName = null;
        String colName = null;
        boolean allLeaves = true;
        for (ParseNode parseNode : l) {
            if (helper.isLeaf(parseNode)) continue;
            allLeaves = false;
            break;
        }
        if (allLeaves) {
            DBObjectID dBObjectID;
            if (l.size() >= 3) {
                userName = helper.getContent(l.get(0));
                l.remove(0);
            }
            if (l.size() >= 2) {
                tableName = helper.getContent(l.get(0));
                l.remove(0);
            }
            if (l.size() >= 1) {
                colName = helper.getContent(l.get(0));
                l.remove(0);
            }
            ArrayList<String> attributes = new ArrayList<String>();
            for (ParseNode parseNode : l) {
                attributes.add(helper.getContent(parseNode));
            }
            StringBuilder stringBuilder = new StringBuilder();
            if (ModelUtil.hasLength((String)userName)) {
                stringBuilder.append(".").append(userName);
            }
            if (ModelUtil.hasLength((String)tableName)) {
                stringBuilder.append(".").append(tableName);
            }
            if (ModelUtil.hasLength((String)colName)) {
                stringBuilder.append(".").append(colName);
                for (String s : attributes) {
                    stringBuilder.append(".").append(s);
                }
            }
            if ((dBObjectID = context.findIdForFunctionString(stringBuilder.substring(1))) != null && !(dBObjectID instanceof ReferenceID)) {
                retval = new FunctionUsage();
                retval.setObjectID(dBObjectID);
            }
        }
        return retval;
    }

    private SQLFragment createColumnUsage(ParseNode columnDef, ExpressionContext context) throws SQLQueryException {
        ColumnKeywordUsage retval = null;
        OracleSQLQueryBuilderHelper helper = context.getHelper();
        OracleSQLQueryBuilder queryBuilder = context.getQueryBuilder();
        SQLFragment creating = context.getCreating();
        boolean isOuterJoin = false;
        if (helper.isRule(columnDef, "col_oj")) {
            isOuterJoin = true;
            columnDef = helper.getOrderedChildren(columnDef).get(0);
        }
        List<String> bits = this.getBits(columnDef, context);
        ArrayList<String> bitsCopy = new ArrayList<String>(bits);
        int colindex = 0;
        FromObject extraFrom = creating instanceof FromObject ? (FromObject)creating : null;
        FromObject from = null;
        String parentName = null;
        if (bits.size() > 1) {
            ++colindex;
            parentName = bits.remove(0);
            from = context.findFromObject(parentName, extraFrom);
            if (from == null && bits.size() > 0 && (from = context.findFromObject(parentName = parentName + "." + bits.get(0), extraFrom)) != null) {
                ++colindex;
                bits.remove(0);
            }
            if (from == null) {
                String schemaName = context.getDefaultSchemaName();
                ReferenceID par = null;
                ReferenceID id = null;
                for (String bit : bitsCopy) {
                    DBObjectProvider pro = context.getProvider();
                    id = new ReferenceID("UNSPECIFIED_TYPE", schemaName, pro.getInternalName(bit));
                    id.setParent(par);
                    id.setProvider(pro);
                    schemaName = null;
                    par = id;
                }
                if (id != null) {
                    DBObject ref = null;
                    try {
                        ref = id.resolveID();
                    }
                    catch (DBException e) {
                        ref = null;
                    }
                    if (ref instanceof SQLCallable) {
                        FunctionUsage fu = new FunctionUsage();
                        fu.setObjectID(ref.getID());
                        retval = fu;
                    } else {
                        String name = id.getName();
                        if (ref == null && bitsCopy.size() >= 2 && ("NEXTVAL".equals(name) || "CURRVAL".equals(name))) {
                            try {
                                ref = id.getParent().resolveID();
                                if (ref instanceof Sequence) {
                                    SequenceUsage su = new SequenceUsage();
                                    su.setObjectID(ref.getID());
                                    su.setMode(SequenceUsage.Mode.valueOf((String)name));
                                    retval = su;
                                }
                            }
                            catch (DBException e) {
                                ref = null;
                            }
                        }
                    }
                }
            }
            if (from == null && retval == null) {
                queryBuilder.throwException(new SQLQueryException(APIBundle.format((String)"SQL_CANT_FIND_FROM", (Object[])new Object[]{parentName})));
            }
        }
        if (retval == null) {
            String externalColName = bits.remove(0);
            ColumnKeywordUsage fromObjUsage = null;
            if ("*".equals(externalColName)) {
                fromObjUsage = new ColumnKeywordUsage(externalColName, from);
            } else if (from == null) {
                fromObjUsage = queryBuilder.findColumnInFromObjects(externalColName, true, creating, extraFrom);
                if (fromObjUsage == null) {
                    if (creating instanceof OrderByObject) {
                        DatabaseDescriptor desc = context.getProvider().getDescriptor();
                        for (SelectObject select : context.getQuery().getSelectObjects()) {
                            String selectName = select.getUsableAlias();
                            if (selectName == null || !desc.areNamesEqual(externalColName, selectName, "COLUMN", true)) continue;
                            queryBuilder.ensureID((DBObject)select);
                            fromObjUsage = new SelectObjectUsage(select, null);
                            break;
                        }
                    }
                    if (fromObjUsage == null) {
                        queryBuilder.throwException(new SQLQueryException(APIBundle.format((String)"SQL_CANT_RESOLVE_COL", (Object[])new Object[]{externalColName})));
                    }
                }
            } else {
                queryBuilder.ensureID((DBObject)from);
                SQLFragment exp = from.getExpression();
                if (exp instanceof RelationUsage) {
                    fromObjUsage = queryBuilder.findColumnInRelation(externalColName, true, (RelationUsage)exp);
                    if (fromObjUsage == null) {
                        queryBuilder.throwException(new SQLQueryException(APIBundle.format((String)"SQL_NO_COL_ON_REL", (Object[])new Object[]{externalColName, parentName})));
                    }
                } else if (exp instanceof SQLQuery) {
                    SQLQuery sqlQuery = (SQLQuery)exp;
                    fromObjUsage = queryBuilder.findColumnInSubQuery(externalColName, true, sqlQuery);
                    if (fromObjUsage == null) {
                        fromObjUsage = queryBuilder.findColumnInStarSubQuery(externalColName, true, from);
                    }
                    if (fromObjUsage == null) {
                        queryBuilder.throwException(new SQLQueryException(APIBundle.format((String)"SQL_NO_COL_IN_QUERY", (Object[])new Object[]{externalColName})));
                    }
                } else if (exp instanceof SynonymUsage) {
                    SchemaObject obj = ((SynonymUsage)exp).getReferencedObject();
                    if (obj instanceof Relation) {
                        fromObjUsage = queryBuilder.findColumnInRelation(externalColName, true, (Relation)obj);
                    }
                    if (fromObjUsage == null) {
                        queryBuilder.throwException(new SQLQueryException(APIBundle.format((String)"SQL_NO_COL_ON_SYN", (Object[])new Object[]{externalColName, parentName})));
                    } else {
                        fromObjUsage.setFromObjectID(from.getID());
                    }
                } else {
                    fromObjUsage = queryBuilder.findColumnInFromExpression(externalColName, true, exp, false, from, creating);
                    if (fromObjUsage == null) {
                        queryBuilder.throwException(new SQLQueryException(APIBundle.format((String)"SQL_MISSING_COL", (Object[])new Object[]{externalColName, parentName})));
                    }
                }
            }
            fromObjUsage.setQualified(colindex > 0);
            if (fromObjUsage instanceof ColumnUsage) {
                if (bits.size() > 0) {
                    ((ColumnUsage)fromObjUsage).setAttributes(bits.toArray(new String[bits.size()]));
                }
                if (isOuterJoin) {
                    ((ColumnUsage)fromObjUsage).setOuterJoin(true);
                }
            }
            retval = fromObjUsage;
        }
        return retval;
    }

    private List<String> getBits(ParseNode dotSeparatedListNode, ExpressionContext context) throws SQLQueryException {
        ArrayList<String> bits = new ArrayList<String>();
        OracleSQLQueryBuilderHelper helper = context.getHelper();
        if (helper.isLeaf(dotSeparatedListNode)) {
            bits.add(helper.getContent(dotSeparatedListNode));
        } else if (helper.isDotSeperatedList(dotSeparatedListNode)) {
            List<ParseNode> l = helper.getDotSeparatedList(dotSeparatedListNode);
            for (ParseNode n : l) {
                if (helper.isLeaf(n)) {
                    bits.add(helper.getContent(n));
                    continue;
                }
                bits.addAll(this.getBits(n, context));
            }
        } else {
            String rules = dotSeparatedListNode.toString();
            String sourceFragment = helper.getSourceFragment(dotSeparatedListNode);
            DBLog.getLogger().log(Level.FINEST, "OracleSQLQueryBuilder: Node cannot be built - Unrecognized SQL fragment\n Rules: " + rules + "\n" + " Source fragment: " + sourceFragment);
            throw new UnrecognizedFragmentException(helper.getSourceFragment(dotSeparatedListNode));
        }
        return bits;
    }
}

