/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.View;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.OracleRelationBuilder;
import oracle.javatools.db.sql.SQLQuery;

public class OracleViewBuilder
extends OracleRelationBuilder<View> {
    protected OracleViewBuilder(BaseOracleDatabase db) {
        super(db, "VIEW");
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"SQLQuery", "restriction"})
    public void fillInQueryText(final View view) throws DBException {
        final QueryWrapper wrap = this.getDatabase().newQueryWrapper((SystemObject)view, "SELECT /*OracleDictionaryQueries.ALL_VIEW_TEXT_QUERY*/\n       TEXT_LENGTH, TEXT FROM SYS.ALL_VIEWS WHERE OWNER = ? AND VIEW_NAME = ?", view.getSchema(), view);
        QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet rs) throws DBException {
                try {
                    if (rs.next()) {
                        int len = rs.getInt(1);
                        String txt = rs.getString(2);
                        if (txt != null) {
                            if ((txt = txt.trim()).toUpperCase().trim().endsWith(View.Restriction.CHECK_OPTION.toString())) {
                                view.setRestriction(View.Restriction.CHECK_OPTION);
                                txt = txt.substring(0, txt.toUpperCase().lastIndexOf("WITH") - 1);
                            } else if (txt.toUpperCase().trim().endsWith(View.Restriction.READ_ONLY.toString())) {
                                view.setRestriction(View.Restriction.READ_ONLY);
                                txt = txt.substring(0, txt.toUpperCase().lastIndexOf("WITH") - 1);
                            }
                            SQLQuery query = (SQLQuery)OracleViewBuilder.this.newObject(SQLQuery.class, null);
                            query.setQueryString(txt);
                            view.setSQLQuery(query);
                        }
                    }
                }
                catch (SQLException ex) {
                    wrap.throwDBException((DBObject)view, ex);
                }
            }
        };
        wrap.executeQuery(r);
    }

    @Override
    @AbstractDBObjectBuilder.PropertyBuilder(value={"constraints"})
    public void fillInConstraints(View relation) throws DBException {
        super.fillInConstraints(relation);
    }

    protected boolean canBuildComponents() {
        return true;
    }
}

