/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.javatools.db.AbstractBuildableObject;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.SourceObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.OracleDBObjectBuilder;
import oracle.javatools.db.property.Metadata;

public abstract class OracleSourceBuilder<T extends AbstractBuildableObject>
extends OracleDBObjectBuilder<T> {
    OracleSourceBuilder(BaseOracleDatabase db, String type) {
        super(db, type);
        if (!Metadata.getInstance().isTypeOf(SourceObject.class, type)) {
            throw new IllegalArgumentException("Invalid SourceObject type: " + type);
        }
    }

    protected boolean canBuildComponents() {
        return true;
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"source"})
    public void fillInSource(T so) throws DBException {
        String source = this.getSource((SourceObject)so);
        ((SourceObject)so).setSource(source);
    }

    protected abstract String getQuery();

    protected String getSource(final SourceObject src) throws DBException {
        final StringBuilder buf = new StringBuilder();
        String type = this.getObjectType();
        final QueryWrapper wrap = this.getDatabase().newQueryWrapper((SystemObject)src, this.getQuery(), type, src.getSchema(), src);
        QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet rs) throws DBException {
                try {
                    while (rs.next()) {
                        String line = rs.getString(1);
                        if (line != null) {
                            buf.append(line);
                            if (line.endsWith("\n")) continue;
                            buf.append('\n');
                            continue;
                        }
                        buf.append('\n');
                    }
                }
                catch (SQLException ex) {
                    wrap.throwDBException((DBObject)src, ex);
                }
            }
        };
        wrap.executeQuery(r);
        String retval = null;
        if (buf.length() > 0) {
            retval = buf.toString().trim();
        }
        return retval;
    }
}

