/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.util.ArrayList;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.ora.OracleExternalTableProperties;
import oracle.javatools.db.ora.bigdata.BigDataAccessParameter;
import oracle.javatools.db.ora.bigdata.BigDataAccessParameterMetadata;
import oracle.javatools.db.ora.bigdata.BigDataAccessParameters;
import oracle.javatools.db.property.DerivedPropertyBuilder;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.util.ModelUtil;

public class ExternalTablePropertiesBuilder
extends DerivedPropertyBuilder<OracleExternalTableProperties> {
    public ExternalTablePropertiesBuilder(AbstractDBObjectProvider pro) {
        super(pro, "EXTERNAL TABLE PROPERTIES");
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"accessParametersFragment"})
    public void buildAccessParameters(OracleExternalTableProperties props) throws DBException {
        String driver;
        String source = props.getAccessParameters();
        if (source != null && source.trim().length() > 0 && BigDataAccessParameterMetadata.isBigDataAccessDriver((String)(driver = props.getAccessDriverType()))) {
            source = source.replace("\r\n", "\n");
            ArrayList<BigDataAccessParameter> params = new ArrayList<BigDataAccessParameter>();
            boolean name = true;
            StringBuilder buff = new StringBuilder();
            BigDataAccessParameter current = (BigDataAccessParameter)this.newObject(BigDataAccessParameter.class, null);
            int last = 48;
            for (int i = 0; i < source.length(); ++i) {
                boolean finishCurrentParam;
                char c = source.charAt(i);
                boolean bl = finishCurrentParam = i == source.length() - 1;
                if (c == '\n' && last != 92) {
                    finishCurrentParam = true;
                } else if (name && (c == ':' || c == '=' || buff.length() > 0 && Character.isSpaceChar(c))) {
                    name = false;
                    current.setName(buff.toString());
                    buff = new StringBuilder();
                } else if (buff.length() == 0 && c == '-' && i + 1 < source.length() && source.charAt(i + 1) == '-') {
                    i = source.indexOf(10, i);
                } else if (buff.length() != 0 || !Character.isWhitespace(c)) {
                    buff.append(c);
                }
                last = c;
                if (!finishCurrentParam) continue;
                if (name) {
                    current.setName(buff.toString());
                } else {
                    current.setParameterValue(buff.toString());
                }
                buff = new StringBuilder();
                if (!name || ModelUtil.hasLength((String)current.getName()) || ModelUtil.hasLength((String)current.getParameterValue())) {
                    params.add(current);
                    current = (BigDataAccessParameter)this.newObject(BigDataAccessParameter.class, null);
                }
                name = true;
            }
            if (params.size() == 0) {
                throw new DBException((DBObject)props, source);
            }
            BigDataAccessParameters frag = new BigDataAccessParameters();
            frag.setBigDataAccessParameters(params.toArray(new BigDataAccessParameter[params.size()]));
            props.setAccessParametersFragment((SQLFragment)frag);
        }
    }
}

