/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.hive;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.Table;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.execute.StatementWrapper;
import oracle.javatools.db.hive.HiveDatabaseImpl;
import oracle.javatools.db.hive.HivePartition;
import oracle.javatools.db.hive.HivePartitionBuilder;
import oracle.javatools.db.hive.HivePartitionProperties;

public class HivePartitionsBuilder
extends AbstractDBObjectBuilder<HivePartitionProperties> {
    public HivePartitionsBuilder(HiveDatabaseImpl db) {
        super((AbstractDBObjectProvider)db, "HivePartitionProperties");
    }

    protected boolean canBuildComponents() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @AbstractDBObjectBuilder.PropertyBuilder(value={"partitions"})
    public void buildUsingDescribe(HivePartitionProperties props) throws DBException {
        ArrayList partitionSpecs;
        HiveDatabaseImpl db;
        block15: {
            Table tab = (Table)props.getParent();
            if (tab == null) return;
            db = (HiveDatabaseImpl)this.getProvider();
            boolean supportsDBName = db.getDatabaseVersion() >= 13;
            Schema defSchema = db.getDefaultSchema();
            partitionSpecs = new ArrayList();
            Schema s = tab.getSchema();
            boolean resetDatabase = false;
            try {
                String nameForQuery;
                if (supportsDBName) {
                    nameForQuery = DBUtil.getFullyQualifiedName((DBObject)tab, (boolean)true);
                } else {
                    nameForQuery = tab.getName();
                    if (defSchema != null && s != null && !db.getDescriptor().areNamesEqual((DBObject)s, (DBObject)defSchema)) {
                        resetDatabase = true;
                        new StatementWrapper((Database)db, new String[]{"use " + s.getName()}).execute();
                    }
                }
                QueryWrapper wrap = new QueryWrapper((Database)db, "show partitions " + nameForQuery);
                wrap.executeQuery(new QueryWrapper.QueryRunnable(){

                    public void processResultSet(ResultSet rs) throws DBException, SQLException {
                        while (rs.next()) {
                            partitionSpecs.add(rs.getString(1));
                        }
                    }
                });
                if (!resetDatabase) break block15;
            }
            catch (Throwable throwable) {
                if (!resetDatabase) throw throwable;
                try {
                    new StatementWrapper((Database)db, new String[]{"use " + defSchema.getName()}).execute();
                    throw throwable;
                }
                catch (DBException dbe) {
                    this.getLogger().severe("Could not reset Connection database: " + dbe.getMessage());
                }
                throw throwable;
            }
            try {
                new StatementWrapper((Database)db, new String[]{"use " + defSchema.getName()}).execute();
            }
            catch (DBException dbe) {
                this.getLogger().severe("Could not reset Connection database: " + dbe.getMessage());
            }
        }
        ArrayList<HivePartition> parts = new ArrayList<HivePartition>();
        Iterator iterator = partitionSpecs.iterator();
        while (true) {
            String[] mappings;
            if (!iterator.hasNext()) {
                props.setPartitions(parts.toArray(new HivePartition[parts.size()]));
                return;
            }
            String spec = (String)iterator.next();
            LinkedHashMap<String, String> specMap = new LinkedHashMap<String, String>();
            StringBuilder partName = new StringBuilder();
            for (String mapping : mappings = spec.split("/")) {
                String[] colVal = mapping.split("=");
                if (colVal.length != 2) {
                    this.getLogger().warning("Invalid partition mapping: " + mapping);
                    continue;
                }
                if (specMap.containsKey(colVal[0])) {
                    this.getLogger().warning("Duplicate column " + colVal[0] + " in partition: " + spec);
                    continue;
                }
                String colName = this.decode(colVal[0]);
                String colValue = this.decode(colVal[1]);
                if (partName.length() > 0) {
                    partName.append(',');
                }
                partName.append(colName).append("='").append(colValue).append('\'');
                specMap.put(colName, colValue);
            }
            HivePartition tp = new HivePartition();
            tp.setName(partName.toString());
            Collection values = specMap.values();
            tp.setValues(values.toArray(new String[values.size()]));
            db.setHiveBuilder(tp, new HivePartitionBuilder(db));
            parts.add(tp);
        }
    }

    private String decode(String str) {
        StringBuilder retval = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '%' && i < str.length() - 2) {
                int code;
                try {
                    code = Integer.valueOf(str.substring(i + 1, i + 3), 16);
                }
                catch (Exception e) {
                    code = -1;
                }
                if (code >= 0) {
                    retval.append((char)code);
                    i += 2;
                    continue;
                }
            }
            retval.append(c);
        }
        return retval.toString();
    }
}

