/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.hive;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.javatools.db.AbstractBuildableObject;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectBuilder;
import oracle.javatools.db.Database;
import oracle.javatools.db.execute.ConnectionWrapper;
import oracle.javatools.db.hive.HiveDatabase;
import oracle.javatools.db.hive.HiveTableBuilder;
import oracle.javatools.db.jdbc.JdbcDDLDatabase;
import oracle.javatools.db.resource.APIBundle;

public class HiveDatabaseImpl
extends JdbcDDLDatabase
implements HiveDatabase {
    private static final String DEFAULT = "default";

    public HiveDatabaseImpl(String connStore, String connName, Connection connection, int ver) {
        super(connStore, connName, connection, "Hive", ver);
    }

    @Override
    protected void registerBuilders() {
        super.registerBuilders();
        this.registerBuilder("TABLE", (DBObjectBuilder)new HiveTableBuilder(this));
    }

    @Override
    public boolean catalogIsSchema() {
        return false;
    }

    @Override
    protected String queryCurrentSchemaName() throws DBException {
        ConnectionWrapper wrap = new ConnectionWrapper((Database)this, APIBundle.get((String)"GET_CURR_SCHEMA"));
        String retval = null;
        try {
            retval = (String)wrap.call((ConnectionWrapper.SQLCallable)new ConnectionWrapper.SQLCallable<String>(wrap){

                public String call() throws SQLException {
                    String url = this.getConnection().getMetaData().getURL();
                    return HiveDatabaseImpl.getDatabaseName(url);
                }
            });
        }
        catch (DBException dbe) {
            retval = super.queryCurrentSchemaName();
        }
        return retval;
    }

    <T extends AbstractBuildableObject> void setHiveBuilder(T object, DBObjectBuilder<T> builder) {
        this.markForLazyInit(object, builder);
    }

    static String getDatabaseName(String url) {
        Pattern p = Pattern.compile("jdbc:hive[2]*://[^\\s]+/([^;\\s]+).*");
        Matcher m = p.matcher(url);
        String retval = m.find() ? m.group(1) : DEFAULT;
        return retval;
    }
}

