/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.db2;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import oracle.javatools.db.CheckConstraint;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Database;
import oracle.javatools.db.JdbcDatabase;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Table;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.jdbc.JdbcTableBuilder;

public class DB2TableBuilder
extends JdbcTableBuilder<Table> {
    public DB2TableBuilder(JdbcDatabase db, String catalog) {
        super(db, catalog);
    }

    @Override
    protected void buildUKs(final Table rel) {
        final ArrayList uks = new ArrayList();
        final QueryWrapper wrap = new QueryWrapper((Database)this.getDatabase(), "select constname, tabname from SYSCAT.TABCONST where type = 'U' and tabname = ? ", new Object[]{rel.getName()});
        try {
            wrap.executeQuery(new QueryWrapper.QueryRunnable(){

                public void processResultSet(ResultSet rs) throws DBException {
                    try {
                        while (rs.next()) {
                            String ukName = rs.getString(1);
                            UniqueConstraint con = new UniqueConstraint(ukName, (Relation)rel);
                            con.setID((DBObjectID)new NameBasedID("CONSTRAINT", ukName, rel.getID()));
                            uks.add(con);
                        }
                    }
                    catch (SQLException sqe) {
                        wrap.throwDBException((DBObject)rel, sqe);
                    }
                }
            });
        }
        catch (DBException dbe) {
            DBLog.getLogger().log(Level.WARNING, "Unable to build unqiue constraints for table: " + rel.getName(), dbe);
        }
        for (UniqueConstraint uk : uks) {
            this.getKeyColumns(uk, uk.getName(), rel);
            if (uk.getColumnIDs().length > 0) {
                rel.addConstraint((Constraint)uk);
                continue;
            }
            rel.removeConstraint((Constraint)uk);
        }
    }

    @Override
    protected void buildFKs(final Table rel) throws DBException {
        final String relName = this.getNameForDriver(rel.getName());
        String[] catAndSchema = this.getCatalogAndSchema(rel.getSchema());
        QueryWrapper wrap = new QueryWrapper((Database)this.getDatabase(), "select ky.PKTABLE_CAT, ky.PKTABLE_SCHEM, ky.PKTABLE_NAME, ky.PKCOLUMN_NAME, ky.FKTABLE_CAT, ky.FKTABLE_SCHEM, ky.FKTABLE_NAME, ky.FKCOLUMN_NAME, ky.KEY_SEQ, ky.UPDATE_RULE, ky.DELETE_RULE, ky.FK_NAME, ky.PK_NAME, ky.DEFERRABILITY from sysibm.sqlforeignkeys ky where ky.FKTABLE_SCHEM = ? and ky.FKTABLE_NAME = ? and ky.PKTABLE_NAME in ( select tb.table_name from sysibm.sqltables tb where tb.table_type = 'TABLE' and  tb.table_schem = ky.PKTABLE_SCHEM )", new Object[]{catAndSchema[1], relName});
        QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet rs) throws DBException {
                DB2TableBuilder.this.buildFKsFromMetadata(rs, (Relation)rel, relName);
            }
        };
        try {
            wrap.executeQuery(r);
        }
        catch (DBException dbe) {
            this.getLogger().log(Level.WARNING, "Unable to build FKs for {0}: {1}", new String[]{relName, dbe.getMessage()});
        }
    }

    private void getKeyColumns(final UniqueConstraint uk, String ukName, final Table rel) {
        final QueryWrapper wrap = new QueryWrapper((Database)this.getDatabase(), "select colname from syscat.keycoluse where constname = ?  and tabname = ?  and tabschema = ?  order by colseq", new Object[]{ukName, rel, rel.getSchema()});
        QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet rs2) throws DBException {
                try {
                    while (rs2 != null && rs2.next()) {
                        String colName = rs2.getString(1);
                        Column column = rel.getColumn(colName);
                        if (column == null) continue;
                        uk.addColumn(column);
                    }
                }
                catch (SQLException e) {
                    wrap.throwDBException((DBObject)uk, e);
                }
            }
        };
        try {
            wrap.executeQuery(r);
        }
        catch (DBException dbe) {
            this.getLogger().log(Level.WARNING, "Unable to build UK columns for {0}: {1}", new String[]{ukName, dbe.getMessage()});
        }
    }

    @Override
    protected void buildCCs(final Table rel) throws DBException {
        String relName = this.getNameForDriver(rel.getName());
        final QueryWrapper wrap = new QueryWrapper((Database)this.getDatabase(), "select constname, text from SYSCAT.CHECKS where tabschema = ? and tabname = ? ", new Object[]{rel.getSchema(), rel.getName()});
        QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet rs) throws DBException {
                try {
                    while (rs.next()) {
                        CheckConstraint con = (CheckConstraint)DB2TableBuilder.this.getProvider().getObjectFactory().newObject(CheckConstraint.class, (DBObject)rel);
                        String ccName = rs.getString(1);
                        con.setName(ccName);
                        con.setCheckCondition(rs.getString(2));
                        con.setID((DBObjectID)new NameBasedID("CONSTRAINT", ccName, rel.getID()));
                        rel.addConstraint((Constraint)con);
                    }
                }
                catch (SQLException sqe) {
                    wrap.throwDBException((DBObject)rel, sqe);
                }
            }
        };
        try {
            wrap.executeQuery(r);
        }
        catch (DBException dbe) {
            this.getLogger().log(Level.WARNING, "Unable to build Check Constraints for {0}: {1}", new String[]{relName, dbe.getMessage()});
        }
    }
}

