/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jdeveloper.nbbridge;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import oracle.ide.Ide;
import oracle.javatools.ui.NotificationDisplayer;
import org.openide.awt.Notification;
import org.openide.awt.NotificationDisplayer;

public class JDevNotificationDisplayer
extends NotificationDisplayer {
    public Notification notify(final String title, final Icon icon, final String detailsText, final ActionListener detailsAction, final NotificationDisplayer.Priority priority) {
        if (EventQueue.isDispatchThread()) {
            oracle.javatools.ui.NotificationDisplayer nd = Ide.getNotificationDisplayer();
            NotificationDisplayer.Notification notification = nd.notify(JDevNotificationDisplayer.convertPriority(priority), icon, title, detailsText, JDevNotificationDisplayer.getAction(detailsAction), true);
            return new NotificationImpl(notification);
        }
        final NotificationImpl nbNotification = new NotificationImpl(null);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                oracle.javatools.ui.NotificationDisplayer nd = Ide.getNotificationDisplayer();
                NotificationDisplayer.Notification notification = nd.notify(JDevNotificationDisplayer.convertPriority(priority), icon, title, detailsText, JDevNotificationDisplayer.getAction(detailsAction), true);
                nbNotification.setNotification(notification);
            }
        });
        return nbNotification;
    }

    public Notification notify(final String title, final Icon icon, final JComponent balloonDetails, final JComponent popupDetails, final NotificationDisplayer.Priority priority) {
        if (EventQueue.isDispatchThread()) {
            oracle.javatools.ui.NotificationDisplayer nd = Ide.getNotificationDisplayer();
            NotificationDisplayer.Notification notification = nd.notify(JDevNotificationDisplayer.convertPriority(priority), icon, title, balloonDetails, popupDetails);
            return new NotificationImpl(notification);
        }
        final NotificationImpl nbNotification = new NotificationImpl(null);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                oracle.javatools.ui.NotificationDisplayer nd = Ide.getNotificationDisplayer();
                NotificationDisplayer.Notification notification = nd.notify(JDevNotificationDisplayer.convertPriority(priority), icon, title, balloonDetails, popupDetails);
                nbNotification.setNotification(notification);
            }
        });
        return nbNotification;
    }

    private static NotificationDisplayer.Priority convertPriority(NotificationDisplayer.Priority nbPriority) {
        NotificationDisplayer.Priority jdevPriority = NotificationDisplayer.Priority.LOW;
        if (nbPriority != null) {
            switch (nbPriority) {
                case HIGH: {
                    jdevPriority = NotificationDisplayer.Priority.HIGH;
                    break;
                }
                case NORMAL: {
                    jdevPriority = NotificationDisplayer.Priority.NORMAL;
                }
            }
        }
        return jdevPriority;
    }

    private static Action getAction(final ActionListener al) {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                al.actionPerformed(e);
            }
        };
    }

    private static class NotificationImpl
    extends Notification {
        private NotificationDisplayer.Notification jdevNotification;
        private boolean cleared;

        NotificationImpl(NotificationDisplayer.Notification n) {
            this.jdevNotification = n;
        }

        void setNotification(NotificationDisplayer.Notification n) {
            assert (this.jdevNotification == null && n != null);
            assert (EventQueue.isDispatchThread());
            this.jdevNotification = n;
            if (this.cleared) {
                this.clearImpl();
            }
        }

        public void clear() {
            this.cleared = true;
            if (this.jdevNotification != null) {
                this.clearImpl();
            }
        }

        private void clearImpl() {
            this.jdevNotification.remove();
        }
    }
}

