/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.report;

import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import oracle.ide.Ide;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.management.Memory;
import oracle.javatools.util.Log;
import oracle.jdeveloper.audit.analyzer.Category;
import oracle.jdeveloper.audit.analyzer.Metric;
import oracle.jdeveloper.audit.analyzer.Rule;
import oracle.jdeveloper.audit.model.ContentDirectory;
import oracle.jdeveloper.audit.model.Location;
import oracle.jdeveloper.audit.model.ModelAdapter;
import oracle.jdeveloper.audit.service.AuditLogger;
import oracle.jdeveloper.audit.service.AuditModel;
import oracle.jdeveloper.audit.service.Violation;
import oracle.jdeveloper.audit.transform.Transform;
import oracle.jdevimpl.audit.model.ProjectModelAdapter;
import oracle.jdevimpl.audit.report.ReportBundle;
import oracle.jdevimpl.audit.report.XmlReportType;
import oracle.jdevimpl.audit.report.XmlReporter;

public class AuditXmlReporter
extends XmlReporter<AuditModel> {
    private Map<ModelAdapter, String> models = new LinkedHashMap<ModelAdapter, String>();
    private Map<Category, String> categories = new LinkedHashMap<Category, String>();
    private Map<Rule, String> rules = new LinkedHashMap<Rule, String>();
    private Map<Transform, String> transforms = new LinkedHashMap<Transform, String>();
    private int nextId = 0;
    private static final String SCHEMA_URI = "http://xmlns.oracle.com/jdeveloper/1013/audit";
    private static final String DOCUMENT_ROOT = "audit";
    private static final Log LOG = new Log("report");
    private static final Log MEMORY_LOG = new Log("memory-statistics", "report");

    @Override
    public XmlReportType getType() {
        return XmlReportType.AUDIT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void writeModel(AuditModel model) throws InterruptedException {
        this.models.clear();
        this.categories.clear();
        this.rules.clear();
        this.transforms.clear();
        this.writeLine("<!DOCTYPE audit [");
        this.indent();
        this.writeLine("<!ATTLIST category id ID #REQUIRED>");
        this.writeLine("<!ATTLIST column id ID #REQUIRED>");
        this.writeLine("<!ATTLIST construct id ID #REQUIRED parent IDREF #REQUIRED root (false|true) \"false\">");
        this.writeLine("<!ATTLIST model id ID #REQUIRED>");
        this.writeLine("<!ATTLIST location model IDREF #REQUIRED>");
        this.writeLine("<!ATTLIST rule id ID #REQUIRED category IDREF #REQUIRED>");
        this.writeLine("<!ATTLIST transform id ID #REQUIRED>");
        this.writeLine("<!ATTLIST transform-applied transform IDREF #REQUIRED>");
        this.writeLine("<!ATTLIST value column IDREF #REQUIRED over-threshold (false|true) \"false\">");
        this.writeLine("<!ATTLIST violation rule IDREF #REQUIRED parent IDREF #REQUIRED suppressed (false|true) \"false\">");
        this.undent();
        this.writeLine("]>");
        this.newline();
        this.collect(model, model.getRoot());
        this.writeBeginTag(DOCUMENT_ROOT, new String[]{"xmlns", SCHEMA_URI}, false, true);
        String title = this.getTitle();
        if (title == null) {
            Object name;
            List<Location> locations = model.getLocations();
            if (locations.size() == 1) {
                Location location = locations.get(0);
                ModelAdapter adapter = location.getModel();
                adapter.beginRead();
                try {
                    name = adapter.getLabel(location);
                }
                finally {
                    adapter.endRead();
                }
            } else {
                name = ReportBundle.get("multiple.selection.name");
            }
            title = ReportBundle.format("audit.default-title", name);
        }
        this.writeTextElement("title", title);
        this.writeStatistics(model);
        this.writeLocations(model);
        this.writeProfile(model);
        this.writeColumns(model);
        this.writeModels();
        this.writeCategories();
        this.writeRules();
        this.writeTransforms();
        this.writeConstruct(model, null, model.getRoot(), null, false);
        this.writeEndTag(DOCUMENT_ROOT);
    }

    private void collect(AuditModel model, Object object) {
        Violation violation;
        ModelAdapter rowModel = model.getLocation(object).getModel();
        if (!this.models.containsKey(rowModel)) {
            this.models.put(rowModel, "d" + this.models.size());
        }
        if ((violation = model.getViolation(object)) == null) {
            for (Object child : model.getVisibleChildren(object)) {
                this.collect(model, child);
            }
        } else {
            Rule rule = violation.getRule();
            Category category = rule.category();
            if (!this.categories.containsKey(category)) {
                this.categories.put(category, "c" + this.categories.size());
            }
            if (!this.rules.containsKey(rule)) {
                this.rules.put(rule, "r" + this.rules.size());
            }
            for (Transform transform : model.getTransformsApplied(violation)) {
                if (this.transforms.containsKey(transform)) continue;
                this.transforms.put(transform, "t" + this.transforms.size());
            }
        }
    }

    private void writeStatistics(AuditModel model) {
        Object root = model.getRoot();
        int fileCount = model.getCount(root, AuditModel.Count.VISIBLE_FILES);
        int exceptionCount = model.getCount(root, AuditModel.Count.VISIBLE_OUT_OF_BANDS);
        int errorCount = model.getCount(root, AuditModel.Count.VISIBLE_ERRORS);
        int warningCount = model.getCount(root, AuditModel.Count.VISIBLE_WARNINGS);
        int incompleteCount = model.getCount(root, AuditModel.Count.VISIBLE_INCOMPLETES);
        int advisoryCount = model.getCount(root, AuditModel.Count.VISIBLE_ADVISORIES);
        this.writeTextElement("model-count", String.valueOf(fileCount));
        this.writeTextElement("violation-count", String.valueOf(errorCount + warningCount + incompleteCount + advisoryCount));
        this.writeTextElement("exception-count", String.valueOf(exceptionCount));
        this.writeTextElement("error-count", String.valueOf(errorCount));
        this.writeTextElement("warning-count", String.valueOf(warningCount));
        this.writeTextElement("incomplete-count", String.valueOf(incompleteCount));
        this.writeTextElement("advisory-count", String.valueOf(advisoryCount));
    }

    private void writeModels() {
        this.writeBeginTag("models");
        for (Map.Entry<ModelAdapter, String> entry : this.models.entrySet()) {
            ModelAdapter model = entry.getKey();
            String id = entry.getValue();
            this.writeBeginTag("model", new String[]{"id", id}, false, true);
            this.writeFile(model.getUrl());
            this.writePackage(model.getDirectory());
            this.writeProject(model.getProject());
            this.writeWorkspace(model.getWorkspace());
            this.writeTextElement("label", model.getShortLabel());
            this.writeEndTag("model");
        }
        this.writeEndTag("models");
    }

    private void writeFile(URL url) {
        if (url != null) {
            this.writeBeginTag("file");
            this.writeTextElement("url", url);
            this.writeTextElement("path", URLFileSystem.getPlatformPathName((URL)url));
            this.writeEndTag("file");
        }
    }

    private void writePackage(ContentDirectory packag) {
        if (packag != null) {
            this.writeTextElement("package", packag.getRelativePath().replace('/', '.'));
        }
    }

    private void writeProject(Project project) {
        if (project != null) {
            this.writeBeginTag("project");
            this.writeTextElement("label", project.getShortLabel());
            this.writeFile(project.getURL());
            this.writeEndTag("project");
        }
    }

    private void writeWorkspace(Workspace workspace) {
        if (workspace != null) {
            this.writeBeginTag("workspace");
            this.writeTextElement("label", workspace.getShortLabel());
            this.writeFile(workspace.getURL());
            this.writeEndTag("workspace");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeLocations(AuditModel model) throws InterruptedException {
        this.writeBeginTag("locations");
        for (Location location : model.getLocations()) {
            location.getModel().beginRead();
            try {
                this.writeLocation(location);
            }
            finally {
                location.getModel().endRead();
            }
        }
        this.writeEndTag("locations");
    }

    private void writeLocation(Location location) {
        ModelAdapter model = location.getModel();
        String modelId = this.models.get(model);
        this.writeBeginTag("location", new String[]{"model", modelId}, false, true);
        int offset = location.getOffset();
        this.writeTextElement("offset", String.valueOf(offset));
        this.writeTextElement("length", String.valueOf(location.getLength()));
        this.writeTextElement("line-number", String.valueOf(model.getLineOffset(offset) + 1));
        this.writeTextElement("column-offset", String.valueOf(model.getColumnOffset(offset)));
        this.writeEndTag("location");
    }

    private void writeProfile(AuditModel model) {
        this.writeBeginTag("profile");
        this.writeTextElement("name", model.getProfile().getName());
        this.writeFile(model.getProfile().getURL());
        this.writeEndTag("profile");
    }

    private void writeColumns(AuditModel model) {
        this.writeBeginTag("columns");
        int size = model.getColumnCount();
        for (int i = 1; i < size; ++i) {
            Metric column = model.getColumn(i);
            String label = column.label();
            String description = column.description();
            this.writeBeginTag("column", new String[]{"id", "a" + i}, false, true);
            this.writeTextElement("name", column.id());
            this.writeTextElement("label", label);
            this.writeTextElement("description", description);
            this.writeTextElement("type", column.getType());
            this.writeTextElement("threshold", column.getThreshold());
            this.writeEndTag("column");
        }
        this.writeEndTag("columns");
    }

    private void writeCategories() {
        this.writeBeginTag("categories");
        for (Map.Entry<Category, String> entry : this.categories.entrySet()) {
            Category category = entry.getKey();
            String id = entry.getValue();
            String name = category.id();
            String label = category.label();
            String description = category.description();
            this.writeBeginTag("category", new String[]{"id", id}, false, true);
            this.writeTextElement("name", name);
            this.writeTextElement("label", label);
            this.writeTextElement("description", description);
            this.writeEndTag("category");
        }
        this.writeEndTag("categories");
    }

    private void writeRules() {
        this.writeBeginTag("rules");
        for (Map.Entry<Rule, String> entry : this.rules.entrySet()) {
            Rule rule = entry.getKey();
            String id = entry.getValue();
            String cid = this.categories.get(rule.category());
            this.writeBeginTag("rule", new String[]{"id", id, "category", cid}, false, true);
            String name = rule.id();
            String label = rule.label();
            String description = rule.description();
            this.writeTextElement("name", name);
            this.writeTextElement("label", label);
            this.writeTextElement("description", description);
            this.writeTextElement("severity", rule.getSeverity());
            this.writeEndTag("rule");
        }
        this.writeEndTag("rules");
    }

    private void writeTransforms() {
        this.writeBeginTag("transforms");
        for (Map.Entry<Transform, String> entry : this.transforms.entrySet()) {
            Transform transform = entry.getKey();
            String id = entry.getValue();
            String name = transform.id();
            String label = transform.label();
            String description = transform.description();
            this.writeBeginTag("transform", new String[]{"id", id}, false, true);
            this.writeTextElement("name", name);
            this.writeTextElement("label", label);
            this.writeTextElement("description", description);
            this.writeEndTag("transform");
        }
        this.writeEndTag("transforms");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeConstruct(AuditModel model, String parentId, Object object, ModelAdapter lockedModel, boolean activeNodeUsageCycle) throws InterruptedException {
        block18: {
            ModelAdapter currentModel;
            block20: {
                block19: {
                    LOG.trace("writing construct {0}", object);
                    Location location = model.getLocation(object);
                    currentModel = location.getModel();
                    boolean atRoot = lockedModel == null;
                    boolean modelEntered = currentModel != lockedModel;
                    boolean endNodeUsageCycle = false;
                    if (modelEntered) {
                        if (!activeNodeUsageCycle && (atRoot || currentModel instanceof ProjectModelAdapter)) {
                            this.printRunningStatistics("begin reporting {0}", currentModel);
                            Node.beginThreadNodeUsageCycle();
                            activeNodeUsageCycle = true;
                            endNodeUsageCycle = true;
                        }
                        currentModel.beginRead();
                        lockedModel = currentModel;
                    }
                    try {
                        Violation violation = model.getViolation(object);
                        if (violation == null) {
                            String id = "o" + this.nextId++;
                            String[] attributes = parentId == null ? new String[]{"id", id, "parent", id, "root", "true"} : new String[]{"id", id, "parent", parentId};
                            this.writeBeginTag("construct", attributes, false, true);
                            this.writeLocation(location);
                            Class<?> type = model.getType(object);
                            this.writeTextElement("type", type);
                            this.writeTextElement("kind", currentModel.getType().label(type));
                            this.writeTextElement("name", model.getSummary(object));
                            this.writeTextElement("label", model.getLabel(object));
                            this.writeValues(model, object);
                            this.writeBeginTag("children");
                            for (Object child : model.getVisibleChildren(object)) {
                                this.writeConstruct(model, id, child, lockedModel, activeNodeUsageCycle);
                            }
                            this.writeEndTag("children");
                            this.writeEndTag("construct");
                        } else {
                            this.writeViolation(model, parentId, object, violation);
                        }
                        if (!modelEntered) break block18;
                        currentModel.endRead();
                        if (!endNodeUsageCycle) break block19;
                    }
                    catch (Throwable throwable) {
                        if (modelEntered) {
                            currentModel.endRead();
                            if (endNodeUsageCycle) {
                                this.printRunningStatistics("end reporting {0}", currentModel);
                                Node.endThreadNodeUsageCycle();
                            } else if (activeNodeUsageCycle) {
                                Node.endThreadNodeUsage((Node)currentModel.getNode());
                            }
                            if (!Ide.getIdeArgs().getCreateUI() && currentModel instanceof ProjectModelAdapter) {
                                try {
                                    currentModel.getProject().close();
                                }
                                catch (IOException e) {
                                    AuditLogger.error(e, "Unexpected exception closing {0}: {1}", currentModel, e);
                                }
                            }
                        }
                        throw throwable;
                    }
                    this.printRunningStatistics("end reporting {0}", currentModel);
                    Node.endThreadNodeUsageCycle();
                    break block20;
                }
                if (activeNodeUsageCycle) {
                    Node.endThreadNodeUsage((Node)currentModel.getNode());
                }
            }
            if (!Ide.getIdeArgs().getCreateUI() && currentModel instanceof ProjectModelAdapter) {
                try {
                    currentModel.getProject().close();
                }
                catch (IOException e) {
                    AuditLogger.error(e, "Unexpected exception closing {0}: {1}", currentModel, e);
                }
            }
        }
    }

    private void writeViolation(AuditModel model, String parentId, Object object, Violation violation) {
        LOG.trace("writing violation {0}", object);
        String rid = this.rules.get(violation.getRule());
        String[] attributes = violation.getSuppressionCount() > 0 ? new String[]{"parent", parentId, "rule", rid, "suppressed", "true"} : new String[]{"parent", parentId, "rule", rid};
        this.writeBeginTag("violation", attributes, false, true);
        this.writeLocation(model.getLocation(object));
        this.writeTextElement("message", model.getLabel(object));
        this.writeValues(model, object);
        this.writeTransformsApplied(model, object);
        this.writeEndTag("violation");
    }

    protected void writeValues(AuditModel model, Object object) {
        this.writeBeginTag("values");
        int size = model.getColumnCount();
        for (int i = 1; i < size; ++i) {
            Object value;
            Metric column = model.getColumn(i);
            String[] attributes = column.isOutOfBand(value = model.getValue(object, i)) ? new String[]{"column", "a" + i, "over-threshold", "true"} : new String[]{"column", "a" + i};
            this.writeTextElement("value", attributes, column.representation(value));
        }
        this.writeEndTag("values");
    }

    protected void writeTransformsApplied(AuditModel model, Object object) {
        this.writeBeginTag("transforms-applied");
        for (Transform transform : model.getTransformsApplied(model.getViolation(object))) {
            String tid = this.transforms.get(transform);
            this.writeBeginTag("transform-applied", new String[]{"transform", tid}, true, true);
        }
        this.writeEndTag("transforms-applied");
    }

    private void printRunningStatistics(String message, Object ... arguments) {
        if (MEMORY_LOG.isEnabled()) {
            String EOL = System.getProperty("line.separator");
            StringBuilder openNodes = new StringBuilder(EOL);
            Iterator i = NodeFactory.getOpenNodes();
            while (i.hasNext()) {
                openNodes.append("  ");
                openNodes.append(((Node)i.next()).getLongLabel());
                openNodes.append(EOL);
            }
            MEMORY_LOG.trace("{0}: {1} nodes, {2} open nodes:{3}{4}{5}", new Object[]{Log.format((String)message, (Object[])arguments), NodeFactory.getCachedNodeCount(), NodeFactory.getOpenNodeCount(), openNodes, Memory.summary(), EOL});
        }
    }
}

