/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.profile;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.Scrollable;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import javax.swing.tree.TreePath;
import oracle.ide.webbrowser.BrowserRunner;
import oracle.ideimpl.extension.ManifestActivator;
import oracle.javatools.ui.Colors;
import oracle.javatools.ui.HyperlinkButton;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.util.Log;
import oracle.jdeveloper.audit.AuditManager;
import oracle.jdeveloper.audit.extension.BeanDefinition;
import oracle.jdeveloper.audit.extension.ExtensionBean;
import oracle.jdeveloper.audit.service.Profile;
import oracle.jdevimpl.audit.bean.BeanPanel;
import oracle.jdevimpl.audit.profile.ProfileBundle;
import oracle.jdevimpl.audit.profile.ProfileModel;
import oracle.jdevimpl.audit.profile.ProfileTreeModel;
import oracle.jdevimpl.audit.swing.CheckBoxTree;
import oracle.jdevimpl.audit.swing.FocusBorder;
import oracle.jdevimpl.audit.swing.HtmlTreeCellRenderer;
import oracle.jdevimpl.audit.swing.LabelTextArea;
import oracle.jdevimpl.audit.swing.MessageDialog;
import oracle.jdevimpl.audit.swing.NullablePanel;
import oracle.jdevimpl.audit.swing.Resources;

class AuditProfilePane
implements TreeSelectionListener,
SearchListener,
ItemListener {
    private ProfileTreeModel model;
    private CheckBoxTree tree;
    private LabelTextArea beanName;
    private LabelTextArea beanId;
    private OpenManifestAction manifestAction;
    private BeanPanel beanPropertiesPane;
    private DescriptionPane beanDescriptionPane;
    private NullablePanel beanPanel;
    private JComponent component;
    private static final Log LOG = new Log("profile");

    public AuditProfilePane(ProfileModel model, ProfileTreeModel.BeanKind type) {
        this.model = new ProfileTreeModel(model, type);
    }

    public void setProfile(Profile profile) {
        LOG.trace("setting profile {0} on pane", (Object)profile);
        if (this.tree != null) {
            this.tree.repaint();
            TreePath path = this.tree.getSelectionPath();
            Object selection = path != null ? path.getLastPathComponent() : null;
            this.processSelection(selection);
        }
    }

    public Object getSelectionState() {
        return null;
    }

    public void setSelectionState(Object state) {
    }

    public boolean flush() {
        return this.beanPropertiesPane.flush();
    }

    public Component getFocusComponent() {
        return this.tree;
    }

    public Component getComponent() {
        if (this.component == null) {
            this.component = this.createComponent();
        }
        return this.component;
    }

    public void searchPerformed(SearchEvent event) {
        String newText = event.getSearchText();
        if (event.isFromClear() || newText.trim().isEmpty()) {
            newText = null;
        }
        if (this.model.setFilterText(newText)) {
            this.tree.expandAll();
        }
    }

    public void searchCategoryChanged(SearchEvent event) {
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        FilterCategoryMenuItem item = (FilterCategoryMenuItem)event.getSource();
        if (this.model.setFilterCategory(item.getCategory(), item.isSelected())) {
            this.tree.expandAll();
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent event) {
        TreePath path = event.getNewLeadSelectionPath();
        Object newSelection = path != null ? path.getLastPathComponent() : null;
        LOG.trace("tree selection changed to {0}", newSelection);
        this.processSelection(newSelection);
    }

    private void processSelection(Object newSelection) {
        ExtensionBean bean;
        LOG.trace("changing tree selection to {0}", newSelection);
        ExtensionBean extensionBean = bean = newSelection != null ? this.model.getBean(newSelection) : null;
        if (bean != null) {
            String beanDescription = this.model.getDescription(newSelection);
            this.beanName.setText(bean.label());
            String id = bean.id();
            this.beanId.setText(id);
            BeanDefinition definition = bean.definition();
            boolean navigable = AuditManager.isDevelopment() && ManifestActivator.isExtensionManifestOpenable((String)definition.getSystemId());
            this.beanId.setToolTipText(ProfileBundle.get(navigable ? "id.navigable.tip" : "id.unnavigable.tip"));
            this.manifestAction.setDefinition(navigable ? definition : null);
            this.beanPropertiesPane.setBean(bean);
            this.beanDescriptionPane.setText(beanDescription);
            this.beanPanel.showContent();
        } else {
            this.beanName.setText(" ");
            this.beanId.setText(" ");
            this.beanId.setToolTipText(null);
            this.manifestAction.setDefinition(null);
            this.beanDescriptionPane.setText(" ");
            this.beanPropertiesPane.setBean(null);
            this.beanPanel.hideContent();
        }
    }

    private JComponent createComponent() {
        SearchField searchField = new SearchField(SearchField.Style.FILTER);
        for (ProfileTreeModel.FilterCategory category : (ProfileTreeModel.FilterCategory[])ProfileTreeModel.FilterCategory.class.getEnumConstants()) {
            FilterCategoryMenuItem item = new FilterCategoryMenuItem(category, this.model.getFilterCategory(category));
            searchField.addCategoryMenuItem((JMenuItem)item);
            item.addItemListener(this);
        }
        this.tree = new CheckBoxTree(this.model, new HtmlTreeCellRenderer(), new HtmlTreeCellRenderer());
        JScrollPane treeScrollPane = new JScrollPane(this.tree, 20, 30);
        this.tree.setVisibleRowCount(12);
        HyperlinkButton expandAllButton = Resources.button(new HyperlinkButton(), ProfileBundle.get("expand-all.label"), ProfileBundle.get("expand-all.tip"));
        expandAllButton.setMargin(new Insets(0, 0, 0, 0));
        HyperlinkButton collapseAllButton = Resources.button(new HyperlinkButton(), ProfileBundle.get("collapse-all.label"), ProfileBundle.get("collapse-all.tip"));
        collapseAllButton.setMargin(new Insets(0, 0, 0, 0));
        HyperlinkButton selectAllButton = Resources.button(new HyperlinkButton(), ProfileBundle.get("select-all.label"), ProfileBundle.get("select-all.tip"));
        selectAllButton.setMargin(new Insets(0, 0, 0, 0));
        HyperlinkButton deselectAllButton = Resources.button(new HyperlinkButton(), ProfileBundle.get("deselect-all.label"), ProfileBundle.get("deselect-all.tip"));
        deselectAllButton.setMargin(new Insets(0, 0, 0, 0));
        Font hyperlinkFont = expandAllButton.getFont();
        expandAllButton.setFont(hyperlinkFont);
        collapseAllButton.setFont(hyperlinkFont);
        selectAllButton.setFont(hyperlinkFont);
        deselectAllButton.setFont(hyperlinkFont);
        Box treeToolPanel = Box.createHorizontalBox();
        treeToolPanel.add((Component)expandAllButton);
        treeToolPanel.add(Box.createHorizontalStrut(8));
        treeToolPanel.add((Component)collapseAllButton);
        treeToolPanel.add(Box.createHorizontalStrut(8));
        treeToolPanel.add(Box.createHorizontalGlue());
        treeToolPanel.add((Component)selectAllButton);
        treeToolPanel.add(Box.createHorizontalStrut(8));
        treeToolPanel.add((Component)deselectAllButton);
        JPanel treePanel = new JPanel(new BorderLayout(0, 4));
        treePanel.add((Component)searchField, "North");
        treePanel.add((Component)treeScrollPane, "Center");
        treePanel.add((Component)treeToolPanel, "South");
        BeanInspectorPanel beanPanel = new BeanInspectorPanel();
        beanPanel.setBorder(BorderFactory.createEmptyBorder());
        this.beanName = new LabelTextArea();
        this.beanName.setFontStyle(1);
        GridBagConstraints constraints = new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0);
        beanPanel.add((Component)this.beanName, constraints);
        ++constraints.gridy;
        this.beanId = new LabelTextArea();
        this.beanId.setForeground(Colors.HINT_TEXT);
        this.manifestAction = new OpenManifestAction();
        this.beanId.addMouseListener(this.manifestAction);
        constraints.insets.top = 4;
        beanPanel.add((Component)this.beanId, constraints);
        ++constraints.gridy;
        this.beanDescriptionPane = new DescriptionPane(3);
        this.beanDescriptionPane.setCollapsed(true);
        JComponent collapseButton = this.beanDescriptionPane.getToggleButton();
        collapseButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        constraints.insets.top = 6;
        constraints.fill = 2;
        beanPanel.add((Component)this.beanDescriptionPane, constraints);
        ++constraints.gridy;
        constraints.insets.top = 0;
        constraints.fill = 0;
        constraints.anchor = 12;
        beanPanel.add((Component)collapseButton, constraints);
        constraints.anchor = 18;
        ++constraints.gridy;
        this.beanPropertiesPane = new BeanPanel(null, AuditManager.getAuditManager().getBeanCustomizers());
        constraints.insets.top = 16;
        constraints.fill = 2;
        beanPanel.add((Component)this.beanPropertiesPane, constraints);
        ++constraints.gridy;
        constraints.insets.top = 0;
        constraints.weighty = 1.0;
        constraints.fill = 0;
        beanPanel.add(Box.createVerticalGlue(), constraints);
        final JScrollPane beanScrollPane = new JScrollPane(beanPanel, 20, 31);
        beanScrollPane.setBorder(BorderFactory.createEmptyBorder());
        beanScrollPane.setViewportBorder(BorderFactory.createEmptyBorder(0, 6, 0, 6));
        beanScrollPane.setBackground(this.beanDescriptionPane.getBackground());
        this.beanPanel = new NullablePanel(null, null, ProfileBundle.get("null.bean.label"), beanScrollPane);
        expandAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AuditProfilePane.this.tree.expandAll();
            }
        });
        collapseAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AuditProfilePane.this.tree.collapseAll();
            }
        });
        selectAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AuditProfilePane.this.tree.enableAll();
            }
        });
        deselectAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AuditProfilePane.this.tree.disableAll();
            }
        });
        beanScrollPane.getVerticalScrollBar().addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
                AuditProfilePane.this.beanDescriptionPane.revalidate();
                beanScrollPane.repaint();
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                AuditProfilePane.this.beanDescriptionPane.revalidate();
                beanScrollPane.repaint();
            }
        });
        this.tree.addTreeSelectionListener(this);
        searchField.addSearchListener((SearchListener)this);
        JSplitPane compositePanel = new JSplitPane(1, treePanel, this.beanPanel);
        compositePanel.setResizeWeight(0.25);
        compositePanel.setDividerLocation(treePanel.getMinimumSize().width);
        compositePanel.setBorder(BorderFactory.createEmptyBorder());
        return compositePanel;
    }

    private class BeanInspectorPanel
    extends JPanel
    implements Scrollable {
        private Dimension preferredScrollableViewportSize;

        private BeanInspectorPanel() {
            super(new GridBagLayout());
            this.setOpaque(true);
        }

        public void setPreferredScrollableViewportSize(Dimension size) {
            this.preferredScrollableViewportSize = size;
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.preferredScrollableViewportSize != null ? this.preferredScrollableViewportSize : this.getPreferredSize();
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 0;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 0;
        }
    }

    public static class DescriptionHyperlinkListener
    implements HyperlinkListener {
        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                StringWriter buffer = new StringWriter();
                PrintWriter writer = new PrintWriter(buffer);
                try {
                    BrowserRunner.getBrowserRunner().runBrowserOnURLV2(e.getURL(), null, writer);
                }
                catch (Exception e1) {
                    MessageDialog dialog = new MessageDialog(MessageDialog.Type.ERROR);
                    dialog.setTitle(ProfileBundle.get("hyperlink.exception.title"));
                    dialog.setContent(ProfileBundle.format("hyperlink.exception.content", e.getURL(), buffer.toString()));
                    dialog.show();
                }
            }
        }
    }

    public static class DescriptionPane
    extends JEditorPane
    implements ActionListener {
        private boolean collapsed;
        private int collapsedHeight;
        private int collapseButtonHeight;
        private AbstractButton collapseButton;
        private String expandLabel;
        private String collapseLabel;
        private Dimension minimumSize = new Dimension();
        private Dimension preferredSize = new Dimension();
        private Dimension maximumSize = new Dimension();

        public DescriptionPane(int collapsedRowCount) {
            super("text/html", DescriptionPane.rowPaddedText(collapsedRowCount));
            this.setEditable(false);
            this.setOpaque(false);
            this.setForeground(UIManager.getColor("Label.foreground"));
            this.setBackground(UIManager.getColor("Label.background"));
            Font font = this.getFont();
            StyleSheet stylesheet = ((HTMLDocument)this.getDocument()).getStyleSheet();
            stylesheet.addRule("body {font-size: " + font.getSize() + "pt;" + "font-family: " + font.getFamily() + ";" + "font-weight: " + (font.isBold() ? "bold" : "normal") + ";" + "font-style: " + (font.isItalic() ? "italic" : "normal") + ";" + "color: #" + Integer.toHexString(this.getForeground().getRGB() & 0xFFFFFF) + "}");
            this.addHyperlinkListener(new DescriptionHyperlinkListener());
            this.setBorder(new FocusBorder(this));
            this.collapseButton = new HyperlinkButton();
            this.collapseButton.setFont(this.collapseButton.getFont().deriveFont(Math.max(this.collapseButton.getFont().getSize2D() * 0.75f, 9.0f)));
            this.collapseButton.setFocusable(false);
            this.collapseButton.setMargin(new Insets(0, 0, 0, 0));
            this.collapseButton.addActionListener(this);
            this.collapsedHeight = this.getPreferredSize().height;
            this.expandLabel = ProfileBundle.get("description.expand.label");
            this.collapseLabel = ProfileBundle.get("description.collapse.label");
            this.setCollapsed(true);
            this.collapseButtonHeight = this.collapseButton.getPreferredSize().height;
        }

        private static String rowPaddedText(int rowCount) {
            StringBuilder builder = new StringBuilder("<html>");
            for (int i = 0; i < rowCount; ++i) {
                builder.append("&nbsp;<br>");
            }
            builder.append("</html>");
            return builder.toString();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.setCollapsed(this.collapseLabel.equals(((AbstractButton)e.getSource()).getText()));
        }

        public JComponent getToggleButton() {
            return this.collapseButton;
        }

        public void setCollapsed(boolean collapsed) {
            this.collapsed = collapsed;
            this.collapseButton.setText(collapsed ? this.expandLabel : this.collapseLabel);
            this.revalidate();
            this.repaint();
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return true;
        }

        private Dimension limit(Dimension size, Dimension superSize) {
            size.width = superSize.width;
            size.height = superSize.height;
            boolean collapsible = size.height > this.collapsedHeight + this.collapseButtonHeight + this.collapseButtonHeight / 4;
            this.collapseButton.setVisible(collapsible);
            if (collapsible && this.collapsed) {
                size = new Dimension(size.width, Math.min(size.height, this.collapsedHeight));
            }
            return size;
        }

        @Override
        public Dimension getMinimumSize() {
            return this.limit(this.minimumSize, super.getMinimumSize());
        }

        @Override
        public Dimension getPreferredSize() {
            return this.limit(this.preferredSize, super.getPreferredSize());
        }

        @Override
        public Dimension getMaximumSize() {
            return this.limit(this.maximumSize, super.getMaximumSize());
        }
    }

    public static class OpenManifestAction
    extends MouseAdapter {
        private BeanDefinition definition;

        @Override
        public void mouseClicked(MouseEvent e) {
            if (this.definition == null || e.getClickCount() != 2) {
                return;
            }
            ManifestActivator.openExtensionManifest((String)this.definition.getSystemId(), (int)this.definition.getLineNumber(), (int)this.definition.getColumnNumber());
        }

        public void setDefinition(BeanDefinition definition) {
            this.definition = definition;
        }
    }

    private class FilterCategoryMenuItem
    extends JCheckBoxMenuItem {
        private ProfileTreeModel.FilterCategory category;

        private FilterCategoryMenuItem(ProfileTreeModel.FilterCategory category, boolean selected) {
            super(category.label(), selected);
            this.category = category;
        }

        private ProfileTreeModel.FilterCategory getCategory() {
            return this.category;
        }
    }
}

