/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.log;

import oracle.jdeveloper.audit.service.AuditModel;
import oracle.jdeveloper.audit.service.AuditModelFilter;
import oracle.jdevimpl.audit.util.Cache;

public class AnomalyFilter
extends AuditModelFilter {
    private boolean anomaliesOnly;
    private String key;

    public AnomalyFilter() {
        this(false, null);
    }

    public AnomalyFilter(boolean defaultIssuesOnly) {
        this(defaultIssuesOnly, null);
    }

    public AnomalyFilter(String persistenceKey) {
        this(false, persistenceKey);
    }

    public AnomalyFilter(boolean defaultAnomaliesOnly, String persistenceKey) {
        this.key = persistenceKey;
        this.anomaliesOnly = Cache.get(this.key, defaultAnomaliesOnly);
    }

    public void setAnomaliesOnly(boolean anomaliesOnly) {
        if (this.anomaliesOnly == anomaliesOnly) {
            return;
        }
        this.anomaliesOnly = anomaliesOnly;
        if (this.key != null) {
            Cache.put(this.key, anomaliesOnly);
        }
        this.fireStateChanged();
    }

    public boolean isAnomaliesOnly() {
        return this.anomaliesOnly;
    }

    @Override
    public boolean isVisible(Object row) {
        AuditModel model = this.getModel();
        return !this.anomaliesOnly || model.isViolation(row) || model.isOutOfBand(row) || model.getCount(row, AuditModel.Count.VISIBLE_ISSUES) > 0 || model.getCount(row, AuditModel.Count.VISIBLE_OUT_OF_BANDS) > 0;
    }
}

