/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.service;

import oracle.jdeveloper.audit.analyzer.Rule;
import oracle.jdeveloper.audit.model.Location;
import oracle.jdeveloper.audit.service.Suppression;
import oracle.jdeveloper.audit.service.Violation;
import oracle.jdeveloper.audit.transform.Transform;

public final class ViolationHelper {
    private long bits;
    private Object[] objects;
    private static final Object[] EMPTY = new Object[0];
    private static final int MAX_TRANSFORM_COUNT_WIDTH;
    private static final int TRANSFORM_OFFSET = 0;
    private static final int TRANSFORM_WIDTH = 15;
    private static final int TRANSFORM_MASK = Short.MAX_VALUE;
    private static final int DEFAULT_TRANSFORM_OFFSET = 15;
    private static final int DEFAULT_TRANSFORM_WIDTH;
    private static final int DEFAULT_TRANSFORM_MASK;
    private static final int PARAMETER_OFFSET;
    private static final int PARAMETER_WIDTH = 8;
    private static final int PARAMETER_MASK = 255;
    private static final int FOCUS_OFFSET;
    private static final int FOCUS_WIDTH = 1;
    private static final int FOCUS_BIT;
    private static final int VARIATION_OFFSET;
    private static final int VARIATION_WIDTH = 4;
    private static final int VARIATION_MASK = 15;

    public ViolationHelper() {
        assert (VARIATION_OFFSET + 4 <= 64);
    }

    public void pack(Violation violation, int transformMask) {
        int defaultTransformIndex = -1;
        Transform defaultTransform = violation.getDefaultTransform();
        if (defaultTransform != null) {
            Transform[] transforms = violation.getRule().getTransforms();
            for (int i = 0; i < transforms.length; ++i) {
                if (defaultTransform != transforms[i]) continue;
                defaultTransformIndex = i;
                break;
            }
        }
        this.pack(violation, transformMask, defaultTransformIndex);
    }

    public void pack(Violation violation, int transformMask, int defaultTransformIndex) {
        Rule rule = violation.getRule();
        Location location = violation.getLocation();
        int variationIndex = -1;
        String variation = violation.getVariation();
        if (variation != null) {
            int i = 0;
            for (String v : rule.variations()) {
                if (v.equals(variation)) {
                    variationIndex = i;
                    break;
                }
                ++i;
            }
        }
        int parameterCount = violation.getParameterCount();
        Location focusLocation = violation.getFocusLocation();
        int focusBit = focusLocation != null && !location.equals(focusLocation) ? 1 : 0;
        this.bits = ViolationHelper.packBits(transformMask, defaultTransformIndex, parameterCount, focusBit, variationIndex);
        int suppressionCount = violation.getSuppressionCount();
        int objectCount = parameterCount * 2 + focusBit + suppressionCount;
        if (objectCount > 0) {
            int i;
            this.objects = new Object[objectCount];
            int o = 0;
            for (i = 0; i < parameterCount; ++i) {
                this.objects[o++] = violation.getParameterName(i);
                this.objects[o++] = violation.getParameterValue(i);
            }
            if (focusBit != 0) {
                this.objects[o++] = focusLocation;
            }
            for (i = 0; i < suppressionCount; ++i) {
                this.objects[o++] = violation.getSuppression(i);
            }
        } else {
            this.objects = EMPTY;
        }
        assert (ViolationHelper.unpackParameterCount(this.bits) == parameterCount);
        assert (ViolationHelper.unpackDefaultTransform(this.bits, rule) == violation.getDefaultTransform());
        assert (ViolationHelper.unpackVariation(this.bits, rule) == violation.getVariation());
        assert (ViolationHelper.unpackSuppressionCount(this.bits, this.objects) == suppressionCount);
    }

    public long getBits() {
        return this.bits;
    }

    public Object[] getObjects() {
        return this.objects;
    }

    public static Location unpackFocusLocation(long bits, Object[] objects, Location location) {
        return ViolationHelper.focusCount(bits) == 0 ? location : ViolationHelper.focus(bits, objects);
    }

    public static String unpackVariation(long bits, Rule rule) {
        int index = ViolationHelper.variationIndex(bits);
        if (index >= 0) {
            int i = 0;
            for (String variation : rule.variations()) {
                if (i++ != index) continue;
                return variation;
            }
        }
        return null;
    }

    public static int unpackParameterCount(long bits) {
        return ViolationHelper.parameterCount(bits);
    }

    public static String unpackParameterName(long bits, Object[] objects, int index) {
        assert (index < ViolationHelper.parameterCount(bits));
        return (String)objects[index *= 2];
    }

    public static Object unpackParameterValue(long bits, Object[] objects, int index) {
        assert (index < ViolationHelper.parameterCount(bits));
        index = index * 2 + 1;
        return objects[index];
    }

    public static Object unpackParameterValue(long bits, Object[] objects, String name) {
        int i = ViolationHelper.unpackParameterCount(bits);
        while (i-- > 0) {
            if (!name.equals(ViolationHelper.unpackParameterName(bits, objects, i))) continue;
            return ViolationHelper.unpackParameterValue(bits, objects, i);
        }
        return null;
    }

    public static int unpackTransformCount(long bits) {
        int mask = ViolationHelper.transformMask(bits);
        int count = 0;
        for (int i = 0; i < 15; ++i) {
            if ((mask & 1 << i) == 0) continue;
            ++count;
        }
        return count;
    }

    public static Transform unpackTransform(long bits, Rule rule, int index) {
        int mask = ViolationHelper.transformMask(bits);
        for (int i = 0; i < 15; ++i) {
            if ((mask & 1 << i) == 0 || index-- != 0) continue;
            return rule.getTransforms()[i];
        }
        throw new IndexOutOfBoundsException(index + " of " + ViolationHelper.unpackTransformCount(bits));
    }

    public static int unpackSuppressionCount(long bits, Object[] objects) {
        return objects.length - (ViolationHelper.parameterCount(bits) * 2 + ViolationHelper.focusCount(bits));
    }

    public static Suppression unpackSuppression(long bits, Object[] objects, int index) {
        int suppressionIndex = ViolationHelper.parameterCount(bits) * 2 + ViolationHelper.focusCount(bits) + index;
        return suppressionIndex < objects.length ? (Suppression)objects[suppressionIndex] : null;
    }

    public static Transform unpackDefaultTransform(long bits, Rule rule) {
        int index = ViolationHelper.defaultTransformIndex(bits);
        if (index < 0) {
            return null;
        }
        return rule.getTransforms()[index];
    }

    private static long packBits(int transformMask, int defaultTransformIndex, int parameterCount, int focusBit, int variationIndex) {
        assert (transformMask <= Short.MAX_VALUE);
        assert (defaultTransformIndex + 1 <= DEFAULT_TRANSFORM_MASK);
        assert (defaultTransformIndex < 0 || (1 << defaultTransformIndex & transformMask) != 0);
        assert (parameterCount <= 255);
        assert (variationIndex + 1 <= 15);
        long bits = transformMask << 0 | defaultTransformIndex + 1 << 15 | parameterCount << PARAMETER_OFFSET | focusBit << FOCUS_OFFSET | variationIndex + 1 << VARIATION_OFFSET;
        assert (parameterCount == ViolationHelper.parameterCount(bits)) : "parameter count " + parameterCount + ", computed " + ViolationHelper.parameterCount(bits);
        return bits;
    }

    private static int transformMask(long bits) {
        return (int)(bits >> 0) & Short.MAX_VALUE;
    }

    private static int defaultTransformIndex(long bits) {
        int index = ((int)(bits >> 15) & DEFAULT_TRANSFORM_MASK) - 1;
        return index;
    }

    private static int parameterCount(long bits) {
        return (int)(bits >> PARAMETER_OFFSET) & 0xFF;
    }

    private static Location focus(long bits, Object[] objects) {
        if ((bits & (long)FOCUS_BIT) == 0L) {
            return null;
        }
        return (Location)objects[ViolationHelper.parameterCount(bits) * 2];
    }

    private static int focusCount(long bits) {
        return (int)(bits >> FOCUS_OFFSET) & 1;
    }

    private static int variationIndex(long bits) {
        int index = ((int)(bits >> VARIATION_OFFSET) & 0xF) - 1;
        return index;
    }

    static {
        DEFAULT_TRANSFORM_WIDTH = MAX_TRANSFORM_COUNT_WIDTH = 32 - Integer.numberOfLeadingZeros(15);
        DEFAULT_TRANSFORM_MASK = (1 << DEFAULT_TRANSFORM_WIDTH) - 1;
        PARAMETER_OFFSET = 15 + DEFAULT_TRANSFORM_WIDTH;
        FOCUS_OFFSET = PARAMETER_OFFSET + 8;
        FOCUS_BIT = 1 << FOCUS_OFFSET;
        VARIATION_OFFSET = FOCUS_OFFSET + 1;
    }
}

