/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.extension;

import java.util.Collection;
import oracle.javatools.util.ArraySortedSet;
import oracle.jdeveloper.audit.extension.Definition;
import oracle.jdeveloper.audit.extension.DefinitionContext;

public class Value
extends Definition
implements Comparable<Value> {
    private String name;
    private String text;
    private Collection<Value> values;

    public Value(String name, DefinitionContext context) {
        super(context);
        this.name = name;
    }

    public Value(String name, String text, DefinitionContext context) {
        super(context);
        this.name = name;
        this.setText(text);
    }

    public void setText(String text) {
        if ("true".equals(text)) {
            text = "true";
        }
        if ("false".equals(text)) {
            text = "false";
        }
        this.text = text;
    }

    public boolean addValue(Value value) {
        if (this.values == null) {
            this.values = new ArraySortedSet();
        }
        return this.values.add(value);
    }

    public String getName() {
        return this.name;
    }

    public String getText() {
        return this.text;
    }

    public Collection<Value> getValues() {
        return this.values;
    }

    @Override
    public int compareTo(Value that) {
        return this.name.compareTo(that.name);
    }

    public boolean equals(Object object) {
        return object instanceof Value && this.name.equals(((Value)object).name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

