/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.extension;

import java.util.ArrayList;
import java.util.Collection;
import oracle.jdeveloper.audit.extension.DefinitionContext;
import oracle.jdeveloper.audit.extension.ExtensionBundle;
import oracle.jdeveloper.audit.extension.TopLevelDefinition;
import oracle.jdeveloper.audit.extension.TypeDefinition;
import oracle.jdeveloper.audit.extension.Value;

public abstract class BeanDefinition
extends TopLevelDefinition {
    private TypeDefinition implementationClass;
    private Collection<Value> values = new ArrayList<Value>();

    BeanDefinition(String id, ExtensionBundle bundle, DefinitionContext context) {
        super(id, bundle, context);
    }

    public abstract boolean hasEnabledProperty();

    public boolean isEnabledByDefault() {
        if (!this.hasEnabledProperty()) {
            throw new UnsupportedOperationException("isEnabled");
        }
        if (this.values != null) {
            for (Value value : this.values) {
                if (!"enabled".equals(value.getName())) continue;
                return "true".equalsIgnoreCase(value.getText());
            }
        }
        return false;
    }

    public TypeDefinition getImplementationClass() {
        return this.implementationClass;
    }

    public void setImplementationClass(TypeDefinition implementationClass) {
        this.implementationClass = implementationClass;
    }

    public Collection<Value> getValues() {
        return this.values;
    }

    public Value getValue(String name) {
        if (this.values != null) {
            for (Value value : this.values) {
                if (!name.equals(value.getName())) continue;
                return value;
            }
        }
        return null;
    }

    public void setValues(Collection<Value> values) {
        this.values = values;
    }
}

