/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.util;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageOutputStream;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ImageIOUtil {
    public static final int DEFAULT_SCREEN_RESOLUTION = 72;
    public static final float DEFAULT_COMPRESSION_QUALITY = 1.0f;
    private static final String STANDARD_METADATA_FORMAT = "javax_imageio_1.0";

    private ImageIOUtil() {
    }

    public static boolean writeImage(BufferedImage image, String imageFormat, String filename, int imageType, int resolution) throws IOException {
        String fileName = filename + "." + imageFormat;
        File file = new File(fileName);
        return ImageIOUtil.writeImage(image, imageFormat, file, resolution);
    }

    public static boolean writeImage(BufferedImage image, String imageFormat, OutputStream outputStream) throws IOException {
        return ImageIOUtil.writeImage(image, imageFormat, outputStream, 72);
    }

    public static boolean writeImage(BufferedImage image, String imageFormat, Object outputStream, int resolution) throws IOException {
        return ImageIOUtil.writeImage(image, imageFormat, outputStream, resolution, 1.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean writeImage(BufferedImage image, String imageFormat, Object outputStream, int resolution, float quality) throws IOException {
        boolean bSuccess = true;
        ImageOutputStream output = null;
        ImageWriter imageWriter = null;
        try {
            output = ImageIO.createImageOutputStream(outputStream);
            boolean foundWriter = false;
            Iterator<ImageWriter> writerIter = ImageIO.getImageWritersByFormatName(imageFormat);
            while (writerIter.hasNext() && !foundWriter) {
                Object var13_13;
                try {
                    try {
                        imageWriter = writerIter.next();
                        ImageWriteParam writerParams = imageWriter.getDefaultWriteParam();
                        if (writerParams.canWriteCompressed()) {
                            writerParams.setCompressionMode(2);
                            if (writerParams.getCompressionType() == null) {
                                writerParams.setCompressionType(writerParams.getCompressionTypes()[0]);
                            }
                            writerParams.setCompressionQuality(quality);
                        }
                        IIOMetadata meta = ImageIOUtil.createMetadata(image, imageWriter, writerParams, resolution);
                        imageWriter.setOutput(output);
                        imageWriter.write(null, new IIOImage(image, null, meta), writerParams);
                        foundWriter = true;
                    }
                    catch (IIOException io) {
                        throw new IOException(io.getMessage());
                    }
                    var13_13 = null;
                    if (imageWriter == null) continue;
                    imageWriter.dispose();
                }
                catch (Throwable throwable) {
                    var13_13 = null;
                    if (imageWriter == null) throw throwable;
                    imageWriter.dispose();
                    throw throwable;
                }
            }
            if (!foundWriter) {
                bSuccess = false;
            }
            Object var15_15 = null;
            if (output == null) return bSuccess;
        }
        catch (Throwable throwable) {
            Object var15_16 = null;
            if (output == null) throw throwable;
            output.flush();
            output.close();
            throw throwable;
        }
        output.flush();
        output.close();
        return bSuccess;
    }

    private static IIOMetadata createMetadata(RenderedImage image, ImageWriter imageWriter, ImageWriteParam writerParams, int resolution) {
        ImageTypeSpecifier type = writerParams.getDestinationType() != null ? writerParams.getDestinationType() : ImageTypeSpecifier.createFromRenderedImage(image);
        IIOMetadata meta = imageWriter.getDefaultImageMetadata(type, writerParams);
        return ImageIOUtil.addResolution(meta, resolution) ? meta : null;
    }

    private static boolean addResolution(IIOMetadata meta, int resolution) {
        if (!meta.isReadOnly() && meta.isStandardMetadataFormatSupported()) {
            IIOMetadataNode child;
            IIOMetadataNode root = (IIOMetadataNode)meta.getAsTree(STANDARD_METADATA_FORMAT);
            IIOMetadataNode dim = ImageIOUtil.getChildNode(root, "Dimension");
            if (dim == null) {
                dim = new IIOMetadataNode("Dimension");
                root.appendChild(dim);
            }
            if ((child = ImageIOUtil.getChildNode(dim, "HorizontalPixelSize")) == null) {
                child = new IIOMetadataNode("HorizontalPixelSize");
                dim.appendChild(child);
            }
            child.setAttribute("value", Double.toString((double)resolution / 25.4));
            child = ImageIOUtil.getChildNode(dim, "VerticalPixelSize");
            if (child == null) {
                child = new IIOMetadataNode("VerticalPixelSize");
                dim.appendChild(child);
            }
            child.setAttribute("value", Double.toString((double)resolution / 25.4));
            try {
                meta.mergeTree(STANDARD_METADATA_FORMAT, root);
            }
            catch (IIOInvalidTreeException e) {
                throw new RuntimeException("Cannot update image metadata: " + e.getMessage());
            }
            return true;
        }
        return false;
    }

    private static IIOMetadataNode getChildNode(Node n, String name) {
        NodeList nodes = n.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node child = nodes.item(i);
            if (!name.equals(child.getNodeName())) continue;
            return (IIOMetadataNode)child;
        }
        return null;
    }
}

