/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.xml;

import oracle.dss.util.persistence.ObjectScope;
import oracle.dss.util.xml.BaseObjectNode;
import oracle.dss.util.xml.ContainerNode;
import oracle.dss.util.xml.NoSuchObjectException;
import oracle.dss.util.xml.PropertyNode;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLText;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ObjectNode
extends BaseObjectNode {
    private static final long serialVersionUID = 1L;
    protected String m_key = null;
    protected boolean m_isRef = false;

    ObjectNode(ObjectScope scope, Node node) {
        super(scope, node);
        this.m_key = ((Element)node).getAttribute("id");
        String refKey = ((Element)node).getAttribute("idref");
        if (refKey != "") {
            this.m_isRef = true;
            this.m_key = refKey;
        } else {
            this.m_isRef = false;
        }
    }

    public ObjectNode(String objName) {
        super(objName);
    }

    public ObjectNode(String objName, Object obj, ObjectScope scope) {
        super(objName);
        this.m_scope = scope;
        this.initBuffer();
        if (obj == null) {
            this.addProperty("xsi:null", "true");
        } else if (scope.isObjectExists(obj)) {
            this.m_isRef = true;
            this.m_key = scope.getID(obj);
            this.m_buffer.append(" idref=\"");
            this.m_buffer.append(this.m_key);
            this.m_buffer.append("\"");
        } else {
            this.m_isRef = false;
            this.m_key = scope.addObject(obj);
            this.m_buffer.append(" id=\"");
            this.m_buffer.append(this.m_key);
            this.m_buffer.append("\"");
        }
    }

    public ObjectNode(Object obj, ObjectScope scope) {
        this(obj.getClass().getName(), obj, scope);
    }

    public void addContainer(ContainerNode node) {
        this.addChild(node);
    }

    public ContainerNode getContainer(String name) {
        Element elem = (Element)((XMLElement)this.m_node).getChildrenByTagName(name).item(0);
        if (elem == null) {
            return null;
        }
        return new ContainerNode(this.m_scope, elem);
    }

    @Override
    public void addProperty(PropertyNode propNode) {
        if (!this.m_isRef) {
            super.addProperty(propNode);
        }
    }

    @Override
    public void addProperty(String name, String value, boolean attr) {
        if (!this.m_isRef) {
            super.addProperty(name, value, attr);
        }
    }

    public void addProperty(ObjectNode propNode) {
        if (!this.m_isRef) {
            this.addChild(propNode);
        }
    }

    public void addProperty(String name, ObjectNode propNode) {
        if (!this.m_isRef && name != null) {
            this.initVector();
            this.initPost();
            if (!this.m_closed) {
                this.m_nodes.addElement("<" + name + ">");
                this.m_nodes.addElement(propNode);
                this.m_nodes.addElement("</" + name + ">");
                this.m_post.append(this.m_name).append(">");
                this.m_post.setCharAt(0, '<');
                this.m_post.setCharAt(1, '/');
                this.m_closed = true;
            } else {
                this.m_nodes.addElement("<" + name + ">");
                this.m_nodes.addElement(propNode);
                this.m_nodes.addElement("</" + name + ">");
            }
        }
    }

    public ObjectNode getPropertyValueAsObjectNode(String name, boolean override) {
        Element node = (Element)((XMLElement)this.m_node).getChildrenByTagName(name).item(0);
        if (node == null) {
            return null;
        }
        if (override) {
            return new ObjectNode(this.m_scope, node);
        }
        Node value = node.getFirstChild();
        if (value instanceof Element) {
            return new ObjectNode(this.m_scope, value);
        }
        return null;
    }

    public ObjectNode getPropertyValueAsObjectNode(String name) {
        return this.getPropertyValueAsObjectNode(name, false);
    }

    public ObjectNode getPropertyValueAsObjectNode() {
        Element _elem = this.getFirstElement();
        if (_elem != null) {
            return new ObjectNode(this.m_scope, _elem);
        }
        return null;
    }

    public String getValueAsString() {
        String eValue = null;
        if (this.m_node instanceof Element) {
            Element elem = (Element)this.m_node;
            Node value = elem.getLastChild();
            if (value instanceof Text) {
                eValue = ((XMLText)value).getNodeValue();
            } else {
                NodeList nodes = elem.getChildNodes();
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Node newValue = nodes.item(i);
                    if (!(newValue instanceof Text)) continue;
                    eValue = ((XMLText)newValue).getNodeValue();
                    break;
                }
            }
        }
        if (eValue != null) {
            return eValue;
        }
        return null;
    }

    public Double getValueAsDouble() {
        String eValue = null;
        if (this.m_node instanceof Element) {
            Element elem = (Element)this.m_node;
            Node value = elem.getLastChild();
            if (value instanceof Text) {
                eValue = ((XMLText)value).getNodeValue();
            } else {
                NodeList nodes = elem.getChildNodes();
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Node newValue = nodes.item(i);
                    if (!(newValue instanceof Text)) continue;
                    eValue = ((XMLText)newValue).getNodeValue();
                    break;
                }
            }
        }
        if (eValue != null) {
            return Double.valueOf(eValue);
        }
        return null;
    }

    public String getID() {
        return this.m_key;
    }

    public Object getReference() throws NoSuchObjectException {
        Object _obj = this.m_scope.getObject(this.m_key);
        if (_obj == null) {
            throw new NoSuchObjectException(this.m_key, this.m_scope);
        }
        return this.m_scope.getObject(this.m_key);
    }

    public boolean isReference() {
        return this.m_isRef;
    }

    public boolean registerObject(Object obj) {
        return this.m_scope.addObject(this.m_key, obj);
    }
}

