/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.parameters;

import java.util.HashMap;
import java.util.Vector;
import oracle.dss.util.parameters.Parameter;
import oracle.dss.util.parameters.ParameterMap;
import oracle.dss.util.parameters.ParameterValueManager;
import oracle.dss.util.parameters.ParameterValueMappingManager;

public class ParameterValueMappingManagerImpl
implements ParameterValueMappingManager {
    private ParameterValueManager m_parent = null;
    private HashMap m_parameterValues = new HashMap();
    private Vector m_mappedParameters = new Vector();
    private HashMap m_overridePrompts = new HashMap();

    @Override
    public ParameterValueManager getParentParameterValueManager() {
        return this.m_parent;
    }

    @Override
    public void setParentParameterValueManager(ParameterValueManager parent) {
        this.m_parent = parent;
    }

    @Override
    public Object getValue(Parameter parameter) {
        if (this.isMappedParameter(parameter) || this.m_parent == null) {
            return this.m_parameterValues.get(parameter);
        }
        return this.m_parent.getValue(parameter);
    }

    @Override
    public HashMap getValue(Parameter parameter, ParameterMap map) {
        return null;
    }

    @Override
    public void setValue(Parameter parameter, Object value) {
        if (this.isMappedParameter(parameter) || this.m_parent == null) {
            if (value == null) {
                this.clearValue(parameter);
            } else {
                this.m_parameterValues.put(parameter, value);
            }
        } else {
            this.m_parent.setValue(parameter, value);
        }
    }

    @Override
    public void setValue(Parameter parameter, HashMap value, ParameterMap map) {
    }

    @Override
    public void clearValue(Parameter parameter) {
        if (this.isMappedParameter(parameter) || this.m_parent == null) {
            this.m_parameterValues.remove(parameter);
        } else {
            this.m_parent.clearValue(parameter);
        }
    }

    @Override
    public void addMappedParameter(Parameter parameter) {
        if (!this.isMappedParameter(parameter)) {
            this.m_mappedParameters.add(parameter);
        }
    }

    @Override
    public boolean isMappedParameter(Parameter parameter) {
        return this.m_mappedParameters.contains(parameter);
    }

    @Override
    public void removeMappedParameter(Parameter parameter) {
        this.m_mappedParameters.remove(parameter);
    }

    @Override
    public Parameter[] getMappedParameters() {
        return this.m_mappedParameters.toArray(new Parameter[this.m_mappedParameters.size()]);
    }

    @Override
    public String getOverridePrompt(Parameter parameter) {
        return (String)this.m_overridePrompts.get(parameter);
    }

    @Override
    public void setOverridePrompt(Parameter parameter, String prompt) {
        if (prompt == null) {
            this.m_overridePrompts.remove(parameter);
        } else {
            this.m_overridePrompts.put(parameter, prompt);
        }
    }
}

