/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util;

import oracle.dss.util.ComponentInfo;
import oracle.dss.util.DataAccess;
import oracle.dss.util.QDR;

public class DataComponentInfo
extends ComponentInfo {
    private static final long serialVersionUID = 1L;
    private int _row;
    private int _column;

    public DataComponentInfo(int row, int column) {
        this._row = row;
        this._column = column;
    }

    public void setRowCol(int row, int col) {
        this._row = row;
        this._column = col;
    }

    @Override
    public Object clone() {
        return new DataComponentInfo(this._row, this._column);
    }

    public int getRow() {
        return this._row;
    }

    public int getColumn() {
        return this._column;
    }

    public boolean equals(Object o) {
        DataComponentInfo dci;
        try {
            dci = (DataComponentInfo)o;
        }
        catch (ClassCastException e) {
            return false;
        }
        return dci != null && this._column == dci._column && this._row == dci._row;
    }

    @Override
    public QDR getQDR(DataAccess dataAccess, int flags) {
        try {
            return dataAccess.getValueQDR(this._row, this._column, flags);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public int hashCode() {
        return (this._row << 16) + this._column;
    }

    public String toString() {
        return "row=" + this._row + ",column=" + this._column;
    }
}

